package cmis.utils;
import java.util.Collections;

import org.hibernate.*;
import org.hibernate.engine.*;
import org.hibernate.engine.spi.*;
import org.hibernate.hql.*;
import org.hibernate.hql.internal.ast.*;
import org.hibernate.hql.spi.*;
 
public class HqlToSqlTranslator {
  private SessionFactory sessionFactory;
 
  public HqlToSqlTranslator(SessionFactory sessionFactory){
    this.sessionFactory = sessionFactory;
  }
 
  public String toSql(String hqlQueryText){
    if (hqlQueryText!=null && hqlQueryText.trim().length()>0){
      final QueryTranslatorFactory translatorFactory = new ASTQueryTranslatorFactory();
      final SessionFactoryImplementor factory = 
        (SessionFactoryImplementor) sessionFactory;
      final QueryTranslator translator = translatorFactory.
        createQueryTranslator(
          hqlQueryText, 
          hqlQueryText, 
          Collections.EMPTY_MAP, factory
        );
      translator.compile(Collections.EMPTY_MAP, false);
      return translator.getSQLString(); 
    }
    return null;
  }
}