package cmis.main;
import java.util.Date;

import javax.management.Query;

import org.hibernate.Session;
import org.hibernate.Transaction;

import cmis.utils.*;
import cmis.model.*;

public class HqlQueriesTest {
	
	public static Session getSession() {
		return HibernateUtil.getSessionFactory().getCurrentSession();
	}
	
	public static void main(String[] args) {
		SchemaGenerator.main(args);
		Transaction t = getSession().beginTransaction();
		initModel();
		System.out.println(getSession().createQuery("from StaffMember").list());
		
		System.out.println(getSession().createQuery("select m.supervisedStudents from StaffMember m").list());
		
		getSession().close();
/*
		HqlToSqlTranslator t = new HqlToSqlTranslator(HibernateUtil.getSessionFactory());
		System.out.println(t.toSql("from Student"));
		System.out.println(t.toSql("from StaffMember"));
		System.out.println(t.toSql("from FixedTermMember"));
		System.out.println(t.toSql("select s.supervisor from Student s"));
		System.out.println(t.toSql("select m.supervisedStudents from StaffMember m where m.id = 123"));
*/
		
	}
	
	
	public static void initModel() {
		Student s = new Student();
		s.setId(1);
		s.setName("John");
		StaffMember m = new PermanentMember();
		m.setCode("123");
		s.setSupervisor(m);
		FixedTermMember m2 = new FixedTermMember();
		m2.setCode("456");
		m2.setEmail("a@a.a");
		m2.setEndTerm(new Date());
		getSession().save(s);
		getSession().save(m);
		getSession().save(m2);
		getSession().flush();
	}
}
