/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill.search;

import AIspace.hill.HillEngine;
import AIspace.hill.elements.HillVariable;
import AIspace.hill.elements.NodeVal;
import AIspace.hill.search.Heuristics;
import java.awt.Color;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class Search {
    public static final String descriptionPath = "AIspace/hill/help/";
    protected Heuristics heuristics;
    protected int step;
    protected String name;
    protected JPanel panel;
    protected JTextArea descText;
    protected JScrollPane descTextScroll;
    protected HillEngine engine;
    protected HillVariable node;
    protected boolean requiresHeap = false;
    protected String descriptionFile = "Nada.txt";
    protected boolean maintain = false;
    protected int[] varHeurs = new int[]{101, 102, 100};
    protected int[] varValHeurs = new int[]{201, 200};
    protected int[] secHeurs = new int[]{301, 300};

    public void turnOnStruct() {
        if (this.requiresHeap || this.heuristics.requiresHeap()) {
            this.engine.turnStruct(true);
        } else {
            this.engine.turnStruct(false);
        }
    }

    public void createDesc() {
        ArrayList<String> s = new ArrayList<String>();
        this.descText = new JTextArea();
        this.descText.setEditable(false);
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/AIspace/hill/help/" + this.descriptionFile)));
            while ((line = in.readLine()) != null) {
                s.add(String.valueOf(line) + "\n");
            }
            s.add("");
        }
        catch (Exception e) {
            s.add("Description Not Available");
        }
        int i = 0;
        while (i < s.size()) {
            this.descText.append((String)s.get(i));
            ++i;
        }
        this.descTextScroll = new JScrollPane(this.descText, 20, 30);
    }

    public void step() {
    }

    public void finestep() {
    }

    public void reset() {
    }

    public boolean fineStep() {
        return true;
    }

    protected HillVariable getNextNode(int heur) {
        switch (heur) {
            case 100: {
                return this.engine.getCSP().getRandNode();
            }
            case 101: {
                return this.engine.getCSP().getBestNode();
            }
            case 102: {
                return this.engine.getCSP().getRandRedNode();
            }
        }
        return null;
    }

    protected int getNextVal(int heur, HillVariable node) {
        switch (heur) {
            case 300: {
                return this.engine.getCSP().getRandVal(node);
            }
            case 301: {
                return this.engine.getCSP().getBestVal(node, this.maintain);
            }
        }
        return -1;
    }

    protected NodeVal getNextNdVal(int heur) {
        switch (heur) {
            case 200: {
                return this.engine.getCSP().getRandNdVal();
            }
            case 201: {
                return this.engine.getCSP().getBestNdVal();
            }
            case 202: {
                return this.engine.getCSP().getRandRedNdVal();
            }
        }
        return null;
    }

    protected void highLight(HillVariable node) {
        if (this.engine.highLight()) {
            this.engine.getCSP().setCurrent(node);
        }
    }

    protected void deHighLight() {
        if (this.engine.getCSP().getCurrent() != null) {
            this.engine.getCSP().getCurrent().isBold = false;
        }
    }

    protected void set(NodeVal ndvl) {
        this.engine.getCSP().setNode(ndvl);
    }

    public String getName() {
        return this.name;
    }

    public JScrollPane getDescription() {
        if (this.descText == null) {
            this.createDesc();
        }
        this.descText.setBackground(Color.lightGray);
        this.descText.setCaretPosition(0);
        return this.descTextScroll;
    }

    public JPanel getOptionsPanel() {
        return this.panel;
    }

    public JPanel getNeighbourPanel(ItemListener l) {
        return this.heuristics.getNeighbourPanel(l);
    }

    public JPanel getSettingsPanel(boolean varFirst) {
        return this.heuristics.getSettingsPanel(varFirst);
    }

    public String[][] getSettings() {
        return this.heuristics.getSettings();
    }

    public int getMaxSteps() {
        return this.heuristics.getMaxSteps();
    }
}

