/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill;

import AIspace.hill.PlotCanvas;
import AIspace.hill.PlotInterface;
import AIspace.hill.intList.IntVector;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class SolveCanvas
extends PlotCanvas
implements PlotInterface {
    public SolveCanvas() {
        this.drawingBatch = false;
        this.initCanvas();
    }

    @Override
    public void clear(int numEdges) {
        this.resetSteps(numEdges);
        this.vLines = null;
        this.yVals = null;
        this.xVals = null;
        this.repaint();
    }

    public void redraw(IntVector[] vals) {
        int next;
        if (vals == null) {
            return;
        }
        this.xVals = vals[0];
        this.yVals = vals[1];
        if (this.xVals.first() == -1) {
            return;
        }
        this.maxX = this.xVals.last();
        this.xStep = (float)this.width / (float)this.maxX;
        this.maxY = this.yVals.first();
        while ((next = this.yVals.next()) != -1) {
            if (next <= this.maxY) continue;
            this.maxY = next;
        }
        this.resetSteps();
        this.repaint();
    }

    public void paint(IntVector[] vals) {
        this.drawingBatch = false;
        if (vals == null) {
            return;
        }
        this.xVals = vals[0];
        this.yVals = vals[1];
        this.maxX = this.xVals.last();
        if (this.maxX == -1) {
            this.maxX = 1;
        }
        this.xStep = (float)this.width / (float)this.maxX;
        if (this.maxX == 1) {
            this.maxY = this.yVals.first();
        }
        if (this.yVals.last() > this.maxY) {
            this.maxY = this.yVals.last();
        }
        this.resetSteps();
        this.repaint();
    }

    protected void drawEverything(Graphics2D g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawGrid(g);
        this.drawPoints(g);
        this.drawLabels(g);
        if (this.mouseX > 50 && this.mouseX < this.getWidth() - 20 && this.mouseY > 50 && this.mouseY < this.getHeight() - 50) {
            g.setColor(Color.white);
            g.fillRect(this.mouseX + 10, this.mouseY - this.fm.getAscent(), this.fm.stringWidth(this.coords), this.fm.getHeight());
            g.setColor(Color.black);
            g.drawString(this.coords, this.mouseX + 10, this.mouseY);
            g.drawLine(this.mouseX - 5, this.mouseY - 5, this.mouseX + 5, this.mouseY + 5);
            g.drawLine(this.mouseX - 5, this.mouseY + 5, this.mouseX + 5, this.mouseY - 5);
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        this.drawEverything((Graphics2D)g);
    }

    protected void drawLabels(Graphics graphics) {
        String title = this.title();
        String xName = "Step Count";
        String yName = "Conflicts";
        if (this.drawingBatch) {
            yName = "Trials";
        }
        graphics.setColor(Color.black);
        graphics.setFont(this.getFont());
        graphics.drawString(title, this.getWidth() / 2 - this.fm.stringWidth(title) / 2, 25);
        graphics.drawString(xName, this.getWidth() / 2 - this.fm.stringWidth(xName) / 2, this.getHeight() - this.fm.getHeight());
        int yNameWidth = this.fm.stringWidth(yName);
        if (25 + yNameWidth < 0) {
            return;
        }
        int fontSize = this.getFont().getSize();
        int x = 15;
        int y = this.getHeight() / 2 - this.fm.getHeight() / 2;
        int i = 0;
        while (i < yName.length()) {
            graphics.drawString(String.valueOf(yName.charAt(i)), x, y + (i - yName.length() / 2) * fontSize);
            ++i;
        }
    }

    protected void drawPoints(Graphics graphics) {
        if (this.xVals == null || this.yVals == null) {
            return;
        }
        int x = this.xVals.first();
        int y = this.yVals.first();
        int xPrev = -1;
        int yPrev = -1;
        int r = 2;
        int xStart = 50;
        int yStart = this.getHeight() - 50;
        float percent = 1.0f;
        graphics.setColor(Color.blue);
        while (x != -1 && y != -1) {
            if (this.useLogScale) {
                percent = this.percent(x);
                x = (int)((float)x * this.xStep * percent * percent);
            } else {
                x = (int)((float)x * this.xStep);
            }
            y = (int)((float)y * this.yStep);
            y = yStart - y;
            graphics.fillRect((x += xStart) - r, y - r, r * 2, r * 2);
            if (xPrev != -1 && yPrev != -1) {
                graphics.drawLine(xPrev, yPrev, x, y);
            }
            xPrev = x;
            yPrev = y;
            x = this.xVals.next();
            y = this.yVals.next();
        }
    }

    @Override
    public void print(JFrame parent) {
        PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(parent, "Print", null);
        if (pj == null) {
            System.out.println("The print request was cancelled");
            return;
        }
        Graphics g = pj.getGraphics();
        Image im = this.createImage(this.width + 50 + 20, this.height + 50 + 50);
        Graphics graphics = im.getGraphics();
        this.drawEverything((Graphics2D)graphics);
        g.drawImage(im, 0, 0, this);
        g.dispose();
        pj.end();
    }
}

