/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.visualElements;

import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.STRIPSToCSP.visualElements.StripsNode;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Point;

public class StripsVariableNode
extends StripsNode {
    public static final int PRE_CONDITION = 4292;
    public static final int POST_CONDITION = 4293;
    private StripsVariableNode sibling = null;
    private int variableType;
    private StripsVariable variable;

    public StripsVariableNode(Graph graph, Point pos, int type, StripsVariable variable) {
        super(graph, pos);
        this.shape = 1110;
        this.variableType = type;
        this.variable = variable;
        this.label[0] = variable.getName();
        this.updateSize();
        if (this.variableType == 4292) {
            this.sibling = new StripsVariableNode(graph, new Point(pos.x, pos.y), 4293, variable);
            this.sibling.setSibling(this);
            graph.addNode(this.sibling);
        }
    }

    public StripsVariableNode getSibling() {
        return this.sibling;
    }

    public void setSibling(StripsVariableNode sibling) {
        this.sibling = sibling;
    }

    public StripsVariable getVariable() {
        return this.variable;
    }

    public void setVariable(StripsVariable variable) {
        this.variable = variable;
        this.label[0] = variable.getName();
        if (this.sibling != null && this.variableType == 4292) {
            this.sibling.setVariable(variable);
        }
    }

    @Override
    public void move(Point p) {
        p.x = this.pos.x;
        float dy = p.y - this.pos.y;
        super.move(p);
        if (this.sibling != null) {
            this.graph.order_bringToFront(this.sibling);
            this.sibling.translate(0.0f, dy);
        }
    }

    public int getVariableType() {
        return this.variableType;
    }

    public void updateLabel() {
        this.label[0] = this.variable.getName();
    }
}

