/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.elements;

import AIspace.STRIPSToCSP.StripsIO.StripsIO;
import AIspace.STRIPSToCSP.elements.StripsCondition;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.STRIPSToCSP.visualElements.StripsEdge;
import AIspace.XMLReader.XMLBlock;
import AIspace.cspTools.Relation;
import AIspace.cspTools.elements.CSPVariable;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StripsCondition_Conj
extends StripsCondition {
    private static final String conditionTag = "CONDITION";
    private static final String pairTag = "PAIR";
    private static final String valueTag = "VALUE";
    private static final String variableIDTag = "VARIABLE_ID";
    private static final String preConditionTag = "PRECONDITIONS";
    private static final String postConditionTag = "POSTCONDITIONS";
    private HashMap<StripsVariable, String> map = new HashMap();

    public StripsCondition_Conj(int type) {
        super(type);
    }

    @Override
    public void addVariable(StripsVariable variable) {
        if (!this.map.containsKey(variable)) {
            this.map.put(variable, variable.getDomain().getDomain()[0]);
        }
    }

    @Override
    public void removeVariable(StripsVariable variable) {
        this.map.remove(variable);
    }

    @Override
    public Set<StripsVariable> getVariables() {
        return this.map.keySet();
    }

    public void setVariableValue(StripsVariable variable, String value) {
        this.map.put(variable, value);
    }

    public String getValue(StripsVariable variable) {
        return this.map.get(variable);
    }

    @Override
    public void setRelation(ArrayList<CSPVariable> variables, HashMap<CSPVariable, StripsVariable> variableMap, Relation relation) {
        HashMap<CSPVariable, String> values = new HashMap<CSPVariable, String>();
        for (CSPVariable cspVar : variables) {
            if (variableMap.containsKey(cspVar)) {
                values.put(cspVar, this.map.get(variableMap.get(cspVar)));
                continue;
            }
            values.put(cspVar, "true");
        }
        int relationSize = 1;
        int relationIndex = 0;
        int outLoop = variables.size() - 1;
        while (outLoop >= 0) {
            CSPVariable variable = variables.get(outLoop);
            String value = (String)values.get(variable);
            String[] domain = variable.getDomain().getDomain();
            int locationInDomain = this.findIndexInDomain(value, domain);
            relationIndex += locationInDomain * relationSize;
            relationSize *= domain.length;
            --outLoop;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.createPreRelation(relationSize, relationIndex));
        relation.setArgs(tokenizer);
    }

    @Override
    public void setupFromXML(XMLBlock conditionBlock, HashMap<String, StripsVariable> variables) {
        if (conditionBlock.childBlocks.size() == 0) {
            return;
        }
        ArrayList<XMLBlock> pairs = conditionBlock.searchChildTag(pairTag);
        if (pairs.size() < 1) {
            StripsIO.missingTag(pairTag, conditionTag);
        }
        for (XMLBlock pair : pairs) {
            this.parsePair(pair, variables);
        }
    }

    @Override
    public String toXML(HashMap<StripsVariable, String> variable_ids) {
        StringBuffer stateString = new StringBuffer();
        if (this.getType() == 4292) {
            stateString.append("\t").append(StripsIO.startTag(preConditionTag)).append("\n");
        } else {
            stateString.append("\t").append(StripsIO.startTag(postConditionTag)).append("\n");
        }
        for (StripsVariable variable : this.map.keySet()) {
            stateString.append("\t\t").append(StripsIO.startTag(pairTag)).append("\n");
            stateString.append("\t\t\t").append(StripsIO.startTag(variableIDTag));
            stateString.append(variable_ids.get(variable)).append(StripsIO.endTag(variableIDTag));
            stateString.append("\t\t\t").append(StripsIO.startTag(valueTag));
            stateString.append(this.map.get(variable)).append(StripsIO.endTag(valueTag));
            stateString.append("\t\t").append(StripsIO.endTag(pairTag));
        }
        if (this.getType() == 4292) {
            stateString.append("\t").append(StripsIO.endTag(preConditionTag)).append("\n");
        } else {
            stateString.append("\t").append(StripsIO.endTag(postConditionTag)).append("\n");
        }
        return stateString.toString();
    }

    private void parsePair(XMLBlock pair, HashMap<String, StripsVariable> variables) {
        ArrayList<XMLBlock> values = pair.searchChildTag(valueTag);
        if (values.size() != 1) {
            StripsIO.missingTag(valueTag, pairTag);
            return;
        }
        ArrayList<XMLBlock> variableIDs = pair.searchChildTag(variableIDTag);
        if (variableIDs.size() != 1) {
            StripsIO.missingTag(variableIDTag, pairTag);
            return;
        }
        String value = values.get(0).getText();
        String variableID = variableIDs.get(0).getText();
        StripsVariable variable = variables.get(variableID);
        this.setVariableValue(variable, value);
    }

    private int findIndexInDomain(String value, String[] domain) {
        int locationInDomain = 0;
        while (locationInDomain < domain.length && !domain[locationInDomain].equals(value)) {
            ++locationInDomain;
        }
        return locationInDomain;
    }

    private String createPreRelation(int relationSize, int relationIndex) {
        StringBuffer returnString = new StringBuffer();
        int loop = 0;
        while (loop < relationSize) {
            if (loop % 2 == 0) {
                returnString.append("F ");
            } else {
                returnString.append("T ");
            }
            ++loop;
        }
        returnString.setCharAt(relationIndex * 2, 'T');
        return returnString.toString();
    }

    @Override
    public JPanel edgePanel(StripsEdge edge) {
        StripsVariable variable = edge.getVariable();
        String value = this.map.get(variable);
        JPanel returnPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        gbc.gridheight = 2;
        gbc.gridwidth = 1;
        returnPanel.setLayout(gbl);
        JPanel namePanel = new JPanel();
        namePanel.add(new JLabel("Variable Name: " + variable.getName()));
        this.addComponent(namePanel, gbc, gbl, returnPanel, 0, 0, -1, 1, 0.0, 0.0);
        JPanel valueChooserPanel = new JPanel();
        valueChooserPanel.add(new JLabel("Choose the value"));
        JComboBox<String> values = new JComboBox<String>();
        values.setName("values");
        String[] domain = variable.getDomain().getDomain();
        int i = 0;
        while (i < domain.length) {
            values.addItem(domain[i]);
            ++i;
        }
        values.setSelectedItem(value);
        valueChooserPanel.add(values);
        this.addComponent(valueChooserPanel, gbc, gbl, returnPanel, 1, 0, -1, 1, 0.0, 0.0);
        return returnPanel;
    }

    protected final void addComponent(JComponent c, GridBagConstraints gbc, GridBagLayout gbl, Container p, int row, int column, int width, int height, double wx, double wy) {
        if (gbc == null || gbl == null) {
            return;
        }
        gbc.gridx = column;
        gbc.gridy = row;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbl.setConstraints(c, gbc);
        p.add(c);
    }

    @Override
    public void actionOK(JPanel edgePanel, StripsEdge edge) {
        Component[] components = edgePanel.getComponents();
        JComboBox values = (JComboBox)((JPanel)components[1]).getComponents()[1];
        this.map.put(edge.getVariable(), (String)values.getSelectedItem());
    }

    @Override
    public boolean removeEdge(StripsEdge edge, ArrayList<String> removedValues) {
        return removedValues.contains(this.map.get(edge.getVariable()));
    }
}

