/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.dialogs;

import AIspace.STRIPSToCSP.StripsWindow;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.cspTools.domains.DomainBoolean;
import AIspace.cspTools.domains.DomainChooser;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VariableEditDialog
extends BasicDialog {
    private static final long serialVersionUID = -7529899835977817075L;
    private StripsVariable var;
    private DomainDiscrete dom;
    private DomainDiscrete original;
    private AffirmPanel namePanel;
    private AffirmPanel domPanel;
    private DomainChooser domainChooser;
    private boolean isCancelled = true;
    private boolean domainUpdated = false;
    private JPanel p;
    private StripsWindow window;
    private ArrayList<String> removedItems;

    public VariableEditDialog(JFrame parent, StripsVariable var) {
        super(parent, "Variable Properties", true);
        this.setSize(300, 400);
        this.window = (StripsWindow)parent;
        if (var == null) {
            return;
        }
        this.var = var;
        this.original = var.getDomain();
        this.dom = this.original == null ? new DomainBoolean() : this.original;
        this.namePanel = new AffirmPanel();
        this.setLayout(new BoxLayout(this, 0));
        this.namePanel.add(new JLabel("Variable Name:     "));
        JTextField value = new JTextField(var.getName(), 10);
        this.namePanel.add(value);
        JLabel name = new JLabel(var.getName());
        this.removedItems = new ArrayList();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridheight = 4;
        this.getContentPane().setLayout(this.gbl);
        this.dom.updateDomain();
        this.domPanel = this.dom.getEditPanel(true);
        this.domainChooser = new DomainChooser(this.dom);
        this.domainChooser.setParent(this);
        Component[] domComponents = this.domPanel.getComponents();
        int i = 0;
        while (i < this.domPanel.getComponentCount()) {
            if (domComponents[i] instanceof JPanel) {
                Component[] innerComponents = ((JPanel)domComponents[i]).getComponents();
                int j = 0;
                while (j < ((JPanel)domComponents[i]).getComponentCount()) {
                    innerComponents[j].setEnabled(true);
                    ++j;
                }
            } else {
                domComponents[i].setEnabled(true);
            }
            ++i;
        }
        Component[] domChooserComponents = this.domainChooser.getComponents();
        int i2 = 0;
        while (i2 < this.domainChooser.getComponentCount()) {
            if (domChooserComponents[i2] instanceof JPanel) {
                Component[] innerComponents = ((JPanel)domChooserComponents[i2]).getComponents();
                int j = 0;
                while (j < ((JPanel)domChooserComponents[i2]).getComponentCount()) {
                    innerComponents[j].setEnabled(true);
                    ++j;
                }
            } else {
                domChooserComponents[i2].setEnabled(true);
            }
            ++i2;
        }
        this.p = new JPanel();
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        this.p.add(ok);
        this.p.add(cancel);
        this.addComponent(this.namePanel, this, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.domainChooser, this, 1, 0, -1, 1, 1.0, 1.0);
        this.addComponent(this.domPanel, this, 2, 0, -1, 2, 1.0, 1.0);
        this.addComponent(this.p, this, 4, 0, -1, 1, 0.0, 0.0);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public void setDomain(DomainDiscrete domain) {
        this.getContentPane().removeAll();
        this.dom = domain;
        this.domPanel = this.dom.getEditPanel(true);
        this.addComponent(this.namePanel, this, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.domainChooser, this, 1, 0, -1, 1, 1.0, 1.0);
        this.addComponent(this.domPanel, this, 2, 0, -1, 2, 1.0, 1.0);
        this.addComponent(this.p, this, 4, 0, -1, 1, 0.0, 0.0);
        this.validate();
    }

    @Override
    protected boolean actionOK() {
        if (!this.domPanel.ok()) {
            this.window.showMessage("Domain Error", "Domain needs to have at least one valid value.");
            return false;
        }
        if (this.dom.getDomainSize() <= 0) {
            this.window.showMessage("Domain Error", "No valid values entered for domain.");
            return false;
        }
        if (!this.namePanel.ok()) {
            return false;
        }
        this.removedItems = this.dom.getRemovedValues();
        this.var.setName(((JTextField)this.namePanel.getComponent(1)).getText());
        this.var.setDomain(this.dom);
        this.isCancelled = false;
        if (this.original != null) {
            this.domainUpdated = true;
        }
        return true;
    }

    @Override
    protected boolean actionCancel() {
        this.domPanel.cancel();
        this.var.setDomain(this.original);
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.domainChooser)) {
            this.setDomain(this.domainChooser.getCurrent());
        } else {
            super.actionPerformed(e);
        }
    }

    public boolean isDomainUpdated() {
        return this.domainUpdated;
    }

    public ArrayList<String> getRemovedValues() {
        return this.removedItems;
    }
}

