/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.conversion;

import AIspace.Constraint.ConstraintCSP;
import AIspace.Constraint.ConstraintCanvas;
import AIspace.Constraint.ConstraintWindow;
import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.STRIPSToCSP.StripsGraph;
import AIspace.STRIPSToCSP.elements.StripsAction;
import AIspace.STRIPSToCSP.elements.StripsCondition;
import AIspace.STRIPSToCSP.elements.StripsCondition_Conj;
import AIspace.STRIPSToCSP.elements.StripsState;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.STRIPSToCSP.visualElements.StripsActionNode;
import AIspace.STRIPSToCSP.visualElements.StripsVariableNode;
import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPWindow;
import AIspace.cspTools.CSPcanvas;
import AIspace.cspTools.CSPgraph;
import AIspace.cspTools.Relation;
import AIspace.cspTools.domains.DomainChooser;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.relations.RelationChooser;
import AIspace.graphToolKit.elements.Point;
import AIspace.hill.HillCSP;
import AIspace.hill.HillCanvas;
import AIspace.hill.elements.HillConstraint;
import AIspace.hill.elements.HillVariable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class StripsConverter {
    private CSPcanvas cspCanvas;
    private static final int constraintToVariableSpace = 80;
    private static final int initialVariableXpos = 50;
    private HashMap<StripsVariable, CSPVariable> preVarList = new HashMap();
    private HashMap<StripsAction, CSPVariable> actionList = new HashMap();
    private HashMap<StripsVariable, CSPVariable> postVarList = new HashMap();

    public CSPcanvas convertToCSP(StripsGraph graph, int horizon, CSPWindow window) {
        CSP csp;
        if (window instanceof ConstraintWindow) {
            csp = new ConstraintCSP(window, false);
            this.cspCanvas = new ConstraintCanvas(window, false, csp);
        } else {
            csp = new HillCSP(window, false);
            this.cspCanvas = new HillCanvas(window, false, csp);
        }
        csp.init(this.cspCanvas);
        this.convertDescriptions(graph, csp);
        for (StripsVariableNode variableNode : graph.getVariableNodes()) {
            if (variableNode.getVariableType() != 4292) continue;
            CSPVariable cspVar = this.convertVariable(variableNode, csp, 0);
            this.preVarList.put(variableNode.getVariable(), cspVar);
            this.postVarList.put(variableNode.getVariable(), cspVar);
            csp.addVariable(cspVar);
        }
        this.convertStartState(graph.getProblem().getStartState(), csp);
        int currentStep = 0;
        while (currentStep < horizon) {
            this.postVarList.clear();
            for (StripsVariableNode variableNode : graph.getVariableNodes()) {
                if (variableNode.getVariableType() != 4292) continue;
                CSPVariable cspVar = this.convertVariable(variableNode, csp, currentStep + 1);
                this.postVarList.put(variableNode.getVariable(), cspVar);
                csp.addVariable(cspVar);
            }
            for (StripsActionNode actionNode : graph.getActionNodes()) {
                CSPVariable action = this.convertAction(actionNode, csp, currentStep);
                this.actionList.put(actionNode.getAction(), action);
                csp.addVariable(action);
                this.convertPreConstraints(actionNode, csp, currentStep);
            }
            this.convertPostConstraints(graph.getActionNodes(), csp, currentStep);
            this.preVarList.clear();
            this.preVarList.putAll(this.postVarList);
            ++currentStep;
        }
        this.convertEndState(graph.getProblem().getEndState(), csp);
        return this.cspCanvas;
    }

    private void convertDescriptions(StripsGraph graph, CSP csp) {
        String shortString = graph.getShortDescription();
        shortString = "Converted from STRIPS\nConverted on " + new Date().toString() + "\n" + shortString;
        csp.setShortDesc(shortString);
        csp.setDetailedDesc(graph.getDetailedDescription());
    }

    private void convertPostConstraints(ArrayList<StripsActionNode> actionNodes, CSP csp, int currentStep) {
        ArrayList<CSPVariable> variables = new ArrayList<CSPVariable>();
        HashMap<CSPVariable, String> values = new HashMap<CSPVariable, String>();
        for (StripsVariable variable : this.postVarList.keySet()) {
            for (StripsActionNode actionNode : actionNodes) {
                if (!(actionNode.getAction().getPostCondition() instanceof StripsCondition_Conj)) continue;
                StripsCondition_Conj condition = (StripsCondition_Conj)actionNode.getAction().getPostCondition();
                for (StripsVariable actionVariable : condition.getVariables()) {
                    if (!actionVariable.equals(variable)) continue;
                    CSPVariable cspActionNode = this.actionList.get(actionNode.getAction());
                    variables.add(cspActionNode);
                    values.put(cspActionNode, condition.getValue(actionVariable));
                }
            }
            CSPVariable var = this.preVarList.get(variable);
            variables.add(var);
            var = this.postVarList.get(variable);
            variables.add(var);
            Point p = new Point(var.getXPos(), var.getYPos());
            p.translate(-80.0f, 0.0f);
            Constraint constraint = csp instanceof ConstraintCSP ? new Constraint((CSPgraph)this.cspCanvas.graph, p, variables, 1, csp) : new HillConstraint((CSPgraph)this.cspCanvas.graph, p, variables, 1, csp);
            Relation tempRelation = RelationChooser.newObject(0, constraint);
            this.determinePostConstraint(variables, values, tempRelation);
            tempRelation.setLabel("Effect_" + variable.getName() + "_" + (currentStep + 1));
            constraint.setRelation(tempRelation);
            csp.addConstraint(constraint);
            variables.clear();
            values.clear();
        }
    }

    private void convertPreConstraints(StripsActionNode actionNode, CSP csp, int currentStep) {
        StripsCondition preConds = actionNode.getAction().getPreCondition();
        ArrayList<CSPVariable> variables = new ArrayList<CSPVariable>();
        HashMap<CSPVariable, StripsVariable> variableMap = new HashMap<CSPVariable, StripsVariable>();
        for (StripsVariable variable : preConds.getVariables()) {
            CSPVariable var = this.preVarList.get(variable);
            variables.add(var);
            variableMap.put(var, variable);
        }
        CSPVariable cspActionNode = this.actionList.get(actionNode.getAction());
        variables.add(cspActionNode);
        Point p = new Point(cspActionNode.getXPos(), cspActionNode.getYPos());
        p.translate(-80.0f, 0.0f);
        Constraint constraint = csp instanceof ConstraintCSP ? new Constraint((CSPgraph)this.cspCanvas.graph, p, variables, 1, csp) : new HillConstraint((CSPgraph)this.cspCanvas.graph, p, variables, 1, csp);
        Relation tempRelation = RelationChooser.newObject(0, constraint);
        preConds.setRelation(variables, variableMap, tempRelation);
        tempRelation.setLabel("Pre_" + actionNode.getLabel() + "_" + currentStep);
        constraint.setRelation(tempRelation);
        csp.addConstraint(constraint);
    }

    private void determinePostConstraint(ArrayList<CSPVariable> variables, HashMap<CSPVariable, String> values, Relation relation) {
        DomainDiscrete domain = variables.get(variables.size() - 1).getDomain();
        StringBuffer relationBuffer = new StringBuffer();
        if (variables.size() == 2) {
            relationBuffer.append(this.postNoEffect(variables));
        } else {
            int allDomains = 1 << variables.size() - 3;
            int actionsIndex = 0;
            int baseStep = allDomains - 1;
            int allowedValue = this.findIndexInDomain(values.get(variables.get(actionsIndex)), domain.getDomain());
            int loop = 0;
            while (loop < 1 << variables.size() - 2) {
                if (loop == baseStep) {
                    int i = 0;
                    while (i < domain.getSize()) {
                        relationBuffer.append(this.createOneAllowedRelation(domain.getSize(), allowedValue));
                        ++i;
                    }
                    baseStep += (allDomains >>= 1);
                    allowedValue = this.findIndexInDomain(values.get(variables.get(++actionsIndex)), domain.getDomain());
                } else {
                    relationBuffer.append(this.postNoEffect(variables));
                }
                ++loop;
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(relationBuffer.toString());
        relation.setArgs(tokenizer);
    }

    private StringBuffer postNoEffect(ArrayList<CSPVariable> variables) {
        StringBuffer noEffectBuffer = new StringBuffer();
        int domainSize = variables.get(variables.size() - 1).getDomain().getSize();
        int offset = 0;
        int loop = 0;
        while (loop < domainSize * domainSize) {
            if (offset == loop) {
                noEffectBuffer.append("T ");
                offset += domainSize + 1;
            } else {
                noEffectBuffer.append("F ");
            }
            ++loop;
        }
        return noEffectBuffer;
    }

    private void convertEndState(StripsState endState, CSP csp) {
        Hashtable<StripsVariable, String> table = endState.getVariables();
        ArrayList<CSPVariable> cspVariables = new ArrayList<CSPVariable>();
        for (StripsVariable variable : table.keySet()) {
            if (table.get(variable).equals("  ---  ")) continue;
            CSPVariable cspVar = this.postVarList.get(variable);
            cspVariables.add(cspVar);
            Point p = new Point(cspVar.getXPos(), cspVar.getYPos());
            p.translate(80.0f, 0.0f);
            Constraint constraint = csp instanceof ConstraintCSP ? new Constraint((CSPgraph)this.cspCanvas.graph, p, cspVariables, 1, csp) : new HillConstraint((CSPgraph)this.cspCanvas.graph, p, cspVariables, 1, csp);
            String value = table.get(variable);
            String[] domain = variable.getDomain().getDomain();
            int locationInDomain = this.findIndexInDomain(value, domain);
            StringTokenizer tokenizer = new StringTokenizer(this.createOneAllowedRelation(domain.length, locationInDomain));
            Relation tempRelation = RelationChooser.newObject(0, constraint);
            tempRelation.setArgs(tokenizer);
            tempRelation.setLabel("End_" + variable.getName());
            constraint.setRelation(tempRelation);
            csp.addConstraint(constraint);
            cspVariables.clear();
        }
    }

    private void convertStartState(StripsState startState, CSP csp) {
        Hashtable<StripsVariable, String> table = startState.getVariables();
        ArrayList<CSPVariable> cspVariables = new ArrayList<CSPVariable>();
        for (StripsVariable variable : table.keySet()) {
            if (table.get(variable).equals("  ---  ")) continue;
            CSPVariable cspVar = this.preVarList.get(variable);
            cspVariables.add(cspVar);
            Point p = new Point(cspVar.getXPos(), cspVar.getYPos());
            p.translate(-80.0f, 0.0f);
            Constraint constraint = csp instanceof ConstraintCSP ? new Constraint((CSPgraph)this.cspCanvas.graph, p, cspVariables, 1, csp) : new HillConstraint((CSPgraph)this.cspCanvas.graph, p, cspVariables, 1, csp);
            String value = table.get(variable);
            String[] domain = variable.getDomain().getDomain();
            int locationInDomain = this.findIndexInDomain(value, domain);
            StringTokenizer tokenizer = new StringTokenizer(this.createOneAllowedRelation(domain.length, locationInDomain));
            Relation tempRelation = RelationChooser.newObject(0, constraint);
            tempRelation.setArgs(tokenizer);
            tempRelation.setLabel("Start_" + variable.getName());
            constraint.setRelation(tempRelation);
            csp.addConstraint(constraint);
            cspVariables.clear();
        }
    }

    private CSPVariable convertAction(StripsActionNode actionNode, CSP csp, int currentTimeStep) {
        int currentXpos = 210 + currentTimeStep * 80 * 4;
        DomainDiscrete newDomain = DomainChooser.newObject("Boolean");
        newDomain.addElement("true");
        newDomain.addElement("false");
        String newName = String.valueOf(actionNode.getAction().getName()) + "_s" + currentTimeStep;
        CSPVariable action = csp instanceof ConstraintCSP ? new ConstraintVariable(newDomain, this.cspCanvas.graph, new Point(currentXpos, actionNode.getPos().y), newName) : new HillVariable(newDomain, this.cspCanvas.graph, new Point(currentXpos, actionNode.getPos().y), newName, (HillCSP)csp);
        return action;
    }

    private CSPVariable convertVariable(StripsVariableNode variableNode, CSP csp, int currentTimeStep) {
        String[] domainItems;
        int currentXpos = 50 + currentTimeStep * 80 * 4;
        DomainDiscrete oldDomain = variableNode.getVariable().getDomain();
        DomainDiscrete newDomain = DomainChooser.newObject(oldDomain.getTypeString());
        String[] stringArray = domainItems = oldDomain.getDomain();
        int n = domainItems.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            newDomain.addElement(new String(item.toString()));
            ++n2;
        }
        String newName = String.valueOf(variableNode.getVariable().getName()) + "_s" + currentTimeStep;
        CSPVariable variable = csp instanceof ConstraintCSP ? new ConstraintVariable(newDomain, this.cspCanvas.graph, new Point(currentXpos, variableNode.getPos().y), newName) : new HillVariable(newDomain, this.cspCanvas.graph, new Point(currentXpos, variableNode.getPos().y), newName, (HillCSP)csp);
        return variable;
    }

    private String createPreRelation(int relationSize, int relationIndex) {
        StringBuffer returnString = new StringBuffer();
        int loop = 0;
        while (loop < relationSize) {
            if (loop % 2 == 0) {
                returnString.append("F ");
            } else {
                returnString.append("T ");
            }
            ++loop;
        }
        returnString.setCharAt(relationIndex * 2, 'T');
        return returnString.toString();
    }

    private String createOneAllowedRelation(int relationSize, int locationInDomain) {
        StringBuffer returnString = new StringBuffer();
        int loop = 0;
        while (loop < relationSize) {
            returnString.append("F ");
            ++loop;
        }
        returnString.setCharAt(locationInDomain * 2, 'T');
        return returnString.toString();
    }

    private int findIndexInDomain(String value, String[] domain) {
        int locationInDomain = 0;
        while (locationInDomain < domain.length && !domain[locationInDomain].equals(value)) {
            ++locationInDomain;
        }
        return locationInDomain;
    }
}

