/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.StripsIO;

import AIspace.STRIPSToCSP.StripsGraph;
import AIspace.STRIPSToCSP.elements.StripsAction;
import AIspace.STRIPSToCSP.elements.StripsCondition;
import AIspace.STRIPSToCSP.elements.StripsProblem;
import AIspace.STRIPSToCSP.elements.StripsState;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.STRIPSToCSP.visualElements.StripsActionNode;
import AIspace.STRIPSToCSP.visualElements.StripsContainer;
import AIspace.STRIPSToCSP.visualElements.StripsEdge;
import AIspace.STRIPSToCSP.visualElements.StripsVariableNode;
import AIspace.XMLReader.XMLBlock;
import AIspace.XMLReader.XMLParseException;
import AIspace.XMLReader.XMLTree;
import AIspace.cspTools.domains.DomainChooser;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class StripsIO {
    private HashMap<String, StripsVariable> variables = new HashMap();
    private HashMap<StripsVariable, String> variable_ids = new HashMap();
    private HashMap<Integer, Float> containerHeights = new HashMap();
    public static final String xmlvatt = "VERSION";
    public static final String xmlversion = "0.01";
    private static final String problemTag = "PROBLEM";
    private static final String containersTag = "CONTAINERS";
    private static final String variablesTag = "VARIABLES";
    private static final String actionsTag = "ACTIONS";
    private static final String statesTag = "STATES";
    private static final String containerTag = "CONTAINER";
    private static final String heightTag = "HEIGHT";
    private static final String variableTag = "VARIABLE";
    private static final String IDTag = "ID";
    private static final String stateTag = "STATE";
    private static final String pairTag = "PAIR";
    private static final String actionTag = "ACTION";
    private static final String preConditionTag = "PRECONDITIONS";
    private static final String postConditionTag = "POSTCONDITIONS";
    private static final String conditionTag = "CONDITION";
    private static final String positionTag = "POSITION";
    private static final String xPosTag = "XPOS";
    private static final String yPosTag = "YPOS";
    public static final String descriptionTag = "DESCRIPTION";
    public static final String shortTag = "SHORT";
    public static final String detailTag = "DETAILED";
    private static final String valueTag = "VALUE";
    private static final String nameTag = "NAME";
    private static final String variableIDTag = "VARIABLE_ID";
    private static final String typeTag = "TYPE";

    public StripsIO() {
        new StripsProblem();
    }

    public Boolean parseXML(String xml, StripsGraph newGraph) {
        Boolean returnVal = false;
        XMLTree tree = new XMLTree();
        try {
            tree.readString(xml);
        }
        catch (XMLParseException e) {
            StripsIO.parseError(e.getLocalizedMessage());
            return false;
        }
        XMLBlock head = tree.getHead();
        if (head.getTag().equals(problemTag)) {
            returnVal = this.parseTree(head, newGraph);
        } else {
            StripsIO.parseError("Missing the PROBLEM.");
        }
        return returnVal;
    }

    private Boolean parseTree(XMLBlock head, StripsGraph newGraph) {
        StripsProblem problem = newGraph.getProblem();
        ArrayList<XMLBlock> description = head.searchChildTag(descriptionTag);
        if (description == null || description.size() != 1) {
            StripsIO.parseError("There should be one DESCRIPTION in the problem");
        } else {
            String[] descriptions = this.parseDescriptions(description.get(0));
            newGraph.setShortDescription(descriptions[0]);
            newGraph.setDetailedDescription(descriptions[1]);
        }
        ArrayList<XMLBlock> containers = head.searchChildTag(containersTag);
        if (containers == null || containers.size() != 1) {
            StripsIO.parseError("There should be one CONTAINERS in the problem");
            return false;
        }
        for (XMLBlock container : containers.get((int)0).childBlocks) {
            this.parseContainer(container, newGraph);
        }
        for (XMLBlock child : head.searchChildTag((String)variablesTag).get((int)0).childBlocks) {
            this.parseVariable(child, problem, newGraph);
        }
        for (XMLBlock child : head.searchChildTag((String)actionsTag).get((int)0).childBlocks) {
            this.parseAction(child, problem, newGraph);
        }
        this.resizeContainers(newGraph);
        ArrayList<XMLBlock> statesBranch = head.searchChildTag(statesTag);
        if (statesBranch.size() != 1) {
            StripsIO.parseError("Missing a STATES tag.");
            return false;
        }
        ArrayList<XMLBlock> states = statesBranch.get(0).searchChildTag(stateTag);
        if (states.size() != 2) {
            StripsIO.parseError("There should only be two states in a problem");
            return false;
        }
        for (XMLBlock state : states) {
            this.parseState(state, problem);
        }
        return true;
    }

    public String graphToXML(StripsGraph graph) {
        StringBuffer returnString = new StringBuffer();
        ArrayList<StripsContainer> containers = new ArrayList<StripsContainer>();
        ArrayList<StripsVariableNode> variableNodes = new ArrayList<StripsVariableNode>();
        ArrayList<StripsActionNode> actionNodes = new ArrayList<StripsActionNode>();
        int variable_id = 1;
        Iterator<Node> nodes = graph.getNodes();
        while (nodes.hasNext()) {
            Node n = nodes.next();
            if (n instanceof StripsContainer && ((StripsContainer)n).getContainerType() != 99877) {
                containers.add((StripsContainer)n);
            }
            if (n instanceof StripsVariableNode && ((StripsVariableNode)n).getVariableType() == 4292) {
                variableNodes.add((StripsVariableNode)n);
            }
            if (!(n instanceof StripsActionNode)) continue;
            actionNodes.add((StripsActionNode)n);
        }
        returnString.append("<").append("?xml").append(" ").append(xmlvatt).append("=\"").append(xmlversion).append("\" ?>\n\n");
        returnString.append(StripsIO.startTag(problemTag)).append("\n");
        returnString.append(this.descriptionsToXML(graph.getShortDescription(), graph.getDetailedDescription()));
        returnString.append(this.containersToXML(containers));
        returnString.append(StripsIO.startTag(variablesTag)).append("\n");
        for (StripsVariableNode variable : variableNodes) {
            returnString.append(this.variableToXML(variable, variable_id));
            ++variable_id;
        }
        returnString.append(StripsIO.endTag(variablesTag));
        returnString.append(StripsIO.startTag(actionsTag)).append("\n");
        for (StripsActionNode action : actionNodes) {
            returnString.append(this.actionToXML(action));
        }
        returnString.append(StripsIO.endTag(actionsTag));
        returnString.append(StripsIO.startTag(statesTag)).append("\n");
        returnString.append(this.stateToXML(graph.getProblem().getStartState()));
        returnString.append(this.stateToXML(graph.getProblem().getEndState()));
        returnString.append(StripsIO.endTag(statesTag));
        returnString.append(StripsIO.endTag(problemTag));
        return returnString.toString();
    }

    private void parseContainer(XMLBlock container, StripsGraph newGraph) {
        float containerHeight;
        int containerType;
        ArrayList<XMLBlock> heights = container.searchChildTag(heightTag);
        if (container.getProperties().get(0) == null) {
            StripsIO.parseError("Missing property in CONTAINER block");
            return;
        }
        String typeString = container.getProperties().get((int)0).value;
        if (heights == null || heights.size() != 1) {
            StripsIO.parseError("There should only be the HEIGHT tag in the CONTAINER block");
            return;
        }
        String heightString = heights.get(0).getText();
        try {
            containerType = Integer.parseInt(typeString);
            containerHeight = Float.parseFloat(heightString);
        }
        catch (NumberFormatException e) {
            StripsIO.parseError(e.getLocalizedMessage());
            return;
        }
        this.containerHeights.put(new Integer(containerType), new Float(containerHeight));
        this.resizeContainers(newGraph);
    }

    private String containersToXML(ArrayList<StripsContainer> containers) {
        StringBuffer containersString = new StringBuffer();
        containersString.append(StripsIO.startTag(containersTag)).append("\n");
        for (StripsContainer container : containers) {
            containersString.append("\t<").append(containerTag).append(" ").append(typeTag).append("=");
            containersString.append(container.getContainerType()).append(">\n");
            containersString.append("\t\t").append(StripsIO.startTag(heightTag));
            containersString.append(container.height);
            containersString.append(StripsIO.endTag(heightTag));
            containersString.append("\t").append(StripsIO.endTag(containerTag));
        }
        containersString.append(StripsIO.endTag(containersTag));
        return containersString.toString();
    }

    private void parseVariable(XMLBlock child, StripsProblem problem, StripsGraph newGraph) {
        if (!child.getTag().endsWith(variableTag)) {
            StripsIO.parseError("Non Variable found in Variables section");
            return;
        }
        String type = child.getProperties().get((int)0).value;
        DomainDiscrete domain = DomainChooser.newObject(type);
        if (domain == null) {
            StripsIO.parseError("Variable TYPE " + type + " Not Found");
            return;
        }
        for (XMLBlock values : child.searchChildTag(valueTag)) {
            domain.addElement(values.getText());
        }
        String name = null;
        name = child.searchChildTag(nameTag).get(0).getText();
        if (name == null) {
            StripsIO.parseError("Could not find a NAME tag in a variable");
            return;
        }
        StripsVariable variable = new StripsVariable(domain, name);
        XMLBlock id = child.searchChildTag(IDTag).get(0);
        if (id == null) {
            StripsIO.missingTag(IDTag, variableTag);
            return;
        }
        this.variables.put(id.getText(), variable);
        XMLBlock position = child.searchChildTag(positionTag).get(0);
        if (position == null) {
            StripsIO.missingTag(positionTag, variableTag);
            return;
        }
        Point p = this.parsePosition(position);
        if (p != null) {
            StripsVariableNode node = new StripsVariableNode(newGraph, p, 4292, variable);
            newGraph.addNode(node);
            problem.addVariable(variable);
        }
    }

    private String variableToXML(StripsVariableNode variable, int variable_id) {
        StringBuffer variableString = new StringBuffer();
        variableString.append("\t<").append(variableTag).append(" ").append(typeTag).append("=");
        variableString.append(variable.getVariable().getDomain().getTypeString()).append(">\n");
        variableString.append("\t\t").append(StripsIO.startTag(IDTag));
        variableString.append(variable_id).append(StripsIO.endTag(IDTag));
        this.variable_ids.put(variable.getVariable(), Integer.toString(variable_id));
        variableString.append("\t\t").append(StripsIO.startTag(nameTag));
        variableString.append(variable.getVariable().getName()).append(StripsIO.endTag(nameTag));
        variableString.append("\t\t").append(StripsIO.startTag(positionTag)).append("\n");
        variableString.append("\t\t\t").append(StripsIO.startTag(xPosTag));
        variableString.append(variable.getPos().x).append(StripsIO.endTag(xPosTag));
        variableString.append("\t\t\t").append(StripsIO.startTag(yPosTag));
        variableString.append(variable.getPos().y).append(StripsIO.endTag(yPosTag));
        variableString.append("\t\t").append(StripsIO.endTag(positionTag));
        String[] stringArray = variable.getVariable().getDomain().getDomain();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String domainValue = stringArray[n2];
            variableString.append("\t\t").append(StripsIO.startTag(valueTag));
            variableString.append(domainValue).append(StripsIO.endTag(valueTag));
            ++n2;
        }
        variableString.append("\t").append(StripsIO.endTag(variableTag));
        return variableString.toString();
    }

    private void parseAction(XMLBlock child, StripsProblem problem, StripsGraph newGraph) {
        if (!child.getTag().equals(actionTag)) {
            StripsIO.parseError("Non-action node found in the actions");
            return;
        }
        ArrayList<XMLBlock> names = child.searchChildTag(nameTag);
        if (names.size() != 1) {
            StripsIO.parseError("There should be only one NAME tag in an ACTION block");
        }
        StripsAction action = new StripsAction(names.get(0).getText());
        ArrayList<XMLBlock> positions = child.searchChildTag(positionTag);
        if (positions.size() != 1) {
            StripsIO.parseError("There should be only one POSITION tag in an ACTION block");
            return;
        }
        Point point = this.parsePosition(positions.get(0));
        problem.addAction(action);
        StripsActionNode actionNode = new StripsActionNode(newGraph, point, action);
        newGraph.addNode(actionNode);
        ArrayList<XMLBlock> preConditions = child.searchChildTag(preConditionTag);
        if (preConditions.size() != 1) {
            StripsIO.parseError("There should be only one PRECONDITION tag in an ACTION block");
            return;
        }
        StripsCondition preCond = action.getPreCondition();
        preCond.setupFromXML(preConditions.get(0), this.variables);
        for (StripsVariable conditionVar : preCond.getVariables()) {
            StripsEdge edge = new StripsEdge(newGraph, (Node)newGraph.getVariableNode(conditionVar, 4292), (Node)actionNode);
            newGraph.addEdge(edge);
        }
        ArrayList<XMLBlock> postConditions = child.searchChildTag(postConditionTag);
        if (postConditions.size() != 1) {
            StripsIO.parseError("There should be only one POSTCONDITION tag in an ACTION block");
            return;
        }
        StripsCondition postCond = action.getPostCondition();
        postCond.setupFromXML(postConditions.get(0), this.variables);
        for (StripsVariable conditionVar : postCond.getVariables()) {
            StripsEdge edge = new StripsEdge(newGraph, (Node)actionNode, (Node)newGraph.getVariableNode(conditionVar, 4293));
            newGraph.addEdge(edge);
        }
    }

    private String actionToXML(StripsActionNode action) {
        StringBuffer actionString = new StringBuffer();
        actionString.append("\t").append(StripsIO.startTag(actionTag)).append("\n");
        actionString.append("\t\t").append(StripsIO.startTag(nameTag));
        actionString.append(action.getAction().getName()).append(StripsIO.endTag(nameTag));
        actionString.append("\t\t").append(StripsIO.startTag(positionTag)).append("\n");
        actionString.append("\t\t\t").append(StripsIO.startTag(xPosTag));
        actionString.append(action.getPos().x).append(StripsIO.endTag(xPosTag));
        actionString.append("\t\t\t").append(StripsIO.startTag(yPosTag));
        actionString.append(action.getPos().y).append(StripsIO.endTag(yPosTag));
        actionString.append("\t\t").append(StripsIO.endTag(positionTag));
        actionString.append(action.getAction().getPreCondition().toXML(this.variable_ids));
        actionString.append(action.getAction().getPostCondition().toXML(this.variable_ids));
        actionString.append("\t").append(StripsIO.endTag(actionTag));
        return actionString.toString();
    }

    private void parseState(XMLBlock state, StripsProblem problem) {
        String type;
        ArrayList<XMLBlock> types = state.searchChildTag(typeTag);
        if (types.size() != 1) {
            StripsIO.missingTag(typeTag, stateTag);
        }
        StripsState problemState = (type = types.get(0).getText().toLowerCase()).equals("goal") ? problem.getEndState() : problem.getStartState();
        ArrayList<XMLBlock> pairs = state.searchChildTag(pairTag);
        if (pairs.size() < 1) {
            StripsIO.missingTag(pairTag, stateTag);
        }
        for (XMLBlock pair : pairs) {
            this.parsePair(pair, problemState);
        }
    }

    private String stateToXML(StripsState state) {
        StringBuffer stateString = new StringBuffer();
        stateString.append("\t").append(StripsIO.startTag(stateTag)).append("\n");
        stateString.append("\t\t").append(StripsIO.startTag(typeTag));
        if (state.getStateType() == 793) {
            stateString.append("GOAL");
        } else {
            stateString.append("START");
        }
        stateString.append(StripsIO.endTag(typeTag));
        for (StripsVariable variable : state.getVariables().keySet()) {
            stateString.append("\t\t").append(StripsIO.startTag(pairTag)).append("\n");
            stateString.append("\t\t\t").append(StripsIO.startTag(variableIDTag));
            stateString.append(this.variable_ids.get(variable)).append(StripsIO.endTag(variableIDTag));
            stateString.append("\t\t\t").append(StripsIO.startTag(valueTag));
            stateString.append(state.getVariables().get(variable)).append(StripsIO.endTag(valueTag));
            stateString.append("\t\t").append(StripsIO.endTag(pairTag));
        }
        stateString.append("\t").append(StripsIO.endTag(stateTag)).append("\n");
        return stateString.toString();
    }

    private void parsePair(XMLBlock pair, StripsState state) {
        ArrayList<XMLBlock> values = pair.searchChildTag(valueTag);
        if (values.size() != 1) {
            StripsIO.missingTag(valueTag, pairTag);
            return;
        }
        ArrayList<XMLBlock> variableIDs = pair.searchChildTag(variableIDTag);
        if (variableIDs.size() != 1) {
            StripsIO.missingTag(variableIDTag, pairTag);
            return;
        }
        String value = values.get(0).getText();
        String variableID = variableIDs.get(0).getText();
        StripsVariable variable = this.variables.get(variableID);
        state.addVariable(variable, value);
    }

    private Point parsePosition(XMLBlock position) {
        ArrayList<XMLBlock> xPosArray = position.searchChildTag(xPosTag);
        if (xPosArray.size() != 1) {
            StripsIO.missingTag(xPosTag, positionTag);
            return null;
        }
        ArrayList<XMLBlock> yPosArray = position.searchChildTag(yPosTag);
        if (yPosArray.size() != 1) {
            StripsIO.missingTag(yPosTag, positionTag);
            return null;
        }
        float xPos = 0.0f;
        float yPos = 0.0f;
        try {
            xPos = Float.parseFloat(xPosArray.get(0).getText());
            yPos = Float.parseFloat(yPosArray.get(0).getText());
        }
        catch (Exception e) {
            StripsIO.parseError(e.getMessage());
            return null;
        }
        return new Point(xPos, yPos);
    }

    private String[] parseDescriptions(XMLBlock descriptionBlock) {
        String[] returnArray = new String[]{"", ""};
        ArrayList<XMLBlock> shortDesc = descriptionBlock.searchChildTag(shortTag);
        ArrayList<XMLBlock> longDesc = descriptionBlock.searchChildTag(detailTag);
        if (shortDesc != null && shortDesc.size() == 1) {
            returnArray[0] = shortDesc.get(0).getText();
        } else {
            StripsIO.parseError("There should be one SHORT in the problem");
        }
        if (longDesc != null && longDesc.size() == 1) {
            returnArray[1] = longDesc.get(0).getText();
        } else {
            StripsIO.parseError("Too many or too few DETAILED's in the description block");
        }
        return returnArray;
    }

    private String descriptionsToXML(String shortDescription, String longDescription) {
        StringBuffer returnBuffer = new StringBuffer();
        returnBuffer.append(StripsIO.startTag(descriptionTag)).append("\n");
        returnBuffer.append("\t").append(StripsIO.startTag(shortTag));
        returnBuffer.append(shortDescription);
        returnBuffer.append(StripsIO.endTag(shortTag)).append("\n");
        returnBuffer.append("\t").append(StripsIO.startTag(detailTag));
        returnBuffer.append(longDescription);
        returnBuffer.append(StripsIO.endTag(detailTag)).append("\n");
        returnBuffer.append(StripsIO.endTag(descriptionTag));
        return returnBuffer.toString();
    }

    public static String startTag(String tag) {
        return "<" + tag + ">";
    }

    public static String endTag(String tag) {
        return "</" + tag + ">\n";
    }

    private void resizeContainers(StripsGraph newGraph) {
        for (StripsContainer container : newGraph.getContainers()) {
            Integer key = new Integer(container.getContainerType());
            if (container.getContainerType() == 99877) {
                key = 99876;
            }
            if (!this.containerHeights.containsKey(key)) continue;
            container.resizeY(this.containerHeights.get(key).floatValue() - (float)container.height);
        }
    }

    public static void missingTag(String tag, String block) {
        StripsIO.parseError("Missing " + tag + " in block " + block + ".");
    }

    public static void parseError(String error) {
        JOptionPane.showMessageDialog(null, "XML Parsing Error: " + error, "Error", 0);
    }
}

