/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint;

import AIspace.Constraint.ConstraintCSP;
import AIspace.Constraint.ConstraintCanvas;
import AIspace.Constraint.dialogs.AutoSolveOptionsDialog;
import AIspace.Constraint.dialogs.ConstraintHelpCanvas;
import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPWindow;
import AIspace.cspTools.CSPcanvas;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.help.HelpFrame;
import AIspace.graphToolKit.help.HelpMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class ConstraintWindow
extends CSPWindow {
    private static final long serialVersionUID = 1L;
    public static final int SMALLEST = 1431;
    public static final int DEFAULT = 1432;
    public static final int CUSTOM = 1433;
    private JCheckBoxMenuItem showFineStepsCheckBoxMenuItem;
    private boolean isSplitHalf = true;
    private int splitBy = 1431;
    private ArrayList<CSPVariable> autoSolveVariableOrder;
    private int saveSpeed;
    public JTextArea textArea;
    public int domainHistoryIndent;
    public int numSplitsOnStack;
    public boolean domainSplit;
    private ImageIcon autoArcIcon;
    private ImageIcon autoSolveIcon;
    private ImageIcon backstepIcon;
    private ImageIcon stopIcon;
    private ImageIcon stepIcon;
    private ImageIcon finestepIcon;
    private ImageIcon backtrackIcon;
    private ImageIcon resetIcon;

    public ConstraintWindow(JApplet parent) {
        super(parent);
        this.initializeAppletInfo();
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.txt");
        this.setSize(700, 700);
        this.autoArcIcon = ConstraintWindow.createImageIcon("images/constraint/autoarc.png");
        this.autoSolveIcon = ConstraintWindow.createImageIcon("images/constraint/gear.png");
        this.stopIcon = ConstraintWindow.createImageIcon("images/constraint/stop.gif");
        this.stepIcon = ConstraintWindow.createImageIcon("images/constraint/step.png");
        this.finestepIcon = ConstraintWindow.createImageIcon("images/common/finestep.png");
        this.backtrackIcon = ConstraintWindow.createImageIcon("images/constraint/StepBack24.gif");
        this.resetIcon = ConstraintWindow.createImageIcon("images/constraint/Reset.gif");
        this.backstepIcon = ConstraintWindow.createImageIcon("images/constraint/stepback.png");
        this.textArea = new JTextArea("DOMAIN-SPLITTING HISTORY:\n", 7, 100);
        this.textArea.setEditable(false);
        this.textArea.setBackground(Color.white);
        this.textArea.setForeground(GraphConsts.fg);
        this.textArea.setSize(3, 100);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.scrollPanel.setPreferredSize(new Dimension(525, 450));
        this.bottomPanel.add((Component)new JScrollPane(this.textArea, 22, 31), "Center");
        this.bottomPanel.setVisible(false);
        this.setPromptLabel("Click the canvas to create a variable.");
        this.createButModes[0].setSelected(true);
        this.validate();
        this.domainHistoryIndent = 0;
        this.tabandbottom.setOneTouchExpandable(false);
        this.domainSplit = false;
        this.numSplitsOnStack = 0;
        this.setVisible(true);
    }

    private void initializeAppletInfo() {
        appletTitle = "CSP Applet Version 4.6.1";
        appletName = "constraint";
        aboutText = String.valueOf(appletTitle) + "\n\n" + "Constraint satisfaction problems (CSPs) are pervasive in AI problems.\n" + "A constraint satisfaction problem is the problem of assigning values\n" + "to variables that satisfy some constraints. This constraint\n" + "satisfaction problem solver (arc consistency) tool is designed to\n" + "help you learn about solving CSPs with a systematic search technique\n" + "called arc consistency.\n\n" + "This applet was written by Kevin O'Neill, Shinjiro Sueda, Saleema \n" + "Amershi, Mike Pavlin, Kyle Porter, and Byron Knoll, with help from\n" + "Leslie Tung, Mike Cline, Holger Hoos, Peter Gorniak, Cristina Conati, \n" + "Alan Mackworth, and David Poole.";
    }

    @Override
    protected CSPcanvas getCanvas(CSP csp) {
        return new ConstraintCanvas(this, false, csp);
    }

    @Override
    protected void getCanvas() {
        this.csp = this.getCSP();
        this.canvas = new ConstraintCanvas(this, false, this.csp);
        this.csp.init((CSPcanvas)this.canvas);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    @Override
    protected CSP getCSP() {
        return new ConstraintCSP(this, false);
    }

    protected CSP returnCSP() {
        return this.csp;
    }

    public int getIndent() {
        return this.domainHistoryIndent;
    }

    public void setIndent(int n) {
        this.domainHistoryIndent = n;
    }

    public int getSplitsOnStack() {
        return this.numSplitsOnStack;
    }

    public void setSplitsOnStack(int n) {
        this.numSplitsOnStack = n;
    }

    public ArrayList<CSPVariable> getVariableOrder() {
        return this.autoSolveVariableOrder;
    }

    public void setVariableOrder(ArrayList<CSPVariable> vars, int d) {
        this.splitBy = d;
        this.autoSolveVariableOrder = vars;
    }

    public boolean getSplitInHalf() {
        return this.isSplitHalf;
    }

    public void setSplitInHalf(boolean b) {
        this.isSplitHalf = b;
    }

    public void setSplitBy(int d) {
        this.splitBy = d;
    }

    public int getSplitBy() {
        return this.splitBy;
    }

    @Override
    protected void solveToolBar() {
        this.solveButModes = new JToggleButton[9];
        this.setSolveButtons(0, this.finestepIcon, "Fine Step");
        this.setSolveButtons(1, this.stepIcon, "Step");
        this.setSolveButtons(2, this.autoArcIcon, "Auto Arc-Consistency");
        this.setSolveButtons(3, this.autoSolveIcon, "AutoSolve");
        this.setSolveButtons(4, this.stopIcon, "Stop");
        this.setSolveButtons(5, this.backstepIcon, "Step Back");
        this.setSolveButtons(6, this.backtrackIcon, "Backtrack");
        this.setSolveButtons(7, this.resetIcon, "Reset");
        this.setSolveButtons(8, this.stepIcon, "Fake");
        this.solveToolBarLayout();
    }

    @Override
    protected void solveToolBarWithText() {
        this.solveButModes = new JToggleButton[9];
        this.setSolveButtonsWithText(0, " Fine Step ", this.finestepIcon, "Fine Step");
        this.setSolveButtonsWithText(1, "    Step    ", this.stepIcon, "Step");
        this.setSolveButtonsWithText(2, "Auto Arc-Consistency", this.autoArcIcon, "Auto Arc-Consistency");
        this.setSolveButtonsWithText(3, "AutoSolve", this.autoSolveIcon, "AutoSolve");
        this.setSolveButtonsWithText(4, "    Stop    ", this.stopIcon, "Stop");
        this.setSolveButtonsWithText(5, " Step Back ", this.backstepIcon, "Step Back");
        this.setSolveButtonsWithText(6, " Backtrack ", this.backtrackIcon, "Backtrack");
        this.setSolveButtonsWithText(7, "   Reset    ", this.resetIcon, "Reset");
        this.setSolveButtonsWithText(8, "Fake", this.stepIcon, "Fake");
        this.solveToolBarLayout();
    }

    private void solveToolBarLayout() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        int i = 0;
        while (i < 9) {
            if (i == 4 || i == 7) {
                this.toolBar.addSeparator();
            }
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.algoText.setText(" ");
        this.solveButModes[4].setEnabled(false);
        this.solveButModes[5].setEnabled(false);
        this.solveButModes[6].setEnabled(false);
        this.solveButModes[8].setVisible(false);
    }

    protected JMenu createCSPMenu() {
        JMenu m = new JMenu("CSP Options");
        m.setMnemonic(67);
        JMenu ACspeed = new JMenu("Arc-Consistency Speed");
        ACspeed.setMnemonic(83);
        ACspeed.setDisplayedMnemonicIndex(4);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem xFast = new JRadioButtonMenuItem("Very Fast (0 s)", false);
        xFast.addActionListener(this);
        ACspeed.add(xFast);
        group.add(xFast);
        JRadioButtonMenuItem fast = new JRadioButtonMenuItem("Fast (0.1 s)", false);
        fast.addActionListener(this);
        ACspeed.add(fast);
        group.add(fast);
        JRadioButtonMenuItem medium = new JRadioButtonMenuItem("Medium (0.5 s)", true);
        medium.addActionListener(this);
        ACspeed.add(medium);
        group.add(medium);
        JRadioButtonMenuItem slow = new JRadioButtonMenuItem("Slow (1 s)", false);
        slow.addActionListener(this);
        ACspeed.add(slow);
        group.add(slow);
        m.add(ACspeed);
        m.addSeparator();
        JMenuItem algOptions = new JMenuItem("AutoSolve Options...");
        algOptions.setMnemonic(65);
        algOptions.setActionCommand(algOptions.getText());
        algOptions.addActionListener(this);
        m.add(algOptions);
        m.addSeparator();
        this.showFineStepsCheckBoxMenuItem = new JCheckBoxMenuItem("Show Fine Steps", true);
        this.showFineStepsCheckBoxMenuItem.addActionListener(this);
        m.add(this.showFineStepsCheckBoxMenuItem);
        return m;
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar mBar = super.createMenuBar();
        mBar.add((Component)this.createCSPMenu(), 3);
        return mBar;
    }

    @Override
    protected JMenu createHelpMenu() {
        return new HelpMenu("constraint", this);
    }

    @Override
    protected void setMode(boolean solve) {
        ((ConstraintCanvas)this.canvas).stopAC();
        this.domainHistoryIndent = 0;
        this.numSplitsOnStack = 0;
        this.textArea.setText("DOMAIN-SPLITTING HISTORY:\n");
        if (this.solveButModes != null) {
            this.solveButModes[6].setEnabled(false);
        }
        if (this.solveButModes == null) {
            if (this.isButtonTextShowing()) {
                this.solveToolBarWithText();
            } else {
                this.solveToolBar();
            }
        }
        if (!solve) {
            this.bottomPanel.setVisible(false);
            this.tabandbottom.setOneTouchExpandable(false);
            this.setPromptLabel("");
            this.validate();
        } else if (solve) {
            this.bottomPanel.setVisible(true);
            this.tabandbottom.setOneTouchExpandable(true);
            this.tabandbottom.setDividerLocation(0.85);
            this.textArea.setCaretPosition(0);
            ((ConstraintCanvas)this.canvas).resetCSP();
            ((ConstraintCanvas)this.canvas).setNextSolve(ConstraintCanvas.FIRST_SOLVE);
            this.setPromptLabel("Click on a variable to split its domain.\nClick on a constraint to view its properties.\nClick on an arc to make it arc-consistent.");
            this.validate();
            this.returnCanvas().repaint();
        }
    }

    public void domainSplittingOccurred(ConstraintVariable splittingNode) {
        splittingNode.pushIndent(this.domainHistoryIndent);
        this.textArea.append("\n");
        int i = 0;
        while (i < this.domainHistoryIndent) {
            this.textArea.append("    ");
            ++i;
        }
        this.textArea.append(splittingNode.getSplittingString());
        ++this.domainHistoryIndent;
        this.solveButModes[6].setEnabled(true);
        ++this.numSplitsOnStack;
        this.domainSplit = true;
        ((ConstraintCanvas)this.canvas).enableBacktrack(true);
    }

    public void backtrackingOccurred(ConstraintVariable backtrackNode, boolean displayInfo) {
        if (((ConstraintCanvas)this.canvas).getNextSolve() == ConstraintCanvas.FIRST_SOLVE) {
            this.setPromptLabel("No more solutions.");
            return;
        }
        if (backtrackNode == null) {
            this.numSplitsOnStack = 0;
            return;
        }
        if (displayInfo) {
            this.domainHistoryIndent = backtrackNode.popIndent();
            this.textArea.append("\n");
            int i = 0;
            while (i < this.domainHistoryIndent) {
                this.textArea.append("    ");
                ++i;
            }
            this.textArea.append(backtrackNode.getSplittingString());
            ++this.domainHistoryIndent;
        }
        --this.numSplitsOnStack;
        if (this.numSplitsOnStack <= 0) {
            this.solveButModes[6].setEnabled(false);
            ((ConstraintCanvas)this.canvas).backTrackItem.setEnabled(false);
        }
        this.solveButModes[0].setEnabled(true);
        this.solveButModes[1].setEnabled(true);
        this.solveButModes[2].setEnabled(true);
        this.solveButModes[8].setSelected(true);
        this.setPromptLabel("Backtracked - Variable " + backtrackNode.getName() + " in {" + backtrackNode.getSplitRep() + "}\nNow try to solve the CSP.");
    }

    protected boolean hasMoreSplits() {
        return this.numSplitsOnStack > 0;
    }

    @Override
    public void switchTab(String str) {
        super.switchTab(str);
        if (str == "Solve") {
            this.resetWindow();
        } else if (str.equals("Create")) {
            this.stopAutoAC();
            this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
        }
        this.canvas.autoscale();
    }

    @Override
    protected void saveProperties() {
        super.saveProperties();
        this.saveSpeed = ((ConstraintCanvas)this.canvas).getSpeed();
    }

    @Override
    protected void restoreProperties() {
        super.restoreProperties();
        ((ConstraintCanvas)this.canvas).setSpeed(this.saveSpeed);
        if (this.returnCanvas().getMode() == 2220) {
            this.createButModes[0].setSelected(true);
            this.returnCanvas().setSubmode(351);
            this.setPromptLabel("Click the canvas to create a variable.");
        }
        this.setVariableOrder(null, 1431);
        this.setSplitInHalf(true);
    }

    protected void autoArcStart() {
        if (((ConstraintCanvas)this.canvas).graph.numNodes() == 0) {
            this.setPromptLabel("There is no CSP.  Create one first!");
        } else {
            this.solveButModes[0].setEnabled(false);
            this.solveButModes[1].setEnabled(false);
            this.solveButModes[4].setEnabled(true);
            this.solveButModes[3].setEnabled(false);
            ((ConstraintCanvas)this.canvas).autoSolveItem.setEnabled(false);
            ((ConstraintCanvas)this.canvas).stopItem.setEnabled(true);
            ((ConstraintCanvas)this.canvas).autoAC();
        }
        this.canvas.repaint();
    }

    protected void autoSolveStart() {
        if (((ConstraintCanvas)this.canvas).graph.numNodes() == 0) {
            this.setPromptLabel("There is no CSP.  Create one first!");
        } else {
            this.solveButModes[0].setEnabled(false);
            this.solveButModes[1].setEnabled(false);
            this.solveButModes[2].setEnabled(false);
            this.solveButModes[3].setEnabled(false);
            this.solveButModes[4].setEnabled(true);
            ((ConstraintCanvas)this.canvas).autoSolveItem.setEnabled(true);
            ((ConstraintCanvas)this.canvas).stopItem.setEnabled(true);
            ((ConstraintCanvas)this.canvas).autoSolve();
        }
        this.canvas.repaint();
    }

    @Override
    protected void loadSampleGraph() {
        super.loadSampleGraph();
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.switchTab("Solve");
        }
        this.getUndoMenuItem().setEnabled(false);
        this.tabandbottom.setDividerLocation(0.85);
        ((ConstraintCanvas)this.canvas).getCSP().setPosition();
    }

    @Override
    protected void openGraph() {
        super.openGraph();
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.switchTab("Solve");
        }
        this.getUndoMenuItem().setEnabled(false);
    }

    @Override
    protected void createNewGraph() {
        super.createNewGraph();
        this.getUndoMenuItem().setEnabled(false);
    }

    public void resetWindow() {
        this.domainHistoryIndent = 0;
        this.numSplitsOnStack = 0;
        this.textArea.setText("DOMAIN-SPLITTING HISTORY:\n");
        this.domainSplit = false;
        if (this.solveButModes != null) {
            int i = 0;
            while (i < 4) {
                this.solveButModes[i].setEnabled(true);
                ++i;
            }
            ((ConstraintCanvas)this.canvas).autoSolveItem.setEnabled(true);
            ((ConstraintCanvas)this.canvas).stepBackItem.setEnabled(false);
            this.solveButModes[5].setEnabled(false);
            this.solveButModes[6].setEnabled(false);
            this.solveButModes[8].setSelected(true);
            if (((ConstraintCanvas)this.canvas).pop.getSubElements().length >= 7) {
                ((ConstraintCanvas)this.canvas).pop.getComponent(7).setEnabled(false);
            }
        }
        ((ConstraintCanvas)this.canvas).resetCSP();
        ((ConstraintCanvas)this.canvas).setNextSolve(ConstraintCanvas.FIRST_SOLVE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Very Fast (0 s)")) {
            ((ConstraintCanvas)this.canvas).setSpeed(0);
        } else if (arg.equals("Fast (0.1 s)")) {
            ((ConstraintCanvas)this.canvas).setSpeed(100);
        } else if (arg.equals("Medium (0.5 s)")) {
            ((ConstraintCanvas)this.canvas).setSpeed(500);
        } else if (arg.equals("Slow (1 s)")) {
            ((ConstraintCanvas)this.canvas).setSpeed(1000);
        } else if (arg.equals("Show Fine Steps")) {
            ((ConstraintCanvas)this.canvas).showFS(this.showFineStepsCheckBoxMenuItem.isSelected());
        } else if (arg.equals("AutoSolve Options...")) {
            new AutoSolveOptionsDialog(this, (ConstraintCSP)this.csp);
        } else {
            if (arg.equals("Legend for Nodes/Edges")) {
                new HelpFrame("Legend", new ConstraintHelpCanvas(this.isAntiAliasingEnabled()), 350, 350);
                return;
            }
            if (this.returnCanvas().getMode() == 2221) {
                if (arg.equals("Auto Arc-Consistency") || e.getSource() == this.solveButModes[2]) {
                    this.autoArcStart();
                } else if (arg.equals("AutoSolve") || e.getSource() == this.solveButModes[3]) {
                    this.autoSolveStart();
                } else if (arg.equals("    Stop    ") || e.getSource() == this.solveButModes[4]) {
                    this.stopAutoAC();
                } else if (arg.equals("    Step    ") || e.getSource() == this.solveButModes[1]) {
                    if (((ConstraintCanvas)this.canvas).graph.numNodes() == 0) {
                        this.setPromptLabel("There is no CSP.  Create one first!");
                    } else if (!((ConstraintCanvas)this.canvas).step()) {
                        this.setPromptLabel("Click on a variable to split its domain.\nClick on a constraint to reorder its variables.\nClick on an arc to make it arc-consistent.");
                    } else if (((ConstraintCanvas)this.canvas).checkSolutions() == ConstraintCanvas.NO_MORE_SOLUTIONS) {
                        ((ConstraintCanvas)this.canvas).ACSolve();
                        this.setACButtons(false);
                    }
                    this.canvas.repaint();
                    this.solveButModes[8].setSelected(true);
                } else if (arg.equals(" Fine Step ") || e.getSource() == this.solveButModes[0]) {
                    if (((ConstraintCanvas)this.canvas).graph.numNodes() == 0) {
                        this.setPromptLabel("There is no CSP.  Create one first!");
                    } else if (!((ConstraintCanvas)this.canvas).fineStep()) {
                        this.canvas.repaint();
                    } else {
                        if (((ConstraintCanvas)this.canvas).checkSolutions() == ConstraintCanvas.NO_MORE_SOLUTIONS) {
                            ((ConstraintCanvas)this.canvas).ACSolve();
                        }
                        this.setACButtons(false);
                    }
                    this.solveButModes[8].setSelected(true);
                } else if (arg.equals(" Backtrack ") || e.getSource() == this.solveButModes[6]) {
                    this.backtrackingOccurred(((ConstraintCanvas)this.canvas).backtrack(), true);
                } else if (arg.equals(" Step Back ") || e.getSource() == this.solveButModes[5]) {
                    ((ConstraintCanvas)this.canvas).stepback();
                    this.canvas.repaint();
                    this.setACButtons(true);
                    this.solveButModes[8].setSelected(true);
                } else if (arg.equals("   Reset    ") || e.getSource() == this.solveButModes[7]) {
                    ((ConstraintCanvas)this.canvas).stopSolving();
                    ((ConstraintCanvas)this.canvas).stopAC();
                    this.solveButModes[4].setEnabled(false);
                    ((ConstraintCanvas)this.canvas).stopItem.setEnabled(false);
                    while (((ConstraintCanvas)this.canvas).auto != null && ((ConstraintCanvas)this.canvas).auto.isAlive() || ((ConstraintCanvas)this.canvas).autosolve != null && ((ConstraintCanvas)this.canvas).autosolve.isAlive()) {
                    }
                    this.resetWindow();
                    this.canvas.repaint();
                }
            }
        }
        super.actionPerformed(e);
    }

    private void stopAutoAC() {
        this.solveButModes[4].setEnabled(false);
        ((ConstraintCanvas)this.canvas).stopItem.setEnabled(false);
        int i = 0;
        while (i < 4) {
            this.solveButModes[i].setEnabled(true);
            ++i;
        }
        ((ConstraintCanvas)this.canvas).autoSolveItem.setEnabled(true);
        if (((ConstraintCanvas)this.canvas).autosolve != null) {
            ((ConstraintCanvas)this.canvas).stopSolving();
        }
        if (((ConstraintCanvas)this.canvas).auto != null) {
            ((ConstraintCanvas)this.canvas).stopAC();
        }
        this.canvas.repaint();
    }

    public void setACButtons(boolean isEnabled) {
        this.solveButModes[0].setEnabled(isEnabled);
        this.solveButModes[1].setEnabled(isEnabled);
        this.solveButModes[2].setEnabled(isEnabled);
    }

    public void setButtonsForAutoAC(boolean isEnabled) {
        this.solveButModes[0].setEnabled(!isEnabled);
        this.solveButModes[1].setEnabled(!isEnabled);
        this.solveButModes[2].setEnabled(!isEnabled);
        this.solveButModes[3].setEnabled(!isEnabled);
        this.solveButModes[4].setEnabled(isEnabled);
        this.solveButModes[7].setEnabled(!isEnabled);
        this.solveButModes[8].setSelected(!isEnabled);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.tabandbottom.setDividerLocation(0.85);
    }

    public static void main(String[] args) {
        ConstraintWindow window = new ConstraintWindow(null);
        if (args.length > 0) {
            String url = args[0];
            try {
                window.fileName = url.substring(url.lastIndexOf("/") + 1);
                window.load(new BufferedReader(new InputStreamReader(new URL(url).openStream())));
            }
            catch (Exception exc) {
                window.showMessage("Error", exc.toString());
            }
        }
    }
}

