/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill;

import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPWindow;
import AIspace.cspTools.CSPcanvas;
import AIspace.graphToolKit.help.HelpFrame;
import AIspace.graphToolKit.help.HelpMenu;
import AIspace.hill.HillCSP;
import AIspace.hill.HillCanvas;
import AIspace.hill.SolveCanvas;
import AIspace.hill.Updateable;
import AIspace.hill.batch.BatchCanvas;
import AIspace.hill.dialogs.BatchDialog;
import AIspace.hill.dialogs.TraceFrame;
import AIspace.hill.help.HillHelpCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class HillWindow
extends CSPWindow {
    private static final long serialVersionUID = 1L;
    private JMenuItem batchOptions;
    private JMenuItem algOptions;
    private JMenu ASspeed;
    private int saveSpeedProperty;
    private JToggleButton step;
    private JToggleButton finestep;
    private JToggleButton auto;
    private JToggleButton stop;
    private JToggleButton random;
    private JToggleButton showPlot;
    public JToggleButton batch;
    private ImageIcon showTraceIcon;
    private ImageIcon stopIcon;
    private ImageIcon stepIcon;
    private ImageIcon finestepIcon;
    private ImageIcon batchIcon;
    private ImageIcon initIcon;
    private ImageIcon showPlotIcon;
    private boolean isFineStepEnabled;
    private int init;
    private int giveUp;
    private int alg;
    private int maxBatchCount;

    public HillWindow(JApplet parent) {
        super(parent);
        this.initializeAppletInfo();
        this.stopIcon = HillWindow.createImageIcon("images/hill/stop.gif");
        this.stepIcon = HillWindow.createImageIcon("images/hill/step.png");
        this.finestepIcon = HillWindow.createImageIcon("images/common/finestep.png");
        this.batchIcon = HillWindow.createImageIcon("images/hill/batchrunner.png");
        this.initIcon = HillWindow.createImageIcon("images/hill/initialize.png");
        this.showPlotIcon = HillWindow.createImageIcon("images/hill/showPlot.png");
        this.showTraceIcon = HillWindow.createImageIcon("images/hill/viewCurrentPlan.png");
        this.setSize(700, 700);
        this.scrollPanel.setPreferredSize(new Dimension(525, 450));
        this.bottomPanel.setVisible(false);
        this.algoText.setVisible(false);
        this.tabandbottom.setBottomComponent(this.algoText);
        this.tabandbottom.setResizeWeight(1.0);
        this.tabandbottom.setOneTouchExpandable(false);
        this.ASspeed.setEnabled(false);
        this.algOptions.setEnabled(false);
        this.batchOptions.setEnabled(false);
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.txt");
        this.setPromptLabel("Click the canvas to create a variable.");
        this.createButModes[0].setSelected(true);
        this.setVisible(true);
    }

    private void initializeAppletInfo() {
        appletTitle = "Stochastic Local Search Applet Version 4.6.0";
        appletName = "hill";
        aboutText = String.valueOf(appletTitle) + "\n\n" + "Constraint satisfaction problems (CSPs) are pervasive in AI problems.\n" + "A constraint satisfaction problem is the problem of assigning values to\n" + "variables that satisfy some constraints. This CSP solver uses stochastic\n" + "local search algorithms to attempt to find assignments to the variables\n" + "which satisfy the constraints using heuristics in a local neighbourhood.\n\n" + "This applet was written by Shinjiro Sueda, Mike Pavlin, Saleema Amershi, \n" + "Regan Yuen, Kyle Porter, and Byron Knoll, with help from Kevin O'Neill, \n" + "Leslie Tung, Mike Cline, Holger Hoos, Cristina Conati, Peter Gorniak, \n" + "Alan Mackworth, and David Poole.";
    }

    @Override
    protected CSPcanvas getCanvas(CSP csp) {
        HillCanvas hc = new HillCanvas(this, false, csp);
        hc.setPreferredSize(new Dimension(1000, 1000));
        return hc;
    }

    @Override
    protected CSP getCSP() {
        return new HillCSP(this, false);
    }

    @Override
    protected void getCanvas() {
        this.csp = this.getCSP();
        HillCanvas newcanvas = new HillCanvas(this, false, this.csp);
        this.canvas = newcanvas;
        this.csp.init((CSPcanvas)this.canvas);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    protected BatchCanvas getBatchCanvas() {
        return ((HillCanvas)this.canvas).engine.getBatchCanvas();
    }

    protected SolveCanvas getSolveCanvas() {
        return ((HillCanvas)this.canvas).engine.getSolveCanvas();
    }

    protected CSP returnCSP() {
        return this.csp;
    }

    @Override
    protected void solveToolBar() {
        this.solveButModes = new JToggleButton[9];
        this.setSolveButtons(0, this.initIcon, "Initialize");
        this.setSolveButtons(1, this.finestepIcon, "Fine Step");
        this.setSolveButtons(2, this.stepIcon, "Step");
        this.setSolveButtons(3, solveIcon, "Auto Solve");
        this.setSolveButtons(4, this.batchIcon, "Batch Run");
        this.setSolveButtons(5, this.stopIcon, "Stop");
        this.setSolveButtons(6, this.showPlotIcon, "Show Plot");
        this.setSolveButtons(7, this.showTraceIcon, "Show Trace");
        this.setSolveButtons(8, this.stepIcon, "Fake");
        this.solveToolBarLayout();
    }

    @Override
    protected void solveToolBarWithText() {
        this.solveButModes = new JToggleButton[9];
        this.setSolveButtonsWithText(0, "Initialize", this.initIcon, "Initialize");
        this.setSolveButtonsWithText(1, "Fine Step", this.finestepIcon, "Fine Step");
        this.setSolveButtonsWithText(2, "Step", this.stepIcon, "Step");
        this.setSolveButtonsWithText(3, "Auto Solve", solveIcon, "Auto Solve");
        this.setSolveButtonsWithText(4, "Batch Run", this.batchIcon, "Batch Run");
        this.setSolveButtonsWithText(5, "Stop", this.stopIcon, "Stop");
        this.setSolveButtonsWithText(6, "Show Plot", this.showPlotIcon, "Show Plot");
        this.setSolveButtonsWithText(7, "Show Trace", this.showTraceIcon, "Show Trace");
        this.setSolveButtonsWithText(8, "Fake", this.stepIcon, "Fake");
        this.solveToolBarLayout();
    }

    private void solveToolBarLayout() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        int i = 0;
        while (i < 8) {
            this.solveModeButGroup.add(this.solveButModes[i]);
            if (i == 6) {
                this.toolBar.addSeparator();
            }
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.solveModeButGroup.add(this.solveButModes[8]);
        this.random = this.solveButModes[0];
        this.finestep = this.solveButModes[1];
        this.step = this.solveButModes[2];
        this.auto = this.solveButModes[3];
        this.batch = this.solveButModes[4];
        this.stop = this.solveButModes[5];
        this.showPlot = this.solveButModes[6];
    }

    protected JMenu createHillMenu() {
        JMenu m = new JMenu("Hill Options");
        m.setMnemonic(72);
        this.ASspeed = new JMenu("Auto Solve Speed");
        this.ASspeed.setMnemonic(83);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem xFast = new JRadioButtonMenuItem("Very Fast (0 s)", false);
        xFast.addActionListener(this);
        this.ASspeed.add(xFast);
        group.add(xFast);
        JRadioButtonMenuItem fast = new JRadioButtonMenuItem("Fast (0.1 s)", false);
        fast.addActionListener(this);
        this.ASspeed.add(fast);
        group.add(fast);
        JRadioButtonMenuItem medium = new JRadioButtonMenuItem("Medium (0.5 s)", true);
        medium.addActionListener(this);
        this.ASspeed.add(medium);
        group.add(medium);
        JRadioButtonMenuItem slow = new JRadioButtonMenuItem("Slow (1 s)", false);
        slow.addActionListener(this);
        this.ASspeed.add(slow);
        m.add(this.ASspeed);
        group.add(slow);
        m.addSeparator();
        this.algOptions = new JMenuItem("Algorithm Options...");
        this.algOptions.setMnemonic(65);
        this.algOptions.setActionCommand(this.algOptions.getText());
        this.algOptions.addActionListener(this);
        m.add(this.algOptions);
        this.batchOptions = new JMenuItem("Batch Run Options...");
        this.batchOptions.setMnemonic(66);
        this.batchOptions.setActionCommand(this.batchOptions.getText());
        this.batchOptions.addActionListener(this);
        m.add(this.batchOptions);
        return m;
    }

    @Override
    protected JMenu createHelpMenu() {
        return new HelpMenu("hill", this);
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        menuBar.add((Component)this.createHillMenu(), 3);
        return menuBar;
    }

    @Override
    public void setMode(boolean solve) {
        if (!solve) {
            this.setPromptLabel("Create Mode");
            this.ASspeed.setEnabled(false);
            this.algOptions.setEnabled(false);
            this.batchOptions.setEnabled(false);
            this.algoText.setVisible(false);
            this.bottomPanel.setVisible(false);
            this.tabandbottom.setDividerLocation(0.96);
        } else {
            this.setPromptLabel("Click on \"Initialize\" to start.");
            this.ASspeed.setEnabled(true);
            this.algOptions.setEnabled(true);
            this.batchOptions.setEnabled(true);
            ((HillCSP)this.csp).started = false;
            this.enableInit(false);
            this.algoText.setVisible(true);
            this.bottomPanel.setVisible(true);
            this.tabandbottom.setDividerLocation(0.96);
            this.setTA(true);
        }
        ((HillCSP)this.csp).setCurrBold(false);
    }

    public void setButtonsSolved(boolean boolSolved) {
        this.random.setEnabled(true);
        this.step.setEnabled(!boolSolved);
        if (!((HillCanvas)this.canvas).engine.fineStepAllowed()) {
            this.finestep.setEnabled(false);
        } else {
            this.finestep.setEnabled(!boolSolved);
        }
        this.auto.setEnabled(!boolSolved);
        this.stop.setEnabled(false);
        ((HillCanvas)this.returnCanvas()).setButtonsSolved(boolSolved);
    }

    public void enableButtons(boolean bool) {
        ((HillCanvas)this.canvas).enableButtons(bool);
        this.step.setEnabled(bool);
        this.enableFineStep(bool);
        this.auto.setEnabled(bool);
        this.stop.setEnabled(false);
        this.batch.setEnabled(bool);
    }

    public void enableInit(boolean bool) {
        ((HillCanvas)this.canvas).enableInit(bool);
        this.step.setEnabled(bool);
        this.enableFineStep(bool);
        this.auto.setEnabled(bool);
        this.stop.setEnabled(false);
        this.batch.setEnabled(!bool);
    }

    public void enableBatch(boolean bool) {
        this.batch.setEnabled(bool);
        this.step.setEnabled(bool);
        this.enableFineStep(bool);
        this.auto.setEnabled(bool);
        this.stop.setEnabled(!bool);
        this.random.setEnabled(bool);
    }

    public void enableAuto(boolean bool) {
        this.batch.setEnabled(bool);
        this.step.setEnabled(bool);
        this.enableFineStep(bool);
        this.auto.setEnabled(bool);
        this.stop.setEnabled(!bool);
        this.random.setEnabled(bool);
    }

    public void enableFineStep(boolean bool) {
        this.isFineStepEnabled = bool;
        if (!bool) {
            this.finestep.setEnabled(bool);
            ((HillCanvas)this.canvas).finestep.setEnabled(bool);
        } else if (((HillCanvas)this.canvas).engine.fineStepAllowed() && !((HillCanvas)this.canvas).engine.isStoppingCriteriaMet()) {
            this.finestep.setEnabled(bool);
            ((HillCanvas)this.canvas).finestep.setEnabled(bool);
        } else {
            this.finestep.setEnabled(false);
            ((HillCanvas)this.canvas).finestep.setEnabled(false);
        }
    }

    public void disableFineStep() {
        if (!((HillCanvas)this.canvas).engine.fineStepAllowed()) {
            if (this.finestep != null) {
                this.finestep.setEnabled(false);
                ((HillCanvas)this.canvas).finestep.setEnabled(false);
            }
        } else if (!((HillCanvas)this.canvas).engine.isStoppingCriteriaMet() && this.finestep != null) {
            this.finestep.setEnabled(this.isFineStepEnabled);
            ((HillCanvas)this.canvas).finestep.setEnabled(this.isFineStepEnabled);
        }
    }

    protected void setTA(boolean t) {
        if (t) {
            this.setAlgoText(((HillCanvas)this.canvas).engine.getCurrSearch().getName());
        } else {
            this.algoText.setText("");
        }
    }

    public void setAlgoText(String algName) {
        this.algoText.setText("Algorithm Selected:  " + algName);
    }

    public void fineStep() {
        this.setPromptLabel("");
        ((HillCanvas)this.canvas).engine.finestep();
        this.canvas.repaint();
        this.solveButModes[8].setSelected(true);
        ((HillCanvas)this.canvas).updateNodeDetailFrame();
    }

    protected void showTrace() {
        if (((HillCanvas)this.canvas).engine.trace == null) {
            ((HillCanvas)this.canvas).engine.trace = new TraceFrame((Container)this, ((HillCanvas)this.canvas).engine);
        }
        ((HillCanvas)this.canvas).engine.openTrace();
        this.solveButModes[8].setSelected(true);
    }

    protected void showPlot() {
        ((HillCanvas)this.canvas).engine.showPlot();
        this.solveButModes[8].setSelected(true);
    }

    public void step() {
        this.setPromptLabel("");
        ((HillCanvas)this.canvas).engine.step();
        this.solveButModes[8].setSelected(true);
        ((HillCanvas)this.canvas).updateNodeDetailFrame();
    }

    protected void autoSolveStart() {
        this.setPromptLabel("Running Auto Solve...");
        this.solveButModes[8].setSelected(true);
        ((HillCanvas)this.canvas).engine.autoSolveStart();
    }

    protected void autoSolveStop() {
        this.setPromptLabel("Click on a node to change its value");
        ((HillCanvas)this.canvas).engine.stopBatchRun();
        ((HillCanvas)this.canvas).engine.resetAutoSolve();
        this.canvas.repaint();
    }

    protected void batchRunStart() {
        this.solveButModes[8].setSelected(true);
        ((HillCSP)this.csp).setCurrBold(false);
        ((HillCanvas)this.canvas).hideConflictFrame();
        ((HillCanvas)this.canvas).engine.batchRun();
    }

    @Override
    protected void closeTrace() {
        if (((HillCanvas)this.canvas).engine.trace != null) {
            ((HillCanvas)this.canvas).engine.trace.setVisible(false);
            ((HillCanvas)this.canvas).engine.trace.dispose();
        }
    }

    protected void closePlot() {
        if (((HillCanvas)this.canvas).engine.getPlotFrame() != null) {
            ((HillCanvas)this.canvas).engine.closePlotFrame();
        }
    }

    protected void closeBatch() {
        if (((HillCanvas)this.canvas).engine.getBatchFrame() != null) {
            ((HillCanvas)this.canvas).engine.getBatchFrame().setVisible(false);
            ((HillCanvas)this.canvas).engine.getBatchFrame().dispose();
        }
    }

    @Override
    protected void saveProperties() {
        super.saveProperties();
        this.saveSpeedProperty = ((HillCanvas)this.canvas).getSpeed();
        this.saveSettings();
    }

    public void saveSettings() {
        this.init = ((HillCanvas)this.canvas).engine.init;
        this.giveUp = ((HillCanvas)this.canvas).engine.giveUp;
        this.alg = ((HillCanvas)this.canvas).engine.getSearchAlg();
        this.maxBatchCount = ((HillCanvas)this.canvas).engine.getMaxBatchCount();
    }

    @Override
    protected void loadSampleGraph() {
        this.saveProperties();
        super.loadSampleGraph();
        this.restoreProperties();
        this.csp.setPosition();
        this.canvas.repaint();
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.switchTab("Solve");
        }
        this.getUndoMenuItem().setEnabled(false);
    }

    @Override
    protected void openGraph() {
        this.saveProperties();
        super.openGraph();
        this.restoreProperties();
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.switchTab("Solve");
        }
        this.getUndoMenuItem().setEnabled(false);
    }

    @Override
    protected void createNewGraph() {
        this.closeTrace();
        super.createNewGraph();
        this.getUndoMenuItem().setEnabled(false);
    }

    protected void initializeGraph() {
        ((HillCanvas)this.canvas).engine.restart();
        this.canvas.repaint();
        this.enableButtons(true);
        this.setPromptLabel("Step 1 - Initialized.\nClick on a variable to change its value.\nClick on a constraint to reorder its variables.");
        this.solveButModes[8].setSelected(true);
        ((HillCanvas)this.canvas).updateNodeDetailFrame();
    }

    @Override
    protected void openLocation() {
        super.openLocation();
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.switchTab("Solve");
        }
        this.getUndoMenuItem().setEnabled(false);
    }

    @Override
    protected void restoreProperties() {
        super.restoreProperties();
        ((HillCanvas)this.canvas).setSpeed(this.saveSpeedProperty);
        ((HillCanvas)this.canvas).engine.dt = this.saveSpeedProperty;
        if (this.returnCanvas().getMode() == 2220) {
            this.createButModes[0].setSelected(true);
            this.returnCanvas().setSubmode(351);
            this.setPromptLabel("Click the canvas to create a variable.");
        }
        this.restoreSettings();
    }

    public void restoreSettings() {
        ((HillCanvas)this.canvas).engine.init = this.init;
        ((HillCanvas)this.canvas).engine.giveUp = this.giveUp;
        ((HillCanvas)this.canvas).engine.setSearchAlg(this.alg);
        ((Updateable)((Object)((HillCanvas)this.canvas).engine.getSearchAlgs()[this.alg].getOptionsPanel())).update();
        ((HillCanvas)this.canvas).engine.maxBatchCount = this.maxBatchCount;
        if (this.returnCanvas().getMode() == 2220) {
            this.setTA(false);
        } else {
            this.setTA(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String arg = e.getActionCommand().trim();
        if (arg.equals("Extra Large (30 pt)") || arg.equals("Large (20 pt)") || arg.equals("Medium (12 pt)") || arg.equals("Small (9 pt)") || arg.equals("Other...")) {
            if (this.getBatchCanvas() != null) {
                this.getBatchCanvas().setFont(this.returnCanvas().getFont());
            }
            if (this.getSolveCanvas() != null) {
                this.getSolveCanvas().setFont(this.returnCanvas().getFont());
            }
        } else if (arg.equals("Very Fast (0 s)")) {
            ((HillCanvas)this.canvas).setSpeed(0);
        } else if (arg.equals("Fast (0.1 s)")) {
            ((HillCanvas)this.canvas).setSpeed(100);
        } else if (arg.equals("Medium (0.5 s)")) {
            ((HillCanvas)this.canvas).setSpeed(500);
        } else if (arg.equals("Slow (1 s)")) {
            ((HillCanvas)this.canvas).setSpeed(1000);
        } else if (arg.equals("Algorithm Options...")) {
            ((HillCanvas)this.canvas).engine.openHeurOptions(this);
        } else if (arg.equals("Batch Run Options...")) {
            new BatchDialog((JFrame)this, ((HillCanvas)this.canvas).engine);
        } else if (arg.equals("Show Trace")) {
            this.showTrace();
        } else {
            if (arg.equals("Legend for Nodes/Edges")) {
                new HelpFrame("Legend", new HillHelpCanvas(this.isAntiAliasingEnabled()), 325, 475);
                return;
            }
            if (this.returnCanvas().getMode() == 2221) {
                if (arg.equals("Step") || e.getSource() == this.step) {
                    this.step();
                } else if (arg.equals("Fine Step") || e.getSource() == this.finestep) {
                    this.fineStep();
                } else if (arg.equals("Auto Solve") || e.getSource() == this.auto) {
                    this.autoSolveStart();
                } else if (arg.equals("Stop") || e.getSource() == this.stop) {
                    this.autoSolveStop();
                } else if (arg.equals("Initialize") || e.getSource() == this.solveButModes[0]) {
                    this.initializeGraph();
                } else if (arg.equals("Show Plot") || e.getSource() == this.showPlot) {
                    this.showPlot();
                } else if (arg.equals("Batch Run") || e.getSource() == this.batch) {
                    this.batchRunStart();
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.tabandbottom.setDividerLocation(0.96);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeTrace();
        this.closeBatch();
        this.closePlot();
        super.windowClosing(e);
    }

    public static void main(String[] args) {
        HillWindow window = new HillWindow(null);
        if (args.length > 0) {
            String url = args[0];
            try {
                window.fileName = url.substring(url.lastIndexOf("/") + 1);
                window.load(new BufferedReader(new InputStreamReader(new URL(url).openStream())));
            }
            catch (Exception exc) {
                window.showMessage("Error", exc.toString());
            }
        }
    }
}

