/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit;

import AIspace.graphToolKit.GraphCanvas;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.EdgeLabel;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    public ArrayList<Node> nodes;
    protected LinkedList<Node> layeredNodes;
    public ArrayList<Edge> edges;
    protected ArrayList<Node> selectedNodes;
    protected ArrayList<Edge> selectedEdges;
    private float scale;
    public GraphCanvas canvas;
    private int lineWidth;
    private float arrowWidth;
    private float arrowHeight;

    public Graph(GraphCanvas canvas) {
        this.canvas = canvas;
        this.nodes = new ArrayList();
        this.layeredNodes = new LinkedList();
        this.edges = new ArrayList();
        this.selectedNodes = new ArrayList();
        this.selectedEdges = new ArrayList();
        this.setScale(1.0f);
        this.setLineWidth(1);
    }

    public void addEdge(Edge newEdge) {
        this.edges.add(newEdge);
    }

    public void addEdge(String label, Node start, Node end, Color color, int edgeType) {
        this.addEdge(new Edge(this, label, start, end, color, edgeType));
    }

    public void addNode(Node newNode) {
        newNode.setIndex(this.getNextIndex());
        this.nodes.add(newNode.index, newNode);
        this.layeredNodes.addLast(newNode);
    }

    private void calculateArrowSize() {
        this.arrowWidth = this.lineWidth * 2;
        if (this.arrowWidth < 6.0f) {
            this.arrowWidth = 6.0f;
        }
        if (this.arrowWidth > 15.0f) {
            this.arrowWidth = 15.0f;
        }
        this.arrowHeight = this.arrowWidth * 2.5f;
    }

    public void clearGraph() {
        this.nodes.clear();
        this.layeredNodes.clear();
        this.edges.clear();
        this.selectedNodes.clear();
        this.selectedEdges.clear();
    }

    public void deleteSelected() {
        for (Edge curEdge : this.selectedEdges) {
            curEdge.removeFromNodes();
            this.edges.remove(curEdge);
        }
        this.selectedEdges.clear();
        for (Node curNode : this.selectedNodes) {
            Edge curEdge;
            ArrayList<Edge>[] allNodeEdges = curNode.getAllEdges();
            while (allNodeEdges[0].size() > 0) {
                curEdge = allNodeEdges[0].get(0);
                curEdge.removeFromNodes();
                this.edges.remove(curEdge);
            }
            while (allNodeEdges[1].size() > 0) {
                curEdge = allNodeEdges[1].get(0);
                curEdge.removeFromNodes();
                this.edges.remove(curEdge);
            }
            this.removeNode(curNode);
        }
        this.selectedNodes.clear();
    }

    public boolean deselect(Entity ent) {
        if (ent.type == 7772) {
            return false;
        }
        if (ent.isSelected) {
            if (ent.type == 7770) {
                this.selectedNodes.remove(ent);
            } else if (ent.type == 7771) {
                this.selectedEdges.remove(ent);
            }
            ent.isSelected = false;
        }
        return this.selectedNodes.size() > 0 || this.selectedEdges.size() > 0;
    }

    public boolean deselectAll() {
        Iterator<Node> nodeItr = this.selectedNodes.iterator();
        while (nodeItr.hasNext()) {
            nodeItr.next().isSelected = false;
        }
        this.selectedNodes.clear();
        Iterator<Edge> edgeItr = this.selectedEdges.iterator();
        while (edgeItr.hasNext()) {
            edgeItr.next().isSelected = false;
        }
        this.selectedEdges.clear();
        return false;
    }

    public boolean deselectAllButThis(Entity ent) {
        this.deselectAll();
        this.select(ent);
        return true;
    }

    public void draw(Graphics g, boolean moving) {
        this.updateEdgeSize();
        for (Edge e : this.edges) {
            e.draw(g, moving);
            e.eLabel.draw(g, moving);
        }
        for (Node n : this.layeredNodes) {
            n.draw(g, moving);
        }
    }

    public void drawStructure(Graphics g, boolean moving) {
        for (Edge e : this.edges) {
            e.updateLengthStructure();
            e.drawStructure(g, moving);
        }
        for (Node n : this.nodes) {
            n.drawStructure(g, moving);
        }
    }

    public Edge edgeAt(int index) {
        return this.edges.get(index);
    }

    public float getArrowHeight() {
        return this.arrowHeight;
    }

    public float getArrowWidth() {
        return this.arrowWidth;
    }

    public Point[] getBound() {
        if (this.numNodes() == 0) {
            Point[] tmp = new Point[]{new Point(0.0f, 0.0f), new Point(0.0f, 0.0f)};
            return tmp;
        }
        Iterator<Node> nodeItr = this.nodes.iterator();
        Node curNode = nodeItr.next();
        float minx = curNode.pos.x - (float)(curNode.width / 2);
        float miny = curNode.pos.y - (float)(curNode.height / 2);
        float maxx = curNode.pos.x + (float)(curNode.width / 2);
        float maxy = curNode.pos.y + (float)(curNode.height / 2);
        while (nodeItr.hasNext()) {
            curNode = nodeItr.next();
            if (curNode.pos.x - (float)(curNode.width / 2) < minx) {
                minx = curNode.pos.x - (float)(curNode.width / 2);
            }
            if (curNode.pos.x + (float)(curNode.width / 2) > maxx) {
                maxx = curNode.pos.x + (float)(curNode.width / 2);
            }
            if (curNode.pos.y - (float)(curNode.height / 2) < miny) {
                miny = curNode.pos.y - (float)(curNode.height / 2);
            }
            if (!(curNode.pos.y + (float)(curNode.height / 2) > maxy)) continue;
            maxy = curNode.pos.y + (float)(curNode.height / 2);
        }
        Iterator<Edge> edgeItr = this.edges.iterator();
        while (edgeItr.hasNext()) {
            Point[] bounds = edgeItr.next().eLabel.getBounds();
            if (bounds == null) continue;
            if (bounds[0].x < minx) {
                minx = bounds[0].x;
            }
            if (bounds[0].y < miny) {
                miny = bounds[0].y;
            }
            if (bounds[1].x > maxx) {
                maxx = bounds[1].x;
            }
            if (!(bounds[1].y > maxy)) continue;
            maxy = bounds[1].y;
        }
        float pad = 30.0f;
        Point[] tmp = new Point[]{new Point(minx - pad, miny - pad), new Point(maxx + pad, maxy + pad)};
        return tmp;
    }

    public Edge getEdge(int startIndex, int endIndex) {
        for (Edge curEdge : this.edges) {
            if (curEdge.getStartNode().getIndex() != startIndex || curEdge.getEndNode().getIndex() != endIndex) continue;
            return curEdge;
        }
        return null;
    }

    public Iterator<Edge> getEdges() {
        return this.edges.iterator();
    }

    public int getLastIndex() {
        if (this.numNodes() == 0) {
            return -1;
        }
        return this.nodeAt(this.numNodes() - 1).getIndex();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getNextIndex() {
        int index = 0;
        int i = 0;
        while (i < this.numNodes()) {
            if (index != this.nodeAt(i).getIndex()) {
                return index;
            }
            index = this.nodeAt(i).getIndex() + 1;
            ++i;
        }
        return index;
    }

    public Iterator<Node> getNodes() {
        return this.nodes.iterator();
    }

    public final String getPromptLabel() {
        return this.canvas.getPromptLabel();
    }

    public float getScale() {
        return this.scale;
    }

    public boolean isInSolveMode() {
        return this.canvas.getMode() == 2221;
    }

    public boolean isNodeNameAllowed(String name, Node node) {
        for (Node curNode : this.nodes) {
            if (curNode.equals(node) || !curNode.getLabel().equals(name)) continue;
            return false;
        }
        return true;
    }

    public void modifyEdge(Edge edge, String l, Node s, Node e, Color c, int t) {
        edge.set(l, s, e, c, t);
    }

    public void modifyNode(Node n, String l, Point p, Color c, int s) {
        n.set(l, p, c, s);
    }

    public void moveEntities(Point to, Node n) {
        float dx = to.x - n.pos.x;
        float dy = to.y - n.pos.y;
        n.move(to);
        for (Node curNode : this.selectedNodes) {
            if (curNode.type != 7770 || curNode == n) continue;
            curNode.translate(dx, dy);
        }
    }

    public void moveLabel(Point to, EdgeLabel label) {
        label.move(to);
    }

    public Node nodeAt(int index) {
        return this.nodes.get(index);
    }

    public Node nodeFromIndex(int index) {
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            Node tmpNode = nodeItr.next();
            if (index != tmpNode.getIndex()) continue;
            return tmpNode;
        }
        return null;
    }

    public int numEdges() {
        return this.edges.size();
    }

    public int numNodes() {
        return this.nodes.size();
    }

    public void order_bringToFront(Node node) {
        this.layeredNodes.remove(node);
        this.layeredNodes.addLast(node);
    }

    public void order_sendToBack(Node node) {
        this.layeredNodes.remove(node);
        this.layeredNodes.addFirst(node);
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
        this.layeredNodes.remove(node);
    }

    public void repaint() {
        this.canvas.repaint();
    }

    public void resetEdgeLabels() {
        Iterator<Edge> edgeItr = this.edges.iterator();
        while (edgeItr.hasNext()) {
            edgeItr.next().eLabel.reset();
        }
    }

    public void resetLabel(Edge e) {
        e.eLabel.reset();
    }

    public void resetLabels() {
        Iterator<Edge> itr = this.edges.iterator();
        while (itr.hasNext()) {
            itr.next().eLabel.reset();
        }
    }

    public Entity searchEntities(Point p) {
        Entity found = null;
        for (Edge curEdge : this.edges) {
            if (curEdge.eLabel.contains(p)) {
                found = curEdge.eLabel;
                continue;
            }
            if (!curEdge.contains(p)) continue;
            found = curEdge;
        }
        for (Node curNode : this.layeredNodes) {
            if (!curNode.contains(p)) continue;
            found = curNode;
        }
        return found;
    }

    public ArrayList<Entity> searchEntities(Point a, Point b) {
        ArrayList<Entity> selected = new ArrayList<Entity>();
        for (Node curNode : this.nodes) {
            if (!curNode.isInRect(a, b)) continue;
            selected.add(curNode);
        }
        for (Edge curEdge : this.edges) {
            if (!curEdge.isInRect(a, b)) continue;
            selected.add(curEdge);
        }
        return selected;
    }

    public boolean select(Entity ent) {
        if (ent.type == 7772) {
            return true;
        }
        if (!ent.isSelected) {
            if (ent.type == 7770) {
                this.selectedNodes.add((Node)ent);
            } else if (ent.type == 7771) {
                this.selectedEdges.add((Edge)ent);
            }
            ent.isSelected = true;
        }
        return true;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
        this.calculateArrowSize();
    }

    public final void setPromptColor(Color col) {
        this.canvas.setPromptColor(col);
    }

    public final void appendColoredTextToPrompLabel(String text, Color col) {
        this.canvas.appendColoredTextToPrompLabel(text, col);
    }

    public final void setPromptLabel(String s) {
        this.canvas.setPromptLabel(s);
    }

    public void setScale(float newScale) {
        if (newScale == 0.0f) {
            this.scale = 1.0f;
            return;
        }
        if (newScale < 0.0f) {
            return;
        }
        for (Node n : this.nodes) {
            n.pos.scale(newScale / this.scale);
        }
        for (Edge e : this.edges) {
            e.updateLength();
        }
        this.scale = newScale;
    }

    public void showMessage(String title, String msg) {
        this.canvas.showMessage(title, msg);
    }

    public String toString() {
        if (this.numNodes() > 0) {
            StringBuffer graphText = new StringBuffer("Graph:\n");
            Iterator<Node> nodeItr = this.nodes.iterator();
            int i = 0;
            while (nodeItr.hasNext()) {
                graphText.append(i++).append(" - ").append(nodeItr.next().getLabel()).append("\n");
            }
            return graphText.toString();
        }
        return "Empty graph";
    }

    public void translateAll(float dx, float dy) {
        for (Node n : this.nodes) {
            n.translate(dx, dy);
        }
    }

    public void updateEdgeSize() {
        int i = 0;
        while (i < this.edges.size()) {
            this.edges.get(i).updateLength();
            ++i;
        }
    }

    public void updateNodeSize() {
        int i = 0;
        while (i < this.nodes.size()) {
            this.nodes.get(i).updateSize();
            ++i;
        }
    }

    public void updateNodeSize(Node n) {
        n.updateSize();
        ArrayList<Edge>[] e = n.getAllEdges();
        Iterator<Edge> itr = e[0].iterator();
        while (itr.hasNext()) {
            itr.next().updateLength();
        }
        itr = e[1].iterator();
        while (itr.hasNext()) {
            itr.next().updateLength();
        }
    }

    protected boolean validNodeIndex(int index) {
        Iterator<Node> nodeItr = this.nodes.iterator();
        while (nodeItr.hasNext()) {
            if (nodeItr.next().getIndex() != index) continue;
            return true;
        }
        return false;
    }
}

