/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.elements;

import AIspace.cspTools.CSP;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.cspTools.domains.DomainDiscrete;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class StripsVariable {
    private DomainDiscrete domain;
    private String name;

    public StripsVariable(DomainDiscrete domain, String name) {
        this.name = name;
        this.domain = domain;
    }

    public DomainDiscrete getDomain() {
        return this.domain;
    }

    public void setDomain(DomainDiscrete domain) {
        this.domain = domain;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    class VariablePanel
    extends AffirmPanel
    implements ActionListener {
        private StripsVariable variable;
        private JTextField value;
        private JLabel name;
        private CSP csp;

        VariablePanel(StripsVariable variable, CSP csp) {
            this.variable = variable;
            this.csp = csp;
            this.setLayout(new BoxLayout(this, 0));
            this.add(new JLabel("Variable Name:     "));
            this.value = new JTextField(variable.getName(), 10);
            this.add(this.value);
            this.name = new JLabel(variable.getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ((e.getActionCommand() == "Change name" || e.getSource().equals(this.value)) && this.csp.nameOK(this.value.getText().trim())) {
                this.name.setText(this.value.getText().trim());
                this.value.setText("");
            }
        }

        @Override
        public boolean ok() {
            if (this.csp.nameOK(this.value.getText().trim())) {
                this.name.setText(this.value.getText().trim());
                this.value.setText("");
                this.variable.setName(this.name.getText().trim());
                return true;
            }
            return false;
        }

        @Override
        public boolean okNoCheck() {
            this.name.setText(this.value.getText().trim());
            this.value.setText("");
            this.variable.setName(this.name.getText().trim());
            return true;
        }

        @Override
        public void cancel() {
        }

        @Override
        public String returnText() {
            return this.value.getText().trim();
        }
    }
}

