/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.dialogs;

import AIspace.STRIPSToCSP.elements.StripsState;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StripsStateEditor
extends BasicDialog {
    private StripsState state;
    private JPanel controlPanel;
    private boolean isCancelled = true;
    private AffirmPanel namePanel;
    private ArrayList<ConditionPanel> conditions;

    public StripsStateEditor(JFrame parent, StripsState state) {
        super(parent, String.valueOf(state.getName()) + " Editor", true);
        this.setSize(400, 300);
        this.state = state;
        this.conditions = new ArrayList();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridheight = 3;
        this.getContentPane().setLayout(this.gbl);
        this.layoutInternals();
        this.controlPanel = new JPanel();
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        this.controlPanel.add(ok);
        this.controlPanel.add(cancel);
        this.addComponent(this.controlPanel, this, 2, 0, -1, 1, 0.0, 0.0);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private void layoutInternals() {
        JPanel variablePane = new JPanel();
        variablePane.setLayout(new BoxLayout(variablePane, 1));
        JPanel label = new JPanel();
        label.add(new JLabel("Variables"));
        label.setAlignmentX(0.0f);
        variablePane.add(label);
        Hashtable<StripsVariable, String> table = this.state.getVariables();
        for (StripsVariable variable : table.keySet()) {
            ConditionPanel panel = new ConditionPanel(variable);
            variablePane.add(panel);
            this.conditions.add(panel);
        }
        JScrollPane variableScrollPane = new JScrollPane(variablePane);
        this.addComponent(variableScrollPane, this, 0, 0, -1, 2, 0.0, 0.0);
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    protected boolean actionOK() {
        for (ConditionPanel p : this.conditions) {
            this.state.getVariables().put(p.getVariable(), p.getValue());
        }
        this.isCancelled = false;
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private class ConditionPanel
    extends JPanel {
        private StripsVariable variable;
        private JComboBox valueBox;

        public ConditionPanel(StripsVariable variable) {
            String[] domainValues;
            this.variable = variable;
            this.setLayout(new BoxLayout(this, 1));
            JLabel name = new JLabel("Name: " + variable.getName());
            this.add(name);
            JPanel valuePanel = new JPanel();
            JLabel valueLabel = new JLabel("Value: ");
            valuePanel.add(valueLabel);
            this.valueBox = new JComboBox();
            this.valueBox.addItem("  ---  ");
            String[] stringArray = domainValues = variable.getDomain().getDomain();
            int n = domainValues.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.valueBox.addItem(s);
                ++n2;
            }
            this.valueBox.setSelectedItem(StripsStateEditor.this.state.getVariables().get(variable));
            valuePanel.add(this.valueBox);
            this.add(valuePanel);
        }

        public StripsVariable getVariable() {
            return this.variable;
        }

        public String getValue() {
            return (String)this.valueBox.getSelectedItem();
        }
    }
}

