/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint.dialogs;

import AIspace.Constraint.ConstraintCSP;
import AIspace.Constraint.ConstraintCanvas;
import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SplitNodeDialog
extends BasicDialog {
    private JPanel promptPanel;
    private JPanel choicePanel;
    private JCheckBox[] choices;
    private JPanel donePanel;
    private JPanel splitPanel;
    private boolean isEmpty;
    private boolean isCancelled = true;
    private ConstraintCSP csp;
    private ConstraintVariable variable;
    private DomainDiscrete domain;
    private int[] split;
    private int currSize;

    public SplitNodeDialog(ConstraintCanvas parent) {
        super((JFrame)null, "Split The Domain...", true);
        this.setFont(new Font("SansSerif", 0, 12));
        this.choicePanel = new JPanel();
        this.promptPanel = new JPanel();
        this.splitPanel = new JPanel();
        this.donePanel = new JPanel();
        this.split = new int[1];
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.getContentPane().setLayout(this.gbl);
        this.addComponent(this.promptPanel, this, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.splitPanel, this, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.donePanel, this, 3, 0, 1, 1, 0.0, 0.0);
    }

    public void open(ConstraintVariable variable, ConstraintCSP csp) {
        this.variable = variable;
        this.csp = csp;
        this.domain = variable.getDomain();
        this.split = this.domain.getSplitElements();
        String[] elements = this.domain.getDomain();
        this.isCancelled = true;
        this.isEmpty = true;
        this.choicePanel.removeAll();
        this.choices = new JCheckBox[this.split.length];
        this.currSize = 0;
        ConstraintCSP.intSort(this.split);
        int index = 0;
        while (index < this.split.length) {
            this.choices[index] = new JCheckBox(elements[this.split[index]], false);
            this.choicePanel.add(this.choices[index]);
            this.isEmpty = false;
            ++this.currSize;
            ++index;
        }
        JLabel choicePrompt = this.isEmpty ? new JLabel("There are no values left to prune!") : new JLabel("Select values to keep (in the domain of " + variable.getName() + "):");
        this.promptPanel.removeAll();
        this.promptPanel.add(choicePrompt);
        if (!this.isEmpty) {
            JScrollPane scrollPanel = new JScrollPane(this.choicePanel);
            this.addComponent(scrollPanel, this, 1, 0, 1, 1, 1.0, 1.0);
        }
        this.splitPanel.removeAll();
        if (!this.isEmpty) {
            JButton half = new JButton("Select Half");
            half.addActionListener(this);
            JButton random = new JButton("Select Random");
            random.addActionListener(this);
            this.splitPanel.add(half);
            this.splitPanel.add(random);
        }
        this.donePanel.removeAll();
        JButton button = new JButton("OK");
        button.addActionListener(this);
        this.donePanel.add(button);
        if (!this.isEmpty) {
            button = new JButton("Cancel");
            button.addActionListener(this);
            this.donePanel.add(button);
        }
        this.validate();
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private void selectHalf() {
        int j = 0;
        int i = 0;
        while (i < this.split.length) {
            if (this.choices[i] != null) {
                this.choices[i].setSelected(j++ < this.currSize / 2);
            }
            ++i;
        }
    }

    private void selectRandom() {
        if (this.split.length == 1) {
            boolean numToPick = true;
            this.choices[0].setSelected(true);
        } else {
            int numToPick;
            int j = 0;
            while (j < this.split.length) {
                this.choices[j].setSelected(false);
                ++j;
            }
            while ((numToPick = (int)(Math.random() * (double)this.split.length)) == 0 || numToPick == this.split.length) {
            }
            while (numToPick > 0) {
                int index = (int)(Math.random() * (double)this.split.length);
                if (this.choices[index] == null || this.choices[index].isSelected()) continue;
                this.choices[index].setSelected(true);
                --numToPick;
            }
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    protected boolean actionOK() {
        if (!this.isEmpty) {
            ArrayList<Integer> allowList = new ArrayList<Integer>();
            ArrayList<Integer> backtrackList = new ArrayList<Integer>();
            int i = 0;
            while (i < this.split.length) {
                if (this.choices[i] != null && this.choices[i].isSelected()) {
                    allowList.add(new Integer(this.split[i]));
                } else {
                    backtrackList.add(new Integer(this.split[i]));
                }
                ++i;
            }
            int[] allowed = new int[allowList.size()];
            int[] backtrackAllowed = new int[backtrackList.size()];
            i = 0;
            while (i < allowed.length) {
                allowed[i] = (Integer)allowList.get(i);
                ++i;
            }
            i = 0;
            while (i < backtrackAllowed.length) {
                backtrackAllowed[i] = (Integer)backtrackList.get(i);
                ++i;
            }
            this.csp.backtrackOn(this.variable, allowed, backtrackAllowed);
            this.isCancelled = false;
        } else {
            this.isCancelled = true;
        }
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand().equals("Select Half")) {
            this.selectHalf();
        } else if (e.getActionCommand().equals("Select Random")) {
            this.selectRandom();
        }
    }
}

