/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search;

import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.help.HelpFrame;
import AIspace.graphToolKit.help.HelpMenu;
import AIspace.search.SearchCanvas;
import AIspace.search.SearchGraph;
import AIspace.search.dialogs.AutoSearchOptionDialog;
import AIspace.search.dialogs.InvertDialog;
import AIspace.search.dialogs.SearchDescriptionDialog;
import AIspace.search.help.SearchHelpCanvas;
import AIspace.search.searchTypes.Search;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class SearchWindow
extends GraphWindow {
    private static final long serialVersionUID = 1L;
    public JTextArea pathTextArea;
    private JCheckBoxMenuItem showPathPanel;
    private JRadioButtonMenuItem depthFirst;
    private JRadioButtonMenuItem breadthFirst;
    private JRadioButtonMenuItem lowestCostFirst;
    private JRadioButtonMenuItem bestFirst;
    private JRadioButtonMenuItem heuristicDepthFirst;
    private JRadioButtonMenuItem aStar;
    private JRadioButtonMenuItem branchAndBound;
    private JRadioButtonMenuItem userDefined;
    private JCheckBoxMenuItem showNodeHeuristics;
    private JCheckBoxMenuItem showEdgeCosts;
    private JCheckBoxMenuItem showQuizResults;
    private JMenuItem resetCosts;
    private JMenuItem autoNHMenuItem;
    private JMenuItem autoECMenuItem;
    private JMenuItem textRepresentationMenuItem;
    private JMenuItem xmlRepresentationMenuItem;
    private JMenuItem descriptionMenuItem;
    private JMenuItem redoItem;
    private JMenuItem undoItem;
    private boolean undoBoolean = false;
    protected String[] undoArray;
    protected int undoIndex;
    protected final int undoLimit = 5;
    private JButton fakeButton;
    protected ImageIcon stepIcon;
    protected ImageIcon fineStepIcon;
    protected ImageIcon autoSearchIcon;
    protected ImageIcon stopIcon;
    protected ImageIcon resetIcon;
    protected ImageIcon quizIcon;
    protected ImageIcon viewNodePathIcon;
    protected ImageIcon invertGraphIcon;

    public SearchWindow(JApplet parent) {
        super(parent);
        this.initializeAppletInfo();
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.txt");
        this.setSize(800, 700);
        this.construct();
        this.initialize();
        this.otherSavedButtonIndex = 0;
        this.switchTab("Create");
        this.otherSavedButtonIndex = 5;
        this.centerWindow();
        this.setVisible(true);
    }

    private void initializeAppletInfo() {
        appletTitle = "Search Applet Version 4.5.3";
        appletName = "search";
        aboutText = String.valueOf(appletTitle) + "\n\n" + "Search is an important part of AI; many problems can be cast as the\n" + "problem of finding a path in a graph. This graph-searching tool is\n" + "designed to help you learn about different search strategies.\n\n" + "This applet was written by Kevin O'Neill, Shinjiro Sueda, Leslie Tung, \n" + "Nicole Arksey, Regan Yuen, Kyle Porter, Byron Knoll, Andre Gagne, \n" + "and Janine Li with help from Holger Hoos, Cristina Conati, Wesley Coelho,\n" + "Joseph Roy Santos, Mike Cline, Peter Gorniak, Giuseppe Carenini, \n" + "Alan Mackworth and David Poole.";
    }

    private void construct() {
        this.algoText.setVisible(true);
        this.algoText.setFont(new Font("arial", 1, 15));
        this.pathTextArea = new JTextArea("", 2, 50);
        this.pathTextArea.setEditable(false);
        this.pathTextArea.setBackground(Color.white);
        this.pathTextArea.setForeground(GraphConsts.fg);
        this.pathTextArea.setFont(new Font("arial", 0, ((SearchCanvas)this.returnCanvas()).getFontSize()));
        this.bottomPanel.setPreferredSize(new Dimension(this.getWidth(), 100));
        this.bottomPanel.add((Component)new JScrollPane(this.pathTextArea, 20, 30), "Center");
        this.tabandbottom.setBottomComponent(this.bottomPanel);
    }

    private void initialize() {
        this.stepIcon = SearchWindow.createImageIcon("images/search/step.png");
        this.fineStepIcon = SearchWindow.createImageIcon("images/common/finestep.png");
        this.autoSearchIcon = SearchWindow.createImageIcon("images/search/gear.png");
        this.stopIcon = SearchWindow.createImageIcon("images/search/stop.gif");
        this.resetIcon = SearchWindow.createImageIcon("images/search/Reset.gif");
        this.quizIcon = SearchWindow.createImageIcon("images/search/quiz.gif");
        this.invertGraphIcon = SearchWindow.createImageIcon("images/search/invertgraph.gif");
        this.viewNodePathIcon = SearchWindow.createImageIcon("images/search/viewNodeInfo.png");
        ((SearchCanvas)this.returnCanvas()).setDisplayHeuristics(false);
        ((SearchCanvas)this.returnCanvas()).setDisplayCost(false);
        ((SearchCanvas)this.returnCanvas()).searchMethod = 201;
        ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).createFrontierInfo();
        this.undoArray = new String[6];
        this.resetUndoState();
        ((SearchCanvas)this.returnCanvas()).setSubmode(3330);
        this.setPromptLabel("Click the canvas to create a node.");
    }

    @Override
    protected void createToolBarWithText() {
        this.createButModes = new JToggleButton[7];
        this.setCreateButtonsWithText(0, "Create Node", this.createNodeIcon, "Create Node");
        this.setCreateButtonsWithText(1, "Create Edge", this.createEdgeIcon, "Create Edge");
        this.setCreateButtonsWithText(2, "   Select   ", this.selectIcon, "Select");
        this.setCreateButtonsWithText(3, "   Delete   ", this.deleteIcon, "Delete");
        this.setCreateButtonsWithText(4, "Invert Graph", this.invertGraphIcon, "Invert Graph");
        this.setCreateButtonsWithText(5, "Set Properties", this.setPropsIcon, "Set Properties");
        this.createToolBarLayout();
    }

    @Override
    protected void createToolBar() {
        this.createButModes = new JToggleButton[7];
        this.setCreateButtons(0, this.createNodeIcon, "Create Node");
        this.setCreateButtons(1, this.createEdgeIcon, "Create Edge");
        this.setCreateButtons(2, this.selectIcon, "   Select   ");
        this.setCreateButtons(3, this.deleteIcon, "   Delete   ");
        this.setCreateButtons(4, this.invertGraphIcon, "Invert Graph");
        this.setCreateButtons(5, this.setPropsIcon, "Set Properties");
        this.createToolBarLayout();
    }

    private void createToolBarLayout() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        int i = 0;
        while (i < 6) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.algoText.setText(" ");
    }

    @Override
    protected void solveToolBar() {
        super.solveToolBar();
        this.solveButModes = new JToggleButton[8];
        this.setSolveButtons(0, this.fineStepIcon, "Fine Step");
        this.setSolveButtons(1, this.stepIcon, "Step");
        this.setSolveButtons(2, this.autoSearchIcon, "Auto Search");
        this.setSolveButtons(3, this.stopIcon, "Stop Search");
        this.setSolveButtons(4, this.resetIcon, "Reset Search");
        this.setSolveButtons(5, this.selectIcon, "Select");
        this.setSolveButtons(6, this.viewNodePathIcon, "Inspect Node Paths");
        this.setSolveButtons(7, this.quizIcon, "Quiz Yourself");
        this.solveToolBarLayout();
    }

    @Override
    protected void solveToolBarWithText() {
        super.solveToolBar();
        this.solveButModes = new JToggleButton[8];
        this.setSolveButtonsWithText(0, "  Fine Step    ", this.fineStepIcon, "Fine Step");
        this.setSolveButtonsWithText(1, "      Step       ", this.stepIcon, "Step");
        this.setSolveButtonsWithText(2, " Auto Search ", this.autoSearchIcon, "Auto Search");
        this.setSolveButtonsWithText(3, " Stop Search ", this.stopIcon, "Stop Search");
        this.setSolveButtonsWithText(4, "Reset Search", this.resetIcon, "Reset Search");
        this.setSolveButtonsWithText(5, "   Select   ", this.selectIcon, "Select");
        this.setSolveButtonsWithText(6, "Inspect Node Paths", this.viewNodePathIcon, "Inspect Node Paths");
        this.setSolveButtonsWithText(7, "       Quiz       ", this.quizIcon, "Quiz Yourself");
        this.solveToolBarLayout();
    }

    private void solveToolBarLayout() {
        this.solveModeButGroup = new ButtonGroup();
        this.fakeButton = new JButton();
        this.solveModeButGroup.add(this.fakeButton);
        ButtonGroup group = new ButtonGroup();
        int i = 0;
        while (i < 8) {
            if (i == 5 || i == 6) {
                group.add(this.solveButModes[i]);
            } else {
                this.solveModeButGroup.add(this.solveButModes[i]);
            }
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.algoText.setText("Algorithm Selected: " + this.getAlgorithmName());
    }

    @Override
    protected void getCanvas() {
        this.canvas = new SearchCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7500);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    public boolean isShowingAnswers() {
        return this.showQuizResults.getState();
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        menuBar.add((Component)this.createEditMenu(), 1);
        menuBar.add((Component)this.createSearchOptionsMenu(), 3);
        return menuBar;
    }

    @Override
    public void switchTab(String str) {
        super.switchTab(str);
        this.setPromptColor(Color.blue);
        if (str == "Create") {
            this.textRepresentationMenuItem.setText("View/Edit Text Representation");
            this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
            this.xmlRepresentationMenuItem.setText("View/Edit XML Representation");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View/Edit Graph Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.bottomPanel.setVisible(false);
            this.showPathPanel.setEnabled(false);
            if (this.undoIndex > 0) {
                this.undoItem.setEnabled(true);
            }
            if (this.undoArray[this.undoIndex] != null) {
                this.redoItem.setEnabled(true);
            }
            this.resetCosts.setEnabled(true);
            this.autoNHMenuItem.setEnabled(true);
            this.autoECMenuItem.setEnabled(true);
        } else if (str == "Solve") {
            this.textRepresentationMenuItem.setText("View Text Representation");
            this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
            this.xmlRepresentationMenuItem.setText("View XML Representation");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View Graph Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            ((SearchCanvas)this.returnCanvas()).solvePopUp();
            this.showPathPanel.setEnabled(true);
            this.solveButModes[3].setEnabled(false);
            this.resetCosts.setEnabled(false);
            this.autoNHMenuItem.setEnabled(false);
            this.autoECMenuItem.setEnabled(false);
            this.undoItem.setEnabled(false);
            this.redoItem.setEnabled(false);
            ((SearchCanvas)this.returnCanvas()).greenify();
            if (this.userDefined.isSelected()) {
                this.startUserDefinedSearch();
            }
            if (this.showPathPanel.getState()) {
                this.bottomPanel.setVisible(true);
                this.tabandbottom.setDividerLocation(0.75);
            }
            this.setPromptLabel(this.getAlgorithmPrompt(this.getAlgorithmName()));
        }
        this.validate();
        this.canvas.autoscale();
    }

    @Override
    protected JMenu createFileMenu() {
        JMenu m = super.createFileMenu();
        m.remove(0);
        return m;
    }

    protected JMenu createEditMenu() {
        JMenu m = new JMenu("Edit");
        m.setMnemonic(69);
        this.undoItem = new JMenuItem("Undo");
        this.undoItem.setMnemonic(85);
        this.undoItem.addActionListener(this);
        m.add(this.undoItem);
        this.redoItem = new JMenuItem("Redo");
        this.redoItem.setMnemonic(82);
        this.redoItem.addActionListener(this);
        m.add(this.redoItem);
        m.addSeparator();
        JMenuItem mItem = new JMenuItem("View Prolog Code");
        mItem.setMnemonic(80);
        mItem.addActionListener(this);
        m.add(mItem);
        this.textRepresentationMenuItem = new JMenuItem("View/Edit Text Representation");
        this.textRepresentationMenuItem.setMnemonic(84);
        this.textRepresentationMenuItem.setDisplayedMnemonicIndex(10);
        this.textRepresentationMenuItem.addActionListener(this);
        m.add(this.textRepresentationMenuItem);
        this.xmlRepresentationMenuItem = new JMenuItem("View/Edit XML Representation");
        this.xmlRepresentationMenuItem.setMnemonic(88);
        this.xmlRepresentationMenuItem.addActionListener(this);
        m.add(this.xmlRepresentationMenuItem);
        this.descriptionMenuItem = new JMenuItem("View/Edit Graph Description");
        this.descriptionMenuItem.setMnemonic(68);
        this.descriptionMenuItem.setDisplayedMnemonicIndex(10);
        this.descriptionMenuItem.addActionListener(this);
        m.add(this.descriptionMenuItem);
        return m;
    }

    @Override
    protected JMenu createViewMenu() {
        JMenu m = super.createViewMenu();
        m.addSeparator();
        this.showPathPanel = new JCheckBoxMenuItem("Show Current Path", true);
        this.showPathPanel.setMnemonic(80);
        this.showPathPanel.addActionListener(this);
        m.add(this.showPathPanel);
        this.showNodeHeuristics = new JCheckBoxMenuItem("Show Node Heuristics", false);
        this.showNodeHeuristics.setMnemonic(72);
        this.showNodeHeuristics.setDisplayedMnemonicIndex(10);
        this.showNodeHeuristics.addActionListener(this);
        m.add(this.showNodeHeuristics);
        this.showEdgeCosts = new JCheckBoxMenuItem("Show Edge Costs", false);
        this.showEdgeCosts.setMnemonic(67);
        this.showEdgeCosts.addActionListener(this);
        m.add(this.showEdgeCosts);
        this.showQuizResults = new JCheckBoxMenuItem("Show Quiz Results", false);
        this.showQuizResults.setMnemonic(81);
        this.showQuizResults.addActionListener(this);
        m.add(this.showQuizResults);
        return m;
    }

    protected JMenu createSearchOptionsMenu() {
        JMenu m = new JMenu("Search Options");
        m.setMnemonic(83);
        JMenu algoMenu = new JMenu("Search Algorithms");
        ButtonGroup group = new ButtonGroup();
        algoMenu.setMnemonic(83);
        this.depthFirst = new JRadioButtonMenuItem("Depth First", true);
        this.depthFirst.addActionListener(this);
        algoMenu.add(this.depthFirst);
        group.add(this.depthFirst);
        this.breadthFirst = new JRadioButtonMenuItem("Breadth First");
        this.breadthFirst.addActionListener(this);
        algoMenu.add(this.breadthFirst);
        group.add(this.breadthFirst);
        this.lowestCostFirst = new JRadioButtonMenuItem("Lowest Cost First");
        this.lowestCostFirst.addActionListener(this);
        algoMenu.add(this.lowestCostFirst);
        group.add(this.lowestCostFirst);
        this.bestFirst = new JRadioButtonMenuItem("Best First");
        this.bestFirst.addActionListener(this);
        algoMenu.add(this.bestFirst);
        group.add(this.bestFirst);
        this.heuristicDepthFirst = new JRadioButtonMenuItem("Heuristic Depth First");
        this.heuristicDepthFirst.addActionListener(this);
        algoMenu.add(this.heuristicDepthFirst);
        group.add(this.heuristicDepthFirst);
        this.aStar = new JRadioButtonMenuItem("A*");
        this.aStar.addActionListener(this);
        algoMenu.add(this.aStar);
        group.add(this.aStar);
        this.branchAndBound = new JRadioButtonMenuItem("Branch and Bound");
        this.branchAndBound.addActionListener(this);
        algoMenu.add(this.branchAndBound);
        group.add(this.branchAndBound);
        this.userDefined = new JRadioButtonMenuItem("User Defined");
        this.userDefined.addActionListener(this);
        algoMenu.add(this.userDefined);
        group.add(this.userDefined);
        m.add(algoMenu);
        JMenu pruneMenu = new JMenu("Pruning");
        pruneMenu.setMnemonic(80);
        group = new ButtonGroup();
        JRadioButtonMenuItem multPath = new JRadioButtonMenuItem("Multiple-Path Pruning");
        multPath.addActionListener(this);
        pruneMenu.add(multPath);
        group.add(multPath);
        JRadioButtonMenuItem loop = new JRadioButtonMenuItem("Loop Detection");
        loop.addActionListener(this);
        pruneMenu.add(loop);
        group.add(loop);
        JRadioButtonMenuItem none = new JRadioButtonMenuItem("None", true);
        none.addActionListener(this);
        pruneMenu.add(none);
        group.add(none);
        m.add(pruneMenu);
        JMenu neighborSortMenu = new JMenu("Neighbor Ordering Strategies");
        group = new ButtonGroup();
        JRadioButtonMenuItem leftMost = new JRadioButtonMenuItem("Left to Right", true);
        leftMost.addActionListener(this);
        neighborSortMenu.add(leftMost);
        group.add(leftMost);
        JRadioButtonMenuItem alpha = new JRadioButtonMenuItem("Alphabetical");
        alpha.addActionListener(this);
        neighborSortMenu.add(alpha);
        group.add(alpha);
        JRadioButtonMenuItem fFunc = new JRadioButtonMenuItem("f Function");
        fFunc.addActionListener(this);
        neighborSortMenu.add(fFunc);
        group.add(fFunc);
        m.add(neighborSortMenu);
        m.addSeparator();
        this.resetCosts = new JMenuItem("Set Costs and Heuristics");
        this.resetCosts.setMnemonic(69);
        this.resetCosts.addActionListener(this);
        m.add(this.resetCosts);
        this.autoNHMenuItem = new JMenuItem("Set Node Heuristics Automatically");
        this.autoNHMenuItem.setMnemonic(72);
        this.autoNHMenuItem.addActionListener(this);
        m.add(this.autoNHMenuItem);
        this.autoECMenuItem = new JMenuItem("Set Edge Costs Automatically");
        this.autoECMenuItem.setMnemonic(67);
        this.autoECMenuItem.addActionListener(this);
        m.add(this.autoECMenuItem);
        m.addSeparator();
        JMenu speed = new JMenu("Animation Speed");
        speed.setMnemonic(68);
        group = new ButtonGroup();
        JRadioButtonMenuItem xFast = new JRadioButtonMenuItem("Very Fast (0 s)", false);
        xFast.addActionListener(this);
        speed.add(xFast);
        group.add(xFast);
        JRadioButtonMenuItem fast = new JRadioButtonMenuItem("Fast (0.1 s)", true);
        fast.addActionListener(this);
        speed.add(fast);
        group.add(fast);
        JRadioButtonMenuItem medium = new JRadioButtonMenuItem("Medium (0.5 s)", false);
        medium.addActionListener(this);
        speed.add(medium);
        group.add(medium);
        JRadioButtonMenuItem slow = new JRadioButtonMenuItem("Slow (1 s)", false);
        slow.addActionListener(this);
        speed.add(slow);
        group.add(slow);
        m.add(speed);
        JMenuItem mItem = new JMenuItem("Auto Search Options");
        mItem.setMnemonic(79);
        mItem.addActionListener(this);
        m.add(mItem);
        return m;
    }

    @Override
    protected JMenu createHelpMenu() {
        return new HelpMenu("search", this);
    }

    public void setPathArea(String path) {
        Search sTemp = ((SearchGraph)this.returnCanvas().graph).getSearchObject();
        if (path.equals("") || path.equals("\n")) {
            if (sTemp == null || sTemp.isPathCurrent()) {
                this.pathTextArea.setText("CURRENT PATH: \n   None\n");
            } else {
                this.pathTextArea.setText("PREVIOUS PATH: \n   None\n");
            }
        } else if (sTemp == null || sTemp.isPathCurrent()) {
            this.pathTextArea.setText("CURRENT PATH: \n   " + path);
        } else {
            this.pathTextArea.setText("PREVIOUS PATH2: \n   " + path);
        }
        if (((SearchGraph)this.canvas.graph).getSearchObject() != null && ((SearchGraph)this.canvas.graph).getSearchObject().getGoalString() != null) {
            this.pathTextArea.append(String.valueOf(((SearchGraph)this.canvas.graph).getSearchObject().getGoalString()) + "\n\n");
        }
    }

    public void setFrontierPathArea(String info) {
        if (info.length() > 0) {
            if (((SearchGraph)this.canvas.graph).search != null) {
                this.setPathArea(String.valueOf(((SearchGraph)this.canvas.graph).search.getPathString()) + "\n");
            }
            this.pathTextArea.append(info);
        }
    }

    public void clearPathArea() {
        this.pathTextArea.setText("");
    }

    public void resetSearch() {
        ((SearchCanvas)this.returnCanvas()).resetSearch();
        ((SearchCanvas)this.returnCanvas()).greenify();
        if (this.userDefined.isSelected()) {
            ((SearchCanvas)this.returnCanvas()).doSearch(209, 209);
        }
    }

    private void startUserDefinedSearch() {
        ((SearchCanvas)this.returnCanvas()).doSearch(this.getAlgorithm(), 209);
        this.solveButModes[0].setEnabled(false);
        this.solveButModes[1].setEnabled(false);
        this.solveButModes[2].setEnabled(false);
        this.solveButModes[3].setEnabled(false);
        this.solveButModes[5].setEnabled(false);
        this.solveButModes[6].setEnabled(false);
        this.solveButModes[7].setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).step.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).fineStep.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).autoSearch.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).stop.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).quiz.setEnabled(false);
    }

    @Override
    public void load(String dir, String fileName) {
        super.load(dir, fileName);
        if (this.fileName != null && this.returnCanvas().getMode() == 2221) {
            ((SearchCanvas)this.returnCanvas()).greenify();
            this.stopSearch();
            this.resetSearchAction();
        }
    }

    @Override
    public void load(BufferedReader in) {
        try {
            String line;
            StringBuffer allText = new StringBuffer();
            String errMsg = "";
            while ((line = in.readLine()) != null) {
                allText.append(line).append("\n");
            }
            in.close();
            errMsg = this.fileName.endsWith(".xml") ? ((SearchCanvas)this.returnCanvas()).parseXML(allText.toString()) : ((SearchCanvas)this.returnCanvas()).parse(allText.toString());
            if (!errMsg.equals("OK") && !this.undoBoolean) {
                this.showMessage("Error", errMsg);
            }
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
            this.resetUndoState();
            ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).updateEdgeLabels(this.showEdgeCosts.getState());
            this.returnCanvas().autoscale();
        }
        catch (Exception e) {
            this.showMessage("Error", e.toString());
        }
    }

    @Override
    public void save(File file) {
        if (!file.getName().endsWith(".xml")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.println(((SearchGraph)this.returnCanvas().graph).generateXMLTextRep());
            out.close();
            this.fileName = file.getName();
            if (!file.getName().equals("undo.xml")) {
                // empty if block
            }
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
        }
        catch (FileNotFoundException e) {
            this.showMessage("Error", "File not found: " + e.getLocalizedMessage());
        }
        catch (Exception p) {
            this.showMessage("Error", String.valueOf(p.getLocalizedMessage()) + "\n" + p.getStackTrace() + "\n" + p.toString());
        }
    }

    public void saveUndo() {
        this.redoItem.setEnabled(false);
        this.undoItem.setEnabled(true);
        this.undoBoolean = true;
        if (this.undoIndex >= 5) {
            int i = 0;
            while (i < 4) {
                this.undoArray[i] = this.undoArray[i + 1];
                ++i;
            }
            this.undoArray[5] = null;
            this.undoArray[this.undoIndex - 1] = ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).generateXMLTextRep();
        } else {
            this.undoArray[this.undoIndex++] = ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).generateXMLTextRep();
            if (this.undoArray[this.undoIndex] != null) {
                int i = this.undoIndex;
                while (i < 5) {
                    this.undoArray[i] = null;
                    ++i;
                }
            }
        }
    }

    public void loadUndo() {
        if (this.undoArray[this.undoIndex] == null) {
            this.undoArray[this.undoIndex] = ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).generateXMLTextRep();
        }
        ((SearchCanvas)this.returnCanvas()).parseXML(this.undoArray[--this.undoIndex]);
        this.redoItem.setEnabled(true);
        if (this.undoIndex == 0) {
            this.undoItem.setEnabled(false);
            this.undoBoolean = false;
        }
    }

    public void resetUndoState() {
        this.undoItem.setEnabled(false);
        this.undoBoolean = false;
        this.redoItem.setEnabled(false);
        int i = 0;
        while (i < 5) {
            this.undoArray[i] = null;
            ++i;
        }
        this.undoIndex = 0;
    }

    public void loadRedo() {
        if (this.undoIndex >= 5 || this.undoArray[this.undoIndex] == null) {
            return;
        }
        ((SearchCanvas)this.returnCanvas()).parseXML(this.undoArray[++this.undoIndex]);
        this.undoItem.setEnabled(true);
        if (this.undoIndex == 5 || this.undoArray[this.undoIndex + 1] == null) {
            this.redoItem.setEnabled(false);
        }
    }

    private void setAlgorithm(String algorithm) {
        if (algorithm.equals("Depth First")) {
            this.algoText.setText("Algorithm Selected: Depth First");
            ((SearchCanvas)this.returnCanvas()).searchMethod = 201;
        } else if (algorithm.equals("Breadth First")) {
            this.algoText.setText("Algorithm Selected: Breadth First");
            ((SearchCanvas)this.returnCanvas()).searchMethod = 202;
        } else if (algorithm.equals("Lowest Cost First")) {
            this.algoText.setText(" Algorithm Selected:  Lowest Cost First  ");
            ((SearchCanvas)this.returnCanvas()).searchMethod = 203;
        } else if (algorithm.equals("Best First")) {
            this.algoText.setText(" Algorithm Selected: Best First ");
            ((SearchCanvas)this.returnCanvas()).searchMethod = 204;
        } else if (algorithm.equals("Heuristic Depth First")) {
            this.algoText.setText(" Algorithm Selected: Heuristic Depth First");
            ((SearchCanvas)this.returnCanvas()).searchMethod = 205;
        } else if (algorithm.equals("A*")) {
            this.algoText.setText("Algorithm Selected:  A*");
            ((SearchCanvas)this.returnCanvas()).searchMethod = 206;
        } else if (algorithm.equals("Branch and Bound")) {
            this.algoText.setText("Algortihm Selected: Branch and Bound");
            ((SearchCanvas)this.returnCanvas()).searchMethod = 207;
        } else if (algorithm.equals("User Defined")) {
            this.algoText.setText("Algorithm Selected: User Defined");
            ((SearchCanvas)this.returnCanvas()).searchMethod = 209;
        } else {
            this.showMessage("Error", "Unknown search algorithm");
            return;
        }
        if (this.returnCanvas().getMode() == 2221) {
            this.setPromptLabel(this.getAlgorithmPrompt(algorithm));
        }
        if (this.solveButModes != null) {
            int i = 0;
            while (i < 8) {
                if (i != 3) {
                    this.solveButModes[i].setEnabled(true);
                }
                ++i;
            }
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        }
        ((SearchCanvas)this.returnCanvas()).resetSearch();
        if (((SearchCanvas)this.returnCanvas()).getMode() == 2221) {
            ((SearchCanvas)this.canvas).greenify();
            if (this.userDefined.isSelected()) {
                this.startUserDefinedSearch();
            }
        }
        ((SearchCanvas)this.returnCanvas()).setDisplayCost(this.showEdgeCosts.getState());
        ((SearchCanvas)this.returnCanvas()).setDisplayHeuristics(this.showNodeHeuristics.getState());
        ((SearchCanvas)this.returnCanvas()).updateGraph();
    }

    public int getAlgorithm() {
        if (this.depthFirst.isSelected()) {
            return 201;
        }
        if (this.breadthFirst.isSelected()) {
            return 202;
        }
        if (this.lowestCostFirst.isSelected()) {
            return 203;
        }
        if (this.bestFirst.isSelected()) {
            return 204;
        }
        if (this.heuristicDepthFirst.isSelected()) {
            return 205;
        }
        if (this.aStar.isSelected()) {
            return 206;
        }
        if (this.branchAndBound.isSelected()) {
            return 207;
        }
        if (this.userDefined.isSelected()) {
            return 209;
        }
        return -1;
    }

    private String getAlgorithmName() {
        if (this.depthFirst.isSelected()) {
            return "Depth First";
        }
        if (this.breadthFirst.isSelected()) {
            return "Breadth First";
        }
        if (this.lowestCostFirst.isSelected()) {
            return "Lowest Cost First";
        }
        if (this.bestFirst.isSelected()) {
            return "Best First";
        }
        if (this.heuristicDepthFirst.isSelected()) {
            return "Heuristic Depth First";
        }
        if (this.aStar.isSelected()) {
            return "A*";
        }
        if (this.branchAndBound.isSelected()) {
            return "Branch and Bound";
        }
        if (this.userDefined.isSelected()) {
            return "User Defined";
        }
        return "No Algorithm Selected";
    }

    private String getAlgorithmPrompt(String algorithmName) {
        if (algorithmName.equals("User Defined")) {
            return "Click on a node on the frontier";
        }
        if (algorithmName.equals("Depth First") || algorithmName.equals("Breadth First") || algorithmName.equals("Lowest Cost First") || algorithmName.equals("Best First") || algorithmName.equals("Heuristic Depth First") || algorithmName.equals("A*") || algorithmName.equals("Branch and Bound")) {
            return "Click Fine Step, Step or Auto Search to watch the algorithm run.";
        }
        return "No Algorithm Selected";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setPromptColor(Color.blue);
        if (((SearchCanvas)this.returnCanvas()).pause) {
            return;
        }
        String arg = e.getActionCommand().trim();
        if (this.returnCanvas().getMode() == 2220) {
            if (arg.equals("Create Node") || e.getSource() == this.createButModes[0]) {
                this.undoBoolean = true;
            } else if (arg.equals("Create Edge") || e.getSource() == this.createButModes[1]) {
                this.undoBoolean = true;
            } else if (arg.equals("Delete") || e.getSource() == this.createButModes[3]) {
                this.undoBoolean = true;
            } else if (arg.equals("Invert Graph") || e.getSource() == this.createButModes[4]) {
                this.invertGraph();
            }
        } else if (this.returnCanvas().getMode() == 2221) {
            if (arg.equals("Fine Step") || e.getSource() == this.solveButModes[0]) {
                this.fineStep();
            } else if (arg.equals("Step") || e.getSource() == this.solveButModes[1]) {
                this.step();
            } else if (arg.equals("Auto Search") || e.getSource() == this.solveButModes[2]) {
                this.autoSearch();
            } else if (arg.equals("Stop Search") || e.getSource() == this.solveButModes[3]) {
                this.stopSearch();
            } else if (arg.equals("Reset Search") || e.getSource() == this.solveButModes[4]) {
                this.resetSearchAction();
                this.setPromptColor(Color.blue);
                this.setPromptLabel(this.getAlgorithmPrompt(this.getAlgorithmName()));
            } else if (arg.equals("Inspect Node Paths") || e.getSource() == this.solveButModes[6]) {
                this.setPromptLabel("Select a node to see which paths it belongs to.");
                this.returnCanvas().setSubmode(32465);
            } else if (arg.equals("Quiz") || e.getSource() == this.solveButModes[7]) {
                this.startQuiz();
            }
        }
        if (arg.equals("Undo")) {
            this.undoBoolean = true;
            this.loadUndo();
        } else if (arg.equals("Redo")) {
            this.loadRedo();
        } else if (arg.equals("View Prolog Code")) {
            ((SearchCanvas)this.returnCanvas()).prologRep();
        } else if (arg.equals("View/Edit Text Representation")) {
            ((SearchCanvas)this.returnCanvas()).textRep(true);
        } else if (arg.equals("View/Edit XML Representation")) {
            ((SearchCanvas)this.returnCanvas()).XMLRep(true);
        } else if (arg.equals("View/Edit Graph Description")) {
            new SearchDescriptionDialog((GraphWindow)this, (SearchGraph)this.canvas.graph, true).open();
        } else if (arg.equals("View Text Representation")) {
            ((SearchCanvas)this.returnCanvas()).textRep(false);
        } else if (arg.equals("View XML Representation")) {
            ((SearchCanvas)this.returnCanvas()).XMLRep(false);
        } else if (arg.equals("View Graph Description")) {
            new SearchDescriptionDialog((GraphWindow)this, (SearchGraph)this.canvas.graph, false).open();
        } else if (arg.equals("Show Node Heuristics")) {
            ((SearchCanvas)this.returnCanvas()).setDisplayHeuristics(this.showNodeHeuristics.getState());
            ((SearchCanvas)this.returnCanvas()).updateGraph();
            ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).getFrontierInfo().refreshFrontier();
        } else if (arg.equals("Show Edge Costs")) {
            ((SearchCanvas)this.returnCanvas()).setDisplayCost(this.showEdgeCosts.getState());
            ((SearchCanvas)this.returnCanvas()).updateGraph();
            ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).getFrontierInfo().refreshFrontier();
        } else if (arg.equals("Show Quiz Results")) {
            Search searchObject = ((SearchCanvas)this.returnCanvas()).getSearchObject();
            if (searchObject != null) {
                searchObject.setShowAnswers(!searchObject.getShowAnswers());
                if (((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).getSearchRate() == 104) {
                    if (searchObject.getShowAnswers()) {
                        ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).getFrontierInfo().displayQuizFrontier();
                    } else {
                        this.setFrontierPathArea(" ");
                    }
                }
            }
        } else {
            if (arg.equals("Show Current Path")) {
                if (this.showPathPanel.getState()) {
                    this.bottomPanel.setVisible(true);
                    this.tabandbottom.setDividerLocation(0.75);
                    this.validate();
                } else {
                    this.bottomPanel.setVisible(false);
                }
                return;
            }
            if (arg.equals("Auto Search Options")) {
                new AutoSearchOptionDialog(this).open();
            } else if (arg.equals("Set Costs and Heuristics")) {
                this.saveUndo();
                ((SearchCanvas)this.returnCanvas()).resetCosts();
            } else if (arg.equals("Depth First") || arg.equals("Breadth First") || arg.equals("Lowest Cost First") || arg.equals("Best First") || arg.equals("Heuristic Depth First") || arg.equals("A*") || arg.equals("Branch and Bound") || arg.equals("User Defined")) {
                this.setAlgorithm(arg);
            } else if (arg.equals("Very Fast (0 s)")) {
                Search.animationSpeed = 0;
            } else if (arg.equals("Fast (0.1 s)")) {
                Search.animationSpeed = 100;
            } else if (arg.equals("Medium (0.5 s)")) {
                Search.animationSpeed = 500;
            } else if (arg.equals("Slow (1 s)")) {
                Search.animationSpeed = 1000;
            } else if (arg.equals("Set Node Heuristics Automatically") || e.getSource().equals(this.autoNHMenuItem)) {
                this.setHeuristics();
            } else if (arg.equals("Set Edge Costs Automatically")) {
                this.saveUndo();
                ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).setUseEdgeLength(true);
                ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).updateNodeSize();
                ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).updateEdgeSize();
                ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).setUseEdgeLength(false);
                ((SearchCanvas)this.returnCanvas()).repaint();
            } else if (arg.equals("Multiple-Path Pruning")) {
                ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).setPruning(301);
                ((SearchCanvas)this.returnCanvas()).resetSearch();
                this.setAlgorithm(this.getAlgorithmName());
            } else if (arg.equals("Loop Detection")) {
                ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).setPruning(302);
                ((SearchCanvas)this.returnCanvas()).resetSearch();
                this.setAlgorithm(this.getAlgorithmName());
            } else if (arg.equals("None")) {
                ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).setPruning(303);
                ((SearchCanvas)this.returnCanvas()).resetSearch();
                this.setAlgorithm(this.getAlgorithmName());
            } else {
                if (arg.equals("Legend for Nodes/Edges")) {
                    new HelpFrame("Legend", new SearchHelpCanvas(this.isAntiAliasingEnabled()), 400, 500);
                    return;
                }
                if (arg.equals("Create New Graph")) {
                    this.resetUndoState();
                } else if (arg.equals("Left to Right")) {
                    ((SearchCanvas)this.returnCanvas()).getGraph().setSortType(400);
                } else if (arg.equals("Alphabetical")) {
                    ((SearchCanvas)this.returnCanvas()).getGraph().setSortType(401);
                } else if (arg.equals("f Function")) {
                    ((SearchCanvas)this.returnCanvas()).getGraph().setSortType(402);
                }
            }
        }
        super.actionPerformed(e);
    }

    public void setHeuristics() {
        this.saveUndo();
        ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).setUseNodeDistance(true);
        ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).setHeuristicsFromDistance();
        ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).setUseNodeDistance(false);
        ((SearchCanvas)this.returnCanvas()).repaint();
    }

    public void invertGraph() {
        ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).invert();
        InvertDialog d = new InvertDialog(this);
        d.open();
        if (!d.isCancelled()) {
            this.setHeuristics();
        }
        d.dispose();
        this.createModeButGroup.setSelected(this.createButModes[2].getModel(), true);
        ((SearchCanvas)this.returnCanvas()).setSubmode(3332);
    }

    public void resetSearchAction() {
        this.resetSearch();
        this.setPromptLabel("Click Fine Step, Step or Auto Search to watch the algorithm run.");
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        if (!this.userDefined.isSelected()) {
            this.solveButModes[0].setEnabled(true);
            this.solveButModes[1].setEnabled(true);
            this.solveButModes[2].setEnabled(true);
            this.solveButModes[3].setEnabled(false);
            this.solveButModes[5].setEnabled(true);
            this.solveButModes[6].setEnabled(true);
            this.solveButModes[7].setEnabled(true);
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            ((SearchCanvas)this.returnCanvas()).step.setEnabled(true);
            ((SearchCanvas)this.returnCanvas()).fineStep.setEnabled(true);
            ((SearchCanvas)this.returnCanvas()).autoSearch.setEnabled(true);
            ((SearchCanvas)this.returnCanvas()).stop.setEnabled(false);
            ((SearchCanvas)this.returnCanvas()).quiz.setEnabled(true);
        }
    }

    public void startQuiz() {
        this.solveButModes[5].doClick();
        this.solveButModes[0].setEnabled(false);
        this.solveButModes[1].setEnabled(false);
        this.solveButModes[2].setEnabled(false);
        this.solveButModes[3].setEnabled(false);
        this.solveButModes[5].setEnabled(false);
        this.solveButModes[6].setEnabled(false);
        this.solveButModes[7].setEnabled(false);
        if (((SearchGraph)this.returnCanvas().graph).getSearchObject() != null) {
            ((SearchGraph)this.returnCanvas().graph).getSearchObject().updateForQuiz();
        }
        ((SearchCanvas)this.returnCanvas()).doSearch(this.getAlgorithm(), 104);
        ((SearchCanvas)this.returnCanvas()).step.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).fineStep.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).autoSearch.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).stop.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).reset.setEnabled(true);
    }

    public void stopSearch() {
        ((SearchGraph)((SearchCanvas)this.returnCanvas()).graph).stopAutoSearch();
        this.solveButModes[0].setEnabled(true);
        this.solveButModes[1].setEnabled(true);
        this.solveButModes[3].setEnabled(false);
        this.solveButModes[5].setEnabled(true);
        this.solveButModes[6].setEnabled(true);
        this.solveButModes[7].setEnabled(true);
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        ((SearchCanvas)this.returnCanvas()).step.setEnabled(true);
        ((SearchCanvas)this.returnCanvas()).fineStep.setEnabled(true);
        ((SearchCanvas)this.returnCanvas()).stop.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).quiz.setEnabled(true);
    }

    public void setAutoSearch() {
        this.solveButModes[3].setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).stop.setEnabled(false);
    }

    public void autoSearch() {
        this.setIsAutoSearchingOptions(true);
        ((SearchCanvas)this.returnCanvas()).doSearch(this.getAlgorithm(), 101);
    }

    public void setIsAutoSearchingOptions(boolean isEnabled) {
        this.solveButModes[0].setEnabled(!isEnabled);
        this.solveButModes[1].setEnabled(!isEnabled);
        this.solveButModes[3].setEnabled(isEnabled);
        this.solveButModes[5].setEnabled(!isEnabled);
        this.solveButModes[6].setEnabled(!isEnabled);
        this.solveButModes[7].setEnabled(!isEnabled);
        ((SearchCanvas)this.returnCanvas()).step.setEnabled(!isEnabled);
        ((SearchCanvas)this.returnCanvas()).fineStep.setEnabled(!isEnabled);
        ((SearchCanvas)this.returnCanvas()).stop.setEnabled(isEnabled);
        ((SearchCanvas)this.returnCanvas()).quiz.setEnabled(!isEnabled);
        if (!isEnabled) {
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
        }
    }

    public void fineStep() {
        this.solveButModes[3].setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).stop.setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).doSearch(this.getAlgorithm(), 103);
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
    }

    public void step() {
        this.solveButModes[3].setEnabled(false);
        ((SearchCanvas)this.returnCanvas()).doSearch(this.getAlgorithm(), 102);
        this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
    }

    @Override
    protected void createNewGraph() {
        super.createNewGraph();
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.xml");
        ((SearchCanvas)this.returnCanvas()).reset();
        ((SearchGraph)this.canvas.graph).setShortDesc("");
        ((SearchGraph)this.canvas.graph).setDetailedDesc("");
        ((SearchCanvas)this.returnCanvas()).setDisplayHeuristics(this.showNodeHeuristics.getState());
        ((SearchCanvas)this.returnCanvas()).setDisplayCost(this.showEdgeCosts.getState());
        ((SearchCanvas)this.returnCanvas()).setDisplayHeuristics(this.showNodeHeuristics.getState());
        ((SearchCanvas)this.returnCanvas()).setDisplayCost(this.showEdgeCosts.getState());
        ((SearchCanvas)this.returnCanvas()).repaint();
    }

    public void setFontSize(int size) {
        this.pathTextArea.setFont(new Font("arial", 0, size));
        if (size < 15) {
            this.algoText.setFont(new Font("arial", 1, 15));
        } else {
            this.algoText.setFont(new Font("arial", 1, size));
        }
    }

    public static void main(String[] args) {
        SearchWindow window = new SearchWindow(null);
        if (args.length > 0) {
            String url = args[0];
            try {
                window.fileName = url.substring(url.lastIndexOf("/") + 1);
                window.load(new BufferedReader(new InputStreamReader(new URL(url).openStream())));
            }
            catch (Exception exc) {
                window.showMessage("Error", exc.toString());
            }
        }
    }
}

