/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search;

import AIspace.search.SearchCanvas;
import AIspace.search.elements.SearchNode;
import AIspace.search.searchTypes.Search;
import AIspace.search.searchTypes.SearchObject;
import java.util.ArrayList;

public class SearchQuizAnimator
extends Thread {
    private int animateSpeed;
    private ArrayList<SearchObject> frontier;
    private boolean isRunning;
    private boolean isPaused;
    private int nodesLeft;
    private SearchNode oldFrontierNode;
    private SearchCanvas canvas;
    private Search search;

    public SearchQuizAnimator(Search search, SearchCanvas canvas, ArrayList<SearchObject> frontier, int animateSpeed) {
        this.frontier = new ArrayList<SearchObject>(frontier);
        this.canvas = canvas;
        this.search = search;
        this.animateSpeed = animateSpeed;
        this.isRunning = false;
        this.isPaused = false;
        this.nodesLeft = frontier.size();
        this.oldFrontierNode = null;
    }

    @Override
    public void run() {
        this.isRunning = true;
        this.canvas.setQuizAnimating(true);
        while (this.nodesLeft >= 0) {
            if (!this.isRunning) {
                this.canvas.setQuizAnimating(false);
                return;
            }
            if (!this.isPaused) {
                if (this.oldFrontierNode != null) {
                    this.oldFrontierNode.setNodeAppearance(4);
                }
                if (this.nodesLeft > 0) {
                    SearchObject sObject = this.frontier.get(this.frontier.size() - this.nodesLeft);
                    SearchNode node = (SearchNode)this.search.getGraph().nodeFromIndex(sObject.getToNode());
                    node.setNodeAppearance(5);
                    this.oldFrontierNode = node;
                }
            }
            this.canvas.repaint();
            try {
                Thread.sleep(this.animateSpeed * 3);
            }
            catch (InterruptedException err) {
                System.out.println(err);
            }
            --this.nodesLeft;
        }
        this.canvas.setQuizAnimating(false);
    }

    public void quit() {
        this.isRunning = false;
    }
}

