/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search;

import AIspace.search.InlineSearchApplet;
import AIspace.search.SearchCanvas;
import AIspace.search.SearchGraph;
import AIspace.search.SearchWindow;
import AIspace.search.elements.SearchNode;
import AIspace.search.searchTypes.Search;
import AIspace.search.searchTypes.SearchObject;
import java.awt.Container;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class FrontierInfo {
    protected StringBuffer display;
    protected SearchGraph graph;
    protected Search search;
    protected Container window;

    public FrontierInfo(Container w) {
        this.graph = w instanceof InlineSearchApplet ? (SearchGraph)((InlineSearchApplet)w).returnCanvas().graph : (SearchGraph)((SearchWindow)w).returnCanvas().graph;
        this.search = this.graph.getSearchObject();
        this.window = w;
        this.display = new StringBuffer();
    }

    public void setGraph(SearchGraph g) {
        this.graph = g;
    }

    public void refreshFrontier() {
        this.search = this.graph.getSearchObject();
        this.clear();
        if (this.search == null) {
            this.showInitFrontier();
        } else {
            this.setFrontier(false);
        }
    }

    public void displayQuizFrontier() {
        this.search = this.graph.getSearchObject();
        this.clear();
        if (this.search == null || this.search.getQuizFrontier() == null) {
            this.showInitFrontier();
        } else {
            this.setFrontier(true);
        }
    }

    public void setFrontier(boolean useQuizFrontier) {
        this.search = this.graph.getSearchObject();
        if (this.search == null) {
            return;
        }
        this.display = new StringBuffer("NEW FRONTIER:\n");
        ArrayList<SearchObject> frontier = null;
        frontier = useQuizFrontier ? this.search.getQuizFrontier() : this.search.getFrontier(false);
        ArrayList<SearchObject> children = this.search.getNeighbours();
        if (frontier.size() == 0 && children.size() == 0) {
            this.display.append("\tNo node on frontier.");
        }
        DecimalFormat twoDigits = new DecimalFormat("###0.0###");
        int i = 0;
        while (i < frontier.size()) {
            SearchObject currObject = frontier.get(i);
            SearchNode currNode = (SearchNode)this.graph.nodeFromIndex(currObject.getToNode());
            this.display.append("   Node: ").append(currNode.getPredicateLabel()).append(" \t Path Cost: ").append(twoDigits.format(currObject.getPathCost())).append("   \t");
            if (((SearchCanvas)this.graph.canvas).isDisplayingHeuristics()) {
                this.display.append(" h(").append(currNode.getPredicateLabel()).append("): ").append(twoDigits.format(currNode.getHeuristics())).append("   \t");
                this.display.append(" f-value: ").append(twoDigits.format(currObject.getPathCost() + currNode.getHeuristics())).append("   \t");
            }
            this.display.append(" Path: ").append(this.getPathString(currObject.getPath())).append("\n");
            ++i;
        }
        if (this.graph.canvas.inline) {
            ((InlineSearchApplet)this.window).setFrontierPathArea(this.display.toString());
        } else {
            ((SearchWindow)this.window).setFrontierPathArea(this.display.toString());
        }
    }

    public String getPathString(ArrayList<Integer[]> path) {
        int nodeIndex;
        if (path.size() == 0) {
            return "n/a";
        }
        StringBuffer pathString = new StringBuffer();
        int i = 0;
        while (i < path.size()) {
            nodeIndex = path.get(i)[0];
            if (nodeIndex != -1) {
                pathString.append(((SearchNode)this.graph.nodeFromIndex(nodeIndex)).getPredicateLabel()).append(" --> ");
            }
            ++i;
        }
        nodeIndex = path.get(path.size() - 1)[1];
        pathString.append(((SearchNode)this.graph.nodeFromIndex(nodeIndex)).getPredicateLabel());
        return pathString.toString();
    }

    public void showInitFrontier() {
        this.display = new StringBuffer("NEW FRONTIER:\n");
        ArrayList<SearchNode> start = this.graph.getStartNodes();
        if (start.size() == 0) {
            this.display.append("   No node on frontier.");
        }
        DecimalFormat twoDigits = new DecimalFormat("###0.0###");
        int i = 0;
        while (i < start.size()) {
            SearchNode currNode = start.get(i);
            this.display.append("   Node: ").append(currNode.getLabel()).append(" \t Path Cost: 0.0\t\t");
            if (((SearchCanvas)this.graph.canvas).isDisplayingHeuristics()) {
                this.display.append(" h(").append(currNode.getPredicateLabel()).append("): ").append(twoDigits.format(currNode.getHeuristics())).append("\t");
                this.display.append(" f(").append(currNode.getPredicateLabel()).append("): ").append(twoDigits.format(currNode.getHeuristics())).append("\t");
            }
            this.display.append(" Path: ").append(currNode.getLabel()).append("\n");
            ++i;
        }
        if (this.graph.canvas.inline) {
            ((InlineSearchApplet)this.window).clearPathArea();
            ((InlineSearchApplet)this.window).setFrontierPathArea(this.display.toString());
        } else {
            ((SearchWindow)this.window).clearPathArea();
            ((SearchWindow)this.window).setFrontierPathArea(this.display.toString());
        }
    }

    public String getWhiteSpace(int totalLength, int wordLength) {
        StringBuffer whiteSpace = new StringBuffer();
        int i = 0;
        while (i < totalLength - wordLength) {
            whiteSpace.append(" ");
            ++i;
        }
        return whiteSpace.toString();
    }

    public void clear() {
        this.display = new StringBuffer("FRONTIER INFORMATION:\n");
        if (this.graph.getSearchObject() != null) {
            if (this.graph.canvas.inline) {
                ((InlineSearchApplet)this.window).setFrontierPathArea(this.display.toString());
            } else {
                ((SearchWindow)this.window).setFrontierPathArea(this.display.toString());
            }
        } else if (this.graph.canvas.inline) {
            ((InlineSearchApplet)this.window).setFrontierPathArea("");
        } else {
            ((SearchWindow)this.window).setFrontierPathArea("");
        }
    }
}

