/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search.searchTypes;

import AIspace.search.SearchGraph;
import AIspace.search.dialogs.UserSearchPathSelectDialog;
import AIspace.search.elements.SearchNode;
import AIspace.search.searchTypes.Search;
import AIspace.search.searchTypes.SearchObject;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JFrame;

public class UserDefinedSearch
extends Search {
    protected int counter;
    protected int currIndex;
    protected boolean isDone;

    public UserDefinedSearch() {
        this.counter = 0;
        this.isDone = false;
    }

    public UserDefinedSearch(SearchGraph sg) {
        this.graph = sg;
        this.startNodeIndex = new ArrayList<SearchNode>(sg.getStartNodes());
        this.goalNodeIndex = new ArrayList<SearchNode>(sg.getGoalNodes());
        this.searchRate = sg.getSearchRate();
        this.pruning = sg.getPruning();
        this.frontier = new ArrayList(5);
        this.shorterFrontier = new ArrayList(5);
        if (this.startNodeIndex.size() > 0) {
            ArrayList<SearchObject> startNodes = new ArrayList<SearchObject>(5);
            int i = 0;
            while (i < this.startNodeIndex.size()) {
                startNodes.add(new SearchObject(-1, this.graph.nodes.indexOf(this.startNodeIndex.get(i)), null, this.graph));
                ++i;
            }
            this.mergeWithFrontier(startNodes);
        }
        this.pruneNodes();
        this.paintNodes(this.frontier, 4);
        this.counter = 0;
        this.isDone = false;
        this.currIndex = -1;
        this.nodesVisited = new ArrayList(5);
    }

    public UserDefinedSearch(SearchGraph searchGraph, int sortType) {
        super(searchGraph, sortType);
    }

    @Override
    public void step() {
        this.graph.setPromptLabel("Click on a child node or a node on the frontier to create a path to the goal node.");
        if (this.isDone) {
            this.graph.setPromptLabel("Search Completed");
            this.completed();
            return;
        }
        if (this.selectedNode == null) {
            return;
        }
        ArrayList<SearchObject> foundObjects = new ArrayList<SearchObject>();
        for (SearchObject curObject : this.frontier) {
            if (curObject.getToNode() != this.selectedNode.getIndex()) continue;
            foundObjects.add(curObject);
        }
        int selectedPathObjectIndex = 0;
        if (foundObjects.size() <= 0) {
            return;
        }
        if (foundObjects.size() > 1) {
            UserSearchPathSelectDialog userDialog = new UserSearchPathSelectDialog((Container)((JFrame)this.graph.canvas.parent), foundObjects);
            userDialog.open();
            selectedPathObjectIndex = userDialog.getSelectedPathIndex();
        }
        this.resetPrevious(this.currObject);
        if (this.currIndex != -1) {
            ((SearchNode)this.graph.nodeFromIndex(this.currIndex)).setNodeAppearance(6);
            if (this.currObject != null) {
                this.paintPath(this.currObject, false);
            }
            this.currObject = foundObjects.get(selectedPathObjectIndex).clone();
        }
        this.currIndex = this.selectedNode.getIndex();
        this.selectedNode.setSearchOrder(++this.counter);
        this.selectedNode.setSearchOrderDisplayed(true);
        this.selectedNode.setPathFound(true);
        this.nodesVisited.add(new Integer(this.currIndex));
        ArrayList<SearchNode> children = new ArrayList<SearchNode>(this.selectedNode.getChildren());
        int numNeighbours = children.size();
        this.neighbours = new ArrayList(5);
        int i = 0;
        while (i < numNeighbours) {
            SearchNode curNode = children.get(0);
            curNode.setNodeAppearance(5);
            boolean condition = false;
            if (this.pruning == 303 || this.pruning == 301) {
                condition = true;
            } else if (!(this.pruning != 302 || this.currObject != null && this.currObject.checkNodeOnPath(curNode.getIndex()))) {
                condition = true;
            }
            if (condition) {
                if (this.currObject != null) {
                    this.neighbours.add(new SearchObject(this.currIndex, curNode.getIndex(), this.currObject.getPath(), this.graph));
                } else {
                    this.neighbours.add(new SearchObject(this.currIndex, curNode.getIndex(), null, this.graph));
                }
            } else {
                curNode.setNodeAppearance(6);
            }
            children.remove(0);
            ++i;
        }
        Integer toNodeIndex = new Integer(foundObjects.get(selectedPathObjectIndex).getToNode());
        this.frontier.remove(foundObjects.get(selectedPathObjectIndex));
        this.shorterFrontier.remove(toNodeIndex);
        if (this.countOccurances(this.shorterFrontier, toNodeIndex) <= 1) {
            ((SearchNode)this.graph.nodeFromIndex(toNodeIndex)).setDrawnShadowed(false);
        }
        this.paintNodes(this.frontier, 4);
        if (this.neighbours.size() > 0) {
            this.mergeWithFrontier(this.neighbours);
        }
        this.pruneNodes();
        this.selectedNode.setNodeAppearance(3);
        if (this.currObject != null) {
            this.paintPath(this.currObject, true);
        }
        this.checkGoal(this.currIndex);
        this.showPath(this.currObject);
        if (this.frontier.size() == 0) {
            this.isDone = true;
        }
    }

    @Override
    protected void mergeWithFrontier(ArrayList<SearchObject> ch) {
        int i = ch.size() - 1;
        while (i >= 0) {
            Integer toNodeIndex = new Integer(ch.get(ch.size() - 1).getToNode());
            if (this.shorterFrontier.contains(toNodeIndex)) {
                ((SearchNode)this.graph.nodeFromIndex(toNodeIndex)).setDrawnShadowed(true);
            }
            this.shorterFrontier.add(toNodeIndex);
            this.frontier.add(0, ch.get(ch.size() - 1));
            ch.remove(i);
            --i;
        }
    }

    @Override
    protected int getStartIndex() {
        return ((SearchNode)this.startNodeIndex.get(0)).getIndex();
    }
}

