/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search.searchTypes;

import AIspace.search.InlineSearchApplet;
import AIspace.search.SearchGraph;
import AIspace.search.SearchWindow;
import AIspace.search.elements.SearchNode;
import AIspace.search.searchTypes.Search;
import AIspace.search.searchTypes.SearchObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class BranchAndBound
extends Search {
    static double smallestCost = 1.0E23f;
    private SearchObject lastGoalNode;

    public BranchAndBound() {
    }

    public BranchAndBound(SearchGraph sg) {
        super(sg);
    }

    public BranchAndBound(SearchGraph searchGraph, int sortType) {
        super(searchGraph, sortType);
    }

    @Override
    protected int getStartIndex() {
        return ((SearchNode)this.startNodeIndex.get(0)).getIndex();
    }

    @Override
    public void showPath(SearchObject currObj) {
        if (currObj != null) {
            String tmpLabel;
            SearchNode tmpNode;
            ArrayList<Integer[]> path = currObj.getPath();
            this.pathString = "";
            int i = 0;
            while (i < path.size()) {
                if (path.get(i)[0] != -1) {
                    tmpNode = (SearchNode)this.graph.nodeFromIndex(path.get(i)[0]);
                    tmpLabel = tmpNode.getPredicateLabel();
                    if (tmpLabel.equals("")) {
                        tmpLabel = new String("Node " + tmpNode.index);
                    }
                    this.pathString = String.valueOf(this.pathString) + tmpLabel + " --> ";
                }
                ++i;
            }
            tmpNode = (SearchNode)this.graph.nodeFromIndex(path.get(path.size() - 1)[1]);
            tmpLabel = tmpNode.getPredicateLabel();
            if (tmpLabel.equals("")) {
                tmpLabel = new String("Node " + tmpNode.getIndex());
            }
            if (this.goalNodeIndex.contains(tmpNode)) {
                tmpLabel = String.valueOf(tmpLabel) + " (Goal)";
            }
            this.pathString = String.valueOf(this.pathString) + tmpLabel;
            this.graph.setPathArea(this.pathString);
        }
    }

    @Override
    protected void mergeWithFrontier(ArrayList<SearchObject> ch) {
        if (smallestCost <= 0.0) {
            smallestCost = 1.0E21f;
        }
        TreeMap<Integer, SearchObject> nodeMap = new TreeMap<Integer, SearchObject>();
        ArrayList<SearchObject> tempCh = new ArrayList<SearchObject>();
        int position = 1000;
        int i = 0;
        while (i < ch.size()) {
            tempCh.add(ch.get(i));
            ++i;
        }
        int chSize = tempCh.size();
        int i2 = chSize - 1;
        while (i2 >= 0) {
            SearchObject nextObject = (SearchObject)tempCh.get(i2);
            SearchNode nextNode = (SearchNode)this.graph.nodeFromIndex(nextObject.getToNode());
            int j = 0;
            while (j < i2) {
                SearchObject tempObject = (SearchObject)tempCh.get(j);
                SearchNode tempNode = (SearchNode)this.graph.nodeFromIndex(tempObject.getToNode());
                if (tempObject.getPathCost() + tempNode.getHeuristics() > nextObject.getPathCost() + nextNode.getHeuristics()) {
                    nextObject = tempObject;
                    nextNode = tempNode;
                }
                ++j;
            }
            double temp = nextObject.getPathCost() + nextNode.getHeuristics();
            if (temp < smallestCost) {
                if (this.graph.getGoalNodes().contains(nextNode)) {
                    this.lastGoalNode = nextObject;
                    smallestCost = temp;
                }
                this.frontier.add(0, nextObject);
                nodeMap.put(new Integer(position--), nextObject);
            }
            tempCh.remove(nextObject);
            --i2;
        }
        this.fillAnimateFrontier(nodeMap);
    }

    @Override
    public void reset() {
        super.reset();
        smallestCost = 1.0E23f;
    }

    @Override
    protected void checkGoal(int currIndex) {
        if (this.goalNodeIndex.contains(this.graph.nodes.get(currIndex))) {
            this.goalString = "Path to last Goal Node: " + this.pathString + " Cost: " + this.currObject.getPathCost();
            String saveLabel = this.graph.getPromptLabel();
            this.graph.showMessage("Goal Node Found", "Goal Node Found! \nPath cost: " + this.currObject.getPathCost() + "\nUpdating Upper Bound.");
            this.graph.setPromptLabel(" Goal Node Found! (" + this.pathString + ")");
            this.graph.setPromptLabel(saveLabel);
        }
    }

    @Override
    protected void stepOne() {
        if (this.frontier.size() > 0) {
            int currObjectFrontierIndex = this.findNextObject();
            if (currObjectFrontierIndex == this.frontier.size()) {
                this.frontier.clear();
            } else {
                this.currObject = ((SearchObject)this.frontier.get(currObjectFrontierIndex)).clone();
                int curIndex = this.currObject.getToNode();
                SearchNode node = (SearchNode)this.graph.nodeFromIndex(curIndex);
                node.setPathFound(true);
                if (this.searchRate != 104) {
                    node.setNodeAppearance(3);
                    node.setSearchOrder(this.nodeCount++ + 1);
                    node.setSearchOrderDisplayed(true);
                    this.paintPath(this.currObject, true);
                    this.checkGoal(curIndex);
                    this.showPath(this.currObject);
                }
                Integer curIntIndex = new Integer(curIndex);
                this.nodesVisited.add(curIntIndex);
                this.frontier.remove(currObjectFrontierIndex);
                this.shorterFrontier.remove(curIntIndex);
                if (this.countOccurances(this.shorterFrontier, curIntIndex) <= 1) {
                    ((SearchNode)this.graph.nodeFromIndex(curIntIndex)).setDrawnShadowed(false);
                }
            }
        } else {
            this.completed();
            this.printGoalNode(this.lastGoalNode);
        }
    }

    private int findNextObject() {
        int i = 0;
        SearchObject tempObject = ((SearchObject)this.frontier.get(i)).clone();
        int tempIndex = tempObject.getToNode();
        SearchNode node = (SearchNode)this.graph.nodeFromIndex(tempIndex);
        while (node.getHeuristics() + tempObject.getPathCost() > smallestCost && i < this.frontier.size()) {
            if (++i == this.frontier.size()) break;
            tempObject = ((SearchObject)this.frontier.get(i)).clone();
            tempIndex = tempObject.getToNode();
            node = (SearchNode)this.graph.nodeFromIndex(tempIndex);
        }
        return i;
    }

    @Override
    protected void stepTwo() {
        this.neighbours = new ArrayList(5);
        if (this.currObject != null) {
            int currIndex = this.currObject.getToNode();
            ArrayList<SearchNode> children = new ArrayList<SearchNode>(((SearchNode)this.graph.nodeFromIndex(currIndex)).getChildren());
            int numNeigh = children != null ? children.size() : 0;
            int i = 0;
            while (i < numNeigh) {
                int nextNeigh = children.get(0).getIndex();
                boolean condition = false;
                if (this.pruning == 303 || this.pruning == 301) {
                    condition = true;
                } else if (this.pruning == 302 && this.currObject == null || !this.currObject.checkNodeOnPath(nextNeigh)) {
                    condition = true;
                }
                if (condition) {
                    this.neighbours.add(new SearchObject(currIndex, nextNeigh, this.currObject.getPath(), this.graph));
                }
                children.remove(0);
                ++i;
            }
            StringBuffer path = new StringBuffer("Path ").append(this.pathString).append(" expanded.\nNeighbours of ");
            path.append(((SearchNode)this.graph.nodes.get(this.currObject.getToNode())).getLabel()).append(":  ");
            if (this.neighbours.size() > 0) {
                this.paintNodes(this.neighbours, 5);
                Iterator itr = this.neighbours.iterator();
                while (itr.hasNext()) {
                    path.append(((SearchNode)this.graph.nodes.get(((SearchObject)itr.next()).getToNode())).getLabel()).append(", ");
                    if (!itr.hasNext()) continue;
                    path.append(", ");
                }
            } else {
                path.append("no neighbours.");
            }
            this.graph.setPromptLabel(path.toString());
        }
        this.backup = new ArrayList(this.frontier);
    }

    private void printGoalNode(SearchObject node) {
        this.currObject = node;
        this.goalReached = true;
        this.showPath(this.currObject);
        this.graph.repaint();
        this.goalString = "Path to last Goal Node: " + this.pathString + " Cost: " + this.currObject.getPathCost();
        String saveLabel = this.graph.getPromptLabel();
        this.graph.setPromptLabel(" Goal Node reached! (" + this.pathString + ")");
        this.graph.showMessage("No More Nodes Left", "Shortest path found to goal: " + this.pathString + "\nPath cost: " + this.currObject.getPathCost());
        this.graph.setPromptLabel(saveLabel);
        if (this.graph.canvas.inline) {
            ((InlineSearchApplet)this.graph.getWindow()).setAutoSearch();
        } else {
            ((SearchWindow)this.graph.getWindow()).setAutoSearch();
        }
    }
}

