/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.search.SearchGraph;
import AIspace.search.SearchWindow;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AutoSearchOptionDialog
extends BasicDialog {
    private SearchWindow window;
    private Choice choiceYesNo;
    private JTextField textNumSteps;

    public AutoSearchOptionDialog(SearchWindow w) {
        super((JFrame)w, "Auto Search Options", true);
        this.window = w;
        JPanel top = new JPanel();
        top.setLayout(new GridLayout(2, 1));
        JPanel panel = new JPanel();
        panel.add(new JLabel("Stop searching when goal node found? "));
        this.choiceYesNo = new Choice();
        this.choiceYesNo.addItem("Yes");
        this.choiceYesNo.addItem("No");
        this.choiceYesNo.select("Yes");
        panel.add(this.choiceYesNo);
        top.add(panel);
        panel = new JPanel();
        panel.add(new JLabel("Maximum number of steps: "));
        this.textNumSteps = new JTextField("500", 5);
        this.textNumSteps.setHorizontalAlignment(4);
        panel.add(this.textNumSteps);
        top.add(panel);
        JPanel middle = new JPanel();
        JButton ok_button = new JButton("OK");
        ok_button.addActionListener(this);
        JButton cancel_button = new JButton("Cancel");
        cancel_button.addActionListener(this);
        middle.add(ok_button);
        middle.add(cancel_button);
        this.getContentPane().add((Component)top, "North");
        this.getContentPane().add((Component)middle, "Center");
        this.pack();
    }

    public void open() {
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean setValues() {
        try {
            ((SearchGraph)this.window.returnCanvas().graph).setMaxNumSteps(Integer.parseInt(this.textNumSteps.getText()));
            ((SearchGraph)this.window.returnCanvas().graph).setStopAtGoal(this.choiceYesNo.getSelectedIndex() == 0);
            return true;
        }
        catch (NumberFormatException e) {
            this.window.showMessage("Error", "Number of steps must be a positive integer.");
            return false;
        }
    }

    @Override
    protected boolean actionOK() {
        return this.setValues();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }
}

