/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robotProlog;

import CIspace.graphToolKit.Point;
import CIspace.prolog.Functor;
import CIspace.prolog.Goal;
import CIspace.prolog.Predicate;
import CIspace.prolog.Program;
import CIspace.prolog.Rule;
import CIspace.prolog.Substitution;
import CIspace.prolog.Term;
import CIspace.robot.RobotGraph;
import CIspace.robot.RobotGraphCanvas;
import CIspace.robot.RobotWindow;
import CIspace.robotProlog.Debugger;
import CIspace.robotProlog.PrologError;
import CIspace.robotProlog.RobotGoal;
import CIspace.robotProlog.RobotPredicate;
import CIspace.robotProlog.RobotRule;
import CIspace.robotProlog.RobotTerm;
import CIspace.robotProlog.prologNode;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RobotProgram
extends Program {
    public Vector newInitGoals = new Vector();
    public Vector newInitControllerCode = new Vector();
    public Vector newInitFluents = new Vector();
    public int newVarNum = 1;
    public int totalrowsdeleted = 0;
    private boolean markfailed;
    private Vector tabs;
    private int tabnum;
    private int failnum;
    private int linenum;
    private RobotGoal g;
    private boolean fail;
    public int logicalRowNum = 0;
    private static int numsteps;
    private static double compassdir;
    private static Vector newGoals;
    private static Vector goals;
    private static Goal currentGoal;
    private static double currentTime;
    public static int parsingLayer;
    public static final int UNKNOWN = 0;
    public static final int HIGH = 1;
    public static final int MIDDLE = 2;
    public static final int ENV = 3;
    public static Hashtable timeSteps;
    public static Vector usedfluents;
    public static Hashtable previousAssigned;
    public static Hashtable currentAssigned;
    public static Vector robotPositions;
    private static Vector rules;
    private static RobotGraphCanvas canvas;
    private static String errorMessage;
    private Debugger debugger = new Debugger(this);

    static {
        newGoals = new Vector();
        parsingLayer = 0;
        timeSteps = new Hashtable();
        usedfluents = new Vector();
        previousAssigned = new Hashtable();
        currentAssigned = new Hashtable();
        rules = new Vector();
        canvas = null;
    }

    public void resetDebugTable() {
        this.debugger.tableData.clear();
    }

    protected static void setRuleToCurrentTime(RobotTerm currTerm) {
        if (currTerm.getName().equals("T")) {
            RobotTerm newTerm;
            RobotTerm time = new RobotTerm(new Double(RobotProgram.getCurrentTime()).toString());
            currTerm = newTerm = (RobotTerm)currTerm.unify(time, true);
        }
    }

    public static double getCurrentTime() {
        return currentTime;
    }

    public static void setTime(Vector gs) {
        int i = 0;
        while (i < gs.size()) {
            RobotTerm[] terms = (RobotTerm[])((RobotGoal)gs.get(i)).getTerms();
            int k = 0;
            while (k < terms.length) {
                RobotProgram.setRuleToCurrentTime(terms[k]);
                ++k;
            }
            ++i;
        }
    }

    public Vector initGoal() {
        goals = new Vector();
        goals.add(this.parseGoal("assign(robot_pos,(X,Y),T)"));
        goals.add(this.parseGoal("assign(to_do,R,T)"));
        goals.add(this.parseGoal("assign(goal_pos,Coords,T)"));
        goals.add(this.parseGoal("assign(compass,C,T)"));
        int i = 0;
        while (i < this.newInitGoals.size()) {
            goals.add(this.parseGoal((String)this.newInitGoals.elementAt(i)));
            ++i;
        }
        RobotProgram.setTime(goals);
        this.setGoals(goals);
        currentGoal = (RobotGoal)goals.elementAt(0);
        Vector rules = this.getRules(currentGoal, true);
        int j = 0;
        while (j < 3) {
            currentAssigned.put(((RobotRule)rules.elementAt((int)j)).head.getTerms()[0].getName(), rules.elementAt(j));
            ++j;
        }
        return goals;
    }

    public void markWatchPredicates(Vector watchPreds) {
        int i = 0;
        while (i < this.predicates.size()) {
            ((RobotPredicate)this.predicates.elementAt((int)i)).watch = watchPreds.contains(this.predicates.elementAt(i).toString());
            ++i;
        }
    }

    public void sendSignal() throws PrologError {
        try {
            RobotGoal robotposgoal = (RobotGoal)((RobotRule)RobotProgram.currentAssigned.get((Object)"robot_pos")).head;
            Double xval = robotposgoal.getTerms()[1].lastUnified().getTerms()[0].lastUnified().solveArithmetic();
            Double yval = robotposgoal.getTerms()[1].lastUnified().getTerms()[1].lastUnified().solveArithmetic();
            Point robotPoint = new Point(xval.floatValue(), yval.floatValue());
            robotPositions.addElement(robotPoint);
        }
        catch (NullPointerException e) {
            throw new PrologError("Cannot determine next robot position.  Try debugging.");
        }
        try {
            RobotGoal compassgoal = (RobotGoal)((RobotRule)RobotProgram.currentAssigned.get((Object)"compass")).head;
            compassdir = compassgoal.getTerms()[1].lastUnified().solveArithmetic();
        }
        catch (NullPointerException e) {
            throw new PrologError("Cannot determine next robot direction.  Try debugging.");
        }
    }

    public void addassign(RobotGoal g) {
        String fluent = g.getTerms()[0].getName();
        if (!usedfluents.contains(fluent)) {
            currentAssigned.put(fluent, this.makeRule(g, new Vector()));
            usedfluents.add(fluent);
        }
    }

    public void manuallyMovedRobot(Hashtable assigned) {
        Point robotPos = canvas.getRobotPosition();
        String assignRobotPos = "assign(robot_pos,(" + robotPos.x + "," + robotPos.y + "), " + currentTime + ")";
        RobotGoal newRobotPos = (RobotGoal)this.parseGoal(assignRobotPos);
        assigned.put("robot_pos", this.makeRule(newRobotPos, new Vector()));
        double direction = canvas.getRobotDirection();
        String assignRobotDir = "assign(compass," + direction + "," + currentTime + " )";
        RobotGoal newRobotDir = (RobotGoal)this.parseGoal(assignRobotDir);
        assigned.put("compass", this.makeRule(newRobotDir, new Vector()));
    }

    public Vector getUnifiedTerms(Vector rules, RobotGoal g) {
        Vector gunifiedterms = new Vector();
        if (rules.size() > 1) {
            Vector gterms = g.getUniqueVariables();
            int i = 0;
            while (i < gterms.size()) {
                if (((RobotTerm)gterms.elementAt((int)i)).unifiedWith == null) {
                    gunifiedterms.add(gterms.elementAt(i));
                }
                ++i;
            }
        }
        return gunifiedterms;
    }

    public void updateTabnum(RobotGoal g, prologNode root) {
        if (g.indent) {
            ++this.tabnum;
        } else {
            RobotGoal currparent = g;
            RobotGoal currg = g;
            prologNode currnode = root;
            while (currg.isLast) {
                --this.tabnum;
                Vector goalsattime = (Vector)((RobotPredicate)g.getPredicate()).traceHash.get(new Double(g.timestep));
                goalsattime.remove(g);
                currnode = currnode.getParent();
                currparent = (RobotGoal)currnode.getGoals().elementAt(0);
                boolean contains = false;
                while (!contains) {
                    int i = 0;
                    while (i < currparent.derivedFrom.ruleBody().size()) {
                        if (((RobotGoal)currparent.derivedFrom.ruleBody().elementAt(i)).canunify(currg, false)) {
                            contains = true;
                        }
                        ++i;
                    }
                    if (contains) continue;
                    currnode = currnode.getParent();
                    currparent = (RobotGoal)currnode.getGoals().elementAt(0);
                }
                if (!currparent.isLast) break;
                currg = currparent;
            }
        }
    }

    public void backtrackTrace(RobotGoal g) {
        g.tabnum = this.tabnum;
        if (g.tabnum > 0) {
            int currrow = this.debugger.tableData.size() - 2;
            currrow = this.logicalRowNum % this.debugger.tableDataSize - 1 < 0 ? this.debugger.tableDataSize - 2 : (this.logicalRowNum % this.debugger.tableDataSize - 2 < 0 ? this.debugger.tableDataSize - 1 : this.logicalRowNum % this.debugger.tableDataSize - 2);
            while (((Vector)this.debugger.tableData.elementAt(currrow)).elementAt(1) instanceof RobotGoal && ((RobotGoal)((Vector)this.debugger.tableData.elementAt((int)currrow)).elementAt((int)1)).tabnum > 0 && ((RobotGoal)((Vector)this.debugger.tableData.elementAt((int)currrow)).elementAt((int)1)).tabnum >= g.tabnum) {
                if (currrow - 1 < 0) {
                    currrow = this.debugger.tableDataSize;
                }
                --currrow;
            }
            ((RobotGoal)((Vector)this.debugger.tableData.elementAt((int)currrow)).elementAt((int)1)).children.add(g);
            g.parent = (RobotGoal)((Vector)this.debugger.tableData.elementAt(currrow)).elementAt(1);
        }
        this.tabs.add(new Integer(this.tabnum));
    }

    public Vector getNewRow() {
        ++this.linenum;
        Vector<String> newVector = new Vector<String>(4, 1);
        int i = 0;
        while (i < 4) {
            newVector.add(new String(""));
            ++i;
        }
        return newVector;
    }

    public void setTraceRow(RobotGoal g, Vector rowVector) {
        rowVector.set(0, new String(String.valueOf(this.linenum) + "."));
        g.tabnum = this.tabnum;
        rowVector.set(1, g);
        if (g.substitutions != null && g.substitutions.size() > 0) {
            rowVector.set(3, g.substitutions);
        }
    }

    public void setFailTrace() {
        this.fail = true;
        ++this.failnum;
        if (this.tabs.size() > 1) {
            this.tabs.removeElementAt(this.tabs.size() - 1);
            this.tabnum = (Integer)this.tabs.elementAt(this.tabs.size() - 1);
        }
    }

    public void failTrace(RobotGoal g) {
        int rownum;
        if (g.substitutions != null && g.substitutions.size() > 0) {
            rownum = this.logicalRowNum % this.debugger.tableDataSize - 1 < 0 ? this.debugger.tableDataSize - 1 : this.logicalRowNum % this.debugger.tableDataSize - 1;
            ((Vector)this.debugger.tableData.elementAt(rownum)).set(3, g.substitutions);
        }
        rownum = this.logicalRowNum % this.debugger.tableDataSize - 1 < 0 ? this.debugger.tableDataSize - 1 : this.logicalRowNum % this.debugger.tableDataSize - 1;
        ((Vector)this.debugger.tableData.elementAt(rownum)).set(2, new String("   Redoing Line " + (this.linenum - this.failnum)));
        this.linenum -= this.failnum;
        this.fail = false;
        this.failnum = 0;
        RobotGoal currentg = g;
        while (currentg != null) {
            currentg.fail = false;
            currentg = currentg.parent;
        }
    }

    public void markFailed(RobotGoal g) {
        if (!this.markfailed) {
            this.markfailed = true;
            RobotGoal currentg = g;
            while (currentg != null) {
                currentg.fail = true;
                currentg = currentg.parent;
            }
        }
    }

    public void resetStep() {
        this.tabs = new Vector();
        this.tabnum = 0;
        this.linenum = 0;
        this.fail = false;
        this.failnum = 0;
        this.markfailed = false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean step(Vector currgoals) throws PrologError {
        this.resetStep();
        root = new prologNode(currgoals);
        this.g = (RobotGoal)root.getGoals().elementAt(0);
        while (root.getGoals().size() > 0) {
            rowVector = this.getNewRow();
            if (this.debugger.tableData.size() > this.logicalRowNum % this.debugger.tableDataSize) {
                this.debugger.tableData.set(this.logicalRowNum % this.debugger.tableDataSize, rowVector);
            } else {
                this.debugger.tableData.add(this.logicalRowNum % this.debugger.tableDataSize, rowVector);
            }
            ++this.logicalRowNum;
            if (this.fail) {
                this.failTrace(this.g);
            }
            this.g = (RobotGoal)root.getGoals().elementAt(0);
            if (this.g.getPredicate().name.equals("assign")) {
                this.addassign(this.g);
            }
            this.g.timestep = RobotProgram.currentTime;
            if (((RobotPredicate)this.g.getPredicate()).traceHash.get(new Double(this.g.timestep)) == null) {
                traceVector = new Vector();
                traceVector.add(this.g);
                ((RobotPredicate)this.g.getPredicate()).traceHash.put(new Double(this.g.timestep), traceVector);
            } else {
                traceVector = (Vector)((RobotPredicate)this.g.getPredicate()).traceHash.get(new Double(this.g.timestep));
                traceVector.add(this.g);
            }
            this.backtrackTrace(this.g);
            if (this.g.getPredicate().builtIn()) {
                resolvant = this.solveGoal(this.g, root.getGoals());
            } else {
                rules = this.getRules(this.g, true);
                if (rules.size() == 0) {
                    throw new PrologError("No matching rule for goal '" + this.g.getPredicate() + "'.");
                }
                root.setRules(rules, this.getUnifiedTerms(rules, this.g));
                currRule = root.getNextRule();
                resolvant = this.applyRule(currRule, this.g, root.getGoals());
            }
            if (resolvant != null) {
                this.setTraceRow(this.g, rowVector);
                if (resolvant.size() == 0) {
                    return true;
                }
                branch = new prologNode(resolvant);
                root.addchild(branch);
                this.updateTabnum(this.g, root);
                root = root.getChild();
                continue;
            }
            rowVector.set(0, new String(String.valueOf(this.linenum) + "."));
            this.g.tabnum = this.tabnum;
            rowVector.set(1, this.g);
            ** GOTO lbl79
            {
                block17: {
                    this.markfailed = false;
                    currRule = root.getNextRule();
                    resolvant = this.applyRule(currRule, this.g, root.getGoals());
                    if (resolvant == null) break block17;
                    if (this.g.substitutions != null && this.g.substitutions.size() > 0 && !this.fail) {
                        rownum = this.logicalRowNum % this.debugger.tableDataSize - 1 < 0 ? this.debugger.tableDataSize - 1 : this.logicalRowNum % this.debugger.tableDataSize - 1;
                        ((Vector)this.debugger.tableData.elementAt(rownum)).set(3, this.g.substitutions);
                    }
                    if (resolvant.size() == 0) {
                        return true;
                    }
                    branch = new prologNode(resolvant);
                    root.addchild(branch);
                    ** GOTO lbl69
                }
                do {
                    if (root.hasMoreRules() && resolvant == null) continue block1;
lbl69:
                    // 2 sources

                    if (root.getChild() != null) {
                        this.updateTabnum(this.g, root);
                        root = root.getChild();
                        break block1;
                    }
                    this.setFailTrace();
                    root = root.getParent();
                    if (root == null) continue;
                    this.markFailed(this.g);
                    root.removeChild();
                    this.g = (RobotGoal)root.getGoals().elementAt(0);
lbl79:
                    // 3 sources

                } while (root != null);
            }
            if (root != null) continue;
            return false;
        }
        return true;
    }

    public Vector solveGoal(Goal g, Vector goals) {
        if (!g.getPredicate().builtIn()) {
            return null;
        }
        this.clearGoals(goals);
        Goal solved = g.solve();
        if (solved != null) {
            Vector<Goal> resolvent = new Vector<Goal>(goals.size() - 1);
            int i = 0;
            while (i < goals.size()) {
                Goal g1 = (Goal)goals.elementAt(i);
                if (g1 != null && g1 != g) {
                    resolvent.addElement(g1.fixTerms2());
                }
                ++i;
            }
            Vector vars = g.getUniqueVariables();
            Vector<Substitution> subs = new Vector<Substitution>();
            int j = 0;
            while (j < vars.size()) {
                Term t = (Term)vars.elementAt(j);
                if (t.type == 0 && t.lastUnified() != null && !t.name.equals(t.lastUnified().name)) {
                    subs.addElement(new Substitution(t, t.lastUnified()));
                }
                ++j;
            }
            g.substitutions = subs;
            g.extraSubs = new Vector();
            Vector derivedfrombody = g.derivedFrom.ruleBody();
            if (derivedfrombody.size() > 0 && ((Goal)derivedfrombody.lastElement()).canunify(g, false)) {
                g.isLast = true;
            }
            g.derivedFrom = this.makeRule(g, new Vector());
            return resolvent;
        }
        return null;
    }

    public Vector applyRule(Rule r, Goal g, Vector goals) {
        g.usedRules.addElement(r);
        Vector allVars = this.getUniqueVariables(goals);
        int i = 0;
        while (i < allVars.size()) {
            Term t = (Term)allVars.elementAt(i);
            if (!this.usedTerms.contains(t.name)) {
                this.usedTerms.addElement(t.name);
            }
            ++i;
        }
        Rule r1 = r.rename(this.usedTerms);
        Goal unified = g.unify(r1.ruleHead(), this.occursCheck);
        if (unified != null) {
            Vector derivedfrombody;
            ++r.varCounter;
            Vector resolvent = new Vector(goals.size());
            int j = 0;
            while (j < goals.size()) {
                if (goals.elementAt(j) != null && !resolvent.contains(goals.elementAt(j))) {
                    resolvent.addElement(goals.elementAt(j));
                }
                ++j;
            }
            int index = resolvent.indexOf(g);
            resolvent.removeElement(g);
            Vector newGoals = r1.applyUnification();
            this.insertAt(resolvent, newGoals, index);
            int j2 = 0;
            while (j2 < resolvent.size()) {
                resolvent.setElementAt(((Goal)resolvent.elementAt(j2)).fixTerms2(), j2);
                ++j2;
            }
            Vector vars = g.getUniqueVariables();
            Vector<Substitution> subs = new Vector<Substitution>();
            int j3 = 0;
            while (j3 < vars.size()) {
                Term t = (Term)vars.elementAt(j3);
                if (t.type == 0 && t.lastUnified() != null && !t.name.equals(t.lastUnified().name)) {
                    subs.addElement(new Substitution(t, t.lastUnified()));
                }
                ++j3;
            }
            Vector<Substitution> extraSubs = new Vector<Substitution>();
            vars = r1.ruleHead().getUniqueVariables();
            int j4 = 0;
            while (j4 < vars.size()) {
                Term t = (Term)vars.elementAt(j4);
                if (t.type == 0 && t.lastUnified() != null && !t.name.equals(t.lastUnified().name)) {
                    extraSubs.addElement(new Substitution(t, t.lastUnified()));
                }
                ++j4;
            }
            g.extraSubs = extraSubs;
            g.substitutions = subs;
            if (newGoals.size() > 0) {
                g.indent = true;
            }
            if (g.derivedFrom != null && (derivedfrombody = g.derivedFrom.ruleBody()).size() > 0 && ((Goal)derivedfrombody.lastElement()).canunify(g, false)) {
                g.isLast = true;
            }
            g.derivedFrom = r1;
            return resolvent;
        }
        g.clearUnified();
        return null;
    }

    public static Hashtable getpreviousAssigned() {
        return previousAssigned;
    }

    public static Hashtable getcurrentAssigned() {
        return currentAssigned;
    }

    public void updateAssignedHash() {
        Enumeration e = currentAssigned.keys();
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            RobotTerm value = (RobotTerm)((RobotRule)RobotProgram.currentAssigned.get((Object)next)).head.getTerms()[1];
            if (value.unifiedWith != null || !previousAssigned.containsKey(next)) continue;
            currentAssigned.put(next, previousAssigned.get(next));
        }
    }

    public void printOutput(boolean output) {
        Vector<String> rowVector = new Vector<String>(4);
        rowVector.add("");
        if (output) {
            rowVector.add("TRUE");
        } else {
            rowVector.add("NO SOLUTIONS");
        }
        if (this.debugger.tableData.size() > this.logicalRowNum % this.debugger.tableDataSize) {
            this.debugger.tableData.set(this.logicalRowNum % this.debugger.tableDataSize, rowVector);
        } else {
            this.debugger.tableData.add(this.logicalRowNum % this.debugger.tableDataSize, rowVector);
        }
        ++this.logicalRowNum;
        if (this.debugger.tableData.size() > this.logicalRowNum % this.debugger.tableDataSize) {
            this.debugger.tableData.set(this.logicalRowNum % this.debugger.tableDataSize, new Vector(4));
        } else {
            this.debugger.tableData.add(this.logicalRowNum % this.debugger.tableDataSize, new Vector(4));
        }
        ++this.logicalRowNum;
    }

    public void resetAssigns(Hashtable assigned) {
        usedfluents.clear();
        previousAssigned.putAll(assigned);
        currentAssigned.clear();
    }

    public void updateTrace(double time) {
        if (timeSteps.get(new Double(time + 1.0)) != null) {
            int maxrow;
            this.totalrowsdeleted = maxrow = ((Integer)timeSteps.get(new Double(time + 1.0))).intValue();
        }
        timeSteps.remove(new Double(time + 1.0));
        int i = 0;
        while (i < this.predicates.size()) {
            ((RobotPredicate)this.predicates.elementAt((int)i)).traceHash.remove(new Double(time));
            ++i;
        }
        i = 0;
        while (i < this.builtin_predicates.size()) {
            ((RobotPredicate)this.builtin_predicates.elementAt((int)i)).traceHash.remove(new Double(time));
            ++i;
        }
    }

    public Hashtable fullTimeStep(double time, Hashtable assigned) throws PrologError {
        this.resetAssigns(assigned);
        currentTime = time;
        Vector currgoals = this.initGoal();
        numsteps = 0;
        Vector currgoalsvector = new Vector();
        Vector<String> timeRow = new Vector<String>(4);
        timeRow.add("TIME STEP " + currentTime);
        if (this.debugger.tableData.size() > this.logicalRowNum % this.debugger.tableDataSize) {
            this.debugger.tableData.set(this.logicalRowNum % this.debugger.tableDataSize, timeRow);
        } else {
            this.debugger.tableData.add(this.logicalRowNum % this.debugger.tableDataSize, timeRow);
        }
        ++this.logicalRowNum;
        timeSteps.put(new Double(currentTime), new Integer(this.logicalRowNum - 1));
        int i = 0;
        while (i < currgoals.size()) {
            currgoalsvector.add(currgoals.elementAt(i));
            boolean output = this.step(currgoalsvector);
            if (this.fail) {
                int rownum;
                if (this.g.substitutions != null && this.g.substitutions.size() > 0) {
                    rownum = this.logicalRowNum % this.debugger.tableDataSize - 1 < 0 ? this.debugger.tableDataSize - 1 : this.logicalRowNum % this.debugger.tableDataSize - 1;
                    ((Vector)this.debugger.tableData.elementAt(rownum)).set(3, this.g.substitutions);
                }
                rownum = this.logicalRowNum % this.debugger.tableDataSize - 1 < 0 ? this.debugger.tableDataSize - 1 : this.logicalRowNum % this.debugger.tableDataSize - 1;
                ((Vector)this.debugger.tableData.elementAt(rownum)).set(2, new String("     FAIL    "));
                this.linenum -= this.failnum;
                this.fail = false;
                this.failnum = 0;
            }
            this.printOutput(output);
            this.addassign((RobotGoal)currgoals.elementAt(i));
            currgoalsvector.removeAllElements();
            ++i;
        }
        this.sendSignal();
        this.updateControllerSignals();
        this.reset();
        this.updateAssignedHash();
        if (canvas != null) {
            canvas.plotPoint((Point)robotPositions.lastElement(), compassdir);
        }
        return currentAssigned;
    }

    public void updateControllerSignals() {
        String signals = "Time:   T = " + currentTime + "\n";
        int from = 0;
        int to = 0;
        int updatestate = 0;
        boolean isSame = false;
        Vector<String> highSent = new Vector<String>();
        Vector<String> highReceived = new Vector<String>();
        Vector<String> highProved = new Vector<String>();
        Vector<String> highUpdates = new Vector<String>();
        Vector<String> midSent = new Vector<String>();
        Vector<String> midReceived = new Vector<String>();
        Vector<String> midProved = new Vector<String>();
        Vector<String> midUpdates = new Vector<String>();
        Vector<String> envSent = new Vector<String>();
        Vector<String> envReceived = new Vector<String>();
        Vector<String> envProved = new Vector<String>();
        Vector signalInfo = new Vector();
        int i = 0;
        while (i < this.predicates.size()) {
            if (((RobotPredicate)this.predicates.elementAt((int)i)).watch) {
                signalInfo.clear();
                signalInfo = ((RobotPredicate)this.predicates.elementAt(i)).getSignal(currentTime);
                to = (Integer)signalInfo.elementAt(0);
                from = (Integer)signalInfo.elementAt(1);
                isSame = (Boolean)signalInfo.elementAt(2);
                updatestate = (Integer)signalInfo.elementAt(3);
                String predString = (String)signalInfo.elementAt(4);
                if (predString != null) {
                    if (isSame) {
                        if (from == 1) {
                            highProved.add(predString);
                        } else if (from == 2) {
                            midProved.add(predString);
                        } else if (from == 3) {
                            envProved.add(predString);
                        }
                    } else {
                        if (from == 1) {
                            highSent.add(predString);
                        } else if (from == 2) {
                            midSent.add(predString);
                        } else if (from == 3) {
                            envSent.add(predString);
                        }
                        if (to == 1) {
                            highReceived.add(predString);
                        } else if (to == 2) {
                            midReceived.add(predString);
                        } else if (to == 3) {
                            envReceived.add(predString);
                        }
                        if (updatestate == 1) {
                            highUpdates.add(predString);
                        } else if (updatestate == 2) {
                            midUpdates.add(predString);
                        }
                    }
                }
                if (((RobotPredicate)this.predicates.elementAt(i)).toString().equals("assign/3")) {
                    int j = 5;
                    while (j < signalInfo.size()) {
                        to = (Integer)signalInfo.elementAt(0 + j);
                        from = (Integer)signalInfo.elementAt(1 + j);
                        isSame = (Boolean)signalInfo.elementAt(2 + j);
                        updatestate = (Integer)signalInfo.elementAt(3 + j);
                        predString = (String)signalInfo.elementAt(4 + j);
                        if (predString != null) {
                            if (isSame) {
                                if (from == 1) {
                                    highProved.add(predString);
                                } else if (from == 2) {
                                    midProved.add(predString);
                                } else if (from == 3) {
                                    envProved.add(predString);
                                }
                            } else {
                                if (from == 1) {
                                    highSent.add(predString);
                                } else if (from == 2) {
                                    midSent.add(predString);
                                } else if (from == 3) {
                                    envSent.add(predString);
                                }
                                if (to == 1) {
                                    highReceived.add(predString);
                                } else if (to == 2) {
                                    midReceived.add(predString);
                                } else if (to == 3) {
                                    envReceived.add(predString);
                                }
                                if (updatestate == 1) {
                                    highUpdates.add(predString);
                                } else if (updatestate == 2) {
                                    midUpdates.add(predString);
                                }
                            }
                        }
                        j += 5;
                    }
                }
            }
            ++i;
        }
        if (!highSent.isEmpty()) {
            signals = String.valueOf(signals) + "High layer sent signal:\n";
            i = 0;
            while (i < highSent.size()) {
                signals = String.valueOf(signals) + "     " + (String)highSent.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!highReceived.isEmpty()) {
            signals = String.valueOf(signals) + "High layer received signal:\n";
            i = 0;
            while (i < highReceived.size()) {
                signals = String.valueOf(signals) + "     " + (String)highReceived.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!highProved.isEmpty()) {
            signals = String.valueOf(signals) + "High layer proved:\n";
            i = 0;
            while (i < highProved.size()) {
                signals = String.valueOf(signals) + "     " + (String)highProved.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!highUpdates.isEmpty()) {
            signals = String.valueOf(signals) + "High layer updated states:\n";
            i = 0;
            while (i < highUpdates.size()) {
                signals = String.valueOf(signals) + "     " + (String)highUpdates.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!midSent.isEmpty()) {
            signals = String.valueOf(signals) + "Middle layer sent signal:\n";
            i = 0;
            while (i < midSent.size()) {
                signals = String.valueOf(signals) + "     " + (String)midSent.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!midReceived.isEmpty()) {
            signals = String.valueOf(signals) + "Middle layer received signal:\n";
            i = 0;
            while (i < midReceived.size()) {
                signals = String.valueOf(signals) + "     " + (String)midReceived.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!midProved.isEmpty()) {
            signals = String.valueOf(signals) + "Middle layer proved:\n";
            i = 0;
            while (i < midProved.size()) {
                signals = String.valueOf(signals) + "     " + (String)midProved.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!midUpdates.isEmpty()) {
            signals = String.valueOf(signals) + "Middle layer updated states:\n";
            i = 0;
            while (i < midUpdates.size()) {
                signals = String.valueOf(signals) + "     " + (String)midUpdates.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!envSent.isEmpty()) {
            signals = String.valueOf(signals) + "Environment layer sent signal:\n";
            i = 0;
            while (i < envSent.size()) {
                signals = String.valueOf(signals) + "     " + (String)envSent.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!envReceived.isEmpty()) {
            signals = String.valueOf(signals) + "Environment layer received signal:\n";
            i = 0;
            while (i < envReceived.size()) {
                signals = String.valueOf(signals) + "     " + (String)envReceived.elementAt(i) + "\n";
                ++i;
            }
        }
        if (!envProved.isEmpty()) {
            signals = String.valueOf(signals) + "Environment layer proved:\n";
            i = 0;
            while (i < envProved.size()) {
                signals = String.valueOf(signals) + "Environment layer proved:\n";
                ++i;
            }
        }
        signals = String.valueOf(signals) + "\n\n";
        ((RobotWindow)RobotProgram.canvas.parent).addLog(signals);
    }

    public static String getErrorMessage() {
        return errorMessage;
    }

    public static RobotGraph getGraph() {
        return (RobotGraph)RobotProgram.canvas.graph;
    }

    public boolean initializeSimulation_web(RobotGraphCanvas c, double maxTime, double dt) {
        canvas = c;
        String errorLine = "";
        robotPositions = new Vector();
        this.resetRobot();
        String err = this.parse(canvas.getInitControllerCode());
        if (!err.equals("")) {
            parsingLayer = 0;
            c.showMessage("Syntax Error", err);
            return false;
        }
        parsingLayer = 1;
        err = this.parse(canvas.getHighControllerCode());
        if (!err.equals("")) {
            parsingLayer = 0;
            c.showMessage("Syntax Error in High Layer Controller Code", err);
            return false;
        }
        parsingLayer = 2;
        err = this.parse(canvas.getMedControllerCode());
        if (!err.equals("")) {
            parsingLayer = 0;
            c.showMessage("Syntax Error in Middle Layer Controller Code", err);
            return false;
        }
        parsingLayer = 3;
        err = this.parse(canvas.getEnvControllerCode());
        if (!err.equals("")) {
            parsingLayer = 0;
            c.showMessage("Syntax Error in Environment Controller Code", err);
            return false;
        }
        int i = 0;
        while (i < this.newInitControllerCode.size()) {
            err = this.parse(this.newInitControllerCode.elementAt(i).toString());
            ++i;
        }
        parsingLayer = 0;
        return true;
    }

    protected Rule makeRule(Goal head, Vector goals) {
        return new RobotRule((RobotGoal)head, goals);
    }

    protected Goal makeGoal(Predicate p) {
        return new RobotGoal(p);
    }

    protected Goal makeGoal(String name, Term[] newTerms) {
        return new RobotGoal(name, (Term[])((RobotTerm[])newTerms));
    }

    protected Goal makeGoal(int builtin, Term[] newTerms) {
        return new RobotGoal(builtin, (Term[])((RobotTerm[])newTerms));
    }

    protected Goal makeGoal(Goal g) {
        return new RobotGoal((RobotGoal)g);
    }

    protected Term makeTerm(String str) {
        return new RobotTerm(str);
    }

    protected Term makeTerm(Functor f, Term[] newTerms) {
        return new RobotTerm(f, (RobotTerm[])newTerms);
    }

    protected Term makeTerm(Term t) {
        return new RobotTerm((RobotTerm)t);
    }

    protected Term[] makeTerms(int arity) {
        return new RobotTerm[arity];
    }

    protected Goal parseBuiltInGoal(String str) {
        if (!this.matchBrackets(str)) {
            return null;
        }
        if (str.startsWith("was")) {
            int type = 104;
            return this.parseRobotBuiltIn(str, false, type);
        }
        if (str.startsWith("seeblock")) {
            int type = 101;
            return this.parseRobotBuiltIn(str, false, type);
        }
        if (str.startsWith("notseeblock")) {
            int type = 102;
            return this.parseRobotBuiltIn(str, false, type);
        }
        if (str.startsWith("at")) {
            int type = 105;
            return this.parseRobotBuiltIn(str, false, type);
        }
        return super.parseBuiltInGoal(str);
    }

    protected Goal parseNonBuiltInGoal(String str, boolean neg) {
        String fluent;
        Goal g = super.parseNonBuiltInGoal(str, neg);
        Predicate p = g.getPredicate();
        if (!(!p.name.equals("assign") || (fluent = g.getTerms()[0].name).equals("robot_pos") || fluent.equals("compass") || fluent.equals("to_do") || fluent.equals("goal_pos"))) {
            if (!this.newInitFluents.contains(fluent)) {
                this.newInitFluents.add(fluent);
                String newinitgoal = "assign(" + fluent + ", ";
                int i = 1;
                while (i < g.getTerms().length) {
                    newinitgoal = g.getTerms()[i].isGround() ? String.valueOf(newinitgoal) + "Var" + this.newVarNum++ : String.valueOf(newinitgoal) + g.getTerms()[i].name;
                    if (i != g.getTerms().length - 1) {
                        newinitgoal = String.valueOf(newinitgoal) + ", ";
                    }
                    ++i;
                }
                newinitgoal = String.valueOf(newinitgoal) + ")";
                this.newInitGoals.add(newinitgoal);
            } else {
                boolean isAllGround = true;
                int i = 1;
                while (i < g.getTerms().length) {
                    if (!g.getTerms()[i].isGround()) {
                        isAllGround = false;
                        break;
                    }
                    ++i;
                }
                if (isAllGround && !this.newInitControllerCode.contains(g)) {
                    this.newInitControllerCode.add(g);
                }
            }
        }
        return g;
    }

    protected Goal parseRobotBuiltIn(String str, boolean neg, int type) {
        int next;
        int i = str.indexOf("(");
        if (i == -1) {
            Goal g = this.makeGoal(str, this.makeTerms(0));
            g.neg = neg;
            return g;
        }
        String name = str.substring(0, i).trim();
        int compound = str.indexOf("(", i + 1);
        int compound2 = str.indexOf("[", i + 1);
        int j = str.indexOf(",");
        int end = str.length() - 1;
        if (end == -1) {
            return null;
        }
        if (compound > -1 && compound < j && (compound2 == -1 || compound < compound2)) {
            next = this.findNextRight(compound, str);
            if (next == -1) {
                return null;
            }
            j = next + 1;
        } else if (compound2 > -1 && compound2 < j) {
            next = this.findNextRightSquare(compound2, str);
            if (next == -1) {
                return null;
            }
            j = next + 1;
        }
        Vector<Term> terms = new Vector<Term>();
        ++i;
        while (j > 0) {
            String nextTerm = str.substring(i, j).trim();
            if (!this.matchBrackets(nextTerm)) {
                return null;
            }
            i = j + 1;
            terms.addElement(this.makeTerm(nextTerm));
            compound = str.indexOf("(", j);
            compound2 = str.indexOf("[", j);
            int nextComma = str.indexOf(",", i);
            j = compound != -1 && compound < nextComma && (compound2 == -1 || compound < compound2) ? this.findNextRight(compound, str) + 1 : (compound2 > -1 && compound2 < nextComma ? this.findNextRightSquare(compound2, str) + 1 : str.indexOf(",", i));
        }
        if (i < end) {
            terms.addElement(this.makeTerm(str.substring(i, end).trim()));
        }
        Term[] newTerms = this.makeTerms(terms.size());
        int ind = 0;
        while (ind < terms.size()) {
            newTerms[ind] = (Term)terms.elementAt(ind);
            ++ind;
        }
        Goal g = this.makeGoal(type, newTerms);
        g.neg = neg;
        return g;
    }

    public void clearGoals(Vector goals) {
    }

    public void resetRobot() {
        this.predicates = new Vector(5, 2);
        this.builtin_predicates = new Vector(5, 2);
        this.usedTerms = new Vector(5, 2);
        this.occursCheck = true;
    }

    public void showTrace() {
        this.debugger.createTable();
        ((Component)this.debugger.debugFrame).setVisible(true);
    }
}

