/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.robot.RobotGraphCanvas;
import CIspace.robot.RobotWindow;
import CIspace.robotProlog.RobotProgram;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SignalsDialog
extends JFrame
implements ActionListener {
    private Vector programPredicates;
    private Vector predbuttons;
    private JButton updateButton;
    private JButton defaultButton;
    private JButton cancelButton;
    private RobotWindow parent;
    private RobotProgram prog;
    private Vector predicates;
    private Vector defaultpredicates;

    public SignalsDialog(RobotWindow parent) {
        super("Controller Signals");
        this.parent = parent;
        this.prog = parent.program;
        this.setDefaultPredicates();
    }

    public void show() {
        ((Component)this).setLocation(50, 50);
        JPanel p = new JPanel();
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.defaultButton = new JButton("Default");
        this.defaultButton.addActionListener(this);
        this.updateButton = new JButton("Update");
        this.updateButton.addActionListener(this);
        p.add(this.updateButton);
        p.add(this.defaultButton);
        p.add(this.cancelButton);
        this.initialize();
        JPanel predPanel = new JPanel(new GridLayout(this.programPredicates.size(), 1));
        this.predbuttons = new Vector();
        int i = 0;
        while (i < this.programPredicates.size()) {
            JCheckBox predbutton = new JCheckBox(this.programPredicates.elementAt(i).toString());
            predPanel.add(predbutton);
            this.predbuttons.add(predbutton);
            ++i;
        }
        i = 0;
        while (i < this.predbuttons.size()) {
            ((JCheckBox)this.predbuttons.elementAt(i)).setSelected(this.predicates.contains(((JCheckBox)this.predbuttons.elementAt(i)).getText()));
            ++i;
        }
        JScrollPane predScroll = new JScrollPane(predPanel);
        JPanel messagePanel = new JPanel(new GridLayout(3, 1));
        messagePanel.add(new JLabel("Check the predicates that you"));
        messagePanel.add(new JLabel("would like to watch."));
        messagePanel.add(new JLabel());
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)messagePanel, "North");
        this.getContentPane().add((Component)predScroll, "Center");
        this.getContentPane().add((Component)p, "South");
        ((Component)this).setSize(300, 400);
        super.show();
    }

    public void initialize() {
        this.prog.initializeSimulation_web((RobotGraphCanvas)this.parent.returnCanvas(), 1.0, 1.0);
        this.programPredicates = this.prog.getPredicates();
    }

    public void setDefaultPredicates() {
        this.defaultpredicates = new Vector();
        this.defaultpredicates.add(new String("assign/3"));
        this.defaultpredicates.add(new String("arrived/1"));
        this.defaultpredicates.add(new String("steer/2"));
        this.defaultpredicates.add(new String("whisker_sensor/2"));
        this.predicates = new Vector();
        int i = 0;
        while (i < this.defaultpredicates.size()) {
            this.predicates.add(this.defaultpredicates.elementAt(i));
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.updateButton)) {
            this.predicates = new Vector();
            int i = 0;
            while (i < this.predbuttons.size()) {
                if (((JCheckBox)this.predbuttons.elementAt(i)).isSelected()) {
                    this.predicates.add(((JCheckBox)this.predbuttons.elementAt(i)).getText());
                }
                ++i;
            }
            this.dispose();
        } else if (e.getSource().equals(this.defaultButton)) {
            int i = 0;
            while (i < this.predbuttons.size()) {
                ((JCheckBox)this.predbuttons.elementAt(i)).setSelected(this.defaultpredicates.contains(((JCheckBox)this.predbuttons.elementAt(i)).getText()));
                ++i;
            }
        } else {
            this.dispose();
        }
    }

    public Vector getWatchPredicates() {
        return this.predicates;
    }
}

