/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.robot.Environment;
import CIspace.robot.RobotGraph;
import CIspace.robot.RobotGraphCanvas;
import CIspace.robot.RobotPositionDialog;
import CIspace.robot.RobotWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RunDialog
extends JFrame
implements ActionListener,
TextListener,
WindowListener {
    private RobotPositionDialog robotpos;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private JPanel robotpospanel;
    private JRadioButton noTrace;
    private JRadioButton yesTrace;
    private JPanel showTracePanel;
    protected JLabel labelNumSteps;
    protected JTextField textNumSteps;
    protected JLabel labelAutoRate;
    protected JTextField textAutoRate;
    protected JLabel labelDeltaT;
    protected JTextField textDeltaT;
    protected JLabel labelPixelsPerUnit;
    protected JTextField textPixelsPerUnit;
    protected JButton buttonOk;
    protected JButton buttonCancel;
    protected JLabel labelError;
    protected JPanel p;
    protected JLabel labelShowTrace;
    protected ButtonGroup choiceShowTrace;
    protected RobotGraphCanvas graphCanvas;
    protected Integer rate;
    protected Double deltaT;
    protected Integer pixels;
    protected Double maxTimeStep;
    protected boolean showTrace;

    public RunDialog(Container parent, RobotGraphCanvas gc) {
        super("Robot Properties");
        this.graphCanvas = gc;
        this.addWindowListener(this);
        this.rate = new Integer(5);
        this.deltaT = new Double(1.0);
        this.pixels = new Integer(Environment.pixelsPerUnit);
        this.maxTimeStep = new Double(300.0);
        this.showTrace = true;
        this.labelNumSteps = new JLabel("Maximum Time Step to Run:");
        this.textNumSteps = new JTextField(this.maxTimeStep.toString(), 20);
        this.textNumSteps.addActionListener(this);
        this.labelAutoRate = new JLabel("Rate of Running Robot:");
        this.textAutoRate = new JTextField(this.rate.toString(), 20);
        this.textAutoRate.addActionListener(this);
        this.labelDeltaT = new JLabel("dt:");
        this.textDeltaT = new JTextField(this.deltaT.toString(), 20);
        this.labelPixelsPerUnit = new JLabel("Number of Pixels per Unit:");
        this.textPixelsPerUnit = new JTextField(this.pixels.toString(), 20);
        this.labelShowTrace = new JLabel("Show Trace:");
        this.showTracePanel = new JPanel();
        this.yesTrace = new JRadioButton("Yes");
        this.yesTrace.addActionListener(this);
        this.noTrace = new JRadioButton("No");
        this.noTrace.addActionListener(this);
        this.choiceShowTrace = new ButtonGroup();
        this.choiceShowTrace.add(this.yesTrace);
        this.choiceShowTrace.add(this.noTrace);
        this.yesTrace.setSelected(true);
        this.showTracePanel.add(this.yesTrace);
        this.showTracePanel.add(new JLabel("         "));
        this.showTracePanel.add(this.noTrace);
        this.buttonOk = new JButton("OK");
        this.buttonOk.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(this);
        this.labelError = new JLabel("");
        this.p = new JPanel();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridheight = 8;
        this.p.setLayout(this.gbl);
        this.setControl();
        this.addComponent(this.labelNumSteps, this.p, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.textNumSteps, this.p, 0, 1, 1, 1, 1.0, 1.0);
        this.addComponent(this.labelDeltaT, this.p, 1, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.textDeltaT, this.p, 1, 1, 1, 1, 1.0, 1.0);
        this.addComponent(this.labelPixelsPerUnit, this.p, 2, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.textPixelsPerUnit, this.p, 2, 1, 1, 1, 1.0, 1.0);
        this.addComponent(this.labelShowTrace, this.p, 3, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.showTracePanel, this.p, 3, 1, 1, 1, 1.0, 1.0);
        this.robotpos = this.graphCanvas.showRobotPositionDialog(((RobotGraph)this.graphCanvas.graph).env.getCurrentCartesianPosition(), ((RobotGraph)this.graphCanvas.graph).env.getCompass());
        this.robotpos.setBorder(BorderFactory.createTitledBorder("Current Robot Properties"));
        this.addComponent(this.robotpos, this.p, 4, 0, 2, 3, 1.0, 1.0);
        this.addComponent(this.buttonOk, this.p, 7, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.buttonCancel, this.p, 7, 1, 1, 1, 1.0, 1.0);
        this.getContentPane().add(this.p);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        RobotWindow.centerWindow(this);
        this.show();
    }

    protected void addComponent(JComponent c, JPanel p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    public void setControl() {
        this.textNumSteps.setEnabled(this.graphCanvas.propertiesEnabled);
        this.textAutoRate.setEnabled(this.graphCanvas.propertiesEnabled);
        this.textDeltaT.setEnabled(this.graphCanvas.propertiesEnabled);
        this.textPixelsPerUnit.setEnabled(this.graphCanvas.propertiesEnabled);
        this.yesTrace.setEnabled(this.graphCanvas.propertiesEnabled);
        this.noTrace.setEnabled(this.graphCanvas.propertiesEnabled);
    }

    public void display() {
        this.textAutoRate.setText(this.rate.toString());
        this.textDeltaT.setText(this.deltaT.toString());
        if (this.showTrace) {
            this.yesTrace.setSelected(true);
        } else {
            this.noTrace.setSelected(true);
        }
        this.setControl();
        this.robotpos = this.graphCanvas.showRobotPositionDialog(((RobotGraph)this.graphCanvas.graph).env.getCurrentCartesianPosition(), ((RobotGraph)this.graphCanvas.graph).env.getCompass());
        this.validate();
        this.show();
    }

    public boolean setProperties() {
        try {
            this.maxTimeStep = Double.valueOf(this.textNumSteps.getText());
            this.deltaT = Double.valueOf(this.textDeltaT.getText());
            this.pixels = Integer.valueOf(this.textPixelsPerUnit.getText());
            this.graphCanvas.setMaxTimeStep(this.maxTimeStep);
            this.graphCanvas.setDeltaT(this.deltaT);
            this.graphCanvas.setShowTrace(this.showTrace);
            Environment.setPixelsPerUnit(this.pixels);
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Field(s) have invalid integer format!");
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
            if (this.setProperties() && this.robotpos.ok()) {
                ((RobotWindow)this.graphCanvas.parent).setPromptLabel(((RobotWindow)this.graphCanvas.parent).getMessage());
                ((Component)this).setVisible(false);
                this.dispose();
            }
        } else if (e.getActionCommand() == "Cancel") {
            ((RobotWindow)this.graphCanvas.parent).setPromptLabel(((RobotWindow)this.graphCanvas.parent).getMessage());
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (e.getSource().equals(this.textAutoRate)) {
            this.textAutoRate.transferFocus();
        } else if (e.getSource().equals(this.textDeltaT)) {
            this.textDeltaT.transferFocus();
        } else if (e.getSource().equals(this.yesTrace)) {
            this.showTrace = true;
        } else if (e.getSource().equals(this.noTrace)) {
            this.showTrace = false;
        }
    }

    public void textValueChanged(TextEvent e) {
        this.labelError.setText("");
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (((RobotWindow)this.graphCanvas.parent).solveViewModes != null) {
            ((RobotWindow)this.graphCanvas.parent).solveViewModes[2].setSelected(true);
        }
        if (((RobotWindow)this.graphCanvas.parent).createViewModes != null) {
            ((RobotWindow)this.graphCanvas.parent).createViewModes[2].setSelected(true);
        }
        ((RobotWindow)this.graphCanvas.parent).setPromptLabel(((RobotWindow)this.graphCanvas.parent).getMessage());
    }

    public void windowClosing(WindowEvent e) {
        if (((RobotWindow)this.graphCanvas.parent).solveViewModes != null) {
            ((RobotWindow)this.graphCanvas.parent).solveViewModes[2].setSelected(true);
        }
        if (((RobotWindow)this.graphCanvas.parent).createViewModes != null) {
            ((RobotWindow)this.graphCanvas.parent).createViewModes[2].setSelected(true);
        }
        ((RobotWindow)this.graphCanvas.parent).setPromptLabel(((RobotWindow)this.graphCanvas.parent).getMessage());
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

