/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.HelpMenu;
import CIspace.graphToolKit.OpenLocationDialog;
import CIspace.graphToolKit.Point;
import CIspace.robot.EnvironmentDialog;
import CIspace.robot.EnvironmentDialogWindows;
import CIspace.robot.HighControllerDialog;
import CIspace.robot.HighControllerDialogWindows;
import CIspace.robot.MiddleControllerDialog;
import CIspace.robot.MiddleControllerDialogWindows;
import CIspace.robot.PlannerFrame;
import CIspace.robot.ProblemDialog;
import CIspace.robot.RobotGraph;
import CIspace.robot.RobotGraphCanvas;
import CIspace.robot.SignalsDialog;
import CIspace.robotProlog.RobotProgram;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class RobotWindow
extends GraphWindow
implements WindowListener,
ActionListener {
    public SignalsDialog signalsDialog;
    public String oldTextRep;
    private ButtonGroup solveViewButGroup;
    private ButtonGroup createViewButGroup;
    public JToggleButton[] solveViewModes;
    public JToggleButton[] createViewModes;
    private String oldmessage;
    private static String aboutText = "About this applet\n\n" + appletTitle + "Updated: Saleema Amershi\n" + "Main Author: Leslie Tung\n" + "Graph Drawing Kit: Shinjiro Sueda\n" + "Bug Fixes: Joseph Roy Santos\n\n" + "Special Thanks to:\n" + "David Poole, Alan Mackworth, Holger Hoos,\n" + "Peter Gorniak, and Cristina Conati";
    public static String appletTitle = "Robot Applet Version 4.6";
    private RobotGraphCanvas canvas;
    private JButton toggle;
    private JPanel center;
    private JPanel left;
    private JPanel bottom;
    private JToggleButton runRobotButton;
    private JToggleButton stepRobotButton;
    private JToggleButton stopRobotButton;
    private JToggleButton resetRobotButton;
    private JToggleButton clearTraceButton;
    private JMenuItem plannerMenu;
    private JMenuItem propertiesMenu;
    private JTextArea logArea;
    private JScrollPane logScroll;
    private String extension;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private String filename;
    private ImageIcon runIcon = GraphWindow.createImageIcon("images/runner.png");
    private ImageIcon stopIcon = GraphWindow.createImageIcon("images/stop.gif");
    private ImageIcon stepIcon = GraphWindow.createImageIcon("images/step.png");
    private ImageIcon resetIcon = GraphWindow.createImageIcon("images/Reset.gif");
    private ImageIcon robottraceIcon = GraphWindow.createImageIcon("images/robottrace.png");
    private ImageIcon bugIcon = GraphWindow.createImageIcon("images/bug.png");
    private static ImageIcon viewPlanIcon = GraphWindow.createImageIcon("images/viewCurrentPlan.png");
    private static ImageIcon viewRobotIcon = GraphWindow.createImageIcon("images/viewRobotProps.png");
    private static ImageIcon robotlocationIcon = GraphWindow.createImageIcon("images/robotloc.png");
    private static ImageIcon wallIcon = GraphWindow.createImageIcon("images/wall.png");
    public RobotProgram program = new RobotProgram();
    private JMenu robotSpeed;
    private JCheckBoxMenuItem xFast;
    private JCheckBoxMenuItem fast;
    private JCheckBoxMenuItem medium;
    private JCheckBoxMenuItem slow;

    public RobotWindow(JApplet parent) {
        super(parent);
        this.setTitle(appletTitle);
        ((Component)this).setSize(700, 700);
        this.logArea = new JTextArea("", 7, 50);
        this.logArea.setEditable(false);
        this.logScroll = new JScrollPane(this.logArea, 22, 30);
        this.algoText.setVisible(true);
        this.algoText.setFont(new Font("arial", 1, 15));
        this.algoText.setText("Controller Log");
        this.bottomPanel.setPreferredSize(new Dimension(this.getWidth(), 100));
        this.bottomPanel.add((Component)this.algoText, "North");
        this.bottomPanel.add((Component)this.logScroll, "Center");
        this.bottomPanel.setVisible(true);
        this.tabandbottom.setBottomComponent(this.bottomPanel);
        this.signalsDialog = new SignalsDialog(this);
        this.scrollPanel.setPreferredSize(new Dimension(525, 450));
        this.validate();
        this.show();
        this.extension = ".txt";
        this.oldmessage = "";
        this.canvas.addRobot(new Point(this.scrollPanel.getHorizontalScrollBar().getValue() + this.scrollPanel.getSize().width / 2, this.scrollPanel.getVerticalScrollBar().getValue() + this.scrollPanel.getSize().height / 2));
        this.resetButtons();
        this.setPromptLabel("Click on the canvas to create a new location");
        this.createButModes[0].setSelected(true);
        this.canvas.setSubmode(3330);
    }

    protected void getCanvas() {
        this.canvas = new RobotGraphCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.canvas.addComponentListener(this);
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
        this.scrollPanel.addComponentListener(this);
    }

    protected GraphCanvas returnCanvas() {
        return this.canvas;
    }

    protected JMenuBar createMenuBar() {
        super.createMenuBar();
        JMenu editmenu = this.createEditMenu();
        this.mBar.add((Component)editmenu, 1);
        JMenu robotMenu = this.createRobotMenu();
        this.mBar.add((Component)robotMenu, 3);
        return this.mBar;
    }

    protected JMenu createRobotMenu() {
        JMenu m = new JMenu("Robot Options");
        this.robotSpeed = new JMenu("Robot Speed");
        this.xFast = new JCheckBoxMenuItem("Very Fast (0 s)", true);
        this.xFast.addActionListener(this);
        this.robotSpeed.add(this.xFast);
        this.fast = new JCheckBoxMenuItem("Fast (0.05 s)", false);
        this.fast.addActionListener(this);
        this.robotSpeed.add(this.fast);
        this.medium = new JCheckBoxMenuItem("Medium (0.1 s)", false);
        this.medium.addActionListener(this);
        this.robotSpeed.add(this.medium);
        this.slow = new JCheckBoxMenuItem("Slow (0.5 s)", false);
        this.slow.addActionListener(this);
        this.robotSpeed.add(this.slow);
        m.add(this.robotSpeed);
        return m;
    }

    protected JMenu createFileMenu() {
        JMenu m = super.createFileMenu();
        m.remove(0);
        return m;
    }

    public JMenu createEditMenu() {
        JMenu m = new JMenu("Edit");
        JMenuItem mItem = new JMenuItem("Undo");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setEnabled(false);
        m.add(mItem);
        m.addSeparator();
        mItem = new JMenuItem("High Layer Controller Code");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(72);
        m.add(mItem);
        mItem = new JMenuItem("Middle Layer Controller Code");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(77);
        m.add(mItem);
        mItem = new JMenuItem("Environment Controller Code");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(69);
        m.add(mItem);
        m.addSeparator();
        mItem = new JMenuItem("World Representation");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(84);
        m.add(mItem);
        mItem = new JMenuItem("XML Representation");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        m.add(mItem);
        m.addSeparator();
        mItem = new JMenuItem("Controller Log Watched Predicates");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        m.add(mItem);
        return m;
    }

    protected JMenu createViewMenu() {
        JMenu m = super.createViewMenu();
        m.remove(5);
        return m;
    }

    protected JMenu createHelpMenu() {
        HelpMenu m = new HelpMenu(this.applet, "robot", this);
        return m;
    }

    protected void setCreateViewButtons(int num, ImageIcon icon, String toolTip) {
        this.createViewModes[num] = new JToggleButton(icon);
        this.createViewModes[num].setActionCommand(toolTip);
        this.createViewModes[num].addActionListener(this);
        this.createViewModes[num].setToolTipText(toolTip);
    }

    protected void setSolveViewButtons(int num, ImageIcon icon, String toolTip) {
        this.solveViewModes[num] = new JToggleButton(icon);
        this.solveViewModes[num].setActionCommand(toolTip);
        this.solveViewModes[num].addActionListener(this);
        this.solveViewModes[num].setToolTipText(toolTip);
    }

    protected void setCreateViewButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip) {
        this.createViewModes[num] = new JToggleButton(buttonName, icon);
        this.createViewModes[num].addActionListener(this);
        this.createViewModes[num].setToolTipText(toolTip);
        this.createViewModes[num].setVerticalTextPosition(3);
        this.createViewModes[num].setHorizontalTextPosition(0);
    }

    protected void setSolveViewButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip) {
        this.solveViewModes[num] = new JToggleButton(buttonName, icon);
        this.solveViewModes[num].addActionListener(this);
        this.solveViewModes[num].setToolTipText(toolTip);
        this.solveViewModes[num].setVerticalTextPosition(3);
        this.solveViewModes[num].setHorizontalTextPosition(0);
    }

    public void createToolBar() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createButModes = new JToggleButton[7];
        this.setCreateButtons(0, robotlocationIcon, "Create Location");
        this.setCreateButtons(1, wallIcon, "Create Wall");
        this.setCreateButtons(2, this.selectIcon, "   Select   ");
        this.setCreateButtons(3, this.deleteIcon, "   Delete   ");
        this.setCreateButtons(4, this.setPropsIcon, "Location Properties");
        this.setCreateButtons(5, this.selectIcon, "blank");
        this.setCreateButtons(6, this.deleteIcon, "blank");
        this.createViewButGroup = new ButtonGroup();
        this.createViewModes = new JToggleButton[3];
        this.setCreateViewButtons(0, viewPlanIcon, "View/Modify Plan");
        this.setCreateViewButtons(1, viewRobotIcon, "View/Modify Robot Properties");
        this.setCreateViewButtons(2, this.createNodeIcon, "fake");
        int i = 0;
        while (i <= 6) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.toolBar.addSeparator();
        i = 0;
        while (i <= 2) {
            this.createViewButGroup.add(this.createViewModes[i]);
            this.toolBar.add(this.createViewModes[i]);
            this.createViewModes[i].setFont(this.toolFont);
            ++i;
        }
        this.createButModes[5].setVisible(false);
        this.createButModes[6].setVisible(false);
        this.createViewModes[2].setVisible(false);
    }

    public void createToolBarWithText() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createButModes = new JToggleButton[7];
        this.setCreateButtonsWithText(0, "Create Location", robotlocationIcon, "Create Location");
        this.setCreateButtonsWithText(1, "Create Wall", wallIcon, "Create Wall");
        this.setCreateButtonsWithText(2, "   Select   ", this.selectIcon, "Select");
        this.setCreateButtonsWithText(3, "   Delete   ", this.deleteIcon, "Delete");
        this.setCreateButtonsWithText(4, "Location Properties", this.setPropsIcon, "Location Properties");
        this.setCreateButtonsWithText(5, "blank", this.selectIcon, "blank");
        this.setCreateButtonsWithText(6, "blank", this.deleteIcon, "blank");
        this.createViewButGroup = new ButtonGroup();
        this.createViewModes = new JToggleButton[3];
        this.setCreateViewButtonsWithText(0, "View/Modify Plan", viewPlanIcon, "View/Modify Plan");
        this.setCreateViewButtonsWithText(1, "View/Modify Robot Properties", viewRobotIcon, "View/Modify Robot Properties");
        this.setCreateViewButtonsWithText(2, "fake", this.createNodeIcon, "fake");
        int i = 0;
        while (i <= 6) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.toolBar.addSeparator();
        i = 0;
        while (i <= 2) {
            this.createViewButGroup.add(this.createViewModes[i]);
            this.toolBar.add(this.createViewModes[i]);
            this.createViewModes[i].setFont(this.toolFont);
            ++i;
        }
        this.createButModes[5].setVisible(false);
        this.createButModes[6].setVisible(false);
        this.createViewModes[2].setVisible(false);
    }

    public void solveToolBar() {
        super.solveToolBar();
        this.setSolveButtons(0, this.stepIcon, "Step Robot");
        this.setSolveButtons(1, this.runIcon, "Run Robot");
        this.setSolveButtons(2, this.stopIcon, "Stop Robot");
        this.setSolveButtons(3, this.resetIcon, "Reset Robot");
        this.setSolveButtons(4, this.robottraceIcon, "Clear Trace");
        this.setSolveButtons(5, this.resetIcon, "fake");
        this.solveViewButGroup = new ButtonGroup();
        this.solveViewModes = new JToggleButton[4];
        this.setSolveViewButtons(0, viewPlanIcon, "View/Modify Plan");
        this.setSolveViewButtons(1, viewRobotIcon, "View/Modify Robot Properties");
        this.setSolveViewButtons(2, this.createNodeIcon, "fake");
        this.setSolveViewButtonsWithText(3, "Trace & Debug", this.bugIcon, "Trace & Debug");
        int i = 0;
        while (i <= 5) {
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.solveButModes[5].setVisible(false);
        this.toolBar.addSeparator();
        i = 0;
        while (i <= 2) {
            this.solveViewButGroup.add(this.solveViewModes[i]);
            this.toolBar.add(this.solveViewModes[i]);
            this.solveViewModes[i].setFont(this.toolFont);
            ++i;
        }
        this.solveViewModes[2].setVisible(false);
        this.stepRobotButton = this.solveButModes[0];
        this.runRobotButton = this.solveButModes[1];
        this.stopRobotButton = this.solveButModes[2];
        this.resetRobotButton = this.solveButModes[3];
        this.clearTraceButton = this.solveButModes[4];
    }

    public void solveToolBarWithText() {
        super.solveToolBar();
        this.setSolveButtonsWithText(0, "Step Robot", this.stepIcon, "Step Robot");
        this.setSolveButtonsWithText(1, "Run Robot", this.runIcon, "Run Robot");
        this.setSolveButtonsWithText(2, "Stop Robot", this.stopIcon, "Stop Robot");
        this.setSolveButtonsWithText(3, "Reset Robot", this.resetIcon, "Reset Robot");
        this.setSolveButtonsWithText(4, "Clear Trace", this.robottraceIcon, "Clear Trace");
        this.setSolveButtonsWithText(5, "Fake", this.resetIcon, "Fake");
        this.solveViewButGroup = new ButtonGroup();
        this.solveViewModes = new JToggleButton[4];
        this.setSolveViewButtonsWithText(0, "View/Modify Plan", viewPlanIcon, "View/Modify Plan");
        this.setSolveViewButtonsWithText(1, "Robot Properties", viewRobotIcon, "Robot Properties");
        this.setSolveViewButtonsWithText(2, "fake", this.createNodeIcon, "fake");
        this.setSolveViewButtonsWithText(3, "Trace & Debug", this.bugIcon, "Trace & Debug");
        int i = 0;
        while (i <= 5) {
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.solveButModes[5].setVisible(false);
        this.toolBar.addSeparator();
        i = 0;
        while (i <= 3) {
            this.solveViewButGroup.add(this.solveViewModes[i]);
            this.toolBar.add(this.solveViewModes[i]);
            this.solveViewModes[i].setFont(this.toolFont);
            ++i;
        }
        this.solveViewModes[2].setVisible(false);
        this.stepRobotButton = this.solveButModes[0];
        this.runRobotButton = this.solveButModes[1];
        this.stopRobotButton = this.solveButModes[2];
        this.resetRobotButton = this.solveButModes[3];
        this.clearTraceButton = this.solveButModes[4];
    }

    public static void centerWindow(JFrame c) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = c.getSize();
        int widthOffset = windowSize.width / 2;
        int heightOffset = windowSize.height / 2;
        ((Component)c).setLocation((int)centerPosition.x - widthOffset, (int)centerPosition.y - heightOffset);
    }

    protected JMenuItem getUndoButton() {
        return this.mBar.getMenu(1).getItem(0);
    }

    public void addPromptLabel(String str) {
        String old = this.messageCanvas.getText();
        if (old.indexOf(10) != -1) {
            old = old.substring(0, old.indexOf(10));
        }
        this.messageCanvas.setText(String.valueOf(old) + "\n" + str);
    }

    public void load(File file) {
        try {
            boolean xml;
            String ext = this.filename.substring(this.filename.lastIndexOf(".") + 1);
            boolean bl = xml = !ext.equals("txt");
            if (this.applet != null) {
                URL url = new URL(this.applet.getCodeBase() + file.getPath());
                InputStream iStream = url.openStream();
                this.load(new BufferedReader(new InputStreamReader(iStream)));
            } else {
                this.load(new BufferedReader(new FileReader(file.getPath())));
            }
        }
        catch (Exception e) {
            this.filename = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(String dir, String filename) {
        try {
            this.filename = filename;
            if (this.applet != null) {
                URL url = new URL(this.applet.getCodeBase() + dir + filename);
                InputStream iStream = url.openStream();
                this.load(new BufferedReader(new InputStreamReader(iStream)));
            } else {
                this.load(new BufferedReader(new FileReader(String.valueOf(dir) + filename)));
            }
        }
        catch (Exception e) {
            filename = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(BufferedReader in) {
        try {
            String all = "";
            String errMsg = "";
            String line = in.readLine();
            while (line != null) {
                all = String.valueOf(all) + line + "\n";
                line = in.readLine();
            }
            in.close();
            boolean success = this.filename.endsWith(".xml") ? this.canvas.updateXMLtextRep(all) : this.canvas.updateGraphFromText(all);
            if (success) {
                this.setTitle(String.valueOf(appletTitle) + " --- " + this.filename);
            }
        }
        catch (Exception e) {
            this.showMessage("Error", e.toString());
        }
    }

    public void save(File file) {
        if (!file.getName().endsWith(".xml")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintWriter out = new PrintWriter(fos);
            out.println(((RobotGraph)this.canvas.graph).generateXMLTextRep());
            out.close();
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.filename);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public void save(String dir, String filename) {
        if (!filename.endsWith(".xml")) {
            filename = String.valueOf(filename) + ".xml";
        }
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(dir) + filename);
            PrintWriter out = new PrintWriter(fos);
            out.println(((RobotGraph)this.canvas.graph).generateXMLTextRep());
            out.close();
            this.setTitle(String.valueOf(appletTitle) + " --- " + filename);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public void doRunRobot() {
        if (this.canvas.checkRunReady()) {
            this.canvas.runAuto2(this.applet != null, false);
            this.setRunningButtons();
        }
    }

    public void doStepRobot() {
        if (this.canvas.checkRunReady()) {
            this.canvas.runAuto2(this.applet != null, true);
            this.setRunningButtons();
        }
    }

    public void doStopRobot() {
        this.canvas.stopAuto();
        this.setStoppedButtons();
    }

    public void doResetRobot() {
        this.setPromptLabel("Robot Reset.\nClick on a location to view its properties.");
        this.resetButtons();
        this.canvas.resetAuto();
        this.canvas.clearTrace();
    }

    public void addLog(String str) {
        this.logArea.append(str);
    }

    public void clearLog() {
        this.logArea.setText("");
    }

    public void resetButtons() {
        if (this.solveButModes != null) {
            this.runRobotButton.setEnabled(true);
            this.stepRobotButton.setEnabled(true);
            this.stopRobotButton.setEnabled(false);
            this.resetRobotButton.setEnabled(false);
            this.clearTraceButton.setEnabled(false);
            this.robotSpeed.setEnabled(true);
            this.clearLog();
            this.canvas.setCrashed(false);
            this.canvas.setResetState();
        }
    }

    public void setRunningButtons() {
        if (this.solveButModes != null) {
            this.runRobotButton.setEnabled(false);
            this.stepRobotButton.setEnabled(false);
            this.stopRobotButton.setEnabled(true);
            this.resetRobotButton.setEnabled(false);
            this.clearTraceButton.setEnabled(true);
            this.solveButModes[5].setSelected(true);
            this.robotSpeed.setEnabled(false);
            this.canvas.setRunningState();
        }
    }

    public void setStoppedButtons() {
        if (this.solveButModes != null) {
            this.runRobotButton.setEnabled(true);
            this.stepRobotButton.setEnabled(true);
            this.stopRobotButton.setEnabled(false);
            this.resetRobotButton.setEnabled(true);
            this.solveButModes[5].setSelected(true);
            this.robotSpeed.setEnabled(true);
            this.canvas.setStoppedState();
        }
    }

    public void setSolve() {
        super.setSolve();
        this.setPromptLabel("Click on a location to view its properties.");
        if (this.solveButModes != null) {
            this.runRobotButton.setEnabled(this.canvas.runEnabled);
            this.stepRobotButton.setEnabled(this.canvas.runEnabled);
            this.stopRobotButton.setEnabled(this.canvas.stopEnabled);
            this.resetRobotButton.setEnabled(this.canvas.resetEnabled);
            this.clearTraceButton.setEnabled(this.canvas.clearTraceEnabled);
        }
        this.getUndoButton().setEnabled(false);
    }

    public JApplet getApplet() {
        return this.applet;
    }

    protected String getAboutText() {
        return aboutText;
    }

    public String getMessage() {
        return this.oldmessage;
    }

    public void showMessage(String title, String msg) {
        this.canvas.showMessage(title, msg);
    }

    protected void createnewgraph() {
        this.canvas.newGraph();
        this.resetButtons();
        this.tabbedPane.setSelectedIndex(0);
        this.newTab("Create");
        this.returnCanvas().repaint();
        this.getUndoButton().setEnabled(false);
    }

    protected void opengraph() {
        this.setCursor(GraphConsts.WAIT_CURSOR);
        JFileChooser load = new JFileChooser();
        load.setFileSelectionMode(2);
        load.setLocation(0, 0);
        int returnval = load.showOpenDialog(this);
        if (returnval == 0) {
            File file = load.getSelectedFile();
            this.filename = file.getName();
            this.load(file);
        }
        this.setCursor(GraphConsts.DEFAULT_CURSOR);
        this.getUndoButton().setEnabled(false);
    }

    protected void openlocation() {
        OpenLocationDialog old = new OpenLocationDialog(this);
        String urlString = old.url;
        if (urlString != null) {
            this.filename = urlString.substring(urlString.lastIndexOf("/") + 1);
            try {
                URL url = new URL(urlString);
                InputStream iStream = url.openStream();
                this.load(new BufferedReader(new InputStreamReader(iStream)));
            }
            catch (Exception exc) {
                this.showMessage("Error", exc.toString());
            }
        }
        this.getUndoButton().setEnabled(false);
    }

    protected void loadsamplegraph() {
        ProblemDialog pDialog = new ProblemDialog(this);
        this.getUndoButton().setEnabled(false);
    }

    protected void savegraph() {
        String parentfile = null;
        String filename = this.getTitle();
        this.setCursor(GraphConsts.WAIT_CURSOR);
        JFileChooser save = new JFileChooser();
        save.setFileSelectionMode(2);
        save.setLocation(0, 0);
        int returnval = save.showSaveDialog(this);
        if (returnval == 0) {
            File file = save.getSelectedFile();
            parentfile = file.getParentFile().getName();
            filename = file.getName();
            File newfile = save.getCurrentDirectory();
            this.save(file);
        }
        this.setCursor(GraphConsts.DEFAULT_CURSOR);
        if (filename == null) {
            return;
        }
    }

    protected void restoreProperties() {
        super.restoreProperties();
        if (this.returnCanvas().getMode() == 2220) {
            this.createButModes[0].setSelected(true);
            this.returnCanvas().setSubmode(3330);
            this.setPromptLabel("Click on the canvas to create a new location");
        }
    }

    public void changeLogFont(int size) {
        Font font = new Font("SansSerif", 0, size);
        this.logArea.setFont(font);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Very Fast (0 s)")) {
            this.canvas.setAutoRate(0);
            this.xFast.setState(true);
            this.fast.setState(false);
            this.medium.setState(false);
            this.slow.setState(false);
        } else if (arg.equals("Fast (0.05 s)")) {
            this.canvas.setAutoRate(50);
            this.xFast.setState(false);
            this.fast.setState(true);
            this.medium.setState(false);
            this.slow.setState(false);
        } else if (arg.equals("Medium (0.1 s)")) {
            this.canvas.setAutoRate(100);
            this.xFast.setState(false);
            this.fast.setState(false);
            this.medium.setState(true);
            this.slow.setState(false);
        } else if (arg.equals("Slow (0.5 s)")) {
            this.canvas.setAutoRate(500);
            this.xFast.setState(false);
            this.fast.setState(false);
            this.medium.setState(false);
            this.slow.setState(true);
        } else if (arg.equals("Undo")) {
            this.canvas.updateXMLtextRep(this.oldTextRep);
            this.getUndoButton().setEnabled(false);
        } else if (arg.equals("Extra Large (30 pt)")) {
            this.changeLogFont(30);
        } else if (arg.equals("Large (20 pt)")) {
            this.changeLogFont(20);
        } else if (arg.equals("Medium (12 pt)")) {
            this.changeLogFont(12);
        } else if (arg.equals("Small (9 pt)")) {
            this.changeLogFont(9);
        } else if (!arg.equals("others...")) {
            if (arg.equals("Print")) {
                this.returnCanvas().print(this.getTitle().substring(this.getTitle().indexOf("--- ") + 4));
                return;
            }
            if (arg.equals("High Layer Controller Code")) {
                String os = System.getProperty("os.name");
                if (os.startsWith("Windows")) {
                    HighControllerDialogWindows hcdwindows = new HighControllerDialogWindows(this.canvas);
                } else {
                    HighControllerDialog hcd = new HighControllerDialog(this.canvas);
                }
            } else if (arg.equals("Middle Layer Controller Code")) {
                String os = System.getProperty("os.name");
                if (os.startsWith("Windows")) {
                    MiddleControllerDialogWindows mcdwindows = new MiddleControllerDialogWindows(this.canvas);
                } else {
                    MiddleControllerDialog mcd = new MiddleControllerDialog(this.canvas);
                }
            } else if (arg.equals("Environment Controller Code")) {
                String os = System.getProperty("os.name");
                if (os.startsWith("Windows")) {
                    EnvironmentDialogWindows edwindows = new EnvironmentDialogWindows(this.canvas);
                } else {
                    EnvironmentDialog ed = new EnvironmentDialog(this.canvas);
                }
            } else if (arg.equals("World Representation")) {
                this.canvas.textRep();
            } else if (arg.equals("XML Representation")) {
                this.canvas.XMLtextRep();
            } else if (arg.equals("Controller Log Watched Predicates")) {
                this.signalsDialog.show();
            } else {
                if (arg.equals("View/Modify Plan") || this.createViewModes != null && e.getSource() == this.createViewModes[0] || this.solveViewModes != null && e.getSource() == this.solveViewModes[0]) {
                    this.oldmessage = this.getExactPromptLabel();
                    this.setPromptLabel("");
                    PlannerFrame plannerFrame = new PlannerFrame(this.canvas);
                    return;
                }
                if (arg.equals("Robot Properties") || this.createViewModes != null && e.getSource() == this.createViewModes[1] || this.solveViewModes != null && e.getSource() == this.solveViewModes[1]) {
                    this.oldmessage = this.getExactPromptLabel();
                    this.setPromptLabel("");
                    this.canvas.setAutoProperties();
                    return;
                }
            }
        }
        if (this.returnCanvas().getMode() == 2220) {
            if (arg.equals("Create Location") || e.getSource() == this.createButModes[0]) {
                this.returnCanvas().setSubmode(3330);
                this.setPromptLabel("Click on the canvas to create a new location");
                this.canvas.tempString = this.getExactPromptLabel();
                return;
            }
            if (arg.equals("Create Wall") || e.getSource() == this.createButModes[1]) {
                this.returnCanvas().setSubmode(3331);
                this.setPromptLabel("Click on the canvas to begin creating a new wall");
                this.canvas.tempString = this.getExactPromptLabel();
                return;
            }
            if (arg.equals("   Select   ") || e.getSource() == this.createButModes[2]) {
                this.returnCanvas().setSubmode(3332);
                this.setPromptLabel("Click on the location/wall/robot and drag it to move");
                this.canvas.tempString = this.getExactPromptLabel();
                return;
            }
            if (arg.equals("Location Properties") || e.getSource() == this.createButModes[4]) {
                this.returnCanvas().setSubmode(3334);
                this.setPromptLabel("Click on a location to view its properties.");
                this.canvas.tempString = this.getExactPromptLabel();
                return;
            }
        }
        if (this.returnCanvas().getMode() == 2221) {
            if (arg.equals("Run Robot") || e.getSource() == this.runRobotButton) {
                this.doRunRobot();
            } else if (arg.equals("Step Robot") || e.getSource() == this.stepRobotButton) {
                this.doStepRobot();
            } else if (arg.equals("Stop Robot") || e.getSource() == this.stopRobotButton) {
                this.doStopRobot();
            } else if (arg.equals("Clear Trace") || e.getSource() == this.clearTraceButton) {
                ((RobotGraphCanvas)this.returnCanvas()).clearTrace();
                this.solveButModes[5].setSelected(true);
            } else if (arg.equals("Reset Robot") || e.getSource() == this.resetRobotButton) {
                this.doResetRobot();
                this.solveButModes[5].setSelected(true);
            } else if (arg.equals("Trace & Debug")) {
                if (this.canvas.myAutoRobot == null) {
                    this.setPromptLabel("Robot has not been run.");
                } else {
                    this.canvas.myAutoRobot.p.showTrace();
                }
                this.solveViewModes[2].setSelected(true);
            }
        }
        super.actionPerformed(e);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

