/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import CIspace.robot.Environment;
import CIspace.robot.RobotGraph;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class RobotRobot
extends Node {
    private Point robotBottom;
    private Point robotTop;
    protected Environment env;
    public double direction;

    public RobotRobot(RobotGraph graph, Point p) {
        super(graph);
        this.color = Color.blue;
        this.label[0] = "";
        this.pos = p;
        this.shape = 1119;
        this.updateSize();
        this.type = 7778;
        this.direction = 0.0;
        this.env = graph.getEnvironment();
    }

    public RobotRobot(Graph graph, String label, Point pos, Color color, int shape) {
        super(graph);
        this.label[0] = label;
        this.pos = pos;
        this.isSelected = false;
        this.isBold = false;
        this.color = color;
        this.shape = shape;
        this.edgesIn = new Vector(10, 10);
        this.edgesOut = new Vector(10, 10);
        this.type = 7778;
        this.direction = 0.0;
        this.updateSize();
        this.env = ((RobotGraph)graph).getEnvironment();
        this.robotTop = new Point();
        this.robotBottom = new Point();
    }

    public Point getRobotTop() {
        return this.robotTop;
    }

    public Point getRobotBottom() {
        return this.robotBottom;
    }

    public void draw(Graphics offscreen, boolean moving) {
        Point robotPos = this.getCartesianPos();
        double directionRadian = this.direction * Math.PI / 180.0;
        double whisker = this.env.addAngle(this.direction, -30.0) * Math.PI / 180.0;
        offscreen.setColor(this.color);
        double thi = this.env.addAngle(this.env.getCompass(), 90.0) * Math.PI / 180.0;
        double a0 = (double)robotPos.x + 10.0 * Math.cos(directionRadian);
        double b0 = (double)robotPos.y + 10.0 * Math.sin(directionRadian);
        double a1 = (double)robotPos.x - 10.0 * Math.cos(directionRadian);
        double b1 = (double)robotPos.y - 10.0 * Math.sin(directionRadian);
        double a2 = a1 + 5.0 * Math.cos(thi);
        double b2 = b1 + 5.0 * Math.sin(thi);
        double a3 = a1 - 5.0 * Math.cos(thi);
        double b3 = b1 - 5.0 * Math.sin(thi);
        double a4 = (double)robotPos.x + Environment.whiskerValidDistance * Math.cos(whisker);
        double b4 = (double)robotPos.y + Environment.whiskerValidDistance * Math.sin(whisker);
        Point intersectionPoint = this.env.getIntersectionPoint();
        if (intersectionPoint != null) {
            a4 = intersectionPoint.x;
            b4 = intersectionPoint.y;
        }
        robotPos.y = -robotPos.y;
        b0 = -b0;
        b1 = -b1;
        b2 = -b2;
        b3 = -b3;
        b4 = -b4;
        Point p0 = new Point((float)a0, (float)b0);
        Point p1 = new Point((float)a1, (float)b1);
        Point p2 = new Point((float)a2, (float)b2);
        Point p3 = new Point((float)a3, (float)b3);
        Point p4 = new Point((float)a4, (float)b4);
        this.robotTop = p0;
        this.robotBottom = p1;
        int[] xArray = new int[]{(int)p0.x, (int)p2.x, (int)p3.x};
        int[] yArray = new int[]{(int)p0.y, (int)p2.y, (int)p3.y};
        offscreen.fillPolygon(xArray, yArray, 3);
        float lineWidth = this.graph.getLineWidth() + (float)this.xw;
        float dx = p4.x - robotPos.x;
        float dy = p4.y - robotPos.y;
        Point point1 = new Point(robotPos);
        Point point2 = new Point(point1);
        float length = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
        point1.translate(-lineWidth / length * dy, lineWidth / length * dx);
        point2.translate(lineWidth / length * dy, -lineWidth / length * dx);
        Point point3 = new Point(p4);
        Point point4 = new Point(point3);
        point3.translate(lineWidth / length * dy, -lineWidth / length * dx);
        point4.translate(-lineWidth / length * dy, lineWidth / length * dx);
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = (int)point1.x;
        x[1] = (int)point2.x;
        x[2] = (int)point3.x;
        x[3] = (int)point4.x;
        y[0] = (int)point1.y;
        y[1] = (int)point2.y;
        y[2] = (int)point3.y;
        y[3] = (int)point4.y;
        offscreen.fillPolygon(x, y, 4);
        if (this.isSelected) {
            offscreen.setColor(Color.magenta);
            offscreen.fillRect((int)robotPos.x - 2, (int)robotPos.y - 7, 4, 14);
            offscreen.fillRect((int)robotPos.x - 7, (int)robotPos.y - 2, 14, 4);
        }
    }

    public Point getCartesianPos() {
        return new Point(this.pos.x, -this.pos.y);
    }

    public void setRobotPosition(Point p) {
        this.pos = new Point(p.x, p.y);
    }

    public void setRobotDirection(double dir) {
        this.direction = dir;
    }
}

