/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.robot.RobotWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProblemDialog
extends JDialog
implements ActionListener,
WindowListener {
    private JButton cancel_button;
    private JButton load_button;
    private RobotWindow window;
    private Vector problemList;
    private JComboBox sampleChoice;

    public ProblemDialog(RobotWindow w) {
        super(w, "Load Sample Problems", true);
        this.window = w;
        JLabel label = new JLabel("Select an Example File:");
        JPanel top = new JPanel();
        top.add("Center", label);
        this.sampleChoice = new JComboBox();
        this.problemList = new Vector(5, 2);
        if (!this.getProblemList()) {
            return;
        }
        int i = 0;
        while (i < this.problemList.size()) {
            this.sampleChoice.addItem(((String[])this.problemList.elementAt(i))[0]);
            ++i;
        }
        this.sampleChoice.setSelectedIndex(0);
        JPanel middle = new JPanel();
        middle.add("Center", this.sampleChoice);
        JPanel bottom = new JPanel();
        this.load_button = new JButton("Load");
        this.load_button.addActionListener(this);
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        bottom.add(this.load_button);
        bottom.add(this.cancel_button);
        this.getContentPane().add("North", top);
        this.getContentPane().add("Center", middle);
        this.getContentPane().add("South", bottom);
        this.pack();
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public boolean getProblemList() {
        try {
            String text;
            BufferedReader in;
            if (this.window.applet != null) {
                URL url = new URL(this.window.applet.getCodeBase() + "SampleProblems.txt");
                InputStream iStream = url.openStream();
                in = new BufferedReader(new InputStreamReader(iStream));
            } else {
                in = new BufferedReader(new FileReader("SampleProblems.txt"));
            }
            while ((text = in.readLine()) != null) {
                if (text.trim().length() <= 0) continue;
                int p1 = text.indexOf(",");
                String[] tempString = new String[]{new String(text.substring(0, p1)), new String(text.substring(p1 + 2, text.trim().length()))};
                this.problemList.addElement(tempString);
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            this.window.showMessage("Error", "Need SampleProblems.txt in the CIspace/RobotApplet/ directory.");
            return false;
        }
    }

    public void loadProblem() {
        String directory = new String("");
        int index = this.sampleChoice.getSelectedIndex();
        if (index >= 0) {
            this.window.load("saves/", ((String[])this.problemList.elementAt(index))[1]);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("Cancel")) {
            this.loadProblem();
            this.window.returnCanvas().autoscale();
            this.window.returnCanvas().repaint();
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

