/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Point;
import CIspace.robot.Environment;
import CIspace.robot.MiddleLayerController;
import CIspace.robot.RobotNode;
import java.util.Vector;

public class HighLayerController {
    protected Vector toDoList = new Vector();
    protected MiddleLayerController middle;
    protected Environment env;

    public HighLayerController(MiddleLayerController m, Environment e) {
        this.middle = m;
        this.env = e;
    }

    public void setMiddleLayerController(MiddleLayerController m) {
        this.middle = m;
    }

    public void setEnvironment(Environment e) {
        this.env = e;
    }

    public boolean assign(String location) {
        boolean success = false;
        Point coord = this.env.getCoordByLocation(location);
        if (coord != null) {
            this.toDoList.addElement(coord);
            success = true;
        }
        return success;
    }

    public boolean assign(int index) {
        boolean success = false;
        RobotNode goal = this.env.getNodeByIndex(index);
        if (goal != null) {
            this.toDoList.addElement(goal);
            success = true;
        }
        return success;
    }

    public RobotNode getNextGoal() {
        if (this.toDoList.size() > 0) {
            return (RobotNode)this.toDoList.firstElement();
        }
        return null;
    }

    public void checkArrived() {
        if (this.middle.arrived()) {
            System.out.println("Arrived at local goal");
            this.toDoList.removeElementAt(0);
        }
    }

    public boolean action(boolean checkGoalDirection) {
        boolean successful = false;
        RobotNode nextGoal = this.getNextGoal();
        if (nextGoal != null) {
            this.middle.setGoalPos(nextGoal.getCartesianPos());
            successful = this.middle.action(checkGoalDirection);
            this.checkArrived();
        } else {
            System.out.println("Mission completed.");
        }
        return successful;
    }

    public String getModifiableDefaultCode() {
        String defaultCode = new String("% High Layer Controller\n\n");
        defaultCode = String.valueOf(defaultCode) + "% assign(goal_pos,Coords,T) is true if we can assign the attribute goal_pos\n% with value Coords at time T, ie. the last goal is reached at time T.\nassign(goal_pos,Coords,T) <-\n\t\tarrived(T) &\n\t\twas(to_do,[goto(Loc)|_],_,T) &\n\t\tat(Loc,Coords).\n\n% assign(to_do,R,T) is true if we can assign the attribute to_do\n% with value R at time T, ie. the last goal is reached at time T.\nassign(to_do,R,T) <-\n\t\tarrived(T) &\n\t\twas(to_do,[_|R],_,T).\n\n% arrived(1.0) is a fact.\narrived(1.0).\n";
        return defaultCode;
    }

    public String getCommentedDefaultCode() {
        String defaultCode = "";
        return defaultCode;
    }

    public String getDefaultCode() {
        String defaultCode = new String("% High Layer Controller\n\n");
        defaultCode = String.valueOf(defaultCode) + "% assign(goal_pos,Coords,T) is true if we can assign the attribute goal_pos\n% with value Coords at time T, ie. the last goal is reached at time T.\nassign(goal_pos,Coords,T) <-\n\t\tarrived(T) &\n\t\twas(to_do,[goto(Loc)|_],_,T) &\n\t\tat(Loc,Coords).\n\n% assign(to_do,R,T) is true if we can assign the attribute to_do\n% with value R at time T, ie. the last goal is reached at time T.\nassign(to_do,R,T) <-\n\t\tarrived(T) &\n\t\twas(to_do,[_|R],_,T).\n\n% arrived(1.0) is a fact.\narrived(1.0).\n";
        return defaultCode;
    }
}

