/*
 * Decompiled with CFR 0.152.
 */
package CIspace.prolog;

import CIspace.prolog.Functor;
import CIspace.prolog.Goal;
import CIspace.prolog.Predicate;
import CIspace.prolog.Program;
import CIspace.prolog.Substitution;
import java.text.DecimalFormat;
import java.util.Vector;

public class Term {
    public static final int C_VARIABLE = 0;
    public static final int C_CONSTANT = 1;
    public static final int C_COMPOUND = 2;
    public int type;
    protected Term[] terms;
    public String name;
    public String realName;
    public boolean isList = false;
    protected Functor func;
    public Term unifiedWith;

    public Term(String str) {
        this.name = "";
        this.realName = "";
        int bracket = str.indexOf("(");
        int square = str.indexOf("[");
        Program p = new Program();
        if (bracket == -1 && square == -1) {
            if (str.indexOf("=") != -1 || str.indexOf("<") != -1 || str.indexOf(">") != -1) {
                Goal g = p.parseBuiltInGoal(str);
                this.type = 2;
                this.func = new Functor(g.pred.type);
                this.terms = g.terms;
            } else {
                this.name = str;
                this.realName = str;
                String firstLetter = str.substring(0, 1);
                this.type = firstLetter.toLowerCase().equals(firstLetter) && !str.startsWith("_") ? 1 : 0;
            }
        } else if (square != -1 && (square < bracket || bracket == -1)) {
            square = str.indexOf("[", square + 1);
            int middle = str.indexOf("|");
            int nextComma = str.indexOf(",");
            int next = -1;
            next = !(bracket == -1 || bracket >= square && square != -1 || bracket >= nextComma && nextComma != -1) ? p.findNextRight(bracket, str) + 1 : (!(square == -1 || square >= bracket && bracket != -1 || square >= nextComma && nextComma != -1) ? p.findNextRightSquare(square, str) + 1 : (nextComma != -1 ? nextComma : str.length()));
            if (next <= 0) {
                this.name = "";
                this.realName = "";
                return;
            }
            if (middle == -1 && str.indexOf(",", next) == -1 && nextComma < next) {
                if (str.substring(1, str.length() - 1).trim().equals("")) {
                    this.name = "[]";
                    this.realName = "[]";
                    this.type = 1;
                    this.isList = true;
                } else {
                    Term t = this.makeTerm(str.substring(1, str.lastIndexOf("]")).trim());
                    this.type = 2;
                    this.func = new Functor(772);
                    this.terms = this.makeTerms(2);
                    this.terms[0] = t;
                    this.terms[1] = this.makeTerm("[]");
                    this.isList = true;
                }
            } else if (middle != -1 && nextComma < next && str.indexOf(",", next) == -1) {
                this.type = 2;
                this.func = new Functor(772);
                this.isList = true;
                this.terms = this.makeTerms(2);
                this.terms[0] = this.makeTerm(str.substring(1, middle).trim());
                Term carCdr = this.makeTerm(str.substring(middle + 1, str.lastIndexOf("]")).trim());
                if (carCdr.type != 0) {
                    Term cdrCdr = this.makeTerm("[]");
                    Term[] tempTerms = this.makeTerms(2);
                    tempTerms[0] = carCdr;
                    tempTerms[1] = cdrCdr;
                    this.terms[1] = this.makeTerm(this.func, tempTerms);
                } else {
                    this.terms[1] = carCdr;
                }
                this.terms[1].isList = true;
            } else {
                int j = next;
                this.type = 2;
                this.func = new Functor(772);
                this.isList = true;
                this.terms = this.makeTerms(2);
                this.terms[0] = this.makeTerm(str.substring(1, j).trim());
                String tempString = str.substring(j + 1).trim();
                this.terms[1] = this.makeTerm("[" + tempString);
            }
        } else {
            int next;
            int i = str.indexOf("(");
            String fname = str.substring(0, i).trim();
            int compound = str.indexOf("(", i + 1);
            int compound2 = str.indexOf("[", i + 1);
            int j = str.indexOf(",");
            int end = str.length() - 1;
            if (compound > -1 && compound < j && (compound2 == -1 || compound < compound)) {
                next = p.findNextRight(compound, str);
                if (next == -1) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                j = next + 1;
            } else if (compound2 > -1 && compound2 < j) {
                next = p.findNextRightSquare(compound2, str);
                if (next == -1) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                j = next + 1;
            }
            Vector<Term> newTerms = new Vector<Term>();
            ++i;
            while (j > 0) {
                String nextTerm = str.substring(i, j).trim();
                if (!p.matchBrackets(nextTerm)) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                i = j + 1;
                newTerms.addElement(this.makeTerm(nextTerm));
                compound = str.indexOf("(", j);
                compound2 = str.indexOf("[", j);
                int nextComma = str.indexOf(",", i);
                j = compound != -1 && compound < nextComma && (compound2 == -1 || compound < compound2) ? p.findNextRight(compound, str) + 1 : (compound2 > -1 && compound2 < nextComma ? p.findNextRightSquare(compound2, str) + 1 : str.indexOf(",", i));
            }
            if (i < end) {
                newTerms.addElement(this.makeTerm(str.substring(i, end).trim()));
            }
            this.terms = this.makeTerms(newTerms.size());
            int ind = 0;
            while (ind < newTerms.size()) {
                this.terms[ind] = (Term)newTerms.elementAt(ind);
                ++ind;
            }
            this.func = new Functor(fname, this.terms.length);
            this.type = 2;
        }
    }

    public Term(Functor f, Term[] newTerms) {
        this.name = "";
        this.realName = "";
        this.func = f;
        this.terms = newTerms;
        this.type = 2;
        if (f.type == 772) {
            this.isList = true;
        }
    }

    public Term(Term t) {
        this.type = t.type;
        if (this.type != 2) {
            this.name = t.name;
            this.realName = t.name;
        } else {
            this.name = "";
            this.realName = "";
            this.func = t.func;
            this.terms = this.makeTerms(t.terms.length);
            int i = 0;
            while (i < t.terms.length) {
                this.terms[i] = this.makeTerm(t.terms[i]);
                ++i;
            }
        }
        this.isList = t.isList;
    }

    protected Predicate makePredicate(String name, int arity) {
        return new Predicate(name, arity);
    }

    protected Predicate makePredicate() {
        return new Predicate();
    }

    protected Term makeTerm(String str) {
        return new Term(str);
    }

    protected Term makeTerm(Term t) {
        return new Term(t);
    }

    protected Term makeTerm(Functor f, Term[] terms) {
        return new Term(f, terms);
    }

    protected Term[] makeTerms(int size) {
        return new Term[size];
    }

    public Goal termToGoal() {
        if (this.type != 2) {
            return null;
        }
        if (this.func.builtIn()) {
            Predicate tempp = this.makePredicate();
            Predicate p = tempp.getPred(this.func.type);
            Goal g = new Goal(p, this.copyTerms());
            return g;
        }
        Predicate p = new Predicate(this.func.name, this.func.arity);
        Goal g = new Goal(p, this.cloneTerms());
        return g;
    }

    public String getName() {
        return this.toString();
    }

    public String getRealName() {
        return this.realName;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public Vector getVariables() {
        if (this.type == 2) {
            Vector vars = new Vector(this.terms.length);
            Program p = new Program();
            int i = 0;
            while (i < this.terms.length) {
                p.append(vars, this.terms[i].getVariables());
                ++i;
            }
            return vars;
        }
        Vector<Term> vars = new Vector<Term>(1);
        vars.addElement(this);
        return vars;
    }

    private Term[] copyTerms() {
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.makeTerm(this.terms[i]);
            ++i;
        }
        return newTerms;
    }

    private Term[] cloneTerms() {
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i];
            ++i;
        }
        return newTerms;
    }

    public int putVariables(Vector v, int index) {
        if (this.type != 2) {
            return index;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i].type != 2) {
                this.terms[i] = (Term)v.elementAt(index);
                ++index;
            } else {
                index = this.terms[i].putVariables(v, index);
            }
            ++i;
        }
        return index;
    }

    public void clearUnified() {
        this.unifiedWith = null;
        if (this.type == 2) {
            int i = 0;
            while (i < this.terms.length) {
                this.terms[i].clearUnified();
                ++i;
            }
        }
    }

    public Term[] getTerms() {
        if (this.terms != null) {
            return this.terms;
        }
        return null;
    }

    public Term lastUnified() {
        if (this.unifiedWith == null) {
            return this;
        }
        Term t = this.unifiedWith.lastUnified();
        if (t.type == 2 && !t.containsVariable(this)) {
            return t.fixTerms();
        }
        return t;
    }

    public Term fixTerms() {
        if (this.type != 2) {
            return this.makeTerm(this.lastUnified());
        }
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].lastUnified();
            ++i;
        }
        Term t = this.makeTerm(this.func, newTerms);
        t.isList = this.isList;
        return t;
    }

    public Term fixTerms2() {
        if (this.type != 2) {
            if (this.unifiedWith == null) {
                return this;
            }
            if (this.unifiedWith.containsVariable(this)) {
                return this.unifiedWith;
            }
            return this.unifiedWith.fixTerms2();
        }
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].containsVariable(this) ? this.terms[i] : this.terms[i].fixTerms2();
            ++i;
        }
        Term t = this.makeTerm(this.func, newTerms);
        t.isList = this.isList;
        return t;
    }

    protected boolean containsVariable(Term t) {
        if (this.type != 2) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i] == t || this.terms[i].containsVariable(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Term unify(Term t, boolean occursCheck) {
        block16: {
            if (t.name.equals("_")) {
                return this;
            }
            if (this.name.equals("_")) {
                return t;
            }
            if (!(t.type != 0 || occursCheck && this.containsVariable(t))) {
                if (this.type == 1 && !this.isList && t.isList) {
                    return null;
                }
                t.unifiedWith = this;
                if (this.unifiedWith == t) {
                    this.unifiedWith = null;
                }
                return this;
            }
            if (!(this.type != 0 || occursCheck && t.containsVariable(this))) {
                if (t.type == 1 && !t.isList && this.isList) {
                    return null;
                }
                this.unifiedWith = t;
                if (t.unifiedWith == this) {
                    t.unifiedWith = null;
                }
                return t;
            }
            if (this.type == 1 && t.type == 1) {
                if (t.name.equals(this.name)) {
                    return this;
                }
                try {
                    double num1 = Double.parseDouble(this.name);
                    double num2 = Double.parseDouble(t.name);
                    if (num1 == num2) {
                        return this;
                    }
                    break block16;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.type == 2 && t.type == 2 && t.func.name.equals(this.func.name) && t.func.arity == this.func.arity && t.isList == this.isList) {
                Term[] unified = this.makeTerms(this.terms.length);
                int i = 0;
                while (i < this.terms.length) {
                    Term newTerm = this.terms[i].lastUnified().unify(t.getTerms()[i].lastUnified(), occursCheck);
                    if (newTerm == null) {
                        return null;
                    }
                    unified[i] = newTerm;
                    unified[i].isList = this.terms[i].isList;
                    ++i;
                }
                this.unifiedWith = this.makeTerm(this.func, unified);
                this.unifiedWith.isList = this.isList;
                return this.unifiedWith;
            }
        }
        return null;
    }

    public boolean canunify(Term t, boolean occursCheck) {
        if (t.name.equals("_")) {
            return true;
        }
        if (this.name.equals("_")) {
            return true;
        }
        if (!(t.type != 0 || occursCheck && this.containsVariable(t))) {
            return this.type != 1 || this.isList || !t.isList;
        }
        if (!(this.type != 0 || occursCheck && t.containsVariable(this))) {
            return t.type != 1 || t.isList || !this.isList;
        }
        if (this.type == 1 && t.type == 1 && t.name.equals(this.name)) {
            return true;
        }
        if (this.type == 1 && t.type == 1) {
            try {
                if (new Double(t.name).equals(new Double(this.name))) {
                    return true;
                }
            }
            catch (NumberFormatException e) {}
        } else if (this.type == 2 && t.type == 2 && t.func.name.equals(this.func.name) && t.func.arity == this.func.arity && t.isList == this.isList) {
            int i = 0;
            while (i < this.terms.length) {
                if (!this.terms[i].lastUnified().canunify(t.getTerms()[i].lastUnified(), occursCheck)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Double solveArithmetic() {
        try {
            if (this.type == 1 && this.name.toUpperCase().equals(this.name)) {
                double ans = Double.parseDouble(this.name);
                return new Double(ans);
            }
            if (this.type == 2 && this.func != null && this.func.builtin) {
                if (this.terms.length == 1) {
                    int type = this.func.type;
                    Double term1 = this.terms[0].lastUnified().solveArithmetic();
                    if (term1 == null) {
                        return null;
                    }
                    double termvalue = term1;
                    switch (type) {
                        case 779: {
                            return new Double(Math.abs(termvalue));
                        }
                        case 776: {
                            return new Double(Math.acos(termvalue));
                        }
                        case 777: {
                            return new Double(Math.sqrt(Math.abs(termvalue)));
                        }
                        case 778: {
                            return new Double(Math.pow(termvalue, 2.0));
                        }
                        case 780: {
                            return new Double(Math.cos(termvalue));
                        }
                        case 781: {
                            return new Double(Math.sin(termvalue));
                        }
                    }
                    return null;
                }
                int type = this.func.type;
                Double left1 = this.terms[0].lastUnified().solveArithmetic();
                Double left2 = this.terms[1].lastUnified().solveArithmetic();
                if (left1 == null || left2 == null) {
                    return null;
                }
                double left = left1;
                double right = left2;
                switch (type) {
                    case 770: {
                        return new Double(left * right);
                    }
                    case 771: {
                        return new Double(left + right);
                    }
                    case 773: {
                        return new Double(left % right);
                    }
                    case 775: {
                        return new Double(left / right);
                    }
                    case 774: {
                        return new Double(left - right);
                    }
                }
                return null;
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Term applySubs(Term newTerm, Vector subs) {
        if (newTerm.type != 2) {
            return newTerm;
        }
        Vector<Term> newTerms = new Vector<Term>(newTerm.getVariables().size());
        Vector vars = newTerm.getVariables();
        int i = 0;
        while (i < vars.size()) {
            Term t = (Term)vars.elementAt(i);
            int j = 0;
            while (j < subs.size()) {
                Substitution s = (Substitution)subs.elementAt(j);
                if (s.first.name.equals(t.name)) {
                    t = t.applySubs(s.second, subs);
                }
                ++j;
            }
            newTerms.addElement(t);
            ++i;
        }
        Term t1 = this.makeTerm(newTerm);
        t1.putVariables(newTerms, 0);
        return t1;
    }

    public Term applySubs(Vector subs, boolean recurse) {
        if (this.type != 2) {
            int i = 0;
            while (i < subs.size()) {
                Substitution s = (Substitution)subs.elementAt(i);
                if (s.first.name.equals(this.name)) {
                    if (s.second.type != 1 && recurse && !s.second.containsVariable(this)) {
                        return s.second.applySubs(subs, true);
                    }
                    s.second.unifiedWith = null;
                    return s.second;
                }
                ++i;
            }
            return this;
        }
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].containsVariable(this) ? this.terms[i] : this.terms[i].applySubs(subs, recurse);
            ++i;
        }
        return this.makeTerm(this.func, newTerms);
    }

    protected boolean equals(Term t) {
        if (t.type == 1) {
            return this.name.equals(t.name);
        }
        if (t.type == 0) {
            if (this.isList != t.isList) {
                return false;
            }
            return this.name.equals(t.name);
        }
        if (!t.func.equals(this.func)) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].equals(t.terms[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isGround() {
        if (this.type == 0) {
            return false;
        }
        if (this.type == 1) {
            return true;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].isGround()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Vector getElements() {
        if (this.type == 1) {
            Vector<Term> single = new Vector<Term>(1);
            single.addElement(this);
            return single;
        }
        if (!this.isList) {
            return new Vector();
        }
        if (this.type == 0) {
            Vector<Term> two = new Vector<Term>(2);
            two.addElement(this);
            two.addElement(this.makeTerm("[]"));
            return two;
        }
        Vector<Term> elements = new Vector<Term>(5, 2);
        elements.addElement(this.terms[0]);
        Program p = new Program();
        p.append(elements, this.terms[1].getElements());
        return elements;
    }

    public String toString() {
        if (this.isList && this.type == 2) {
            String str = new String("[");
            Vector elements = this.getElements();
            str = String.valueOf(str) + ((Term)elements.elementAt(0)).toString();
            int i = 1;
            while (i < elements.size() - 1) {
                Term t = (Term)elements.elementAt(i);
                str = i == elements.size() - 2 && t.type == 0 && t.isList ? String.valueOf(str) + " | " + t.toString() : String.valueOf(str) + ", " + t.toString();
                ++i;
            }
            str = String.valueOf(str) + "]";
            return str;
        }
        if (this.type != 2) {
            try {
                DecimalFormat formatter = new DecimalFormat("0.##");
                return formatter.format(Double.valueOf(this.name));
            }
            catch (NumberFormatException e) {
                return this.name;
            }
        }
        if (!this.func.builtIn()) {
            String str = new String(this.func.name);
            str = String.valueOf(str) + "(" + this.terms[0].toString();
            int i = 1;
            while (i < this.terms.length) {
                str = String.valueOf(str) + ", " + this.terms[i].toString();
                ++i;
            }
            str = String.valueOf(str) + ")";
            return str;
        }
        if (this.func.type == 779) {
            return new String("abs(" + this.terms[0].toString() + ")");
        }
        if (this.func.type == 776) {
            return new String("acos(" + this.terms[0].toString() + ")");
        }
        if (this.func.type == 780) {
            return new String("cos(" + this.terms[0].toString() + ")");
        }
        if (this.func.type == 781) {
            return new String("sin(" + this.terms[0].toString() + ")");
        }
        if (this.func.type == 777) {
            return new String("sqrt(" + this.terms[0].toString() + ")");
        }
        if (this.func.type == 778) {
            return new String("square(" + this.terms[0].toString() + ")");
        }
        String middle = new String("");
        switch (this.func.type) {
            case 770: {
                middle = "*";
                break;
            }
            case 771: {
                middle = "+";
                break;
            }
            case 773: {
                middle = " mod ";
                break;
            }
            case 774: {
                middle = "-";
                break;
            }
            case 775: {
                middle = "/";
                break;
            }
            default: {
                return this.termToGoal().toString();
            }
        }
        String str = new String("(" + this.terms[0].toString());
        str = String.valueOf(str) + middle;
        str = String.valueOf(str) + this.terms[1].toString() + ")";
        return str;
    }

    public String printString() {
        if (this.isList && this.type == 2) {
            String str = new String("[");
            Vector elements = this.getElements();
            str = String.valueOf(str) + ((Term)elements.elementAt(0)).printString();
            int i = 1;
            while (i < elements.size() - 1) {
                Term t = (Term)elements.elementAt(i);
                str = i == elements.size() - 2 && t.type == 0 && t.isList ? String.valueOf(str) + " | " + t.printString() : String.valueOf(str) + ", " + t.printString();
                ++i;
            }
            str = String.valueOf(str) + "]";
            return str;
        }
        if (this.type != 2) {
            if (this.unifiedWith != null) {
                return this.lastUnified().toString();
            }
            return this.name;
        }
        if (!this.func.builtIn()) {
            String str = new String(this.func.name);
            str = String.valueOf(str) + "(" + this.terms[0].printString();
            int i = 1;
            while (i < this.terms.length) {
                str = String.valueOf(str) + ", " + this.terms[i].printString();
                ++i;
            }
            str = String.valueOf(str) + ")";
            return str;
        }
        if (this.func.type == 779) {
            return new String("abs(" + this.terms[0].printString() + ")");
        }
        if (this.func.type == 776) {
            return new String("acos(" + this.terms[0].printString() + ")");
        }
        if (this.func.type == 780) {
            return new String("cos(" + this.terms[0].printString() + ")");
        }
        if (this.func.type == 781) {
            return new String("sin(" + this.terms[0].printString() + ")");
        }
        if (this.func.type == 777) {
            return new String("sqrt(" + this.terms[0].printString() + ")");
        }
        if (this.func.type == 778) {
            return new String("square(" + this.terms[0].printString() + ")");
        }
        String middle = new String("");
        switch (this.func.type) {
            case 770: {
                middle = "*";
                break;
            }
            case 771: {
                middle = "+";
                break;
            }
            case 773: {
                middle = " mod ";
                break;
            }
            case 774: {
                middle = "-";
                break;
            }
            case 775: {
                middle = "/";
                break;
            }
            default: {
                return this.termToGoal().printString();
            }
        }
        String str = new String("(" + this.terms[0].printString());
        str = String.valueOf(str) + middle;
        str = String.valueOf(str) + this.terms[1].printString() + ")";
        return str;
    }
}

