/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NodeDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private JComboBox colors;
    private JComboBox shapes;
    private GraphCanvas canvas;
    private Point pos;
    private JTextField label;
    private boolean creating;
    private Node node;

    public NodeDialog(GraphCanvas canvas) {
        super((JFrame)canvas.parent, "Node Options", true);
        this.canvas = canvas;
        this.creating = true;
        ((Component)this).setSize(300, 300);
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.colors = new JComboBox();
        this.colors.addItem("Black");
        this.colors.addItem("Red");
        this.colors.addItem("Blue");
        this.colors.addItem("Green");
        this.shapes = new JComboBox();
        this.shapes.addItem("Oval");
        this.shapes.addItem("Rectangle");
        this.shapes.addItem("Diamond");
        this.label = new JTextField("", 10);
        this.label.addActionListener(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(3, 1));
        JPanel p1 = new JPanel();
        p1.add(new JLabel("Label"));
        p1.add(this.label);
        contentPane.add(p1);
        JPanel p2 = new JPanel();
        p2.add(this.colors);
        p2.add(this.shapes);
        contentPane.add(p2);
        JPanel p4 = new JPanel();
        p4.add(this.ok);
        p4.add(this.cancel);
        contentPane.add(p4);
        this.pack();
        this.setResizable(false);
    }

    public void open(Point pos) {
        this.creating = true;
        this.pos = pos;
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    public void open(Node n) {
        this.creating = false;
        this.node = n;
        this.pos = n.pos;
        this.label.setText(n.label[0]);
        if (n.color == Color.black) {
            this.colors.setSelectedItem("Black");
        } else if (n.color == Color.red) {
            this.colors.setSelectedItem("Red");
        } else if (n.color == Color.blue) {
            this.colors.setSelectedItem("Blue");
        } else {
            this.colors.setSelectedItem("Green");
        }
        if (n.shape == 1110) {
            this.shapes.setSelectedItem("Oval");
        } else if (n.shape == 1111) {
            this.shapes.setSelectedItem("Rectangle");
        } else {
            this.shapes.setSelectedItem("Diamond");
        }
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (!arg.equals("Cancel")) {
            this.parseDialog();
        }
        ((Component)this).setVisible(false);
    }

    private void parseDialog() {
        Color color = this.colors.getSelectedItem() == "Black" ? Color.black : (this.colors.getSelectedItem() == "Red" ? Color.red : (this.colors.getSelectedItem() == "Blue" ? Color.blue : Color.green));
        int shape = this.shapes.getSelectedItem() == "Oval" ? 1110 : (this.shapes.getSelectedItem() == "Rectangle" ? 1111 : 1112);
        if (this.creating) {
            Node n = new Node(this.canvas.graph, this.label.getText(), this.pos, color, shape);
            this.canvas.graph.addNode(n);
        } else {
            this.canvas.graph.modifyNode(this.node, this.label.getText(), this.pos, color, shape);
        }
    }
}

