/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class Node
extends Entity {
    public Point pos;
    public int width;
    public int height;
    public int shape;
    protected Vector edgesIn;
    protected Vector edgesOut;
    public int index;
    protected int wPad;
    protected int hPad;
    protected int printWidth;
    protected int printHeight;

    public Node(Graph graph) {
        super(graph);
        this.pos = new Point();
        this.shape = 0;
        this.edgesIn = new Vector(10, 10);
        this.edgesOut = new Vector(10, 10);
        this.index = -1;
        this.updateSize();
        this.wPad = 20;
        this.hPad = 20;
    }

    public Node(Graph graph, String label, Point pos, Color color, int shape) {
        super(graph);
        this.label[0] = label;
        this.pos = pos;
        this.isSelected = false;
        this.isBold = false;
        this.color = color;
        this.shape = shape;
        this.edgesIn = new Vector(10, 10);
        this.edgesOut = new Vector(10, 10);
        this.type = 7770;
        this.wPad = 20;
        this.hPad = 20;
        this.updateSize();
    }

    public void updateSize() {
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    public void updateSize(int printWidth, int printHeight) {
        this.width = printWidth;
        this.height = printHeight;
    }

    protected int getWidth() {
        return this.graph.canvas.getFontMetrics().stringWidth(this.label[0]) + this.wPad;
    }

    protected int getHeight() {
        return this.graph.canvas.getFontMetrics().getHeight() + this.hPad;
    }

    protected Point getPos() {
        return this.pos;
    }

    public void set(String l, Point p, Color c, int s) {
        this.label[0] = l;
        this.pos = p;
        this.color = c;
        this.shape = s;
    }

    public void draw(Graphics offscreen, boolean moving) {
        float lw = this.graph.getLineWidth() + (float)this.xw;
        Point nw = new Point(this.pos);
        nw.translate(-this.width / 2, -this.height / 2);
        if (this.shape == 1110) {
            offscreen.setColor(this.color);
            if (lw == 1.0f) {
                if (this.isBold) {
                    offscreen.setColor(this.color);
                } else {
                    offscreen.setColor(Color.white);
                }
                offscreen.fillOval((int)nw.x, (int)nw.y, this.width, this.height);
                offscreen.setColor(this.color);
                offscreen.drawOval((int)nw.x, (int)nw.y, this.width, this.height);
            } else {
                offscreen.fillOval((int)(nw.x - lw), (int)(nw.y - lw), (int)((float)this.width + lw * 2.0f), (int)((float)this.height + lw * 2.0f));
                if (!this.isBold) {
                    offscreen.setColor(Color.white);
                }
                offscreen.fillOval((int)nw.x, (int)nw.y, this.width, this.height);
            }
        } else if (this.shape == 1111) {
            offscreen.setColor(this.color);
            if (lw == 1.0f) {
                if (this.isBold) {
                    offscreen.setColor(this.color);
                } else {
                    offscreen.setColor(Color.white);
                }
                offscreen.fillRect((int)nw.x, (int)nw.y, this.width, this.height);
                offscreen.setColor(this.color);
                offscreen.drawRect((int)nw.x, (int)nw.y, this.width, this.height);
            } else {
                offscreen.fillRect((int)(nw.x - lw), (int)(nw.y - lw), (int)((float)this.width + lw * 2.0f), (int)((float)this.height + lw * 2.0f));
                if (!this.isBold) {
                    offscreen.setColor(Color.white);
                }
                offscreen.fillRect((int)nw.x, (int)nw.y, this.width, this.height);
            }
        } else if (this.shape == 1112) {
            int[] xVals = new int[4];
            int[] yVals = new int[4];
            xVals[0] = (int)this.pos.x;
            xVals[1] = (int)((double)this.pos.x + (double)this.width / 1.5 + (double)lw);
            xVals[2] = (int)this.pos.x;
            xVals[3] = (int)((double)this.pos.x - (double)this.width / 1.5 - (double)lw);
            yVals[0] = (int)((double)this.pos.y - (double)this.height / 1.5 - (double)lw);
            yVals[1] = (int)this.pos.y;
            yVals[2] = (int)((double)this.pos.y + (double)this.height / 1.5 + (double)lw);
            yVals[3] = (int)this.pos.y;
            offscreen.setColor(Color.white);
            offscreen.fillPolygon(xVals, yVals, 4);
            if ((double)lw <= 1.0) {
                offscreen.setColor(this.color);
                if (this.isBold) {
                    offscreen.fillPolygon(xVals, yVals, 4);
                } else {
                    offscreen.drawPolygon(xVals, yVals, 4);
                }
            } else {
                offscreen.setColor(this.color);
                offscreen.fillPolygon(xVals, yVals, 4);
                if (!this.isBold) {
                    offscreen.setColor(Color.white);
                    xVals[1] = (int)((float)xVals[1] + -lw);
                    xVals[3] = (int)((float)xVals[3] + lw);
                    yVals[0] = (int)((float)yVals[0] + lw);
                    yVals[2] = (int)((float)yVals[2] + -lw);
                    offscreen.fillPolygon(xVals, yVals, 4);
                }
            }
        }
        if (!moving || this.graph.canvas.getSubmode() == 3335) {
            this.drawLabel(offscreen);
            offscreen.setColor(Color.magenta);
            if (this.isSelected && this.graph.canvas.getMode() != 2221) {
                offscreen.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
                offscreen.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
                offscreen.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
                offscreen.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
            }
        }
    }

    protected void drawLabel(Graphics offscreen) {
        if (this.isBold && (this.color == Color.blue || this.color == Color.black)) {
            offscreen.setColor(Color.white);
        } else {
            offscreen.setColor(Color.black);
        }
        int h = this.graph.canvas.getFontMetrics().getAscent();
        int w = this.graph.canvas.getFontMetrics().stringWidth(this.label[0]);
        offscreen.drawString(this.label[0], (int)this.pos.x - w / 2, (int)this.pos.y + h / 2);
    }

    public void drawStructure(Graphics g, boolean moving) {
        this.width /= 2;
        this.height /= 2;
        float lw = this.graph.getLineWidth() + (float)this.xw;
        Point nw = new Point(this.pos);
        nw.translate(-this.width / 2, -this.height / 2);
        if (this.shape == 1110) {
            g.setColor(this.color);
            if (lw == 1.0f) {
                if (this.isBold) {
                    g.setColor(this.color);
                } else {
                    g.setColor(Color.white);
                }
                g.fillOval((int)nw.x, (int)nw.y, this.width, this.height);
                g.setColor(this.color);
                g.drawOval((int)nw.x, (int)nw.y, this.width, this.height);
            } else {
                g.fillOval((int)(nw.x - lw), (int)(nw.y - lw), (int)((float)this.width + lw * 2.0f), (int)((float)this.height + lw * 2.0f));
                if (!this.isBold) {
                    g.setColor(Color.white);
                }
                g.fillOval((int)nw.x, (int)nw.y, this.width, this.height);
            }
        } else if (this.shape == 1111) {
            g.setColor(this.color);
            if (lw == 1.0f) {
                if (this.isBold) {
                    g.setColor(this.color);
                } else {
                    g.setColor(Color.white);
                }
                g.fillRect((int)nw.x, (int)nw.y, this.width, this.height);
                g.setColor(this.color);
                g.drawRect((int)nw.x, (int)nw.y, this.width, this.height);
            } else {
                g.fillRect((int)(nw.x - lw), (int)(nw.y - lw), (int)((float)this.width + lw * 2.0f), (int)((float)this.height + lw * 2.0f));
                if (!this.isBold) {
                    g.setColor(Color.white);
                }
                g.fillRect((int)nw.x, (int)nw.y, this.width, this.height);
            }
        } else if (this.shape == 1112) {
            int[] xVals = new int[4];
            int[] yVals = new int[4];
            xVals[0] = (int)this.pos.x;
            xVals[1] = (int)((double)this.pos.x + (double)this.width / 1.5 + (double)lw);
            xVals[2] = (int)this.pos.x;
            xVals[3] = (int)((double)this.pos.x - (double)this.width / 1.5 - (double)lw);
            yVals[0] = (int)((double)this.pos.y - (double)this.height / 1.5 - (double)lw);
            yVals[1] = (int)this.pos.y;
            yVals[2] = (int)((double)this.pos.y + (double)this.height / 1.5 + (double)lw);
            yVals[3] = (int)this.pos.y;
            g.setColor(Color.white);
            g.fillPolygon(xVals, yVals, 4);
            if ((double)lw <= 1.0) {
                g.setColor(this.color);
                if (this.isBold) {
                    g.fillPolygon(xVals, yVals, 4);
                } else {
                    g.drawPolygon(xVals, yVals, 4);
                }
            } else {
                g.setColor(this.color);
                g.fillPolygon(xVals, yVals, 4);
                if (!this.isBold) {
                    g.setColor(Color.white);
                    xVals[1] = (int)((float)xVals[1] + -lw);
                    xVals[3] = (int)((float)xVals[3] + lw);
                    yVals[0] = (int)((float)yVals[0] + lw);
                    yVals[2] = (int)((float)yVals[2] + -lw);
                    g.fillPolygon(xVals, yVals, 4);
                }
            }
        }
        if (!moving) {
            g.setColor(Color.magenta);
            if (this.isSelected && this.graph.canvas.getMode() != 2221) {
                g.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
                g.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
                g.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
                g.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
            }
        }
        this.width *= 2;
        this.height *= 2;
        lw = this.graph.getLineWidth() - (float)this.xw;
    }

    public void addEdgesIn(Edge e) {
        this.edgesIn.addElement(e);
    }

    public void addEdgesOut(Edge e) {
        this.edgesOut.addElement(e);
    }

    public void removeEdgesIn(Edge e) {
        this.edgesIn.removeElement(e);
    }

    public void removeEdgesOut(Edge e) {
        this.edgesOut.removeElement(e);
    }

    public Vector[] getAllEdges() {
        Vector[] tmp = new Vector[]{this.edgesIn, this.edgesOut};
        return tmp;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean contains(Point p) {
        if (this.width == 0 || this.height == 0) {
            return false;
        }
        int dx = (int)Math.abs(this.pos.x - p.x);
        int dy = (int)Math.abs(this.pos.y - p.y);
        if (this.shape == 1110 || this.shape == 1111) {
            return (double)(4 * dx * dx / (this.width * this.width) + 4 * dy * dy / (this.height * this.height)) <= 0.5;
        }
        Point p1 = new Point(this.pos.x, this.pos.y - (float)this.height / 1.5f);
        Point p2 = new Point(this.pos.x + (float)this.width / 1.5f, this.pos.y);
        Point p3 = new Point(this.pos.x, this.pos.y + (float)this.height / 1.5f);
        Point p4 = new Point(this.pos.x - (float)this.width / 1.5f, this.pos.y);
        return p.checkSide(p1, p4) < 0.0f && p.checkSide(p4, p3) < 0.0f && p.checkSide(p3, p2) < 0.0f && p.checkSide(p2, p1) < 0.0f;
    }

    public boolean isInRect(Point a, Point b) {
        Point c = new Point(this.pos.x - (float)(this.width / 2), this.pos.y - (float)(this.height / 2));
        Point d = new Point(this.pos.x + (float)(this.width / 2), this.pos.y + (float)(this.height / 2));
        if (this.shape == 1112) {
            c.x = this.pos.x - (float)this.width / 1.5f;
            c.y = this.pos.y - (float)this.height / 1.5f;
            d.x = this.pos.x + (float)this.width / 1.5f;
            d.y = this.pos.y + (float)this.height / 1.5f;
        }
        return c.x > a.x && d.x < b.x && c.y > a.y && d.y < b.y;
    }

    public void translate(float dx, float dy) {
        this.pos.translate(dx, dy);
        int i = 0;
        while (i < this.edgesIn.size()) {
            ((Edge)this.edgesIn.elementAt(i)).updateLength();
            ++i;
        }
        i = 0;
        while (i < this.edgesOut.size()) {
            ((Edge)this.edgesOut.elementAt(i)).updateLength();
            ++i;
        }
    }

    public void move(Point p) {
        this.pos.move(p);
        int i = 0;
        while (i < this.edgesIn.size()) {
            ((Edge)this.edgesIn.elementAt(i)).updateLength();
            ++i;
        }
        i = 0;
        while (i < this.edgesOut.size()) {
            ((Edge)this.edgesOut.elementAt(i)).updateLength();
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point findBorder(Node start) {
        float tmp2;
        if (this.shape == 1110) {
            float dx = this.pos.x - start.pos.x;
            float dy = this.pos.y - start.pos.y;
            float m = dy / dx;
            float b = this.pos.y - m * this.pos.x;
            float t = (float)(0.5 / Math.sqrt(dx * dx / (float)(this.width * this.width) + dy * dy / (float)(this.height * this.height)));
            return new Point(this.pos.x - dx * t, this.pos.y - dy * t);
        }
        Point a = new Point(this.pos);
        Point b = new Point(start.pos.x, start.pos.y);
        Point c = new Point(0.0f, 0.0f);
        Point d = new Point(0.0f, 0.0f);
        Point p1 = new Point(0.0f, 0.0f);
        Point p2 = new Point(0.0f, 0.0f);
        Point p3 = new Point(0.0f, 0.0f);
        Point p4 = new Point(0.0f, 0.0f);
        if (this.shape == 1111) {
            p1.move(this.pos.x - (float)(this.width / 2), this.pos.y - (float)(this.height / 2));
            p2.move(p1.x, this.pos.y + (float)(this.height / 2));
            p3.move(this.pos.x + (float)(this.width / 2), p2.y);
            p4.move(p3.x, p1.y);
        } else {
            p1.move(this.pos.x, this.pos.y - (float)this.height / 1.5f);
            p2.move(this.pos.x - (float)this.width / 1.5f, this.pos.y);
            p3.move(this.pos.x, this.pos.y + (float)this.height / 1.5f);
            p4.move(this.pos.x + (float)this.width / 1.5f, this.pos.y);
        }
        float tmp1 = b.checkSide(p3, p1);
        if (tmp1 < 0.0f) {
            tmp2 = b.checkSide(p4, p2);
            if (tmp2 < 0.0f) {
                c.move(p2);
                d.move(p3);
            } else {
                if (!(tmp2 > 0.0f)) return p2;
                c.move(p1);
                d.move(p2);
            }
        } else if (tmp1 > 0.0f) {
            tmp2 = b.checkSide(p2, p4);
            if (tmp2 < 0.0f) {
                c.move(p4);
                d.move(p1);
            } else {
                if (!(tmp2 > 0.0f)) return p4;
                c.move(p3);
                d.move(p4);
            }
        } else {
            float tmp22 = b.checkSide(p2, p4);
            if (tmp22 < 0.0f) {
                return p1;
            }
            if (!(tmp22 > 0.0f)) return a;
            return p3;
        }
        float[][] A = new float[2][2];
        A[0][0] = b.y - a.y;
        A[0][1] = a.x - b.x;
        A[1][0] = d.y - c.y;
        A[1][1] = c.x - d.x;
        float[] B = new float[]{a.x * b.y - b.x * a.y, c.x * d.y - d.x * c.y};
        float denominator = A[0][0] * A[1][1] - A[0][1] * A[1][0];
        float[][] invA = new float[2][2];
        invA[0][0] = A[1][1] / denominator;
        invA[0][1] = -A[0][1] / denominator;
        invA[1][0] = -A[1][0] / denominator;
        invA[1][1] = A[0][0] / denominator;
        return new Point(invA[0][0] * B[0] + invA[0][1] * B[1], invA[1][0] * B[0] + invA[1][1] * B[1]);
    }

    public boolean equals(Entity ent) {
        if (ent.type == 7770) {
            Node node = (Node)ent;
            return node.index == this.index && this.pos.equals(node.pos);
        }
        return false;
    }

    public Vector getNeighbours() {
        Vector<Node> tmp = new Vector<Node>(this.edgesOut.size());
        int i = 0;
        while (i < this.edgesOut.size()) {
            tmp.addElement(((Edge)this.edgesOut.elementAt(i)).otherNode(this));
            ++i;
        }
        return tmp;
    }

    public boolean connected() {
        return this.edgesIn.size() > 0 || this.edgesOut.size() > 0;
    }

    public String toString() {
        this.pos.scale(1.0f / this.graph.getScale());
        String str = this.label[0];
        this.pos.scale(this.graph.getScale());
        return str;
    }
}

