/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.AboutBox;
import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.Point;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.JApplet;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpMenu
extends JMenu
implements ActionListener {
    private static final String helpURL = "http://www.cs.ubc.ca/labs/lci/CIspace/CIspaceWebDev/CIspace/";
    private static final String localHelp = "help";
    private static final String aboutCIspaceURL = "http://www.cs.ubc.ca/labs/lci/CIspace/Version4/";
    private static final String notAppletMessage = "To access help, please open a browser to the following URL: ";
    private String appletName;
    private JApplet applet;
    private JFrame parent;
    private JEditorPane htmlPane;

    public HelpMenu(JApplet applet, String name, JFrame parent) {
        super("Help");
        this.applet = applet;
        this.appletName = name;
        this.parent = parent;
        JMenuItem mi = new JMenuItem("Help");
        this.add(mi);
        mi.addActionListener(this);
        this.addSeparator();
        mi = new JMenuItem("About CIspace");
        this.add(mi);
        mi.addActionListener(this);
        mi = new JMenuItem("About this applet");
        this.add(mi);
        mi.addActionListener(this);
    }

    public void openBrowserHelp(String helptype) {
        String urlString = aboutCIspaceURL + this.appletName + "/help/" + helptype;
        MyEditor editor = new MyEditor();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Help") {
            this.openBrowserHelp("index.html");
        } else if (e.getActionCommand() == "About CIspace") {
            new AboutBox(this.parent, true);
        } else if (e.getActionCommand() == "About this applet") {
            new AboutBox(this.parent, false);
        }
    }

    class MyEditor
    extends JFrame
    implements HyperlinkListener,
    WindowListener {
        public MyEditor() {
            super("Help");
            try {
                HelpMenu.this.htmlPane = new JEditorPane();
                HelpMenu.this.htmlPane.addHyperlinkListener(this);
                HelpMenu.this.htmlPane.setPage(HelpMenu.aboutCIspaceURL + HelpMenu.this.appletName + "/help/");
                HelpMenu.this.htmlPane.setEditable(false);
                JScrollPane htmlView = new JScrollPane(HelpMenu.this.htmlPane);
                Dimension minimumSize = new Dimension(500, 500);
                htmlView.setMinimumSize(minimumSize);
                this.getContentPane().add((Component)htmlView, "Center");
                ((Component)this).setSize(600, 600);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension screenSize = toolkit.getScreenSize();
                Point bottomLeftCorner = new Point(screenSize.width, screenSize.height);
                Dimension windowSize = this.getSize();
                int widthOffset = windowSize.width;
                int heightOffset = windowSize.height;
                ((Component)this).setLocation((int)(bottomLeftCorner.x - (float)widthOffset), (int)(bottomLeftCorner.y - (float)heightOffset));
                this.show();
            }
            catch (IOException e) {
                System.err.println("Error URL null or cannot be accessed: " + e.getMessage());
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    HelpMenu.this.htmlPane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            GraphWindow.writeToLog("Help Window closing");
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }
}

