/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.LabelCanvas;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Time;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class GraphWindow
extends JFrame
implements WindowListener,
ActionListener,
AdjustmentListener,
ComponentListener,
ChangeListener {
    protected boolean undoBoolean;
    protected JCheckBoxMenuItem pan;
    protected JCheckBoxMenuItem zoom;
    protected JCheckBoxMenuItem showToolbar;
    protected JMenuItem line;
    static String log = "";
    protected JMenuItem resetLabel;
    protected JMenuItem autoscale;
    private ButtonGroup zpGroup;
    protected JMenuItem save;
    protected Font toolFont;
    protected boolean nL;
    protected boolean mL;
    protected boolean wL;
    protected int linewidth;
    protected boolean oF;
    protected boolean sF;
    protected boolean mF;
    protected boolean lF;
    protected int fontsize;
    protected JMenuItem openloc;
    protected JMenuItem opengraph;
    protected JMenuItem loadsamplegraph;
    protected JMenuItem createnewgraph;
    protected JMenu zp;
    protected Graph graph;
    public GraphCanvas canvas;
    protected JPanel canvasPanel;
    protected JCheckBoxMenuItem extraLargeFont;
    protected JCheckBoxMenuItem largeFont;
    protected JCheckBoxMenuItem mediumFont;
    protected JCheckBoxMenuItem smallFont;
    protected JCheckBoxMenuItem otherFont;
    protected JCheckBoxMenuItem wideLine;
    protected JCheckBoxMenuItem mediumLine;
    protected JCheckBoxMenuItem narrowLine;
    protected JCheckBoxMenuItem showMP;
    protected JCheckBoxMenuItem showText;
    protected boolean buttontext;
    private GridBagConstraints gbc;
    protected GridBagLayout gbl;
    protected LabelCanvas messageCanvas;
    private Color bg;
    public JApplet applet;
    protected JTabbedPane tabbedPane;
    public JScrollPane scrollPanel;
    public JSplitPane tabandbottom;
    protected int fontSize;
    protected JPanel bottomPanel;
    protected JScrollPane bottomScrollPanel;
    protected JTextArea algoText;
    protected JPanel algoTextPanel;
    protected ButtonGroup fontGroup;
    protected ButtonGroup lineWidthGroup;
    protected JPanel main;
    protected ButtonGroup solveModeGroup;
    protected JPanel toolBarPanel;
    public JToggleButton[] createButModes;
    public JToggleButton[] solveButModes;
    private JPanel toolbarPanel;
    protected ButtonGroup createModeButGroup;
    public ButtonGroup solveModeButGroup;
    protected JToolBar toolBar;
    private JButton changeMode;
    private JButton solveMode;
    private JMenuItem menuItem;
    protected static PrintWriter outLog;
    protected JPanel emptyPanel1;
    protected JPanel emptyPanel2;
    protected JMenu m;
    protected JMenuBar mBar;
    protected ImageIcon createNodeIcon;
    protected ImageIcon createEdgeIcon;
    protected ImageIcon selectIcon;
    protected ImageIcon deleteIcon;
    protected ImageIcon setPropsIcon;
    protected boolean componentResized;
    static /* synthetic */ Class class$0;

    public GraphWindow(JApplet parent) {
        this.applet = parent;
        Color bg = GraphConsts.bg;
        ((Component)this).setBackground(bg);
        this.setForeground(GraphConsts.fg);
        this.setTitle("Graph Drawing Kit");
        ((Component)this).setSize(600, 700);
        this.toolFont = new Font("arial", 0, 10);
        this.buttontext = false;
        this.componentResized = true;
        this.addWindowListener(this);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        UIManager.put("TabbedPane.selected", Color.white);
        this.createNodeIcon = GraphWindow.createImageIcon("images/newNode.png");
        this.createEdgeIcon = GraphWindow.createImageIcon("images/newEdge2.png");
        this.selectIcon = GraphWindow.createImageIcon("images/select.png");
        this.deleteIcon = GraphWindow.createImageIcon("images/delete.png");
        this.setPropsIcon = GraphWindow.createImageIcon("images/setProp.png");
        this.tabbedPane = new JTabbedPane();
        this.emptyPanel1 = new JPanel();
        this.emptyPanel2 = new JPanel();
        this.canvasPanel = new JPanel();
        this.canvasPanel.setBackground(Color.white);
        this.messageCanvas = new LabelCanvas();
        this.getCanvas();
        this.canvasPanel.setLayout(this.gbl);
        this.scrollPanel.setPreferredSize(new Dimension(425, 300));
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.135);
        this.addComponent(this.scrollPanel, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.buttontext = true;
        this.tabbedPane.addTab("Create", null, this.canvasPanel, "Click to change to Create mode");
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addTab("Solve", null, this.emptyPanel2, "Click to change to Solve mode");
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setBackground(Color.lightGray);
        BasicTabbedPaneUI tPane = new BasicTabbedPaneUI();
        this.tabbedPane.setUI(new BasicTabbedPaneUI(){

            public void paintComponent(Graphics g, JComponent c) {
                this.focus = Color.white;
                super.paint(g, c);
            }
        });
        this.toolBarPanel = new JPanel(new BorderLayout());
        this.main = new JPanel(new BorderLayout());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.main);
        this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
        this.mBar = this.createMenuBar();
        Font textFont = new Font("arial", 1, 12);
        this.algoText = new JTextArea();
        this.algoText.setBorder(BorderFactory.createRaisedBevelBorder());
        this.algoText.setBackground(Color.lightGray);
        this.algoText.setFont(textFont);
        this.algoText.setEditable(false);
        this.algoText.setVisible(false);
        this.toolBar = new JToolBar();
        this.createToolBarWithText();
        this.bottomPanel = new JPanel(new BorderLayout());
        this.tabandbottom = new JSplitPane(0);
        this.tabandbottom.setOneTouchExpandable(true);
        this.bottomPanel.add((Component)this.algoText, "North");
        this.toolBarPanel.add((Component)this.toolBar, "West");
        this.tabandbottom.setTopComponent(this.tabbedPane);
        this.tabandbottom.setBottomComponent(this.bottomPanel);
        this.tabandbottom.setResizeWeight(0.85);
        this.tabandbottom.setDividerLocation(0.8);
        this.main.add((Component)this.toolBarPanel, "North");
        this.main.add((Component)this.tabandbottom, "Center");
        this.messageCanvas.setPreferredSize(new Dimension(525, 50));
        this.centerWindow();
    }

    protected void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    protected JMenuBar createMenuBar() {
        this.mBar = new JMenuBar();
        JMenu fileMenu = this.createFileMenu();
        this.mBar.add(fileMenu);
        JMenu viewMenu = this.createViewMenu();
        this.mBar.add(viewMenu);
        JMenu helpMenu = this.createHelpMenu();
        this.mBar.add(helpMenu);
        this.setJMenuBar(this.mBar);
        return this.mBar;
    }

    protected JMenu createFileMenu() {
        JMenu m = new JMenu("File");
        JMenuItem mItem = new JMenuItem("Create Random Graph");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(82);
        m.add(mItem);
        this.createnewgraph = new JMenuItem("Create New Graph");
        this.createnewgraph.addActionListener(this);
        this.createnewgraph.setMnemonic(78);
        m.add(this.createnewgraph);
        this.loadsamplegraph = new JMenuItem("Load Sample Graph");
        this.loadsamplegraph.setMnemonic(83);
        this.loadsamplegraph.addActionListener(this);
        m.add(this.loadsamplegraph);
        if (this.applet == null) {
            this.opengraph = new JMenuItem("Open Graph");
            this.opengraph.setMnemonic(79);
            this.opengraph.addActionListener(this);
            m.add(this.opengraph);
        }
        this.openloc = new JMenuItem("Open Location");
        this.openloc.setMnemonic(76);
        this.openloc.addActionListener(this);
        m.add(this.openloc);
        m.addSeparator();
        if (this.applet == null) {
            this.save = new JMenuItem("Save Graph");
            this.save.addActionListener(this);
            this.save.setMnemonic(83);
            m.add(this.save);
        }
        mItem = new JMenuItem("Print");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(80);
        m.add(mItem);
        mItem = new JMenuItem("Quit");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(81);
        m.add(mItem);
        return m;
    }

    protected JMenu createViewMenu() {
        this.zpGroup = new ButtonGroup();
        ButtonGroup fontGroup = new ButtonGroup();
        this.m = new JMenu("View");
        JMenu font = new JMenu("Font Size");
        this.extraLargeFont = new JCheckBoxMenuItem("Extra Large (30 pt)", false);
        this.extraLargeFont.addActionListener(this);
        font.add(this.extraLargeFont);
        fontGroup.add(this.extraLargeFont);
        this.largeFont = new JCheckBoxMenuItem("Large (20 pt)", false);
        this.largeFont.addActionListener(this);
        font.add(this.largeFont);
        fontGroup.add(this.largeFont);
        this.mediumFont = new JCheckBoxMenuItem("Medium (12 pt)", true);
        this.mediumFont.addActionListener(this);
        font.add(this.mediumFont);
        fontGroup.add(this.mediumFont);
        this.smallFont = new JCheckBoxMenuItem("Small (9 pt)", false);
        this.smallFont.addActionListener(this);
        font.add(this.smallFont);
        fontGroup.add(this.smallFont);
        this.otherFont = new JCheckBoxMenuItem("others...", false);
        this.otherFont.addActionListener(this);
        font.add(this.otherFont);
        this.m.add(font);
        fontGroup.add(this.otherFont);
        this.lineWidthGroup = new ButtonGroup();
        this.line = new JMenu("Line Width");
        this.wideLine = new JCheckBoxMenuItem("Wide (4 pixels)", false);
        this.wideLine.addActionListener(this);
        this.line.add(this.wideLine);
        this.lineWidthGroup.add(this.wideLine);
        this.mediumLine = new JCheckBoxMenuItem("Medium (2 pixels)", false);
        this.mediumLine.addActionListener(this);
        this.line.add(this.mediumLine);
        this.lineWidthGroup.add(this.mediumLine);
        this.narrowLine = new JCheckBoxMenuItem("Narrow (1 pixel)", true);
        this.narrowLine.addActionListener(this);
        this.line.add(this.narrowLine);
        this.lineWidthGroup.add(this.narrowLine);
        this.m.add(this.line);
        this.m.addSeparator();
        this.autoscale = new JMenuItem("Autoscale");
        this.autoscale.addActionListener(this);
        this.m.add(this.autoscale);
        this.zp = new JMenu("Pan/Zoom");
        this.zoom = new JCheckBoxMenuItem("Zoom", true);
        this.zoom.addActionListener(this);
        this.zpGroup.add(this.zoom);
        this.zp.add(this.zoom);
        this.pan = new JCheckBoxMenuItem("Pan", false);
        this.pan.addActionListener(this);
        this.zp.add(this.pan);
        this.zpGroup.add(this.pan);
        this.m.add(this.zp);
        this.resetLabel = new JMenuItem("Reset Labels");
        this.resetLabel.addActionListener(this);
        this.m.add(this.resetLabel);
        this.m.addSeparator();
        this.showMP = new JCheckBoxMenuItem("Show Message Panel", true);
        this.showMP.addActionListener(this);
        this.m.add(this.showMP);
        this.showText = new JCheckBoxMenuItem("Show Button Text", true);
        this.showText.addActionListener(this);
        this.m.add(this.showText);
        this.showToolbar = new JCheckBoxMenuItem("Show Buttons", true);
        this.showToolbar.addActionListener(this);
        this.m.add(this.showToolbar);
        return this.m;
    }

    protected JMenu createHelpMenu() {
        JMenu m = new JMenu("Help");
        JMenuItem mItem = new JMenuItem("About CIspace");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        m.add(mItem);
        return m;
    }

    protected String getAboutText() {
        return null;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("CIspace.graphToolKit.GraphWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((imgURL = clazz.getResource(path)) != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public void createToolBar() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createButModes = new JToggleButton[7];
        this.setCreateButtons(0, this.createNodeIcon, "Create Node");
        this.setCreateButtons(1, this.createEdgeIcon, "Create Edge");
        this.setCreateButtons(2, this.selectIcon, "   Select   ");
        this.setCreateButtons(3, this.deleteIcon, "   Delete   ");
        this.setCreateButtons(4, this.setPropsIcon, "Set Properties");
        int i = 0;
        while (i <= 4) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.algoText.setText(" ");
    }

    public void createToolBarWithText() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createButModes = new JToggleButton[7];
        this.setCreateButtonsWithText(0, "Create Node", this.createNodeIcon, "Create Node");
        this.setCreateButtonsWithText(1, "Create Edge", this.createEdgeIcon, "Create Edge");
        this.setCreateButtonsWithText(2, "   Select   ", this.selectIcon, "Select");
        this.setCreateButtonsWithText(3, "   Delete   ", this.deleteIcon, "Delete");
        this.setCreateButtonsWithText(4, "Set Properties", this.setPropsIcon, "Set Properties");
        int i = 0;
        while (i <= 4) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.algoText.setText(" ");
    }

    protected void setCreateButtons(int num, ImageIcon icon, String toolTip) {
        this.createButModes[num] = new JToggleButton(icon);
        this.createButModes[num].setActionCommand(toolTip);
        this.createButModes[num].addActionListener(this);
        this.createButModes[num].setToolTipText(toolTip);
    }

    protected void setSolveButtons(int num, ImageIcon icon, String toolTip) {
        this.solveButModes[num] = new JToggleButton(icon);
        this.solveButModes[num].setActionCommand(toolTip);
        this.solveButModes[num].addActionListener(this);
        this.solveButModes[num].setToolTipText(toolTip);
    }

    protected void setCreateButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip) {
        this.createButModes[num] = new JToggleButton(buttonName, icon);
        this.createButModes[num].addActionListener(this);
        this.createButModes[num].setToolTipText(toolTip);
        this.createButModes[num].setVerticalTextPosition(3);
        this.createButModes[num].setHorizontalTextPosition(0);
    }

    protected void setSolveButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip) {
        this.solveButModes[num] = new JToggleButton(buttonName, icon);
        this.solveButModes[num].addActionListener(this);
        this.solveButModes[num].setToolTipText(toolTip);
        this.solveButModes[num].setVerticalTextPosition(3);
        this.solveButModes[num].setHorizontalTextPosition(0);
    }

    public void solveToolBar() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.solveButModes = new JToggleButton[9];
    }

    public void solveToolBarWithText() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.solveButModes = new JToggleButton[9];
    }

    public int getFontSize() {
        return this.fontSize;
    }

    private void randomGraph(int numNodes) {
        String label;
        this.graph = new Graph(this.returnCanvas());
        int i = 0;
        while (i < numNodes) {
            label = Integer.toString((int)(200.0 * Math.random()));
            int x = 150 - (int)(300.0 * Math.random());
            int y = 150 - (int)(300.0 * Math.random());
            int shape = 1110;
            Point p = new Point(x, y);
            Color color = Color.black;
            if (i % 4 == 0) {
                color = Color.red;
                shape = 1111;
            } else if (i % 4 == 1) {
                color = Color.blue;
                shape = 1112;
            } else if (i % 4 == 2) {
                color = Color.green;
                shape = 1110;
            }
            if (i == numNodes - 1) {
                p = new Point(0.0f, 0.0f);
            }
            Node n = new Node(this.graph, label, p, color, shape);
            this.graph.addNode(n);
            ++i;
        }
        i = 0;
        while (i < numNodes - 1) {
            label = "Edge #" + i;
            Node start = this.graph.nodeAt(i);
            Node end = this.graph.nodeAt(numNodes - 1);
            Color color = Color.black;
            if (i % 4 == 0) {
                color = Color.red;
            } else if (i % 4 == 1) {
                color = Color.blue;
            } else if (i % 4 == 2) {
                color = Color.green;
            }
            Edge e = new Edge(this.graph, label, start, end, color, 5551);
            this.graph.addEdge(e);
            ++i;
        }
    }

    private void loadPreset() {
        this.graph = new Graph(this.returnCanvas());
        String label1 = Integer.toString((int)(200.0 * Math.random()));
        int shape1 = 1110;
        Point p1 = new Point(0.0f, 0.0f);
        Color color1 = Color.blue;
        Node n1 = new Node(this.graph, label1, p1, color1, shape1);
        this.graph.addNode(n1);
        String label2 = Integer.toString((int)(200.0 * Math.random()));
        Point p2 = new Point(100.0f, 100.0f);
        Color color2 = Color.blue;
        int shape2 = shape1;
        Node n2 = new Node(this.graph, label2, p2, color2, shape2);
        this.graph.addNode(n2);
        String label3 = "Edge #1";
        Node start = this.graph.nodeAt(1);
        Node end = this.graph.nodeAt(0);
        Color color3 = Color.red;
        Edge e = new Edge(this.graph, label3, start, end, color2, 5551);
        this.graph.addEdge(e);
    }

    protected void getCanvas() {
        this.canvas = new GraphCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.canvas.addComponentListener(this);
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    protected GraphCanvas returnCanvas() {
        return this.canvas;
    }

    public void newTab(String str) {
        if (str == "Create") {
            this.setCreate();
        } else if (str == "Solve") {
            this.setSolve();
        }
    }

    public int getTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setPanZoom(int num) {
        Enumeration<AbstractButton> e = this.zpGroup.getElements();
        int i = 0;
        while (e.hasMoreElements()) {
            if (i == num) {
                ((JCheckBoxMenuItem)e.nextElement()).setSelected(true);
            } else {
                ((JCheckBoxMenuItem)e.nextElement()).setSelected(false);
            }
            ++i;
        }
    }

    public void setCreate() {
        this.returnCanvas().setMode(2220);
        this.tabbedPane.setComponentAt(0, this.emptyPanel1);
        this.tabbedPane.setComponentAt(1, this.emptyPanel2);
        this.tabbedPane.setComponentAt(0, this.canvasPanel);
        this.tabbedPane.setSelectedIndex(0);
        if (this.buttontext) {
            this.createToolBarWithText();
        } else {
            this.createToolBar();
        }
        this.returnCanvas().setSubmode(3332);
        this.createButModes[2].setSelected(true);
        this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
        this.componentResized = true;
        this.createnewgraph.setEnabled(true);
    }

    public void setSolve() {
        this.returnCanvas().setMode(2221);
        this.createnewgraph.setEnabled(false);
        this.tabbedPane.setComponentAt(0, this.emptyPanel1);
        this.tabbedPane.setComponentAt(1, this.emptyPanel2);
        this.tabbedPane.setComponentAt(1, this.canvasPanel);
        this.tabbedPane.setSelectedIndex(1);
        if (this.buttontext) {
            this.solveToolBarWithText();
        } else {
            this.solveToolBar();
        }
        this.componentResized = true;
    }

    public void setPromptLabel(String str) {
        this.messageCanvas.setText(str);
    }

    public String getExactPromptLabel() {
        return this.messageCanvas.getExactText();
    }

    public void setPromptColor(Color col) {
        this.messageCanvas.setTextColor(col);
    }

    public String getPromptLabel() {
        return this.messageCanvas.getText();
    }

    public void repaintTab() {
        this.tabbedPane.setSelectedIndex(0);
        this.newTab("Create");
        this.returnCanvas().repaint();
    }

    protected void saveProperties() {
        this.fontsize = this.returnCanvas().getFont().getSize();
        this.lF = this.largeFont.getState();
        this.mF = this.mediumFont.getState();
        this.sF = this.smallFont.getState();
        this.oF = this.otherFont.getState();
        this.linewidth = (int)this.returnCanvas().graph.getLineWidth();
        this.wL = this.wideLine.getState();
        this.mL = this.mediumLine.getState();
        this.nL = this.narrowLine.getState();
    }

    protected void restoreProperties() {
        this.wideLine.setState(this.wL);
        this.mediumLine.setState(this.mL);
        this.narrowLine.setState(this.nL);
        this.returnCanvas().graph.setLineWidth(this.linewidth);
        this.returnCanvas().changeLineWidth();
        this.returnCanvas().changeFont(this.fontsize);
        this.largeFont.setState(this.lF);
        this.mediumFont.setState(this.mF);
        this.smallFont.setState(this.sF);
        this.otherFont.setState(this.oF);
        if (this.returnCanvas().getMode() == 2220) {
            this.createButModes[0].setSelected(true);
            this.returnCanvas().setSubmode(3330);
            this.setPromptLabel("Click the canvas to create a node.");
        }
    }

    protected void loadsamplegraph() {
    }

    protected void opengraph() {
    }

    protected void createnewgraph() {
        this.returnCanvas().reset();
        this.returnCanvas().setSubmode(3330);
        this.createButModes[0].setSelected(true);
        this.setPromptLabel("Click the canvas to create a node.");
        this.returnCanvas().repaint();
    }

    protected void openlocation() {
    }

    protected void savegraph() {
    }

    public static void writeToLog(String arg) {
        Time time = new Time(System.currentTimeMillis());
        log = String.valueOf(log) + time.toString() + "   " + arg + "\n";
    }

    public static void writeToLogNoTime(String arg) {
        log = String.valueOf(log) + "                   " + arg + "\n";
    }

    public void setName(String name) {
        try {
            outLog = new PrintWriter(new BufferedWriter(new FileWriter("study/" + name)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        GraphWindow.writeToLog("Window Closing");
        outLog.print(log);
        ((Component)this).setVisible(false);
        outLog.close();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void setMessageCanvasFontSize(int size) {
        this.messageCanvas.setFontSize(size);
        this.messageCanvas.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (e.getSource() == this.loadsamplegraph || e.getSource() == this.opengraph || e.getSource() == this.openloc || e.getSource() == this.createnewgraph) {
            this.saveProperties();
            if (e.getSource() == this.loadsamplegraph) {
                this.loadsamplegraph();
            } else if (e.getSource() == this.opengraph) {
                this.opengraph();
            } else if (e.getSource() == this.openloc) {
                this.openlocation();
            } else if (e.getSource() == this.createnewgraph) {
                this.createnewgraph();
            }
            this.restoreProperties();
        } else if (e.getSource() == this.save) {
            this.savegraph();
        } else if (arg.equals("Create Node") || e.getSource() == this.createButModes[0]) {
            this.returnCanvas().setSubmode(3330);
            this.setPromptLabel("Click the canvas to create a node.");
        } else if (arg.equals("Create Edge") || e.getSource() == this.createButModes[1]) {
            this.returnCanvas().setSubmode(3331);
            this.setPromptLabel("Click on a node to start creating an edge.\nClick on another node to finish.\nYou can cancel edge creation by clicking on the canvas.");
        } else if (arg.equals("   Select   ") || e.getSource() == this.createButModes[2]) {
            this.returnCanvas().setSubmode(3332);
            this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
        } else if (arg.equals("   Delete   ") || e.getSource() == this.createButModes[3]) {
            this.returnCanvas().setSubmode(3333);
            this.setPromptLabel("Click on an entity to delete.");
        } else if (arg.equals("Set Properties") || e.getSource() == this.createButModes[4]) {
            this.returnCanvas().setSubmode(3334);
            this.setPromptLabel("Click on an entity to set its properties.");
        } else if (arg.equals("Extra Large (30 pt)")) {
            this.returnCanvas().changeFont(30);
            this.algoText.setFont(new Font("Arial", 1, 30));
            this.extraLargeFont.setState(true);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Large (20 pt)")) {
            this.returnCanvas().changeFont(20);
            this.algoText.setFont(new Font("Arial", 1, 20));
            this.extraLargeFont.setState(false);
            this.largeFont.setState(true);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Medium (12 pt)")) {
            this.returnCanvas().changeFont(12);
            this.algoText.setFont(new Font("Arial", 1, 15));
            this.extraLargeFont.setState(false);
            this.largeFont.setState(false);
            this.mediumFont.setState(true);
            this.smallFont.setState(false);
            this.otherFont.setState(false);
        } else if (arg.equals("Small (9 pt)")) {
            this.returnCanvas().changeFont(9);
            this.algoText.setFont(new Font("Arial", 1, 15));
            this.extraLargeFont.setState(false);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(true);
            this.otherFont.setState(false);
        } else if (arg.equals("others...")) {
            this.returnCanvas().changeFont(-1);
            this.extraLargeFont.setState(false);
            this.largeFont.setState(false);
            this.mediumFont.setState(false);
            this.smallFont.setState(false);
            this.otherFont.setState(true);
        } else if (arg.equals("Wide (4 pixels)")) {
            this.returnCanvas().graph.setLineWidth(4);
            this.returnCanvas().changeLineWidth();
            this.wideLine.setState(true);
            this.mediumLine.setState(false);
            this.narrowLine.setState(false);
        } else if (arg.equals("Medium (2 pixels)")) {
            this.returnCanvas().graph.setLineWidth(2);
            this.returnCanvas().changeLineWidth();
            this.wideLine.setState(false);
            this.mediumLine.setState(true);
            this.narrowLine.setState(false);
        } else if (arg.equals("Narrow (1 pixel)")) {
            this.returnCanvas().graph.setLineWidth(1);
            this.returnCanvas().changeLineWidth();
            this.wideLine.setState(false);
            this.mediumLine.setState(false);
            this.narrowLine.setState(true);
        } else if (!arg.equals("Show Control Panel")) {
            if (arg.equals("Show Message Panel")) {
                this.messageCanvas.setVisible(this.showMP.getState());
                this.validate();
            } else if (arg.equals("Show Button Text")) {
                this.buttontext = this.showText.getState();
                if (this.buttontext) {
                    if (this.tabbedPane.getSelectedIndex() == 0) {
                        this.createToolBarWithText();
                    } else {
                        this.solveToolBarWithText();
                    }
                } else if (this.tabbedPane.getSelectedIndex() == 0) {
                    this.createToolBar();
                } else {
                    this.solveToolBar();
                }
            } else if (arg.equals("Autoscale")) {
                this.returnCanvas().autoscale();
            } else if (arg.equals("Reset Labels")) {
                this.returnCanvas().resetLabels();
            } else if (arg.equals("Pan")) {
                this.returnCanvas().setRMode(4440);
                this.pan.setSelected(true);
                this.setPromptLabel("Drag the right mouse button to pan the graph.");
            } else if (arg.equals("Zoom")) {
                this.returnCanvas().setRMode(4441);
                this.zoom.setSelected(true);
                this.setPromptLabel("Drag the right mouse button up to zoom in and down to zoom out.");
            } else if (arg.equals("Create New Graph")) {
                this.createnewgraph();
            } else if (arg.equals("Create Random Graph")) {
                this.randomGraph(10);
                this.returnCanvas().setGraph(this.graph);
                this.returnCanvas().repaint();
            } else if (arg.equals("Show Buttons")) {
                if (this.showToolbar.getState()) {
                    this.toolBar.setVisible(true);
                } else {
                    this.toolBar.setVisible(false);
                }
            } else if (arg.equals("Print")) {
                this.returnCanvas().print("No Title");
            } else if (arg.equals("Quit")) {
                ((Component)this).setVisible(false);
                this.dispose();
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.componentResized) {
            this.returnCanvas().moveToMiddle();
        }
        this.componentResized = true;
    }

    public void componentShown(ComponentEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        String title = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        this.componentResized = false;
        this.newTab(title);
    }

    protected void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        int widthOffset = windowSize.width / 2;
        int heightOffset = windowSize.height / 2;
        ((Component)this).setLocation((int)centerPosition.x - widthOffset, (int)centerPosition.y - heightOffset);
    }

    public static void main(String[] args) {
        GraphWindow window = new GraphWindow(null);
    }
}

