/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.EdgeDialog;
import CIspace.graphToolKit.EdgeLabel;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.FontDialog;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.MessageDialog;
import CIspace.graphToolKit.MessageFrame;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.NodeDialog;
import CIspace.graphToolKit.Point;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class GraphCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
Printable,
KeyListener,
ActionListener {
    private Object programScroll;
    public int tempMode;
    protected Entity tempEnt;
    public Container parent;
    public Graph graph;
    public int WIDTH;
    public int HEIGHT;
    protected Font font;
    protected Point mClickedPos;
    protected Point mDraggedPos;
    protected Point mMovedPos;
    protected Point mPressedPos;
    protected Point mReleasedPos;
    protected boolean dragging;
    protected boolean moving;
    protected boolean clicked;
    protected boolean selected;
    protected Entity hover;
    protected Node from;
    protected Node to;
    protected int makingEdge;
    protected static final int NO = 0;
    protected static final int YES = 1;
    protected static final int DONE = 2;
    protected boolean makingNode;
    protected int submode;
    protected int mode;
    protected int rmode;
    protected NodeDialog nDialog;
    protected EdgeDialog eDialog;
    private boolean printing;
    public Point graphPoint;
    public float graphScale;
    private boolean popupShow = false;
    protected boolean zooming;
    protected boolean panning;
    protected float[] pzRect;
    public boolean pause = true;
    public boolean inline;
    public boolean moveable;
    public JPopupMenu pop;
    private MessageDialog md;
    private MessageFrame mf;
    protected int tmpMode;
    protected Entity entClicked;
    protected float scale;
    public boolean solveMode;
    public boolean ready = false;
    protected int blinkCount;

    public GraphCanvas(Container parent, boolean inline) {
        this.parent = parent;
        this.inline = inline;
        this.graph = new Graph(this);
        this.init();
    }

    public void init() {
        this.font = new Font("SansSerif", 0, 12);
        this.mode = 2220;
        this.submode = 3332;
        this.rmode = 4441;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setBackground(Color.white);
        this.pzRect = new float[4];
        this.clearMouse();
        this.pause = false;
        this.moveable = true;
        this.pop = new JPopupMenu();
        this.add(this.pop);
        this.tmpMode = -1;
        this.solveMode = false;
        this.blinkCount = 0;
        this.setVisible(true);
        this.setCanvasSize();
    }

    protected void popupCanvas(int x, int y) {
        JMenuItem mItem;
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Canvas Options"));
        if (this.mode == 2220) {
            mItem = new JMenuItem("Create Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.addSeparator();
        }
        mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Reset Edge Labels");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupNode(int x, int y) {
        if (this.mode == 2221) {
            this.popupCanvas(x, y);
            return;
        }
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        JMenuItem mItem = new JMenuItem("Create Edge");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Properties");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Delete Node");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Edge Options"));
        JMenuItem mItem = new JMenuItem("Properties");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Reset Edge Label");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Delete Edge");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    public void setCanvasSize() {
        this.WIDTH = this.getSize().width;
        this.HEIGHT = this.getSize().height;
        this.ready = true;
    }

    public void reset() {
        this.graph = new Graph(this);
        this.clearMouse();
        this.repaint();
    }

    public void showMessage(String title, String msg) {
        this.pause();
        if (this.inline) {
            if (this.mf == null) {
                this.mf = new MessageFrame(this.parent);
                this.mf.addActionListener(this);
            }
            this.mf.open(title, msg);
        } else {
            if (this.md == null) {
                this.md = new MessageDialog((JFrame)this.parent);
                this.md.addActionListener(this);
            }
            this.md.open(title, msg);
        }
    }

    public void clearMouse() {
        this.dragging = false;
        this.moving = false;
        this.clicked = false;
        this.selected = false;
        this.panning = false;
        this.zooming = false;
        this.mClickedPos = new Point();
        this.mDraggedPos = new Point();
        this.mMovedPos = new Point();
        this.mPressedPos = new Point();
        this.mReleasedPos = new Point();
        this.makingEdge = 0;
        this.makingNode = false;
        this.from = null;
        this.to = null;
        this.pzRect[0] = 0.0f;
        this.pzRect[1] = 0.0f;
        this.pzRect[2] = 0.0f;
        this.pzRect[3] = 0.0f;
        this.entClicked = null;
    }

    public void setGraph(Graph graph) {
        this.clearMouse();
        this.graph = graph;
        this.moveRandomGraphToMiddle();
        this.zoom(this.maximizingScale());
    }

    public void moveGraphToPoint(Point point) {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        float middleX = point.x;
        float middleY = point.y;
        float dx = Math.abs(middleX - (midX += min.x));
        float dy = Math.abs(middleY - (midY += min.y));
        if (midX <= middleX && midY <= middleY) {
            this.graph.translateAll(dx, dy);
        } else if (midX > middleX && midY <= middleY) {
            this.graph.translateAll(-dx, dy);
        } else if (midX > middleX && midY > middleY) {
            this.graph.translateAll(-dx, -dy);
        } else {
            this.graph.translateAll(dx, -dy);
        }
    }

    public void setMoveable(boolean movable) {
        this.moveable = movable;
    }

    public void changeFont(int size) {
        if (size == -1) {
            FontDialog fd = new FontDialog(this);
        } else {
            this.font = new Font("SansSerif", 0, size);
            ((GraphWindow)this.parent).setMessageCanvasFontSize(size);
        }
        this.graph.updateNodeSize();
        this.graph.updateEdgeSize();
        this.repaint();
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return ((Component)this).getFontMetrics(this.font);
    }

    public FontMetrics getFontMetricsForPrinting() {
        return ((Component)this).getFontMetrics(new Font("sans serif", 0, 9));
    }

    public void updateGraph() {
        this.graph.updateNodeSize();
        this.graph.updateEdgeSize();
        this.repaint();
    }

    public void changeLineWidth() {
        this.graph.updateNodeSize();
        this.repaint();
    }

    public void resetLabels() {
        this.graph.resetLabels();
        this.repaint();
    }

    public int getSubmode() {
        return this.submode;
    }

    public int getMode() {
        return this.mode;
    }

    protected float maximizingScale() {
        float visibleHeight;
        float visibleWidth;
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return 0.0f;
        }
        if (min.equals(max)) {
            return -1.0f;
        }
        if (!this.inline) {
            visibleWidth = ((GraphWindow)this.parent).scrollPanel.getWidth();
            visibleHeight = ((GraphWindow)this.parent).scrollPanel.getHeight();
        } else {
            visibleWidth = this.parent.getWidth();
            visibleHeight = this.parent.getHeight();
        }
        float graphWidth = max.x - min.x;
        float graphHeight = max.y - min.y;
        float widthRatio = visibleWidth / graphWidth;
        float heightRatio = visibleHeight / graphHeight;
        float ratio = Math.min(widthRatio, heightRatio);
        return ratio *= this.graph.getScale();
    }

    public float maximizingScaleForPrinting() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return 0.0f;
        }
        if (min.equals(max)) {
            return -1.0f;
        }
        float printingWidth = 450.0f;
        float printingHeight = 400.0f;
        float graphWidth = max.x - min.x;
        float graphHeight = max.y - min.y;
        float widthRatio = printingWidth / graphWidth;
        float heightRatio = printingHeight / graphHeight;
        float ratio = Math.min(widthRatio, heightRatio);
        return ratio *= this.graph.getScale();
    }

    public void zoom(float scale) {
        float middleY;
        float middleX;
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        midX += min.x;
        midY += min.y;
        if (!this.inline) {
            middleX = ((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2;
            middleY = ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2;
        } else {
            middleX = this.parent.getWidth() / 2;
            middleY = this.parent.getHeight() / 2;
        }
        float dx = Math.abs(middleX - midX);
        float dy = Math.abs(middleY - midY);
        this.graphScale = scale;
        this.graphPoint = new Point(midX, midY);
        this.graph.setScale(scale);
        this.moveGraphToPoint(new Point(midX, midY));
        this.repaint();
    }

    public void zoom() {
        float middleY;
        float middleX;
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        midX += min.x;
        midY += min.y;
        if (!this.inline) {
            middleX = ((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2;
            middleY = ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2;
        } else {
            middleX = this.getWidth() / 2;
            middleY = this.getHeight() / 2;
        }
        float dx = Math.abs(middleX - midX);
        float dy = Math.abs(middleY - midY);
        this.graph.setScale(this.graphScale);
        this.moveGraphToPoint(this.graphPoint);
        this.repaint();
    }

    public void zoomForPrinting() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        float middleX = ((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2;
        float middleY = ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2;
        float dx = Math.abs(middleX - (midX += min.x));
        float dy = Math.abs(middleY - (midY += min.y));
        this.graph.setScale(this.maximizingScaleForPrinting());
        this.moveGraphToPoint(new Point(300.0f, 275.0f));
    }

    public void moveToMiddle() {
        Point min = new Point(0.0f, 0.0f);
        Point max = new Point(((GraphWindow)this.parent).scrollPanel.getWidth(), ((GraphWindow)this.parent).scrollPanel.getHeight());
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        this.setCanvasSize();
        float dx = Math.abs((float)(((GraphWindow)this.parent).scrollPanel.getWidth() / 2) - midX);
        float dy = Math.abs((float)(((GraphWindow)this.parent).scrollPanel.getHeight() / 2) - midY);
        if (midX <= (float)(((GraphWindow)this.parent).scrollPanel.getWidth() / 2) && midY <= (float)(((GraphWindow)this.parent).scrollPanel.getHeight() / 2)) {
            this.graph.translateAll(dx, dy);
        } else if (midX > (float)(((GraphWindow)this.parent).scrollPanel.getWidth() / 2) && midY <= (float)(((GraphWindow)this.parent).scrollPanel.getHeight() / 2)) {
            this.graph.translateAll(-dx, dy);
        } else if (midX > (float)(((GraphWindow)this.parent).scrollPanel.getWidth() / 2) && midY > (float)(((GraphWindow)this.parent).scrollPanel.getHeight() / 2)) {
            this.graph.translateAll(-dx, -dy);
        } else {
            this.graph.translateAll(dx, -dy);
        }
    }

    public void moveRandomGraphToMiddle() {
        float middleY;
        float middleX;
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        midX += min.x;
        midY += min.y;
        if (!this.inline) {
            middleX = ((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2;
            middleY = ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2;
        } else {
            middleX = this.parent.getWidth() / 2;
            middleY = this.parent.getHeight() / 2;
        }
        float dx = Math.abs(middleX - midX);
        float dy = Math.abs(middleY - midY);
        if (midX <= middleX && midY <= middleY) {
            this.graph.translateAll(dx, dy);
        } else if (midX > middleX && midY <= middleY) {
            this.graph.translateAll(-dx, dy);
        } else if (midX > middleX && midY > middleY) {
            this.graph.translateAll(-dx, -dy);
        } else {
            this.graph.translateAll(dx, -dy);
        }
    }

    public void moveToTopMiddle() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        midY += min.y;
        float middleX = ((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2;
        float middleY = ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2;
        float dx = Math.abs(middleX - (midX += min.x));
        float dy = Math.abs(middleY + 40.0f);
        this.graph.translateAll(dx, dy);
    }

    public void moveToTopMiddleProofTree() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        midY += min.y;
        float middleX = this.getWidth() / 2;
        float middleY = this.getHeight() / 2;
        float dx = Math.abs(middleX - (midX += min.x));
        float dy = Math.abs(middleY + 20.0f);
        this.graph.translateAll(dx, dy);
    }

    public void autoscale() {
        this.zoom(this.maximizingScale());
        this.zoom(this.maximizingScale());
        this.zoom(this.maximizingScale());
        this.moveRandomGraphToMiddle();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawPrint(g2);
    }

    public void drawPrint(Graphics2D g2) {
        if (this.panning || this.zooming) {
            g2.setColor(Color.black);
            g2.drawRect((int)this.pzRect[0], (int)this.pzRect[1], (int)this.pzRect[2], (int)this.pzRect[3]);
        } else {
            this.graph.draw(g2, this.moving);
            if (this.dragging && !this.moving) {
                g2.setColor(Color.black);
                int x1 = (int)Math.min(this.mPressedPos.x, this.mDraggedPos.x);
                int y1 = (int)Math.min(this.mPressedPos.y, this.mDraggedPos.y);
                int w = (int)Math.abs(this.mPressedPos.x - this.mDraggedPos.x);
                int h = (int)Math.abs(this.mPressedPos.y - this.mDraggedPos.y);
                g2.drawRect(x1, y1, w, h);
            }
        }
        if (this.makingEdge == 1 || this.makingEdge == 2) {
            g2.setColor(Color.black);
            g2.drawLine((int)this.from.pos.x, (int)this.from.pos.y, (int)this.mMovedPos.x, (int)this.mMovedPos.y);
        }
        this.graph.draw(g2, this.moving);
    }

    public void setSubmode(int newMode) {
        this.submode = newMode;
        this.clearMouse();
        this.graph.deselectAll();
        this.repaint();
    }

    public void setMode(int newMode) {
        this.mode = newMode;
        this.solveMode = this.mode == 2221;
        this.clearMouse();
        this.graph.deselectAll();
    }

    public void setRMode(int newMode) {
        this.rmode = newMode;
    }

    public int getRMode() {
        return this.rmode;
    }

    public void pause() {
        this.pause = true;
    }

    public void unpause() {
        this.pause = false;
    }

    public void disposeWindows() {
        if (this.nDialog != null) {
            this.nDialog.dispose();
        }
        if (this.eDialog != null) {
            this.eDialog.dispose();
        }
        if (this.md != null) {
            this.md.dispose();
        }
        if (this.mf != null) {
            this.mf.dispose();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mClicked(e, e.isControlDown());
    }

    public void mouseEntered(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mExited(e);
    }

    public void mousePressed(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mPressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mReleased(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mDragged(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.mMoved(e);
    }

    protected void createNode(Entity ent, Point p) {
        if (ent == null || ent != null && ent.type != 7770) {
            this.makingNode = true;
            this.pause();
            if (this.nDialog == null) {
                this.nDialog = new NodeDialog(this);
            }
            this.nDialog.open(p);
            this.unpause();
            this.makingNode = false;
        }
    }

    protected void createEdge(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (ent == null || ent.type != 7770) {
                this.makingEdge = 0;
            } else if (ent.type == 7770) {
                this.pause();
                this.makingEdge = 2;
                this.to = (Node)ent;
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog(this);
                }
                this.eDialog.open(this.from, this.to);
                this.unpause();
                this.makingEdge = 0;
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
        } else if (ent != null && ent.type == 7770) {
            this.from = (Node)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    protected void setEntProperties(Entity ent) {
        if (ent != null) {
            this.pause();
            if (ent.type == 7770) {
                if (this.nDialog == null) {
                    this.nDialog = new NodeDialog(this);
                }
                this.nDialog.open((Node)ent);
                this.graph.updateNodeSize((Node)ent);
            } else if (ent.type == 7771) {
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog(this);
                }
                this.eDialog.open((Edge)ent);
            } else if (ent.type == 7772) {
                ent = ((EdgeLabel)ent).parent;
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog(this);
                }
                this.eDialog.open((Edge)ent);
            }
            this.unpause();
        }
    }

    protected void undo() {
    }

    protected void deleteEnt(Entity ent) {
        if (ent != null) {
            if (ent.type == 7772) {
                this.graph.select(((EdgeLabel)ent).parent);
            } else {
                this.graph.select(ent);
            }
            this.graph.deleteSelected();
            this.selected = false;
            this.clicked = false;
        }
    }

    protected void mPressedSelect(Entity ent, boolean ctrlDown) {
        if (ent != null) {
            this.clicked = ent.isSelected;
            this.selected = this.graph.select(ent);
            if (this.clicked && ent.type != 7771) {
                this.moving = true;
            }
        } else if (ctrlDown) {
            this.selected = this.graph.deselectAll();
        }
        this.repaint();
    }

    protected void mReleasedSelect(Entity ent, boolean ctrlDown) {
        if (this.dragging) {
            if (this.moving) {
                this.selected = this.graph.deselectAll();
            } else {
                float x1 = Math.min(this.mPressedPos.x, this.mReleasedPos.x);
                float y1 = Math.min(this.mPressedPos.y, this.mReleasedPos.y);
                float w = Math.abs(this.mPressedPos.x - this.mReleasedPos.x);
                float h = Math.abs(this.mPressedPos.y - this.mReleasedPos.y);
                Point a = new Point(x1, y1);
                Point b = new Point(x1 + w, y1 + h);
                Vector selectedEntities = this.graph.searchEntities(a, b);
                this.selected = this.graph.deselectAll();
                int i = 0;
                while (i < selectedEntities.size()) {
                    this.selected = this.graph.select((Entity)selectedEntities.elementAt(i));
                    ++i;
                }
            }
        } else if (ent != null) {
            if (ctrlDown) {
                if (this.clicked) {
                    this.selected = this.graph.deselect(ent);
                }
            } else {
                this.selected = this.clicked ? this.graph.deselect(ent) : this.graph.deselectAllButThis(ent);
            }
        }
        this.repaint();
    }

    protected void mDraggedSelect() {
        if (!this.dragging) {
            if (Math.abs(this.mPressedPos.x - this.mDraggedPos.x) > 5.0f || Math.abs(this.mPressedPos.y - this.mDraggedPos.y) > 5.0f) {
                this.dragging = true;
            }
            return;
        }
        if (this.hover != null && this.hover.type != 7771) {
            if (this.moving) {
                if (this.moveable) {
                    if (this.hover.type == 7770) {
                        this.graph.moveEntities(this.mDraggedPos, (Node)this.hover);
                    } else if (this.hover.type == 7772) {
                        this.graph.moveLabel(this.mDraggedPos, (EdgeLabel)this.hover);
                    }
                }
            } else if (this.selected) {
                this.moving = true;
                this.dragging = true;
            }
        }
        this.repaint();
    }

    protected Entity mClicked(MouseEvent e, boolean ctrlDown) {
        if (this.entClicked != null) {
            this.entClicked.isBold = false;
        }
        this.entClicked = null;
        Point p = new Point(e.getX(), e.getY());
        this.mClickedPos = new Point(p);
        this.entClicked = this.graph.searchEntities(p);
        if (e.getModifiers() == 4) {
            this.selected = this.graph.deselectAll();
            if (this.hover != null) {
                this.hover.isBold = false;
            }
            if (this.makingEdge == 1) {
                this.makingEdge = 0;
                this.submode = this.tmpMode;
                return this.entClicked;
            }
            if (this.entClicked == null) {
                this.popupCanvas(e.getX(), e.getY());
            } else {
                this.entClicked.isBold = true;
                this.clicked = true;
                this.selected = this.graph.select(this.entClicked);
                if (this.entClicked.type == 7770) {
                    this.popupNode(e.getX(), e.getY());
                } else if (this.entClicked.type == 7771) {
                    this.popupEdge(e.getX(), e.getY());
                } else if (this.entClicked.type == 7772) {
                    this.entClicked.isBold = false;
                    this.entClicked = ((EdgeLabel)this.entClicked).parent;
                    this.clicked = true;
                    this.selected = this.graph.deselectAll();
                    this.selected = this.graph.select(this.entClicked);
                    this.popupEdge(e.getX(), e.getY());
                }
            }
        }
        this.repaint();
        return this.entClicked;
    }

    protected Entity mPressed(MouseEvent e) {
        this.requestFocus();
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        this.mPressedPos.move(p);
        this.mDraggedPos.move(p);
        if (e.getModifiers() == 4) {
            return ent;
        }
        if (ent == null && !e.isControlDown()) {
            this.graph.deselectAll();
            if (this.pop.isVisible()) {
                this.pop.setVisible(false);
                return ent;
            }
        }
        if (this.mode == 2220) {
            if (this.submode == 3330) {
                this.createNode(ent, p);
            } else if (this.submode == 3331) {
                this.createEdge(ent, p);
            } else if (this.submode == 3332) {
                this.mPressedSelect(ent, e.isControlDown());
            } else if (this.submode == 3333) {
                if (ent != null) {
                    this.undo();
                    this.deleteEnt(ent);
                }
            } else if (this.submode == 3334) {
                if (ent != null) {
                    this.setEntProperties(ent);
                }
            } else if (this.submode == 3335 && ent == this.tempEnt) {
                this.mPressedSelect(ent, false);
            } else if (this.submode == 3335 && ent != this.tempEnt) {
                this.submode = this.tempMode;
            }
        } else if (this.mode == 2221) {
            this.mPressedSelect(ent, e.isControlDown());
        }
        this.repaint();
        return ent;
    }

    protected void mReleased(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        this.mReleasedPos.move(p);
        if (e.getModifiers() == 4) {
            if (this.moveable) {
                if (this.hover == null && this.dragging) {
                    float dx = p.x - this.mPressedPos.x;
                    float dy = p.y - this.mPressedPos.y;
                    if (this.rmode == 4440) {
                        this.graph.translateAll(dx, dy);
                    } else if (this.rmode == 4441) {
                        float scale = this.graph.getScale();
                        if ((double)(scale *= 1.0f - dy / 100.0f) < 0.1) {
                            scale = 0.1f;
                        }
                        this.zoom(scale);
                    }
                }
                this.panning = false;
                this.zooming = false;
            }
        } else if (this.mode == 2220) {
            if (this.submode != 3330 && this.submode != 3331 && this.submode == 3332) {
                this.mReleasedSelect(ent, e.isControlDown());
            }
        } else if (this.mode == 2221) {
            this.mReleasedSelect(ent, e.isControlDown());
        }
        this.dragging = false;
        this.moving = false;
        this.mDraggedPos.move(0.0f, 0.0f);
        this.repaint();
    }

    protected void mEntered(MouseEvent e) {
        this.repaint();
    }

    protected void mExited(MouseEvent e) {
        this.repaint();
    }

    protected void mDragged(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.mDraggedPos.move(p);
        Entity ent = this.graph.searchEntities(p);
        if (e.getModifiers() == 4 && this.moveable) {
            if (!this.dragging) {
                if (Math.abs(this.mPressedPos.x - p.x) > 5.0f || Math.abs(this.mPressedPos.y - p.y) > 5.0f) {
                    this.dragging = true;
                }
                if (this.hover != null) {
                    this.dragging = false;
                }
                this.repaint();
                return;
            }
            Point[] bounds = this.graph.getBound();
            float dx = p.x - this.mPressedPos.x;
            float dy = p.y - this.mPressedPos.y;
            if (this.rmode == 4440) {
                this.panning = true;
                this.pzRect[0] = bounds[0].x + dx;
                this.pzRect[1] = bounds[0].y + dy;
                this.pzRect[2] = bounds[1].x - bounds[0].x;
                this.pzRect[3] = bounds[1].y - bounds[0].y;
            } else if (this.rmode == 4441) {
                this.zooming = true;
                Point center = !this.inline ? new Point(((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2, ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2) : new Point(this.getWidth() / 2, this.getHeight() / 2);
                float maxDistX = Math.abs(bounds[0].x - center.x) < Math.abs(bounds[1].x - center.x) ? Math.abs(bounds[1].x - center.x) : Math.abs(bounds[0].x - center.x);
                float maxDistY = Math.abs(bounds[0].y - center.y) < Math.abs(bounds[1].y - center.y) ? Math.abs(bounds[1].y - center.y) : Math.abs(bounds[0].y - center.y);
                this.pzRect[2] = 2.0f * maxDistX * (1.0f - dy / 100.0f);
                this.pzRect[3] = 2.0f * maxDistY * (1.0f - dy / 100.0f);
                this.pzRect[0] = center.x - Math.abs(maxDistX) + (2.0f * maxDistX - this.pzRect[2]) / 2.0f;
                this.pzRect[1] = center.y - Math.abs(maxDistY) + (2.0f * maxDistY - this.pzRect[3]) / 2.0f;
            }
        } else if (this.mode == 2220) {
            if (this.submode != 3330 && this.submode != 3331) {
                if (this.submode == 3332) {
                    this.mDraggedSelect();
                } else if (this.submode == 3335 && ent == this.tempEnt) {
                    this.mDraggedSelect();
                } else if (this.submode == 3335 && ent != this.tempEnt) {
                    this.submode = this.tempMode;
                }
            }
        } else if (this.mode == 2221) {
            this.mDraggedSelect();
        }
        this.repaint();
    }

    protected void mMoved(MouseEvent e) {
        if (!this.ready) {
            return;
        }
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (ent == null || ent != this.hover && this.hover != null) {
            if (this.hover != null) {
                this.hover.isBold = false;
                this.hover = null;
                this.repaint();
            }
        } else if (this.hover != ent) {
            this.hover = ent;
            this.hover.isBold = true;
            this.repaint();
        }
        if (this.submode != 3330 && this.submode == 3331) {
            if (this.makingEdge != 0 && this.makingEdge == 1) {
                this.mMovedPos.move(p);
            }
            this.repaint();
        }
        this.repaint();
    }

    public void keyPressed(KeyEvent e) {
        if (this.pause) {
            return;
        }
        this.kPressed(e);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void kPressed(KeyEvent e) {
        if (this.mode == 2221) {
            return;
        }
        int arg = e.getKeyCode();
        if (arg == 127) {
            this.graph.deleteSelected();
            this.repaint();
        }
        if (arg == 27) {
            this.makingEdge = 0;
            this.submode = this.tmpMode;
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.aPerformed(e);
        this.repaint();
    }

    protected void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("msgBoxClosed")) {
            this.unpause();
        } else if (this.pause) {
            return;
        }
        if (arg.equals("Create Node")) {
            this.createNode(this.entClicked, this.mClickedPos);
        } else if (arg.equals("Create Edge")) {
            this.createEdge(this.entClicked, this.mClickedPos);
            this.tmpMode = this.submode;
            this.submode = 3331;
        } else if (!(arg.equals("Set Properties of Edge") || arg.equals("Properties") || arg.equals("Set Properties of Node"))) {
            if (arg.equals("Set Properties of Entity") || arg.equals("Properties") || arg.equals("Set Properties of Node") || arg.equals("Set Properties of Variable") || arg.equals("Set Properties of Constraint")) {
                this.tempMode = this.submode;
                this.submode = 3334;
                this.setEntProperties(this.entClicked);
                this.submode = this.tempMode;
            } else if (!(arg.equals("Delete") || arg.equals("Delete Node") || arg.equals("Delete Edge"))) {
                if (arg.equals("Delete Node") || arg.equals("Delete Entity") || arg.equals("Delete Arc") || arg.equals("Delete Variable") || arg.equals("Delete Constraint")) {
                    this.tempMode = this.submode;
                    this.submode = 3333;
                    this.deleteEnt(this.entClicked);
                    this.submode = this.tempMode;
                } else if (!(arg.equals("Select Entity") || arg.equals("Select Node") || arg.equals("Select Edge"))) {
                    if (arg.equals("Select Node") || arg.equals("Select Entity") || arg.equals("Select Variable") || arg.equals("Select Constraint")) {
                        this.tempEnt = this.entClicked;
                        this.tempMode = this.submode;
                        this.submode = 3335;
                    } else if (arg.equals("Autoscale")) {
                        this.autoscale();
                    } else if (arg.equals("Reset Edge Labels")) {
                        this.resetLabels();
                    } else if (arg.equals("Reset Edge Label")) {
                        this.graph.resetLabel((Edge)this.entClicked);
                        this.repaint();
                    }
                }
            }
        }
        this.graph.deselectAll();
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        this.zoomForPrinting();
        this.drawPrint((Graphics2D)g);
        return 0;
    }

    public void print(String title) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

