/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.GraphCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FontDialog
extends JDialog
implements ActionListener {
    private JTextField tf;
    private GraphCanvas canvas;

    public FontDialog(GraphCanvas parent) {
        super((JFrame)parent.parent, "Choose Font Size", true);
        this.canvas = parent;
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        JLabel label = new JLabel("Font Size:");
        this.tf = new JTextField(String.valueOf(this.canvas.getFont().getSize()) + "", 3);
        this.tf.addActionListener(this);
        JPanel north = new JPanel();
        north.add(label);
        north.add(this.tf);
        JPanel south = new JPanel();
        south.add(ok);
        south.add(cancel);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", north);
        contentPane.add("South", south);
        this.pack();
        this.centerWindow();
        this.show();
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (!arg.equals("Cancel")) {
            try {
                int fontSize = Integer.valueOf(this.tf.getText());
                if (fontSize < 1) {
                    fontSize = 1;
                }
                this.canvas.changeFont(fontSize);
            }
            catch (Exception err) {
                System.out.println(err);
            }
        }
        this.dispose();
    }
}

