/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robotProlog;

import CIspace.graphToolKit.Point;
import CIspace.prolog.Functor;
import CIspace.prolog.Goal;
import CIspace.prolog.Predicate;
import CIspace.prolog.Term;
import CIspace.robot.Environment;
import CIspace.robot.InvisibleNode;
import CIspace.robot.RobotEdge;
import CIspace.robot.RobotNode;
import CIspace.robotProlog.RobotPredicate;
import CIspace.robotProlog.RobotProgram;
import CIspace.robotProlog.RobotRule;
import CIspace.robotProlog.RobotTerm;
import java.util.Hashtable;
import java.util.Vector;

public class RobotGoal
extends Goal {
    public boolean fail = false;
    public RobotGoal parent;
    public Vector children = new Vector();
    public int tabnum;
    public double timestep;
    public int sentsignal = RobotProgram.parsingLayer;

    public RobotGoal(Predicate p) {
        super(p);
    }

    public RobotGoal(Predicate p, Term[] newTerms) {
        super((RobotPredicate)p, (Term[])((RobotTerm[])newTerms));
    }

    public RobotGoal(String name, Term[] newTerms) {
        super(name, (Term[])((RobotTerm[])newTerms));
    }

    public RobotGoal(int builtin, Term[] newTerms) {
        super(builtin, (Term[])((RobotTerm[])newTerms));
    }

    public RobotGoal(Goal g) {
        super((RobotGoal)g);
    }

    protected Goal makeGoal(Predicate p) {
        return new RobotGoal((RobotPredicate)p);
    }

    protected Goal makeGoal(Predicate p, Term[] newTerms) {
        return new RobotGoal((RobotPredicate)p, (Term[])((RobotTerm[])newTerms));
    }

    protected Goal makeGoal(String name, Term[] newTerms) {
        return new RobotGoal(name, (Term[])((RobotTerm[])newTerms));
    }

    protected Goal makeGoal(int builtin, Term[] newTerms) {
        return new RobotGoal(builtin, (Term[])((RobotTerm[])newTerms));
    }

    protected Goal makeGoal(Goal g) {
        return new RobotGoal((RobotGoal)g);
    }

    protected Predicate makePredicate(String name, int arity) {
        return new RobotPredicate(name, arity);
    }

    protected Predicate makePredicate() {
        return new RobotPredicate();
    }

    protected Term[] makeTerms(int arity) {
        return new RobotTerm[arity];
    }

    protected Term makeTerm(Term t) {
        return new RobotTerm((RobotTerm)t);
    }

    protected Term makeTerm(Functor f, Term[] terms) {
        return new RobotTerm(f, (RobotTerm[])terms);
    }

    protected Term makeTerm(String s) {
        return new RobotTerm(s);
    }

    public Goal solve() {
        if (!this.pred.builtIn()) {
            return null;
        }
        if (this.pred.getType() == 101) {
            return this.prove_seeblock();
        }
        if (this.pred.getType() == 102) {
            return this.prove_notseeblock();
        }
        if (this.pred.getType() == 105) {
            return this.prove_at();
        }
        if (this.pred.getType() == 104) {
            return this.prove_was();
        }
        return super.solve();
    }

    public RobotGoal prove_was() {
        RobotTerm fluent = (RobotTerm)this.terms[0];
        RobotTerm value = (RobotTerm)this.terms[1];
        RobotTerm oldTime = (RobotTerm)this.terms[2];
        RobotTerm newTime = (RobotTerm)this.terms[3];
        Double T = newTime.lastUnified().solveArithmetic();
        Hashtable proved = RobotProgram.getCurrentTime() != 0.0 ? RobotProgram.getpreviousAssigned() : RobotProgram.getcurrentAssigned();
        RobotRule currRule = null;
        currRule = (RobotRule)proved.get(fluent.getName());
        if (currRule != null) {
            RobotTerm oldvalue = (RobotTerm)currRule.ruleHead().getTerms()[1].lastUnified();
            RobotTerm oldtime = (RobotTerm)currRule.ruleHead().getTerms()[2];
            RobotTerm newvalue = (RobotTerm)value.lastUnified().unify(oldvalue, true);
            RobotTerm newoldtime = (RobotTerm)oldtime.lastUnified().unify(oldTime, true);
            if (newvalue == null && !fluent.name.equals("to_do")) {
                return null;
            }
            return this;
        }
        return null;
    }

    public RobotGoal prove_seeblock() {
        double y1;
        double dir;
        double dist;
        double x1;
        double y;
        Double xval = this.terms[0].lastUnified().solveArithmetic();
        Double yval = this.terms[1].lastUnified().solveArithmetic();
        Double distval = this.terms[2].lastUnified().solveArithmetic();
        Double dirval = this.terms[3].lastUnified().solveArithmetic();
        double x = xval;
        if (RobotGoal.intersectedWithWall(new Point((float)x, (float)(y = yval.doubleValue())), new Point((float)(x1 = x + (dist = distval.doubleValue()) * Math.cos((dir = dirval.doubleValue()) * Math.PI / 180.0)), (float)(y1 = y + dist * Math.sin(dir * Math.PI / 180.0))))) {
            return this;
        }
        return null;
    }

    public RobotGoal prove_notseeblock() {
        double y1;
        double dir;
        double dist;
        double x1;
        double y;
        Double xval = this.terms[0].lastUnified().solveArithmetic();
        Double yval = this.terms[1].lastUnified().solveArithmetic();
        Double distval = this.terms[2].lastUnified().solveArithmetic();
        Double dirval = this.terms[3].lastUnified().solveArithmetic();
        double x = xval;
        if (!RobotGoal.intersectedWithWall(new Point((float)x, (float)(y = yval.doubleValue())), new Point((float)(x1 = x + (dist = distval.doubleValue()) * Math.cos((dir = dirval.doubleValue()) * Math.PI / 180.0)), (float)(y1 = y + dist * Math.sin(dir * Math.PI / 180.0))))) {
            return this;
        }
        return null;
    }

    public RobotGoal prove_at() {
        String locname = this.terms[0].lastUnified().getName();
        boolean intersected = false;
        int scale = Environment.pixelsPerUnit;
        Vector nodes = RobotProgram.getGraph().getNodesVector();
        int i = 0;
        while (i < nodes.size()) {
            RobotNode node = (RobotNode)nodes.elementAt(i);
            if (locname.equals(node.getName())) {
                Point pos = node.getCartesianPos();
                Term[] newTerms = this.makeTerms(2);
                Term Xpos = this.makeTerm(new Float(pos.x / (float)scale).toString());
                Term Ypos = this.makeTerm(new Float(pos.y / (float)scale).toString());
                newTerms[0] = Xpos;
                newTerms[1] = Ypos;
                this.terms[1].lastUnified().unify(this.makeTerm(new Functor("", newTerms.length), newTerms), true);
                return this;
            }
            ++i;
        }
        return null;
    }

    public static boolean intersectedWithWall(Point posA, Point posB) {
        if (RobotProgram.getGraph() == null) {
            System.out.println("Error: graph is null!");
            return false;
        }
        boolean intersected = false;
        int scale = Environment.pixelsPerUnit;
        Vector edges = RobotProgram.getGraph().getEdgesVector();
        Point from = null;
        Point to = null;
        int count = 0;
        while (!intersected && count < edges.size()) {
            RobotEdge edge = (RobotEdge)edges.elementAt(count);
            InvisibleNode head = (InvisibleNode)edge.start;
            InvisibleNode tail = (InvisibleNode)edge.end;
            to = head.getCartesianPos();
            from = tail.getCartesianPos();
            intersected = RobotGoal.intersect(posA, posB, new Point(from.x / (float)scale, from.y / (float)scale), new Point(to.x / (float)scale, to.y / (float)scale));
            ++count;
        }
        return intersected;
    }

    public static boolean intersect(Point u, Point v, Point w, Point z) {
        Point a = new Point(u.x, u.y);
        Point b = new Point(v.x, v.y);
        Point c = new Point(w.x, w.y);
        Point d = new Point(z.x, z.y);
        if ((double)Math.abs(a.x - b.x) < 0.01) {
            b.x = (float)((double)b.x + 0.1);
        }
        if ((double)Math.abs(a.y - b.y) < 0.01) {
            b.y = (float)((double)b.y + 0.1);
        }
        if ((double)Math.abs(c.x - d.x) < 0.01) {
            d.x = (float)((double)d.x + 0.1);
        }
        if ((double)Math.abs(c.y - d.y) < 0.01) {
            d.y = (float)((double)d.y + 0.1);
        }
        double denom = (a.x - b.x) * (c.y - d.y) - (a.y - b.y) * (c.x - d.x);
        double determAB = a.x * b.y - a.y * b.x;
        double determCD = c.x * d.y - c.y * d.x;
        double numerX = determAB * (double)(c.x - d.x) - (double)(a.x - b.x) * determCD;
        double numerY = determAB * (double)(c.y - d.y) - (double)(a.y - b.y) * determCD;
        double intersectX = numerX / denom;
        double intersectY = numerY / denom;
        boolean inside = (double)Math.min(a.x, b.x) <= intersectX && intersectX <= (double)Math.max(a.x, b.x) && (double)Math.min(a.y, b.y) <= intersectY && intersectY <= (double)Math.max(a.y, b.y) && (double)Math.min(c.x, d.x) <= intersectX && intersectX <= (double)Math.max(c.x, d.x) && (double)Math.min(c.y, d.y) <= intersectY && intersectY <= (double)Math.max(c.y, d.y);
        return inside;
    }

    public String toString() {
        String str = new String();
        int i = 0;
        while (i < this.tabnum) {
            str = String.valueOf(str) + "     ";
            ++i;
        }
        if (this.pred.builtIn()) {
            String name = "";
            boolean robotPred = true;
            switch (this.pred.getType()) {
                case 101: {
                    name = "seeblock";
                    break;
                }
                case 102: {
                    name = "notseeblock";
                    break;
                }
                case 104: {
                    name = "was";
                    break;
                }
                case 105: {
                    name = "at";
                    break;
                }
                default: {
                    robotPred = false;
                }
            }
            if (robotPred) {
                str = String.valueOf(str) + name;
                str = String.valueOf(str) + "( ";
                int i2 = 0;
                while (i2 < this.terms.length) {
                    str = String.valueOf(str) + this.terms[i2].toString();
                    if (i2 != this.terms.length - 1) {
                        str = String.valueOf(str) + ", ";
                    }
                    ++i2;
                }
                str = String.valueOf(str) + ")";
                return str;
            }
            String goalstr = super.toString();
            str = String.valueOf(str) + goalstr;
            return str;
        }
        String goalstr = super.toString();
        str = String.valueOf(str) + goalstr;
        return str;
    }

    public String printString() {
        if (this.pred.builtIn()) {
            String name = "";
            boolean robotPred = true;
            switch (this.pred.getType()) {
                case 101: {
                    name = "seeblock";
                    break;
                }
                case 102: {
                    name = "notseeblock";
                    break;
                }
                case 104: {
                    name = "was";
                    break;
                }
                case 105: {
                    name = "at";
                    break;
                }
                default: {
                    robotPred = false;
                }
            }
            if (robotPred) {
                String str = name;
                str = String.valueOf(str) + "( ";
                int i = 0;
                while (i < this.terms.length) {
                    str = String.valueOf(str) + this.terms[i].printString();
                    if (i != this.terms.length - 1) {
                        str = String.valueOf(str) + ", ";
                    }
                    ++i;
                }
                str = String.valueOf(str) + ")";
                return str;
            }
            return super.printString();
        }
        return super.printString();
    }

    public String signalString() {
        String termsString;
        String signalString = this.getPredicate().getName();
        if (this.getPredicate().toString().equals("assign/3")) {
            termsString = "";
            String key = this.getTerms()[0].name;
            if (!((RobotGoal)((RobotRule)RobotProgram.getcurrentAssigned().get((Object)key)).head).fail) {
                String value = ((RobotRule)RobotProgram.getcurrentAssigned().get((Object)key)).head.getTerms()[1].lastUnified().toString();
                termsString = String.valueOf(termsString) + "\t" + key + " = " + value + "    ";
            }
        } else {
            termsString = "";
            boolean firstTerm = true;
            int i = 0;
            while (i < ((RobotPredicate)this.getPredicate()).termNames.size()) {
                String currterm = ((RobotPredicate)this.getPredicate()).termNames.elementAt(i).toString();
                if (firstTerm) {
                    if (currterm.equals("_constant_")) {
                        termsString = String.valueOf(termsString) + "   D= " + this.terms[i].lastUnified();
                    } else if (!currterm.equals("T")) {
                        termsString = String.valueOf(termsString) + "   " + currterm + " = " + this.terms[i].lastUnified();
                    }
                    firstTerm = false;
                } else if (currterm.equals("_constant_")) {
                    termsString = String.valueOf(termsString) + ",   D = " + this.terms[i].lastUnified();
                } else if (!currterm.equals("T")) {
                    termsString = String.valueOf(termsString) + ",   " + currterm + " = " + this.terms[i].lastUnified();
                }
                ++i;
            }
        }
        if (termsString != "") {
            signalString = String.valueOf(signalString) + ":  ";
            signalString = String.valueOf(signalString) + termsString;
        }
        return signalString;
    }

    public Integer getOrigin(RobotGoal currgoal) {
        int i = 0;
        while (i < currgoal.getPredicate().getRules().size()) {
            RobotGoal headgoal = (RobotGoal)((RobotRule)currgoal.getPredicate().getRules().elementAt((int)i)).head;
            if (currgoal.canunify(headgoal, false)) {
                Integer in = new Integer(headgoal.sentsignal);
                return in;
            }
            ++i;
        }
        return new Integer(0);
    }
}

