/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robotProlog;

import CIspace.robotProlog.RobotGoal;
import CIspace.robotProlog.RobotPredicate;
import CIspace.robotProlog.RobotProgram;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.table.TableColumn;

public class Debugger
implements ActionListener {
    private JButton clearButton;
    private JButton whyNotHelp;
    private JButton whyHelp;
    private JButton howHelp;
    private JButton askHelp;
    private JLabel whyNotErrorLabel;
    private int morefailgoalsindex;
    private JButton whyNotNumberEnter;
    private JTextField whyNotNumberField;
    private JButton whyNotMoreButton;
    private Vector displayTableData;
    private JPanel buttonPanel;
    private JLabel howErrorLabel;
    private JButton whyButton;
    private JButton whyNotEnter;
    private JTextField whyNotField;
    private JButton whyEnter;
    private JTextField whyField;
    private JSplitPane splitPane;
    private JButton openDebugButton;
    private GridBagConstraints gbc;
    protected GridBagLayout gbl;
    private JPanel debugPanel;
    private JPanel tracePanel;
    private JButton okButton;
    private JTextField gotoText;
    private JLabel errorLabel;
    private RobotGoal querygoal;
    private JButton moreButton;
    private JButton askEnter;
    private JButton howEnter;
    private JTextField askField;
    private JTextField howField;
    public RobotProgram program;
    public JFrame debugFrame = new JFrame("Trace & Debug");
    public JTable table;
    private JScrollPane debugScroll;
    private JScrollPane traceScroll;
    public Vector columnNames;
    public Vector tableData;
    public int tableDataSize = 1000;
    private int moregoalsindex = 0;
    private Vector howgoals = new Vector();
    private Vector whynotgoals = new Vector();
    private JTextArea textArea;
    private JTabbedPane queryPane;
    private JButton whyNotWhyHelp;
    private JButton whyNotWhyButton;
    private JButton whynotHowHelp;
    private JTextField whynotHowField;
    private JButton whynotHowEnter;
    private JLabel whynotHowErrorLabel;
    static /* synthetic */ Class class$0;

    public Debugger(RobotProgram program) {
        this.program = program;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.debugScroll = new JScrollPane(this.textArea, 22, 30);
        this.debugScroll.setSize(new Dimension(400, 500));
        this.debugScroll.setVisible(true);
        this.queryPane = new JTabbedPane();
        UIManager.put("TabbedPane.selected", Color.lightGray);
        BasicTabbedPaneUI tPane = new BasicTabbedPaneUI();
        this.queryPane.setUI(new BasicTabbedPaneUI(){

            public void paintComponent(Graphics g, JComponent c) {
                this.focus = Color.lightGray;
                super.paint(g, c);
            }
        });
        JPanel queryPanel = new JPanel();
        queryPanel.setLayout(new BoxLayout(queryPanel, 1));
        JPanel askPanel = new JPanel();
        askPanel.setLayout(new BoxLayout(askPanel, 0));
        askPanel.add(new JLabel("Ask:          "));
        this.askHelp = new JButton("?");
        this.askHelp.addActionListener(this);
        askPanel.add(this.askHelp);
        this.askField = new JTextField(30);
        this.askField.setMaximumSize(new Dimension(100, 25));
        askPanel.add(this.askField);
        this.askEnter = new JButton("Enter");
        this.askEnter.addActionListener(this);
        askPanel.add(this.askEnter);
        this.moreButton = new JButton("More");
        this.moreButton.addActionListener(this);
        askPanel.add(this.moreButton);
        askPanel.add(Box.createHorizontalGlue());
        queryPanel.add(askPanel);
        JPanel howPanel = new JPanel();
        howPanel.setLayout(new BoxLayout(howPanel, 0));
        howPanel.add(new JLabel("How:         "));
        this.howHelp = new JButton("?");
        this.howHelp.addActionListener(this);
        howPanel.add(this.howHelp);
        this.howField = new JTextField(3);
        this.howField.setMaximumSize(new Dimension(100, 25));
        howPanel.add(this.howField);
        this.howEnter = new JButton("Enter");
        this.howEnter.addActionListener(this);
        howPanel.add(this.howEnter);
        this.howErrorLabel = new JLabel("Invalid entry.");
        this.howErrorLabel.setForeground(Color.red);
        howPanel.add(this.howErrorLabel);
        this.howErrorLabel.setVisible(false);
        howPanel.add(Box.createHorizontalGlue());
        queryPanel.add(howPanel);
        JPanel whyPanel = new JPanel();
        whyPanel.setLayout(new BoxLayout(whyPanel, 0));
        whyPanel.add(new JLabel("Why?         "));
        this.whyHelp = new JButton("?");
        this.whyHelp.addActionListener(this);
        whyPanel.add(this.whyHelp);
        this.whyButton = new JButton("Enter");
        this.whyButton.addActionListener(this);
        whyPanel.add(this.whyButton);
        whyPanel.add(Box.createHorizontalGlue());
        queryPanel.add(whyPanel);
        this.queryPane.addTab("Ask", null, queryPanel, "Click to Ask a Query");
        this.queryPane.setSelectedIndex(0);
        JPanel whyNotQueryPanel = new JPanel();
        whyNotQueryPanel.setLayout(new BoxLayout(whyNotQueryPanel, 1));
        JPanel whyNotPanel = new JPanel();
        whyNotPanel.setLayout(new BoxLayout(whyNotPanel, 0));
        whyNotPanel.add(new JLabel("Why Not:   "));
        this.whyNotHelp = new JButton("?");
        this.whyNotHelp.addActionListener(this);
        whyNotPanel.add(this.whyNotHelp);
        this.whyNotField = new JTextField(30);
        this.whyNotField.setMaximumSize(new Dimension(100, 25));
        whyNotPanel.add(this.whyNotField);
        this.whyNotEnter = new JButton("Enter");
        this.whyNotEnter.addActionListener(this);
        whyNotPanel.add(this.whyNotEnter);
        this.whyNotMoreButton = new JButton("More");
        this.whyNotMoreButton.addActionListener(this);
        whyNotPanel.add(this.whyNotMoreButton);
        whyNotPanel.add(new JLabel("Explain: "));
        this.whyNotNumberField = new JTextField(3);
        this.whyNotNumberField.setMaximumSize(new Dimension(100, 25));
        whyNotPanel.add(this.whyNotNumberField);
        this.whyNotNumberEnter = new JButton("Enter");
        this.whyNotNumberEnter.addActionListener(this);
        whyNotPanel.add(this.whyNotNumberEnter);
        this.whyNotErrorLabel = new JLabel("Invalid entry.");
        this.whyNotErrorLabel.setForeground(Color.red);
        whyNotPanel.add(this.whyNotErrorLabel);
        this.whyNotErrorLabel.setVisible(false);
        whyNotPanel.add(Box.createHorizontalGlue());
        whyNotQueryPanel.add(whyNotPanel);
        JPanel whynotHowPanel = new JPanel();
        whynotHowPanel.setLayout(new BoxLayout(whynotHowPanel, 0));
        whynotHowPanel.add(new JLabel("How:         "));
        this.whynotHowHelp = new JButton("?");
        this.whynotHowHelp.addActionListener(this);
        whynotHowPanel.add(this.whynotHowHelp);
        this.whynotHowField = new JTextField(3);
        this.whynotHowField.setMaximumSize(new Dimension(100, 25));
        whynotHowPanel.add(this.whynotHowField);
        this.whynotHowEnter = new JButton("Enter");
        this.whynotHowEnter.addActionListener(this);
        whynotHowPanel.add(this.whynotHowEnter);
        this.whynotHowErrorLabel = new JLabel("Invalid entry.");
        this.whynotHowErrorLabel.setForeground(Color.red);
        whynotHowPanel.add(this.whynotHowErrorLabel);
        this.whynotHowErrorLabel.setVisible(false);
        whynotHowPanel.add(Box.createHorizontalGlue());
        whyNotQueryPanel.add(whynotHowPanel);
        JPanel whyNotWhyPanel = new JPanel();
        whyNotWhyPanel.setLayout(new BoxLayout(whyNotWhyPanel, 0));
        whyNotWhyPanel.add(new JLabel("Why?         "));
        this.whyNotWhyHelp = new JButton("?");
        this.whyNotWhyHelp.addActionListener(this);
        whyNotWhyPanel.add(this.whyNotWhyHelp);
        this.whyNotWhyButton = new JButton("Enter");
        this.whyNotWhyButton.addActionListener(this);
        whyNotWhyPanel.add(this.whyNotWhyButton);
        whyNotWhyPanel.add(Box.createHorizontalGlue());
        whyNotQueryPanel.add(whyNotWhyPanel);
        this.queryPane.addTab("Why Not", null, whyNotQueryPanel, "Click to Ask Why Not");
        this.queryPane.setMaximumSize(new Dimension(2000, 100));
        this.debugPanel = new JPanel();
        this.debugPanel.setLayout(new BoxLayout(this.debugPanel, 1));
        JPanel clearButtonPanel = new JPanel();
        clearButtonPanel.setLayout(new BoxLayout(clearButtonPanel, 0));
        clearButtonPanel.add(Box.createHorizontalGlue());
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(this);
        clearButtonPanel.add(this.clearButton);
        this.debugPanel.add(this.debugScroll);
        this.debugPanel.add(clearButtonPanel);
        this.debugPanel.add(this.queryPane);
        this.columnNames = new Vector(4);
        this.columnNames.add(new String("Line #"));
        this.columnNames.add(new String("Trace"));
        this.columnNames.add(new String(""));
        this.columnNames.add(new String("Substitution"));
        this.tableData = new Vector(this.tableDataSize);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        JLabel gotoLabel = new JLabel("Go to time step: ");
        this.errorLabel = new JLabel();
        this.gotoText = new JTextField(5);
        this.gotoText.setMaximumSize(new Dimension(100, 25));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.openDebugButton = new JButton("Debug");
        this.openDebugButton.addActionListener(this);
        this.buttonPanel.add(gotoLabel);
        this.buttonPanel.add(this.gotoText);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.errorLabel);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.openDebugButton);
        this.tracePanel = new JPanel();
        this.tracePanel.setLayout(this.gbl);
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent(this.tracePanel);
        this.splitPane.setBottomComponent(this.debugPanel);
        this.debugPanel.setVisible(false);
        this.splitPane.setResizeWeight(0.85);
        this.splitPane.setDividerLocation(0.6);
        ((Component)this.debugFrame).setSize(new Dimension(800, 700));
        this.debugFrame.getContentPane().add((Component)this.splitPane, "Center");
    }

    protected void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    public void createTable() {
        this.tracePanel.removeAll();
        if (this.program.logicalRowNum < this.tableDataSize) {
            this.displayTableData = this.tableData;
        } else {
            int position = this.program.logicalRowNum % this.tableDataSize;
            this.displayTableData = new Vector();
            this.displayTableData.addAll(this.tableData.subList(position + 1, this.tableData.size()));
            this.displayTableData.addAll(this.tableData.subList(0, position));
        }
        this.table = new JTable(this.displayTableData, this.columnNames);
        this.table.setAutoResizeMode(3);
        this.table.setShowHorizontalLines(false);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    if (((Vector)Debugger.this.displayTableData.elementAt(selectedRow)).elementAt(1) instanceof RobotGoal) {
                        String traceString = ((RobotGoal)((Vector)Debugger.this.displayTableData.elementAt(selectedRow)).elementAt(1)).toString().trim();
                        if (Debugger.this.queryPane.getSelectedIndex() == 0) {
                            Debugger.this.askField.setText(traceString);
                        } else {
                            Debugger.this.whyNotField.setText(traceString);
                        }
                    } else {
                        Debugger.this.askField.setText("");
                    }
                    lsm.clearSelection();
                }
            }
        });
        this.traceScroll = new JScrollPane(this.table, 22, 30);
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(400);
        column = this.table.getColumnModel().getColumn(2);
        column.setPreferredWidth(100);
        column = this.table.getColumnModel().getColumn(3);
        column.setPreferredWidth(200);
        this.addComponent(this.traceScroll, this.tracePanel, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.buttonPanel, this.tracePanel, 1, 0, 1, 1, 1.0, 0.1);
    }

    public void gotoTimeStep() {
        try {
            int timestep = Integer.valueOf(this.gotoText.getText());
            if ((double)timestep > RobotProgram.getCurrentTime()) {
                this.errorLabel.setForeground(Color.RED);
                this.errorLabel.setText("That time has not been reached.");
            } else if ((double)timestep < RobotProgram.getCurrentTime() - 15.0) {
                this.errorLabel.setForeground(Color.RED);
                this.errorLabel.setText("Cannot access that time step anymore.");
            } else {
                this.errorLabel.setText("");
                this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, false));
                int rownumber = (Integer)RobotProgram.timeSteps.get(new Double(timestep)) % this.tableDataSize;
                if (this.program.logicalRowNum >= this.tableData.size()) {
                    int position = this.program.logicalRowNum % this.tableDataSize;
                    if (rownumber > position) {
                        rownumber -= position + 1;
                    } else if (this.program.logicalRowNum >= this.tableDataSize) {
                        rownumber = this.tableDataSize - position - 1 + rownumber;
                    }
                }
                this.table.scrollRectToVisible(this.table.getCellRect(rownumber, 0, false));
            }
        }
        catch (NumberFormatException err) {
            this.errorLabel.setForeground(Color.RED);
            this.errorLabel.setText("Value is not valid.");
        }
    }

    public void openDebugPanel() {
        this.debugPanel.setVisible(true);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(0.6);
        if (this.table.getSelectedRowCount() != 0) {
            if (((Vector)this.displayTableData.elementAt(this.table.getSelectedRow())).elementAt(1) instanceof RobotGoal) {
                String traceString = ((RobotGoal)((Vector)this.displayTableData.elementAt(this.table.getSelectedRow())).elementAt(1)).toString().trim();
                this.askField.setText(traceString);
            } else {
                this.askField.setText("");
            }
        }
    }

    public void clearFields() {
        this.askField.setText("");
        this.howField.setText("");
        this.whyNotField.setText("");
        this.whyNotNumberField.setText("");
        this.whynotHowField.setText("");
    }

    public void ask() {
        this.moregoalsindex = 0;
        Vector howgoalscopy = (Vector)this.howgoals.clone();
        this.howgoals.clear();
        String query = this.askField.getText();
        query.trim();
        if (query.endsWith(".")) {
            query = query.substring(0, query.lastIndexOf("."));
        }
        this.textArea.append("cilog: ask " + query + ".\n");
        if (query.equals("")) {
            this.textArea.append("No.\n");
            return;
        }
        this.querygoal = (RobotGoal)this.program.parseGoal(query);
        if (this.querygoal == null) {
            this.askField.setText("");
            this.textArea.append("No.\n");
            return;
        }
        RobotPredicate querypred = !this.querygoal.getPredicate().builtIn() ? (RobotPredicate)this.program.predContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity()) : (RobotPredicate)this.program.builtInPredContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity());
        if (querypred == null) {
            this.textArea.append("No. " + query + " doesn't follow from the knowledge base.\n");
        } else {
            boolean answerfound = false;
            int i = 0;
            while ((double)i < RobotProgram.getCurrentTime()) {
                Vector currVector = (Vector)querypred.traceHash.get(new Double(i));
                if (currVector != null) {
                    int j = 0;
                    while (j < currVector.size()) {
                        RobotGoal currgoal = (RobotGoal)currVector.elementAt(j);
                        if (this.querygoal.canunify(currgoal, false) && !currgoal.fail) {
                            this.moregoalsindex = i;
                            answerfound = true;
                            this.textArea.append("Answer: " + currgoal.printString() + ".\n");
                            this.howgoals.add(currgoal);
                            break;
                        }
                        ++j;
                    }
                }
                if (answerfound) break;
                ++i;
            }
            if (!answerfound) {
                this.textArea.append("There is no matching clause that succeeds.\n");
                this.howgoals.addAll(howgoalscopy);
            }
        }
        this.clearFields();
    }

    public void askMore() {
        if (this.querygoal == null) {
            return;
        }
        Vector howgoalscopy = (Vector)this.howgoals.clone();
        this.howgoals.clear();
        RobotPredicate querypred = !this.querygoal.getPredicate().builtIn() ? (RobotPredicate)this.program.predContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity()) : (RobotPredicate)this.program.builtInPredContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity());
        if (querypred == null) {
            this.textArea.append("No. \n");
        } else {
            boolean answerfound = false;
            int i = this.moregoalsindex + 1;
            while ((double)i < RobotProgram.getCurrentTime()) {
                Vector currVector = (Vector)querypred.traceHash.get(new Double(i));
                if (currVector != null) {
                    int j = 0;
                    while (j < currVector.size()) {
                        RobotGoal currgoal = (RobotGoal)currVector.elementAt(j);
                        if (this.querygoal.canunify(currgoal, false) && !currgoal.fail) {
                            this.moregoalsindex = i;
                            answerfound = true;
                            this.textArea.append("Answer: " + currgoal.printString() + ".\n");
                            this.howgoals.add(currgoal);
                            break;
                        }
                        ++j;
                    }
                }
                if (answerfound) break;
                ++i;
            }
            if (!answerfound) {
                this.textArea.append("There are no more matching queries that succeed.\n");
                this.howgoals.addAll(howgoalscopy);
            }
        }
        this.clearFields();
    }

    public void how() {
        String query = this.queryPane.getSelectedIndex() == 0 ? this.howField.getText() : this.whynotHowField.getText();
        if (query.equals("") && this.howgoals.size() > 0) {
            this.textArea.append("     how.\n");
            this.querygoal = (RobotGoal)this.howgoals.elementAt(0);
        } else {
            int index = 0;
            try {
                index = Integer.valueOf(query);
            }
            catch (NumberFormatException ex) {
                this.howErrorLabel.setVisible(true);
                return;
            }
            if (index > this.howgoals.size()) {
                if (this.queryPane.getSelectedIndex() == 0) {
                    this.howErrorLabel.setVisible(true);
                } else {
                    this.whynotHowErrorLabel.setVisible(true);
                }
                return;
            }
            this.textArea.append("     how " + index + ".\n");
            this.querygoal = (RobotGoal)this.howgoals.elementAt(index - 1);
        }
        Vector howgoalscopy = (Vector)this.howgoals.clone();
        this.howgoals.clear();
        if (this.querygoal.getPredicate().builtIn()) {
            this.textArea.append("     " + this.querygoal.printString() + " is built in");
            RobotPredicate querypred = (RobotPredicate)this.program.builtInPredContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity());
            Vector currVector = (Vector)querypred.traceHash.get(new Double(this.querygoal.timestep));
            boolean answerfound = false;
            int i = 0;
            while (i < currVector.size()) {
                RobotGoal currgoal = (RobotGoal)currVector.elementAt(i);
                if (this.querygoal.canunify(currgoal, false)) {
                    answerfound = true;
                    if (!currgoal.fail) {
                        this.textArea.append("\n");
                        break;
                    }
                    this.textArea.append(" and FAILED.\n");
                    break;
                }
                ++i;
            }
            if (!answerfound) {
                this.textArea.append("\n");
            }
            this.howgoals.add(this.querygoal);
        } else {
            RobotPredicate querypred = (RobotPredicate)this.program.predContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity());
            if (querypred == null) {
                this.textArea.append("     No. " + query + " doesn't follow from the knowledge base.\n");
            } else {
                Vector currVector = (Vector)querypred.traceHash.get(new Double(this.querygoal.timestep));
                int i = 0;
                while (i < currVector.size()) {
                    RobotGoal currgoal = (RobotGoal)currVector.elementAt(i);
                    if (this.querygoal.canunify(currgoal, false)) {
                        if (!currgoal.fail) {
                            if (currgoal.children.size() > 0) {
                                this.textArea.append("     " + currgoal.printString() + "<-\n");
                                int j = 0;
                                while (j < currgoal.children.size()) {
                                    this.textArea.append("\t" + (j + 1) + ":  " + ((RobotGoal)currgoal.children.elementAt(j)).printString() + "\n");
                                    this.howgoals.add(currgoal.children.elementAt(j));
                                    ++j;
                                }
                                break;
                            }
                            this.textArea.append("     " + currgoal.printString() + " is a fact\n");
                            this.howgoals.add(currgoal);
                            break;
                        }
                        this.textArea.append("     " + currgoal.printString() + " FAILED.\n");
                        this.howgoals.addAll(howgoalscopy);
                        break;
                    }
                    ++i;
                }
            }
        }
        this.clearFields();
    }

    public void why() {
        if (this.querygoal == null) {
            return;
        }
        RobotGoal currgoal = this.querygoal;
        if (currgoal.parent == null) {
            this.textArea.append("     Thats what you asked.\n");
        } else {
            this.querygoal = currgoal.parent;
            this.howgoals.clear();
            this.whynotgoals.clear();
            this.textArea.append("     " + currgoal.printString() + " is used in the rule\n");
            this.textArea.append("     " + currgoal.parent.printString() + "<-\n");
            int j = 0;
            while (j < currgoal.parent.children.size()) {
                this.howgoals.add((RobotGoal)currgoal.parent.children.elementAt(j));
                this.whynotgoals.add((RobotGoal)currgoal.parent.children.elementAt(j));
                if (currgoal.parent.children.indexOf(currgoal) == j) {
                    this.textArea.append("\t**" + (j + 1) + ":  " + ((RobotGoal)currgoal.parent.children.elementAt(j)).printString() + "\n");
                } else {
                    this.textArea.append("\t  " + (j + 1) + ":  " + ((RobotGoal)currgoal.parent.children.elementAt(j)).printString() + "\n");
                }
                ++j;
            }
        }
    }

    public void whyNot() {
        this.morefailgoalsindex = 0;
        Vector whynotgoalscopy = (Vector)this.whynotgoals.clone();
        this.whynotgoals.clear();
        Vector howgoalscopy = (Vector)this.howgoals.clone();
        this.howgoals.clear();
        String query = this.whyNotField.getText();
        query.trim();
        if (query.endsWith(".")) {
            query = query.substring(0, query.lastIndexOf("."));
        }
        if (query.equals("")) {
            this.textArea.append("No.\n");
            return;
        }
        this.textArea.append("cilog: whynot " + query + ".\n");
        this.querygoal = (RobotGoal)this.program.parseGoal(query);
        if (this.querygoal == null) {
            this.textArea.append("No.\n");
            this.askField.setText("");
            this.howField.setText("");
            this.whyNotNumberField.setText("");
            this.whynotHowField.setText("");
            return;
        }
        RobotPredicate querypred = !this.querygoal.getPredicate().builtIn() ? (RobotPredicate)this.program.predContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity()) : (RobotPredicate)this.program.builtInPredContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity());
        if (querypred == null) {
            this.textArea.append("There is no rule for this query in the knowledge base. \n");
        } else {
            boolean answerfound = false;
            int i = 0;
            while ((double)i <= RobotProgram.getCurrentTime()) {
                Vector currVector = (Vector)querypred.traceHash.get(new Double(i));
                if (currVector != null) {
                    int j = 0;
                    while (j < currVector.size()) {
                        RobotGoal currgoal = (RobotGoal)currVector.elementAt(j);
                        if (this.querygoal.canunify(currgoal, false) && currgoal.fail) {
                            this.morefailgoalsindex = i;
                            answerfound = true;
                            this.textArea.append("Answer: " + currgoal.printString() + " FAILED.\n");
                            this.whynotgoals.add(currgoal);
                            this.howgoals.add(currgoal);
                            break;
                        }
                        ++j;
                    }
                }
                if (answerfound) break;
                ++i;
            }
            if (!answerfound) {
                this.textArea.append("There is no matching clause that fails.\n");
                this.whynotgoals.addAll(whynotgoalscopy);
                this.howgoals.addAll(howgoalscopy);
            }
        }
        this.clearFields();
    }

    public void whyNotMore() {
        if (this.querygoal == null) {
            return;
        }
        Vector whynotgoalscopy = (Vector)this.whynotgoals.clone();
        this.whynotgoals.clear();
        Vector howgoalscopy = (Vector)this.howgoals.clone();
        this.howgoals.clear();
        RobotPredicate querypred = !this.querygoal.getPredicate().builtIn() ? (RobotPredicate)this.program.predContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity()) : (RobotPredicate)this.program.builtInPredContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity());
        if (querypred == null) {
            this.textArea.append("No. \n");
        } else {
            boolean answerfound = false;
            int i = this.morefailgoalsindex + 1;
            while ((double)i < RobotProgram.getCurrentTime()) {
                Vector currVector = (Vector)querypred.traceHash.get(new Double(i));
                if (currVector != null) {
                    int j = 0;
                    while (j < currVector.size()) {
                        RobotGoal currgoal = (RobotGoal)currVector.elementAt(j);
                        if (this.querygoal.canunify(currgoal, false) && currgoal.fail) {
                            this.morefailgoalsindex = i;
                            answerfound = true;
                            this.textArea.append("Answer: " + currgoal.printString() + " FAILED.\n");
                            this.whynotgoals.add(currgoal);
                            this.howgoals.add(currgoal);
                            break;
                        }
                        ++j;
                    }
                }
                if (answerfound) break;
                ++i;
            }
            if (!answerfound) {
                this.textArea.append("There are no more matching clauses that fail.\n");
                this.whynotgoals.addAll(whynotgoalscopy);
                this.howgoals.addAll(howgoalscopy);
            }
        }
        this.clearFields();
    }

    public void explain() {
        String query = this.whyNotNumberField.getText();
        if (query.equals("") && this.whynotgoals.size() > 0) {
            this.querygoal = (RobotGoal)this.whynotgoals.elementAt(0);
        } else {
            int index = 0;
            try {
                index = Integer.valueOf(query);
            }
            catch (NumberFormatException ex) {
                this.whyNotErrorLabel.setVisible(true);
                return;
            }
            if (index > this.whynotgoals.size()) {
                this.whyNotErrorLabel.setVisible(true);
                return;
            }
            this.textArea.append("     whynot " + index + ".\n");
            this.querygoal = (RobotGoal)this.whynotgoals.elementAt(index - 1);
        }
        Vector whynotgoalscopy = (Vector)this.whynotgoals.clone();
        this.whynotgoals.clear();
        Vector howgoalscopy = (Vector)this.howgoals.clone();
        this.howgoals.clear();
        if (this.querygoal.getPredicate().builtIn()) {
            this.textArea.append("     " + this.querygoal.printString() + " is built in");
            RobotPredicate querypred = (RobotPredicate)this.program.builtInPredContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity());
            boolean answerfound = false;
            Vector currVector = (Vector)querypred.traceHash.get(new Double(this.querygoal.timestep));
            int i = 0;
            while (i < currVector.size()) {
                RobotGoal currgoal = (RobotGoal)currVector.elementAt(i);
                if (this.querygoal.canunify(currgoal, false)) {
                    answerfound = true;
                    if (!currgoal.fail) {
                        this.textArea.append(" and succeeds.\n");
                        break;
                    }
                    this.textArea.append(" and FAILED.\n");
                    break;
                }
                ++i;
            }
            if (!answerfound) {
                this.textArea.append(" \n");
            }
            this.whynotgoals.add(this.querygoal);
            this.howgoals.add(this.querygoal);
        } else {
            RobotPredicate querypred = (RobotPredicate)this.program.predContains(this.querygoal.getPredicate().getName(), this.querygoal.getPredicate().getArity());
            if (querypred == null) {
                this.textArea.append("     Reason:     No rule for this query.\n ");
            } else {
                Vector currVector = (Vector)querypred.traceHash.get(new Double(this.querygoal.timestep));
                int i = 0;
                while (i < currVector.size()) {
                    RobotGoal currgoal = (RobotGoal)currVector.elementAt(i);
                    if (this.querygoal.canunify(currgoal, false)) {
                        if (currgoal.fail) {
                            if (currgoal.children.size() <= 0) break;
                            this.textArea.append("     Reason:   \n");
                            this.textArea.append("          " + currgoal.printString() + "<-\n");
                            int j = 0;
                            while (j < currgoal.children.size()) {
                                this.textArea.append("\t" + (j + 1) + ":  " + ((RobotGoal)currgoal.children.elementAt(j)).printString());
                                if (((RobotGoal)currgoal.children.elementAt((int)j)).fail) {
                                    this.textArea.append("  FAILED\n");
                                } else {
                                    this.textArea.append("\n");
                                }
                                this.whynotgoals.add(currgoal.children.elementAt(j));
                                this.howgoals.add(currgoal.children.elementAt(j));
                                ++j;
                            }
                            break;
                        }
                        this.textArea.append("          " + currgoal.printString() + " succeeded.\n");
                        this.whynotgoals.addAll(whynotgoalscopy);
                        this.whynotgoals.addAll(howgoalscopy);
                        break;
                    }
                    ++i;
                }
            }
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        this.howErrorLabel.setVisible(false);
        this.whyNotErrorLabel.setVisible(false);
        if (e.getSource().equals(this.okButton)) {
            this.gotoTimeStep();
        } else if (e.getSource().equals(this.openDebugButton)) {
            this.openDebugPanel();
        } else if (e.getSource().equals(this.clearButton)) {
            this.textArea.setText("");
        } else if (e.getSource().equals(this.askEnter)) {
            this.ask();
        } else if (e.getSource().equals(this.moreButton)) {
            this.askMore();
        } else if (e.getSource().equals(this.howEnter) || e.getSource().equals(this.whynotHowEnter)) {
            this.how();
        } else if (e.getSource().equals(this.whyButton) || e.getSource().equals(this.whyNotWhyButton)) {
            this.why();
        } else if (e.getSource().equals(this.whyNotEnter)) {
            this.whyNot();
        } else if (e.getSource().equals(this.whyNotMoreButton)) {
            this.whyNotMore();
        } else if (e.getSource().equals(this.whyNotNumberEnter)) {
            this.explain();
        } else if (e.getSource().equals(this.askHelp)) {
            ImageIcon askImage = Debugger.createImageIcon("images/askdebug.gif");
            JFrame askFrame = Debugger.createHelpFrame("Ask", askImage);
            ((Component)askFrame).setSize(600, 500);
            askFrame.show();
        } else if (e.getSource().equals(this.howHelp) || e.getSource().equals(this.whynotHowHelp)) {
            ImageIcon howImage = Debugger.createImageIcon("images/howdebug.gif");
            JFrame howFrame = Debugger.createHelpFrame("How", howImage);
            ((Component)howFrame).setSize(650, 700);
            howFrame.show();
        } else if (e.getSource().equals(this.whyHelp) || e.getSource().equals(this.whyNotWhyHelp)) {
            ImageIcon whyImage = Debugger.createImageIcon("images/whydebug.gif");
            JFrame whyFrame = Debugger.createHelpFrame("Why", whyImage);
            ((Component)whyFrame).setSize(600, 550);
            whyFrame.show();
        } else if (e.getSource().equals(this.whyNotHelp)) {
            ImageIcon whynotImage = Debugger.createImageIcon("images/whynotdebug.gif");
            JFrame whynotFrame = Debugger.createHelpFrame("WhyNot", whynotImage);
            ((Component)whynotFrame).setSize(800, 750);
            whynotFrame.show();
        }
    }

    private static JFrame createHelpFrame(String title, ImageIcon image) {
        JLabel picture = new JLabel(image);
        JFrame helpFrame = new JFrame(title);
        JPanel helpPanel = new JPanel();
        helpPanel.setBackground(Color.WHITE);
        helpPanel.add(picture);
        helpFrame.getContentPane().add((Component)helpPanel, "Center");
        return helpFrame;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("CIspace.graphToolKit.GraphWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((imgURL = clazz.getResource(path)) != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public void showHow() {
        ((Component)this.debugFrame).setVisible(true);
    }
}

