/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.robot.RobotGraphCanvas;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class TextFrameWindows
extends Frame
implements ActionListener,
WindowListener,
MouseListener {
    private Button cancelButton;
    private Button updateGraphButton;
    private TextArea display;
    private RobotGraphCanvas canvas;
    private boolean isXML;

    public TextFrameWindows(RobotGraphCanvas canvas, String textRep, boolean isXML) {
        super("Text Representation of the graph");
        ((Component)this).setLocation(50, 50);
        this.addWindowListener(this);
        this.canvas = canvas;
        this.isXML = isXML;
        Panel p = new Panel();
        this.updateGraphButton = new Button("Update");
        this.updateGraphButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        p.add(this.updateGraphButton);
        p.add(this.cancelButton);
        this.display = new TextArea(40, 80);
        this.display.setFont(new Font("Monospaced", 0, canvas.getFontSize()));
        this.display.setText(textRep);
        if (canvas.isRunning()) {
            this.updateGraphButton.setEnabled(false);
            this.display.setEditable(false);
        }
        this.display.addMouseListener(this);
        this.add("Center", this.display);
        this.add("South", p);
        this.pack();
        this.display.setCaretPosition(0);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Update")) {
            if (!this.canvas.isRunning()) {
                if (this.isXML) {
                    if (this.canvas.updateXMLtextRep(this.display.getText())) {
                        this.dispose();
                    }
                } else if (this.canvas.updateGraphFromText(this.display.getText())) {
                    this.dispose();
                }
            } else {
                this.canvas.showMessage("Error", "Cannot update graph when robot is running.");
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        e.getModifiers();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

