/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.robot.RobotGraphCanvas;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class TextFrame
extends JFrame
implements ActionListener,
WindowListener,
MouseListener {
    private JPopupMenu pop;
    private JButton cancelButton;
    private JButton updateGraphButton;
    private JTextArea display;
    private JScrollPane displayScroll;
    private RobotGraphCanvas canvas;
    private boolean isXML;

    public TextFrame(RobotGraphCanvas canvas, String textRep, boolean isXML) {
        super("Text Representation of the graph");
        ((Component)this).setLocation(50, 50);
        this.addWindowListener(this);
        this.canvas = canvas;
        this.isXML = isXML;
        JPanel p = new JPanel();
        this.updateGraphButton = new JButton("Update");
        this.updateGraphButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        p.add(this.updateGraphButton);
        p.add(this.cancelButton);
        this.display = new JTextArea(40, 80);
        this.display.setFont(new Font("Monospaced", 0, canvas.getFontSize()));
        this.display.setText(textRep);
        if (canvas.isRunning()) {
            this.updateGraphButton.setEnabled(false);
            this.display.setEditable(false);
        }
        this.display.addMouseListener(this);
        this.pop = new JPopupMenu();
        this.displayScroll = new JScrollPane(this.display, 20, 30);
        this.getContentPane().add("Center", this.displayScroll);
        this.getContentPane().add("South", p);
        this.display.setCaretPosition(0);
        this.pack();
        this.show();
    }

    private void popupEdit(int x, int y) {
        this.pop.removeAll();
        JMenuItem mItem = new JMenuItem("Cut");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Copy");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Paste");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Update")) {
            if (!this.canvas.isRunning()) {
                if (this.isXML) {
                    if (this.canvas.updateXMLtextRep(this.display.getText())) {
                        this.dispose();
                    }
                } else if (this.canvas.updateGraphFromText(this.display.getText())) {
                    this.dispose();
                }
            } else {
                this.canvas.showMessage("Error", "Cannot update graph when robot is running.");
            }
        } else if (e.getActionCommand().equals("Cut")) {
            this.display.cut();
        } else if (e.getActionCommand().equals("Copy")) {
            this.display.copy();
        } else if (e.getActionCommand().equals("Paste")) {
            this.display.paste();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 4) {
            Point screenp = new Point(e.getX() - this.getLocation().x, e.getY() - this.getLocation().y);
            SwingUtilities.convertPointToScreen(screenp, this.display);
            this.popupEdit(screenp.x, screenp.y);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

