/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Point;
import CIspace.robot.Environment;
import CIspace.robot.RobotGraphCanvas;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RobotPositionDialog
extends JPanel
implements ActionListener,
TextListener {
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    protected JLabel labelCompass;
    protected JTextField textCompass;
    protected JLabel labelLocationX;
    protected JTextField textLocationX;
    protected JLabel labelLocationY;
    protected JTextField textLocationY;
    protected JButton buttonOk;
    protected JButton buttonCancel;
    protected JLabel labelError;
    protected JPanel p;
    protected String dialogTitle = new String("Robot Position Dialog");
    protected Double compass;
    protected Double locationX;
    protected Double locationY;
    protected int scale;
    protected RobotGraphCanvas canvas;

    public RobotPositionDialog(Container parent, RobotGraphCanvas c, Point point, double comp) {
        this.canvas = c;
        this.scale = Environment.pixelsPerUnit;
        double posX = point.x / (float)this.scale;
        double posY = point.y / (float)this.scale;
        Double locX = new Double(posX);
        Double locY = new Double(posY);
        this.compass = new Double(comp);
        this.labelCompass = new JLabel("Compass Direction:             ");
        this.textCompass = new JTextField(this.compass.toString(), 20);
        this.labelLocationX = new JLabel("x coordinate:");
        this.textLocationX = new JTextField(locX.toString(), 20);
        this.labelLocationY = new JLabel("y coordinate:");
        this.textLocationY = new JTextField(locY.toString(), 20);
        this.labelError = new JLabel("");
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridheight = 3;
        this.setLayout(this.gbl);
        this.addComponent(this.labelCompass, this, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.textCompass, this, 0, 1, 1, 1, 1.0, 1.0);
        this.addComponent(this.labelLocationX, this, 1, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.textLocationX, this, 1, 1, 1, 1, 1.0, 1.0);
        this.addComponent(this.labelLocationY, this, 2, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.textLocationY, this, 2, 1, 1, 1, 1.0, 1.0);
    }

    protected void addComponent(JComponent c, JPanel p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    public JPanel display(RobotGraphCanvas c, Point p, double comp) {
        this.canvas = c;
        this.scale = Environment.pixelsPerUnit;
        double posX = p.x / (float)this.scale;
        double posY = p.y / (float)this.scale;
        this.textCompass.setText(new Double(comp).toString());
        this.textLocationX.setText(new Double(posX).toString());
        this.textLocationY.setText(new Double(posY).toString());
        return this;
    }

    public boolean setProperties() {
        try {
            this.compass = Double.valueOf(this.textCompass.getText());
            this.locationX = Double.valueOf(this.textLocationX.getText());
            this.locationY = Double.valueOf(this.textLocationY.getText());
            double posX = this.locationX * (double)this.scale;
            double posY = this.locationY * (double)this.scale;
            Point point = new Point((float)posX, (float)posY);
            this.canvas.setRobot(point, this.compass);
            this.canvas.repaint();
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Field(s) have invalid real number format!");
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.textCompass)) {
            this.textCompass.transferFocus();
        } else if (e.getSource().equals(this.textLocationX)) {
            this.textLocationX.transferFocus();
        } else if (e.getSource().equals(this.textLocationY)) {
            this.textLocationY.transferFocus();
        }
    }

    public boolean ok() {
        return this.setProperties();
    }

    public void textValueChanged(TextEvent e) {
        this.labelError.setText("");
    }
}

