/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import CIspace.robot.RobotGraph;
import java.awt.Color;
import java.awt.Graphics;

public class RobotNode
extends Node {
    public RobotNode(RobotGraph graph, Point p) {
        super(graph);
        this.color = Color.black;
        this.label[0] = "";
        this.pos = p;
        this.shape = 1111;
        this.updateSize();
    }

    public String getName() {
        return this.label[0];
    }

    public void setName(String name) {
        this.label[0] = name;
    }

    public Point getCartesianPos() {
        return new Point(this.pos.x, -this.pos.y);
    }

    protected void drawLabel(Graphics offscreen) {
        if (this.isBold && (this.color == Color.blue || this.color == Color.black)) {
            offscreen.setColor(Color.white);
        } else {
            offscreen.setColor(Color.black);
        }
        int h = this.graph.canvas.getFontMetrics().getAscent();
        int w = this.graph.canvas.getFontMetrics().stringWidth(RobotNode.chompAt(this.label[0]));
        offscreen.drawString(RobotNode.chompAt(this.label[0]), (int)this.pos.x - w / 2, (int)this.pos.y + h / 2);
    }

    private static String chompAt(String sourceStr) {
        String outString = "";
        if (!sourceStr.equals("")) {
            outString = sourceStr.substring(1, sourceStr.length());
        }
        return outString;
    }

    protected int getWidth() {
        return this.graph.canvas.getFontMetrics().stringWidth(RobotNode.chompAt(this.label[0])) + this.wPad;
    }
}

