/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Point;
import CIspace.robot.AutoRobot;
import CIspace.robot.CrashDialog;
import CIspace.robot.Environment;
import CIspace.robot.HighControllerDialog;
import CIspace.robot.InvisibleNode;
import CIspace.robot.LocationDialog;
import CIspace.robot.PlannerFrame;
import CIspace.robot.RobotEdge;
import CIspace.robot.RobotGraph;
import CIspace.robot.RobotNode;
import CIspace.robot.RobotPositionDialog;
import CIspace.robot.RobotRobot;
import CIspace.robot.RobotWindow;
import CIspace.robot.RunDialog;
import CIspace.robot.TextFrame;
import CIspace.robot.TextFrameWindows;
import CIspace.robotProlog.RobotGoal;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class RobotGraphCanvas
extends GraphCanvas {
    private Thread thread;
    public String tempString;
    public static final int RUNNING_STATE = 1;
    public static final int STOPPED_STATE = 2;
    public static final int RESET_STATE = 3;
    protected AutoRobot myAutoRobot;
    protected boolean creatingEdge;
    protected LocationDialog ld;
    protected RobotPositionDialog rpd;
    protected RunDialog runDialog;
    protected HighControllerDialog highControllerDialog;
    protected double maxTimeStep;
    protected int autoRate;
    protected double deltaT;
    protected boolean showTrace;
    protected boolean running;
    protected int count;
    protected boolean createNodeCancelled;
    protected boolean crashed;
    protected Point stoppedPoint;
    protected int robotState;
    protected String signalRobotPos;
    protected String signalGoalPos;
    protected String signalToDo;
    protected String signalCompass;
    protected String signalArrived;
    protected String signalWhiskerSensor;
    protected String signalSteer;
    protected String signalGoalName;
    protected String signalHighArbitrary;
    protected String signalMedArbitrary;
    public boolean runEnabled;
    public boolean stopEnabled;
    public boolean resetEnabled;
    public boolean clearTraceEnabled;
    public boolean plannerEnabled;
    public boolean propertiesEnabled;
    protected int locIndex = 0;

    public RobotGraphCanvas(Container frame_in, boolean inline) {
        super(frame_in, inline);
        this.graph = new RobotGraph(this);
        this.initialize();
    }

    public void initialize() {
        this.creatingEdge = false;
        this.createNodeCancelled = false;
        this.robotState = 3;
        this.maxTimeStep = 300.0;
        this.autoRate = 0;
        this.deltaT = 1.0;
        this.showTrace = true;
        this.running = false;
        this.count = 0;
        this.crashed = false;
        this.stoppedPoint = null;
        this.signalRobotPos = "";
        this.signalGoalPos = "";
        this.signalToDo = "";
        this.signalCompass = "";
        this.signalArrived = "";
        this.signalWhiskerSensor = "";
        this.signalSteer = "";
        this.signalGoalName = "";
        this.signalHighArbitrary = "";
        this.signalMedArbitrary = "";
        this.runEnabled = true;
        this.stopEnabled = false;
        this.resetEnabled = false;
        this.clearTraceEnabled = false;
        this.plannerEnabled = true;
        this.propertiesEnabled = true;
    }

    protected void popupCanvas(int x, int y) {
        if (this.mode == 2220) {
            this.popupCCanv();
        }
        if (this.mode == 2221) {
            this.popupSCanv();
        }
        this.pop.show(this, x, y);
    }

    protected void popupCCanv() {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Create Options"));
        JMenuItem mItem = new JMenuItem("Create Location");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Create Wall");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new JMenuItem("View/Modify Plan");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("View/Modify Robot Properties");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        this.popupView();
    }

    protected void popupSCanv() {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
        JMenuItem mItem = new JMenuItem("Step Robot");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        if (!this.runEnabled) {
            mItem.setEnabled(false);
        }
        this.pop.add(mItem);
        mItem = new JMenuItem("Run Robot");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        if (!this.runEnabled) {
            mItem.setEnabled(false);
        }
        this.pop.add(mItem);
        mItem = new JMenuItem("Stop Robot");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        if (!this.stopEnabled) {
            mItem.setEnabled(false);
        }
        this.pop.add(mItem);
        mItem = new JMenuItem("Reset Robot");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        if (!this.resetEnabled) {
            mItem.setEnabled(false);
        }
        this.pop.add(mItem);
        mItem = new JMenuItem("Clear Trace");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        if (!this.clearTraceEnabled) {
            mItem.setEnabled(false);
        }
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new JMenuItem("View/Modify Plan");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("View/Modify Robot Properties");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        this.popupView();
    }

    protected final void popupView() {
        JCheckBoxMenuItem pan;
        JCheckBoxMenuItem zoom;
        this.pop.add(new JLabel("View Options"));
        JMenuItem mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JCheckBoxMenuItem("Zoom", true);
            pan = new JCheckBoxMenuItem("Pan", false);
        } else {
            zoom = new JCheckBoxMenuItem("Zoom", false);
            pan = new JCheckBoxMenuItem("Pan", true);
        }
        zoom.addActionListener(this);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.addActionListener(this);
        zp.add(pan);
        zpGroup.add(pan);
        this.pop.add(zp);
    }

    protected void popupNode(int x, int y) {
        this.pop.setBorder(BorderFactory.createTitledBorder("Location Options"));
        this.pop.removeAll();
        JMenuItem mItem = new JMenuItem("Location Properties");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Delete Location");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        if (this.isRunning()) {
            mItem.setEnabled(false);
        }
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
        this.pop.setBorder(BorderFactory.createTitledBorder("Wall Options"));
        this.pop.removeAll();
        JMenuItem mItem = new JMenuItem("Delete Wall");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupRobot(int x, int y) {
        this.pop.setBorder(BorderFactory.createTitledBorder("Robot Options"));
        this.pop.removeAll();
        JMenuItem mItem = new JMenuItem("Robot Properties");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        if (this.robotState == 1) {
            mItem.setEnabled(false);
        }
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected Entity mClicked(MouseEvent e, boolean ctrldown) {
        Point p = new Point(e.getX(), e.getY());
        if (e.getModifiers() == 4) {
            this.entClicked = this.graph.searchEntities(p);
            if (this.entClicked != null && this.entClicked.type == 7778) {
                this.entClicked.isBold = true;
                this.clicked = true;
                this.selected = this.graph.select(this.entClicked);
                this.popupRobot(e.getX(), e.getY());
                return this.entClicked;
            }
            if (this.makingEdge == 1) {
                this.makingEdge = 0;
                if (this.tmpMode != -1) {
                    this.submode = this.tmpMode;
                }
                if (this.tempString != null) {
                    ((RobotWindow)this.parent).setPromptLabel(this.tempString);
                }
                return this.entClicked;
            }
            return super.mClicked(e, e.isControlDown());
        }
        Entity ent = this.graph.searchEntities(p);
        if (ent == null) {
            return super.mClicked(e, e.isControlDown());
        }
        if (this.mode == 2221) {
            if (ent.type == 7770) {
                RobotNode node = (RobotNode)ent;
                this.showLocationDialog(node);
                return ent;
            }
            return super.mClicked(e, e.isControlDown());
        }
        return super.mClicked(e, e.isControlDown());
    }

    protected Entity mPressed(MouseEvent e) {
        this.undo();
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        this.mPressedPos.move(p);
        this.mDraggedPos.move(p);
        if (e.getModifiers() == 4) {
            return ent;
        }
        if (ent == null && !e.isControlDown()) {
            this.graph.deselectAll();
            if (this.pop.isVisible()) {
                this.pop.setVisible(false);
                return ent;
            }
        }
        if (this.mode == 2220 && this.submode == 3334 && ent != null) {
            if (ent.type == 7770) {
                RobotNode node = (RobotNode)ent;
                this.showLocationDialog(node);
                return ent;
            }
            if (ent.type == 7771) {
                return ent;
            }
            if (ent.type == 7778) {
                return ent;
            }
        }
        return super.mPressed(e);
    }

    protected void undo() {
        if (((RobotWindow)this.parent).getTabIndex() == 0) {
            ((RobotWindow)this.parent).oldTextRep = ((RobotGraph)this.graph).generateXMLTextRep();
            ((RobotWindow)this.parent).getUndoButton().setEnabled(true);
        }
    }

    protected void createNode(Entity ent, Point p) {
        this.undo();
        if (ent == null || ent.type != 7770) {
            this.showLocationDialog(p);
        }
    }

    protected void createEdge(Entity ent, Point p) {
        this.undo();
        if (this.makingEdge == 1) {
            InvisibleNode node;
            if (ent == null || ent.type != 7779) {
                node = new InvisibleNode((RobotGraph)this.graph, p);
                ((RobotGraph)this.graph).addInvisibleNode(node);
            } else {
                node = (InvisibleNode)ent;
            }
            this.pause();
            this.makingEdge = 2;
            this.to = node;
            RobotEdge edge = new RobotEdge((RobotGraph)this.graph, this.from, this.to);
            this.graph.addEdge(edge);
            this.unpause();
            this.makingEdge = 0;
            if (this.tempString != null) {
                ((RobotWindow)this.parent).setPromptLabel(this.tempString);
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
                this.tmpMode = -1;
            }
            if (!this.inline) {
                if (this.submode == 3330) {
                    ((RobotWindow)this.parent).setPromptLabel("Click on the canvas to create a new location");
                } else if (this.submode == 3331) {
                    ((RobotWindow)this.parent).setPromptLabel("Click on the canvas to begin creating a new wall");
                } else if (this.submode == 3332) {
                    ((RobotWindow)this.parent).setPromptLabel("Click on the location/wall/robot and drag it to move");
                }
            }
        } else {
            InvisibleNode node;
            if (ent == null || ent.type != 7779) {
                node = new InvisibleNode((RobotGraph)this.graph, p);
                ((RobotGraph)this.graph).addInvisibleNode(node);
            } else {
                node = (InvisibleNode)ent;
            }
            this.from = node;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
            if (!this.inline) {
                ((RobotWindow)this.parent).setPromptLabel("Click on the canvas to finish creating wall;\nright click on the canvas to cancel creating wall");
            }
        }
    }

    protected void setRunningState() {
        this.robotState = 1;
        this.runEnabled = false;
        this.stopEnabled = true;
        this.resetEnabled = false;
        this.clearTraceEnabled = true;
        this.plannerEnabled = false;
        this.propertiesEnabled = false;
        this.stoppedPoint = null;
    }

    protected void setStoppedState() {
        this.robotState = 2;
        this.runEnabled = true;
        this.stopEnabled = false;
        this.resetEnabled = true;
        this.clearTraceEnabled = true;
        this.plannerEnabled = false;
        this.propertiesEnabled = false;
    }

    protected void setResetState() {
        this.robotState = 3;
        this.runEnabled = true;
        this.stopEnabled = false;
        this.resetEnabled = false;
        this.clearTraceEnabled = false;
        this.plannerEnabled = true;
        this.propertiesEnabled = true;
        this.stoppedPoint = null;
    }

    protected void mPressedSelect(Entity ent, boolean ctrlDown) {
        if (ent != null) {
            this.selected = this.graph.select(ent);
            this.moving = true;
            if (ent.type == 7771) {
                RobotEdge edge = (RobotEdge)ent;
                if (!edge.start.isSelected) {
                    this.graph.select(edge.start);
                }
                if (!edge.end.isSelected) {
                    this.graph.select(edge.end);
                }
            }
        } else if (ctrlDown) {
            this.selected = this.graph.deselectAll();
        }
    }

    protected void mDraggedSelect() {
        if (!this.dragging) {
            if (Math.abs(this.mPressedPos.x - this.mDraggedPos.x) > 5.0f || Math.abs(this.mPressedPos.y - this.mDraggedPos.y) > 5.0f) {
                this.dragging = true;
            }
            return;
        }
        if (this.hover != null) {
            if (this.moving) {
                if (this.moveable) {
                    ((RobotGraph)this.graph).moveEntities(this.mDraggedPos, this.hover);
                }
            } else if (this.selected) {
                this.moving = true;
                this.dragging = true;
            }
        }
    }

    public void textRep() {
        String textRep = ((RobotGraph)this.graph).generateTextRep();
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            TextFrameWindows tfwindows = new TextFrameWindows(this, textRep, false);
        } else {
            TextFrame textFrame = new TextFrame(this, textRep, false);
        }
    }

    public void XMLtextRep() {
        String textRep = ((RobotGraph)this.graph).generateXMLTextRep();
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            TextFrameWindows tfwindows = new TextFrameWindows(this, textRep, true);
        } else {
            TextFrame textFrame = new TextFrame(this, textRep, true);
        }
    }

    public boolean updateXMLtextRep(String text) {
        RobotGraph old = (RobotGraph)this.graph;
        this.graph = new RobotGraph(this);
        String tmp = ((RobotGraph)this.graph).parseXML(text);
        if (tmp.equals("OK")) {
            this.resetControls();
            this.repaint();
            return true;
        }
        this.showMessage("Error", tmp);
        this.graph = old;
        return false;
    }

    public void newGraph() {
        RobotGraph old = (RobotGraph)this.graph;
        this.graph = new RobotGraph(this);
        ((RobotGraph)this.graph).setHighControllerCode(old.getHighControllerCode());
        ((RobotGraph)this.graph).setMiddleControllerCode(old.getMiddleControllerCode());
        ((RobotGraph)this.graph).setEnvironmentCode(old.getEnvironmentCode());
        this.addRobot(new Point(((RobotWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((RobotWindow)this.parent).scrollPanel.getSize().width / 2, ((RobotWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((RobotWindow)this.parent).scrollPanel.getSize().height / 2));
        this.initialize();
        this.resetControls();
        this.repaint();
    }

    public boolean updateGraphFromText(String allText) {
        RobotGraph old = (RobotGraph)this.graph;
        this.graph = new RobotGraph(this);
        String tmp = ((RobotGraph)this.graph).updateGraphFromText(allText);
        if (tmp.equals("OK")) {
            ((RobotGraph)this.graph).setHighControllerCode(old.getHighControllerCode());
            ((RobotGraph)this.graph).setMiddleControllerCode(old.getMiddleControllerCode());
            ((RobotGraph)this.graph).setEnvironmentCode(old.getEnvironmentCode());
            this.resetControls();
            this.repaint();
            return true;
        }
        this.showMessage("Error", tmp);
        this.graph = old;
        return false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean doAction(int stepNumber) {
        int currentStep = stepNumber % (int)this.deltaT;
        boolean successful = currentStep == 0 ? ((RobotGraph)this.graph).high.action(true) : ((RobotGraph)this.graph).high.action(false);
        this.repaint();
        if (this.showTrace) {
            ((RobotGraph)this.graph).addTrace(((RobotGraph)this.graph).env.getCurrentPosition());
        }
        return successful;
    }

    public void runAuto(boolean isApplet, boolean singleStep) {
        if (this.myAutoRobot == null) {
            ((RobotGraph)this.graph).clearTrace();
            this.graph.deselectAll();
            this.running = true;
            this.count = 0;
            this.myAutoRobot = new AutoRobot(this, 1, isApplet, ((RobotWindow)this.parent).program);
            if (singleStep) {
                this.myAutoRobot.maxTimeStep = 1.0;
                this.myAutoRobot.dt = 1.0;
            } else {
                this.myAutoRobot.maxTimeStep = this.getMaxTimeStep();
                this.myAutoRobot.dt = this.getDeltaT();
            }
            Thread t = new Thread(this.myAutoRobot);
            t.start();
        } else if (this.myAutoRobot.stopRequested) {
            this.myAutoRobot.stopRequested = false;
            this.running = true;
            if (singleStep) {
                this.myAutoRobot.maxTimeStep = 1.0;
                this.myAutoRobot.dt = 1.0;
            } else {
                this.myAutoRobot.maxTimeStep = this.getMaxTimeStep();
                this.myAutoRobot.dt = this.getDeltaT();
            }
            Thread t = new Thread(this.myAutoRobot);
            t.start();
        }
    }

    public void runAuto2(boolean isApplet, boolean singleStep) {
        if (this.myAutoRobot == null) {
            ((RobotGraph)this.graph).clearTrace();
            this.graph.deselectAll();
            this.running = true;
            this.count = 0;
            this.myAutoRobot = new AutoRobot(this, 2, isApplet, ((RobotWindow)this.parent).program);
            if (singleStep) {
                this.myAutoRobot.maxTimeStep = 1.0;
                this.myAutoRobot.dt = 1.0;
            } else {
                this.myAutoRobot.maxTimeStep = this.getMaxTimeStep();
                this.myAutoRobot.dt = this.getDeltaT();
            }
            this.thread = new Thread(this.myAutoRobot);
            this.thread.start();
        } else if (this.myAutoRobot.stopRequested) {
            this.myAutoRobot.stopRequested = false;
            this.running = true;
            if (singleStep) {
                this.myAutoRobot.maxTimeStep = 1.0;
                this.myAutoRobot.dt = 1.0;
            } else {
                this.myAutoRobot.maxTimeStep = this.getMaxTimeStep();
                this.myAutoRobot.dt = this.getDeltaT();
            }
            this.thread = new Thread(this.myAutoRobot);
            this.thread.start();
        }
    }

    public void stopAuto() {
        if (this.myAutoRobot == null) {
            return;
        }
        this.myAutoRobot.stopRequested = true;
    }

    public void resetAuto() {
        ((RobotGraph)this.graph).clearTrace();
        this.graph.deselectAll();
        this.running = false;
        this.myAutoRobot = null;
    }

    public void showLocationDialog(RobotNode node) {
        if (this.ld == null) {
            this.ld = new LocationDialog(this.parent, this, node);
        } else {
            this.ld.display(this, node);
        }
    }

    public void showLocationDialog(Point p) {
        ++this.locIndex;
        if (this.ld == null) {
            this.ld = new LocationDialog(this.parent, this, p);
        } else {
            this.ld.display(this, p);
        }
    }

    public RobotPositionDialog showRobotPositionDialog(Point p, double d) {
        if (this.rpd == null) {
            this.rpd = new RobotPositionDialog(this.parent, this, p, d);
            return this.rpd;
        }
        return (RobotPositionDialog)this.rpd.display(this, p, d);
    }

    public double getMaxTimeStep() {
        return this.maxTimeStep;
    }

    public int getLocIndex() {
        return this.locIndex;
    }

    public int getAutoRate() {
        return this.autoRate;
    }

    public void setMaxTimeStep(double n) {
        this.maxTimeStep = n;
    }

    public void setAutoRate(int rate) {
        this.autoRate = rate;
    }

    public void setDeltaT(double t) {
        this.deltaT = t;
    }

    public double getDeltaT() {
        return this.deltaT;
    }

    public void setShowTrace(boolean v) {
        this.showTrace = v;
    }

    public void reset() {
        this.newGraph();
        ((RobotWindow)this.parent).resetButtons();
        this.repaint();
    }

    public void setAutoProperties() {
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        if (this.runDialog == null) {
            this.runDialog = new RunDialog(this.parent, this);
        } else {
            this.runDialog.display();
        }
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void showHighLevelController() {
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        this.highControllerDialog = new HighControllerDialog(this);
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void clearTrace() {
        ((RobotGraph)this.graph).clearTrace();
        this.repaint();
    }

    public Environment getEnvironment() {
        return ((RobotGraph)this.graph).env;
    }

    public void resetControls() {
        if (!this.inline) {
            ((RobotWindow)this.parent).resetButtons();
        }
        this.resetAuto();
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        this.graphScale = this.graph.getScale();
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        this.graphPoint = new Point(midX += min.x, midY += min.y);
        this.zoomForPrinting();
        this.drawPrint((Graphics2D)g);
        this.graph.setScale(this.graphScale);
        this.moveGraphToPoint(this.graphPoint);
        return 0;
    }

    public void printSelected() {
        ((RobotGraph)this.graph).printSelected();
    }

    public void addRobot(Point p) {
        if (((RobotGraph)this.graph).numRobots() > 0) {
            return;
        }
        RobotRobot newRobot = new RobotRobot((RobotGraph)this.graph, p);
        ((RobotGraph)this.graph).addRobot(newRobot);
        this.repaint();
    }

    public Vector getNodesVector() {
        return ((RobotGraph)this.graph).getNodesVector();
    }

    public Vector getEdgesVector() {
        return ((RobotGraph)this.graph).getEdgesVector();
    }

    public void setCreateNodeCancelled(boolean v) {
        this.createNodeCancelled = v;
    }

    public void plotPath(Vector path) {
        if (path == null) {
            return;
        }
        int i = 0;
        while (i < path.size()) {
            Point p = (Point)path.elementAt(i);
            int scale = Environment.pixelsPerUnit;
            if (this.showTrace) {
                ((RobotGraph)this.graph).addTrace(new Point(p.x * (float)scale, -p.y * (float)scale));
            }
            ++i;
        }
    }

    public void doStopped() {
        if (!this.inline) {
            ((RobotWindow)this.parent).setStoppedButtons();
        }
        this.stoppedPoint = ((RobotGraph)this.graph).env.getCurrentCartesianPosition();
    }

    public void drawSkull() {
        if (!this.inline) {
            JApplet app = ((RobotWindow)this.parent).getApplet();
            CrashDialog hd = new CrashDialog((JFrame)this.parent, app);
        } else {
            CrashDialog crashDialog = new CrashDialog(null, (JApplet)this.parent);
        }
    }

    public void plotPoint(Point p, double dir) {
        if (p != null) {
            int scale = Environment.pixelsPerUnit;
            Point robotOldPos = ((RobotGraph)this.graph).env.getCurrentCartesianPosition();
            Point robotTop = ((RobotRobot)((RobotGraph)this.graph).robots.elementAt(0)).getRobotTop();
            Point robotBottom = ((RobotRobot)((RobotGraph)this.graph).robots.elementAt(0)).getRobotBottom();
            boolean tmpCrashed = RobotGoal.intersectedWithWall(new Point(robotTop.x / (float)scale, -robotTop.y / (float)scale), new Point(robotBottom.x / (float)scale, -robotBottom.y / (float)scale));
            if (tmpCrashed) {
                this.drawSkull();
                this.crashed = true;
                this.stopAuto();
                this.doStopped();
            } else {
                Point point = new Point(p.x * (float)scale, -p.y * (float)scale);
                if (this.showTrace) {
                    ((RobotGraph)this.graph).addTrace(point);
                }
                ((RobotGraph)this.graph).env.setCurrentCartesianPosition(point);
                ((RobotGraph)this.graph).env.setCompass(dir);
                this.repaint();
            }
        }
    }

    public Point getRobotPosition() {
        int scale = Environment.pixelsPerUnit;
        Point p = ((RobotGraph)this.graph).env.getCurrentCartesianPosition();
        return new Point(p.x / (float)scale, p.y / (float)scale);
    }

    public double getRobotDirection() {
        return ((RobotGraph)this.graph).env.getCompass();
    }

    public String getControllerCode() {
        String highCode = ((RobotGraph)this.graph).getHighControllerCode();
        String middleCode = ((RobotGraph)this.graph).getMiddleControllerCode();
        String envCode = ((RobotGraph)this.graph).getEnvironmentCode();
        String initCode = new String("");
        Point robotPos = this.getRobotPosition();
        initCode = String.valueOf(initCode) + "assign(robot_pos,(" + robotPos.x + "," + robotPos.y + "),0.0).\n";
        double direction = this.getRobotDirection();
        initCode = String.valueOf(initCode) + "assign(compass," + direction + ",0.0).\n";
        Vector plan = ((RobotGraph)this.graph).getPlan();
        String planStr = new String("");
        if (plan.size() > 0) {
            planStr = new String("assign(to_do,[");
            int i = 0;
            while (i < plan.size()) {
                String loc = (String)plan.elementAt(i);
                if (i > 0) {
                    planStr = String.valueOf(planStr) + ",";
                }
                planStr = String.valueOf(planStr) + "goto(" + loc + ")";
                ++i;
            }
            planStr = String.valueOf(planStr) + "],0.0).\n";
        } else if (!this.inline) {
            ((RobotWindow)this.parent).setPromptLabel("Plan is empty!!");
        }
        return String.valueOf(initCode) + envCode + middleCode + highCode;
    }

    public String getHighControllerCode() {
        String highCode = ((RobotGraph)this.graph).getHighControllerCode();
        return highCode;
    }

    public String getMedControllerCode() {
        String middleCode = ((RobotGraph)this.graph).getMiddleControllerCode();
        return middleCode;
    }

    public String getEnvControllerCode() {
        String envCode = ((RobotGraph)this.graph).getEnvironmentCode();
        return envCode;
    }

    public String getInitControllerCode() {
        String initCode = new String("");
        Point robotPos = this.getRobotPosition();
        initCode = String.valueOf(initCode) + "assign(robot_pos,(" + robotPos.x + "," + robotPos.y + "),0.0).\n";
        double direction = this.getRobotDirection();
        initCode = String.valueOf(initCode) + "assign(compass," + direction + ",0.0).\n";
        Vector plan = ((RobotGraph)this.graph).getPlan();
        String planStr = new String("");
        if (plan.size() > 0) {
            planStr = new String("assign(to_do,[");
            int i = 0;
            while (i < plan.size()) {
                String loc = (String)plan.elementAt(i);
                if (i > 0) {
                    planStr = String.valueOf(planStr) + ",";
                }
                planStr = String.valueOf(planStr) + "goto(" + loc + ")";
                ++i;
            }
            planStr = String.valueOf(planStr) + "],0.0).\n";
        } else if (!this.inline) {
            ((RobotWindow)this.parent).setPromptLabel("Plan is empty!!");
        }
        initCode = String.valueOf(initCode) + planStr;
        return initCode;
    }

    public boolean checkRunReady() {
        Vector plan;
        if (this.stoppedPoint != null) {
            Point currPos = ((RobotGraph)this.graph).env.getCurrentCartesianPosition();
            if (!currPos.equals(this.stoppedPoint)) {
                this.crashed = false;
                int scale = Environment.pixelsPerUnit;
                Point currPosScaled = new Point(currPos.x / (float)scale, currPos.y / (float)scale);
                double dir = ((RobotGraph)this.graph).env.getCompass();
            } else if (this.crashed) {
                this.showMessage("Information", "Robot in crashed position! Please move robot to another location before running it.");
                return false;
            }
        }
        if ((plan = ((RobotGraph)this.graph).getPlan()).size() != 0) {
            return true;
        }
        this.showMessage("Information", "Cannot run robot.  Plan is empty.");
        return false;
    }

    public void setRobot(Point p, double d) {
        ((RobotGraph)this.graph).env.setCompass(d);
        ((RobotGraph)this.graph).env.setCurrentCartesianPosition(new Point(p.x, -p.y));
    }

    public void setCrashed(boolean v) {
        this.crashed = v;
    }

    public boolean getCrashed() {
        return this.crashed;
    }

    public Point getmPressedPos() {
        return this.mPressedPos;
    }

    public void setPromptLabel(String str) {
        if (!this.inline) {
            ((RobotWindow)this.parent).setPromptLabel(str);
        }
    }

    protected void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("msgBoxClosed")) {
            this.unpause();
        } else if (this.pause) {
            return;
        }
        if (arg.equals("Create Location")) {
            this.createNode(this.entClicked, this.mClickedPos);
        } else if (arg.equals("Create Wall")) {
            this.createEdge(this.entClicked, this.mClickedPos);
            this.tmpMode = this.submode;
            this.submode = 3331;
        } else if (arg.equals("Location Properties")) {
            RobotNode node = (RobotNode)this.entClicked;
            this.showLocationDialog(node);
        } else if (arg.equals("Delete Location")) {
            this.deleteEnt(this.entClicked);
        } else if (arg.equals("Delete Wall")) {
            this.deleteEnt(this.entClicked);
        } else if (arg.equals("Run Robot")) {
            if (!this.inline) {
                ((RobotWindow)this.parent).doRunRobot();
            } else if (this.checkRunReady()) {
                this.runAuto2(true, false);
                this.setRunningState();
            }
        } else if (arg.equals("Step Robot")) {
            if (!this.inline) {
                ((RobotWindow)this.parent).doStepRobot();
            } else if (this.checkRunReady()) {
                this.runAuto2(true, true);
                this.setRunningState();
            }
        } else if (arg.equals("Stop Robot")) {
            if (!this.inline) {
                ((RobotWindow)this.parent).doStopRobot();
            } else {
                this.stopAuto();
                this.setStoppedState();
            }
        } else if (arg.equals("Reset Robot")) {
            if (!this.inline) {
                ((RobotWindow)this.parent).doResetRobot();
            } else {
                this.stopAuto();
                this.resetAuto();
                this.clearTrace();
                this.setResetState();
            }
        } else if (arg.equals("Clear Trace")) {
            this.clearTrace();
        } else if (arg.equals("View/Modify Plan")) {
            PlannerFrame plannerFrame = new PlannerFrame(this);
        } else if (arg.equals("View/Modify Robot Properties")) {
            this.setAutoProperties();
        } else if (arg.equals("Robot Properties")) {
            this.setAutoProperties();
        } else if (arg.equals("Autoscale")) {
            this.autoscale();
        } else if (arg.equals("Pan")) {
            this.setRMode(4440);
            ((RobotWindow)this.parent).setPanZoom(1);
            ((RobotWindow)this.parent).setPromptLabel("Drag the right mouse button to pan the graph.");
        } else if (arg.equals("Zoom")) {
            this.setRMode(4441);
            ((RobotWindow)this.parent).setPanZoom(0);
            ((RobotWindow)this.parent).setPromptLabel("Drag the right mouse button up to zoom in and down to zoom out.");
        }
        this.graph.deselectAll();
    }

    protected void kPressed(KeyEvent e) {
        int arg = e.getKeyCode();
        if (arg == 127) {
            if (this.isRunning() && ((RobotGraph)this.graph).getNumSelectedNodes() > 0) {
                this.showMessage("Error", "Cannot delete location when robot is running.");
                return;
            }
            this.graph.deleteSelected();
            this.repaint();
        }
        if (arg == 27) {
            this.makingEdge = 0;
            this.submode = this.tmpMode;
            this.repaint();
        }
    }
}

