/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.XMLReader.XMLBlock;
import CIspace.XMLReader.XMLTree;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import CIspace.robot.Environment;
import CIspace.robot.HighLayerController;
import CIspace.robot.InvisibleNode;
import CIspace.robot.MiddleLayerController;
import CIspace.robot.RobotEdge;
import CIspace.robot.RobotGraphCanvas;
import CIspace.robot.RobotNode;
import CIspace.robot.RobotRobot;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class RobotGraph
extends Graph {
    public Environment env;
    public MiddleLayerController middle;
    public HighLayerController high;
    protected Vector invisibleNodes = new Vector(10, 10);
    protected Vector selectedInvisibleNodes = new Vector(10, 10);
    protected Vector robots = new Vector(10, 10);
    protected Vector selectedRobots = new Vector(10, 10);
    protected Vector traces = new Vector(10, 10);
    protected Vector plan = new Vector();
    protected String highControllerCode;
    protected String middleControllerCode;
    protected String environmentCode;
    protected Point refPressedPoint = null;

    public RobotGraph(GraphCanvas canvas) {
        super(canvas);
        this.env = new Environment(this);
        this.middle = new MiddleLayerController(this.env);
        this.high = new HighLayerController(this.middle, this.env);
        this.highControllerCode = new String("");
        this.middleControllerCode = new String("");
        this.environmentCode = new String("");
    }

    public void deleteSelected() {
        int i = 0;
        while (i < this.selectedInvisibleNodes.size()) {
            RobotEdge e;
            InvisibleNode n = (InvisibleNode)this.selectedInvisibleNodes.elementAt(i);
            Vector[] connected = n.getAllEdges();
            while (connected[0].size() > 0) {
                e = (RobotEdge)connected[0].firstElement();
                e.removeFromNodes();
                this.edges.removeElement(e);
            }
            while (connected[1].size() > 0) {
                e = (RobotEdge)connected[1].firstElement();
                e.removeFromNodes();
                this.edges.removeElement(e);
            }
            this.invisibleNodes.removeElement(n);
            ++i;
        }
        this.selectedInvisibleNodes.removeAllElements();
        i = 0;
        while (i < this.selectedNodes.size()) {
            RobotNode rn = (RobotNode)this.selectedNodes.elementAt(i);
            this.removeNodeFromPlan(rn.getName());
            ++i;
        }
        super.deleteSelected();
    }

    public void addInvisibleNode(Object o, String l, Point p, Color c, int s) {
        InvisibleNode newNode = new InvisibleNode(this, l, p, c, s);
        newNode.setIndex(this.numInvisibleNodes());
        this.invisibleNodes.addElement(newNode);
    }

    public void addInvisibleNode(InvisibleNode newNode) {
        newNode.setIndex(this.numInvisibleNodes());
        this.invisibleNodes.addElement(newNode);
    }

    public void addRobot(Object o, String l, Point p, Color c, int s) {
        if (this.robots.size() > 0) {
            return;
        }
        RobotRobot newRobot = new RobotRobot(this, l, p, c, s);
        newRobot.setIndex(this.numRobots());
        this.robots.addElement(newRobot);
    }

    public void addRobot(RobotRobot newRobot) {
        if (this.robots.size() > 0) {
            return;
        }
        newRobot.setIndex(this.numRobots());
        this.robots.addElement(newRobot);
    }

    public int numInvisibleNodes() {
        return this.invisibleNodes.size();
    }

    public int numRobots() {
        return this.robots.size();
    }

    public InvisibleNode invisibleNodeAt(int index) {
        return (InvisibleNode)this.invisibleNodes.elementAt(index);
    }

    public RobotRobot robotAt(int index) {
        return (RobotRobot)this.robots.elementAt(index);
    }

    public void setScale(float newScale) {
        if (newScale == 0.0f) {
            this.scale = 1.0f;
            return;
        }
        if (newScale < 0.0f) {
            return;
        }
        int i = 0;
        while (i < this.numNodes()) {
            this.nodeAt((int)i).pos.scale(newScale / this.scale);
            ++i;
        }
        i = 0;
        while (i < this.numEdges()) {
            this.edgeAt(i).updateLength();
            ++i;
        }
        i = 0;
        while (i < this.numInvisibleNodes()) {
            this.invisibleNodeAt((int)i).pos.scale(newScale / this.scale);
            ++i;
        }
        i = 0;
        while (i < this.numRobots()) {
            this.robotAt((int)i).pos.scale(newScale / this.scale);
            ++i;
        }
        i = 0;
        while (i < this.traces.size()) {
            Point p = (Point)this.traces.elementAt(i);
            p.scale(newScale / this.scale);
            ++i;
        }
        this.scale = newScale;
    }

    public Entity searchEntities(Point p) {
        int i = 0;
        while (i < this.numRobots()) {
            if (this.robotAt(i).contains(p)) {
                return this.robotAt(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.numInvisibleNodes()) {
            if (this.invisibleNodeAt(i).contains(p)) {
                return this.invisibleNodeAt(i);
            }
            ++i;
        }
        return super.searchEntities(p);
    }

    public Vector searchEntities(Point a, Point b) {
        Vector selected = super.searchEntities(a, b);
        int i = 0;
        while (i < this.numRobots()) {
            if (this.robotAt(i).isInRect(a, b)) {
                selected.addElement(this.robotAt(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.numInvisibleNodes()) {
            if (this.invisibleNodeAt(i).isInRect(a, b)) {
                selected.addElement(this.invisibleNodeAt(i));
            }
            ++i;
        }
        return selected;
    }

    public boolean select(Entity ent) {
        if (!ent.isSelected) {
            if (ent.type == 7778) {
                this.selectedRobots.addElement(ent);
                ent.isSelected = true;
                return true;
            }
            if (ent.type == 7779) {
                this.selectedInvisibleNodes.addElement(ent);
                ent.isSelected = true;
                return true;
            }
            return super.select(ent);
        }
        return true;
    }

    public boolean deselect(Entity ent) {
        if (ent.isSelected) {
            if (ent.type == 7779) {
                this.selectedInvisibleNodes.removeElement(ent);
                ent.isSelected = false;
            } else if (ent.type == 7778) {
                this.selectedRobots.removeElement(ent);
                ent.isSelected = false;
            } else {
                super.deselect(ent);
            }
        }
        return this.selectedInvisibleNodes.size() > 0 || this.selectedNodes.size() > 0 || this.selectedEdges.size() > 0 || this.selectedRobots.size() > 0;
    }

    public boolean deselectAll() {
        this.refPressedPoint = null;
        int i = 0;
        while (i < this.selectedInvisibleNodes.size()) {
            ((Entity)this.selectedInvisibleNodes.elementAt((int)i)).isSelected = false;
            ++i;
        }
        this.selectedInvisibleNodes.removeAllElements();
        i = 0;
        while (i < this.selectedRobots.size()) {
            ((Entity)this.selectedRobots.elementAt((int)i)).isSelected = false;
            ++i;
        }
        this.selectedRobots.removeAllElements();
        return super.deselectAll();
    }

    public void translateAll(float dx, float dy) {
        super.translateAll(dx, dy);
        int i = 0;
        while (i < this.invisibleNodes.size()) {
            this.invisibleNodeAt(i).translate(dx, dy);
            ++i;
        }
        i = 0;
        while (i < this.robots.size()) {
            this.robotAt(i).translate(dx, dy);
            ++i;
        }
        i = 0;
        while (i < this.traces.size()) {
            Point p = (Point)this.traces.elementAt(i);
            p.translate(dx, dy);
            ++i;
        }
    }

    public void moveEntities(Point to, Entity n) {
        Entity ent;
        Point from;
        float dx = 0.0f;
        float dy = 0.0f;
        if (n.type == 7770) {
            RobotNode rn = (RobotNode)n;
            from = new Point(rn.pos);
            rn.move(to);
            dx = to.x - from.x;
            dy = to.y - from.y;
        } else if (n.type == 7779) {
            InvisibleNode in = (InvisibleNode)n;
            from = new Point(in.pos);
            in.move(to);
            dx = to.x - from.x;
            dy = to.y - from.y;
        } else if (n.type == 7778) {
            RobotRobot rr = (RobotRobot)n;
            from = new Point(rr.pos);
            rr.move(to);
            dx = to.x - from.x;
            dy = to.y - from.y;
        } else if (n.type == 7771) {
            if (this.refPressedPoint == null) {
                this.refPressedPoint = ((RobotGraphCanvas)this.canvas).getmPressedPos();
            }
            dx = to.x - this.refPressedPoint.x;
            dy = to.y - this.refPressedPoint.y;
            this.refPressedPoint = new Point(to.x, to.y);
        }
        int i = 0;
        while (i < this.selectedNodes.size()) {
            ent = (Entity)this.selectedNodes.elementAt(i);
            if (ent != n) {
                ent.translate(dx, dy);
            }
            ++i;
        }
        i = 0;
        while (i < this.selectedInvisibleNodes.size()) {
            ent = (Entity)this.selectedInvisibleNodes.elementAt(i);
            if (ent != n) {
                ent.translate(dx, dy);
            }
            ++i;
        }
        i = 0;
        while (i < this.selectedRobots.size()) {
            ent = (Entity)this.selectedRobots.elementAt(i);
            if (ent != n) {
                ent.translate(dx, dy);
            }
            ++i;
        }
    }

    public Point[] getBound() {
        if (this.numNodes() == 0 && this.numInvisibleNodes() == 0) {
            Point[] tmp = new Point[]{new Point(0.0f, 0.0f), new Point(0.0f, 0.0f)};
            return tmp;
        }
        Node n = this.robotAt(0);
        float minx = n.pos.x - (float)(n.width / 2);
        float miny = n.pos.y - (float)(n.height / 2);
        float maxx = n.pos.x + (float)(n.width / 2);
        float maxy = n.pos.y + (float)(n.height / 2);
        int i = 1;
        while (i < this.numRobots()) {
            n = this.robotAt(i);
            if (n.pos.x - (float)(n.width / 2) < minx) {
                minx = n.pos.x - (float)(n.width / 2);
            }
            if (n.pos.x + (float)(n.width / 2) > maxx) {
                maxx = n.pos.x + (float)(n.width / 2);
            }
            if (n.pos.y - (float)(n.height / 2) < miny) {
                miny = n.pos.y - (float)(n.height / 2);
            }
            if (n.pos.y + (float)(n.height / 2) > maxy) {
                maxy = n.pos.y + (float)(n.height / 2);
            }
            ++i;
        }
        i = 0;
        while (i < this.numNodes()) {
            n = this.nodeAt(i);
            if (n.pos.x - (float)(n.width / 2) < minx) {
                minx = n.pos.x - (float)(n.width / 2);
            }
            if (n.pos.x + (float)(n.width / 2) > maxx) {
                maxx = n.pos.x + (float)(n.width / 2);
            }
            if (n.pos.y - (float)(n.height / 2) < miny) {
                miny = n.pos.y - (float)(n.height / 2);
            }
            if (n.pos.y + (float)(n.height / 2) > maxy) {
                maxy = n.pos.y + (float)(n.height / 2);
            }
            ++i;
        }
        i = 0;
        while (i < this.numInvisibleNodes()) {
            n = this.invisibleNodeAt(i);
            if (n.pos.x - (float)(n.width / 2) < minx) {
                minx = n.pos.x - (float)(n.width / 2);
            }
            if (n.pos.x + (float)(n.width / 2) > maxx) {
                maxx = n.pos.x + (float)(n.width / 2);
            }
            if (n.pos.y - (float)(n.height / 2) < miny) {
                miny = n.pos.y - (float)(n.height / 2);
            }
            if (n.pos.y + (float)(n.height / 2) > maxy) {
                maxy = n.pos.y + (float)(n.height / 2);
            }
            ++i;
        }
        float pad = 5.0f;
        Point[] tmp = new Point[]{new Point(minx - pad, miny - pad), new Point(maxx + pad, maxy + pad)};
        return tmp;
    }

    protected boolean validInvisibleNodeIndex(int index) {
        int i = 0;
        while (i < this.numInvisibleNodes()) {
            if (this.invisibleNodeAt((int)i).index == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getLastInvisibleNodeIndex() {
        if (this.numInvisibleNodes() == 0) {
            return -1;
        }
        return this.invisibleNodeAt((int)(this.numInvisibleNodes() - 1)).index;
    }

    public int getNextInvisibleNodeIndex() {
        int index = 0;
        int i = 0;
        while (i < this.numInvisibleNodes()) {
            if (index != this.invisibleNodeAt((int)i).index) {
                return index;
            }
            index = this.invisibleNodeAt((int)i).index + 1;
            ++i;
        }
        return index;
    }

    public InvisibleNode invisibleNodeFromIndex(int index) {
        if (index < this.numInvisibleNodes() && index == this.invisibleNodeAt((int)index).index) {
            return this.invisibleNodeAt(index);
        }
        int i = 0;
        while (i < this.numInvisibleNodes()) {
            if (index == this.invisibleNodeAt((int)i).index) {
                return this.invisibleNodeAt(i);
            }
            ++i;
        }
        return null;
    }

    public void printSelected() {
        System.out.println(String.valueOf(this.selectedNodes.size()) + ", " + this.selectedEdges.size() + ", " + this.selectedInvisibleNodes.size() + ", " + this.selectedRobots.size() + "; " + this.numInvisibleNodes());
    }

    public void draw(Graphics offscreen, boolean moving) {
        super.draw(offscreen, moving);
        int i = this.numInvisibleNodes() - 1;
        while (i >= 0) {
            this.invisibleNodeAt(i).draw(offscreen, moving);
            --i;
        }
        offscreen.setColor(Color.gray);
        int i2 = this.traces.size() - 1;
        while (i2 >= 0) {
            Point p = (Point)this.traces.elementAt(i2);
            offscreen.fillOval((int)p.x - 2, (int)p.y - 2, 4, 4);
            --i2;
        }
        i2 = this.numRobots() - 1;
        while (i2 >= 0) {
            this.robotAt(i2).draw(offscreen, moving);
            --i2;
        }
    }

    public String generateTextRep() {
        String outString = new String("");
        int scale = Environment.pixelsPerUnit;
        Calendar now = Calendar.getInstance();
        outString = String.valueOf(outString) + "% Auto-generated on " + now.getTime().toString() + "\n\n";
        outString = String.valueOf(outString) + "% Locations\n";
        outString = String.valueOf(outString) + "% L: index, location_name, x_position, y_position;\n";
        int i = 0;
        while (i < this.numNodes()) {
            RobotNode tmpNode = (RobotNode)this.nodeAt(i);
            outString = String.valueOf(outString) + "L: " + RobotGraph.chompAt(tmpNode.getName()) + ", " + tmpNode.pos.x / (float)scale + ", " + -tmpNode.pos.y / (float)scale + ";\n";
            ++i;
        }
        outString = String.valueOf(outString) + "\n% Walls\n";
        outString = String.valueOf(outString) + "% W: from_x_position, from_y_position, to_x_position, to_y_position;\n";
        int i2 = 0;
        while (i2 < this.numEdges()) {
            RobotEdge edge = (RobotEdge)this.edgeAt(i2);
            int fromIndex = edge.start.index;
            int toIndex = edge.end.index;
            InvisibleNode fromNode = this.invisibleNodeFromIndex(fromIndex);
            InvisibleNode toNode = this.invisibleNodeFromIndex(toIndex);
            outString = fromNode == null || toNode == null ? String.valueOf(outString) + "ERROR: EDGE #" + i2 + " NOT VALID\n" : String.valueOf(outString) + "W: " + fromNode.pos.x / (float)scale + ", " + -fromNode.pos.y / (float)scale + ", " + toNode.pos.x / (float)scale + ", " + -toNode.pos.y / (float)scale + ";\n";
            ++i2;
        }
        outString = String.valueOf(outString) + "\n% Robots\n";
        outString = String.valueOf(outString) + "% R: x_position, y_position, direction;\n";
        int i3 = 0;
        while (i3 < this.numRobots()) {
            RobotRobot robot = this.robotAt(i3);
            outString = String.valueOf(outString) + "R: " + robot.pos.x / (float)scale + ", " + -robot.pos.y / (float)scale + ", " + robot.direction + ";\n";
            ++i3;
        }
        outString = String.valueOf(outString) + "\n% Plan\n";
        outString = String.valueOf(outString) + "% P: location_1, location_2, location_3, ..., location_N;\n";
        outString = String.valueOf(outString) + "P: ";
        i3 = 0;
        while (i3 < this.plan.size()) {
            if (i3 > 0) {
                outString = String.valueOf(outString) + ", ";
            }
            outString = String.valueOf(outString) + RobotGraph.chompAt((String)this.plan.elementAt(i3));
            ++i3;
        }
        outString = String.valueOf(outString) + ";\n";
        return outString;
    }

    public String updateGraphFromText(String allText) {
        String errorMessage = new String("");
        StringTokenizer tokenizer = new StringTokenizer(allText, "\n");
        int lineCount = 0;
        boolean eof = false;
        try {
            while (tokenizer.hasMoreTokens()) {
                String inString = tokenizer.nextToken().trim();
                if (inString.length() > 0 && inString.charAt(0) != '%') {
                    boolean lineComplete = false;
                    String line = new String("");
                    while (!eof && !lineComplete) {
                        if (inString.length() > 0 && inString.charAt(0) != '%') {
                            StringTokenizer tokenizer2 = new StringTokenizer(inString, "%");
                            String tmpStr = tokenizer2.nextToken().trim();
                            line = String.valueOf(line) + " " + tmpStr;
                            if (tmpStr.charAt(tmpStr.length() - 1) == ';') {
                                lineComplete = true;
                            }
                        }
                        if (lineComplete) continue;
                        if (tokenizer.hasMoreTokens()) {
                            inString = tokenizer.nextToken().trim();
                            if (inString.charAt(1) == ':') {
                                errorMessage = new String("Missing semicolon in line " + lineCount);
                                throw new Exception();
                            }
                            ++lineCount;
                            continue;
                        }
                        eof = true;
                        errorMessage = new String("Missing semicolon in line " + lineCount);
                        throw new Exception();
                    }
                    errorMessage = this.parseLine(inString);
                    if (errorMessage.length() > 0) {
                        throw new Exception();
                    }
                }
                ++lineCount;
            }
            return "OK";
        }
        catch (Exception e) {
            if (errorMessage.length() > 0) {
                return "Error at line " + (lineCount + 1) + " -- " + errorMessage;
            }
            return "Error at line " + (lineCount + 1) + " -- " + e;
        }
    }

    public String parseLine(String inString) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(inString, ":,;\t\n\r\f");
        int numTokens = tokenizer.countTokens();
        if (numTokens < 1) {
            return "Incomplete line";
        }
        int scale = Environment.pixelsPerUnit;
        String type = tokenizer.nextToken().trim();
        if (type.charAt(0) == 'L') {
            if (numTokens != 4) {
                return "Incorrect number of parameter values";
            }
            String name = tokenizer.nextToken().trim();
            float posX = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)scale;
            float posY = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)(-scale);
            RobotNode node = new RobotNode(this, new Point(posX, posY));
            name = "@" + name;
            node.setName(name);
            node.updateSize();
            this.addNode(node);
        } else if (type.charAt(0) == 'W') {
            if (numTokens != 5) {
                return "Incorrect number of parameter values";
            }
            float posXFrom = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)scale;
            float posYFrom = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)(-scale);
            float posXTo = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)scale;
            float posYTo = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)(-scale);
            InvisibleNode from = null;
            InvisibleNode to = null;
            int i = 0;
            while (i < this.numInvisibleNodes()) {
                InvisibleNode tmpNode = this.invisibleNodeAt(i);
                if (tmpNode.pos.x == posXFrom && tmpNode.pos.y == posYFrom) {
                    from = tmpNode;
                }
                if (tmpNode.pos.x == posXTo && tmpNode.pos.y == posYTo) {
                    to = tmpNode;
                }
                ++i;
            }
            if (from == null) {
                from = new InvisibleNode(this, new Point(posXFrom, posYFrom));
                this.addInvisibleNode(from);
            }
            if (to == null) {
                to = new InvisibleNode(this, new Point(posXTo, posYTo));
                this.addInvisibleNode(to);
            }
            RobotEdge edge = new RobotEdge(this, from, to);
            this.addEdge(edge);
        } else if (type.charAt(0) == 'R') {
            if (numTokens != 4) {
                return "Incorrect number of parameter values";
            }
            float posX = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)scale;
            float posY = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)(-scale);
            double direction = Double.valueOf(tokenizer.nextToken().trim());
            RobotRobot robot = new RobotRobot(this, new Point(posX, posY));
            robot.setRobotDirection(direction);
            this.addRobot(robot);
        } else if (type.charAt(0) == 'P') {
            while (tokenizer.hasMoreTokens()) {
                String nextGoalName = tokenizer.nextToken().trim();
                boolean exists = this.nodeNameExists("@" + nextGoalName);
                if (!exists) {
                    return "Goal '" + nextGoalName + "' does not exist";
                }
                this.plan.addElement("@" + nextGoalName);
            }
        } else {
            return "Unknown type '" + type + "'";
        }
        return "";
    }

    public String parseXML(String inputString) {
        XMLTree robotTree = new XMLTree();
        robotTree.readString(inputString);
        String errString = this.parseXMLTree(robotTree);
        return errString;
    }

    public String parseXMLTree(XMLTree tree) {
        String errorString = "";
        try {
            Vector r;
            Vector walls;
            XMLBlock highcontroller = tree.findNetworkTree("highcontroller");
            if (highcontroller == null) {
                errorString = "No high level controller defined";
                throw new Exception();
            }
            Vector highlogic = highcontroller.searchChildTag("logicprogram");
            if (highlogic == null) {
                errorString = "No logic program defined for high level controller";
                throw new Exception();
            }
            String logicprogram = ((XMLBlock)highlogic.elementAt(0)).getText();
            this.setHighControllerCode(logicprogram.trim());
            XMLBlock midcontroller = tree.findNetworkTree("middlecontroller");
            if (midcontroller == null) {
                errorString = "No middle level controller defined";
                throw new Exception();
            }
            Vector midlogic = midcontroller.searchChildTag("logicprogram");
            if (midlogic == null) {
                errorString = "No logic program defined for middle level controller";
                throw new Exception();
            }
            logicprogram = ((XMLBlock)midlogic.elementAt(0)).getText();
            this.setMiddleControllerCode(logicprogram.trim());
            XMLBlock environment = tree.findNetworkTree("environment");
            if (environment == null) {
                errorString = "No environment defined";
                throw new Exception();
            }
            Vector envlogic = environment.searchChildTag("logicprogram");
            if (envlogic == null) {
                errorString = "No logic program defined for environment";
                throw new Exception();
            }
            logicprogram = ((XMLBlock)envlogic.elementAt(0)).getText();
            this.setEnvironmentCode(logicprogram.trim());
            int scale = Environment.pixelsPerUnit;
            XMLBlock world = tree.findNetworkTree("world");
            if (world == null) {
                errorString = "World is not defined";
                throw new Exception();
            }
            Vector locs = world.searchChildTag("location");
            if (locs != null) {
                int i = 0;
                while (i < locs.size()) {
                    XMLBlock thisloc = (XMLBlock)locs.elementAt(i);
                    String name = "";
                    Vector n = thisloc.searchChildTag("name");
                    if (n == null) {
                        errorString = "One of the nodes defined in the world has no name";
                        throw new Exception();
                    }
                    name = ((XMLBlock)n.elementAt(0)).getText();
                    Vector position = thisloc.searchChildTag("property");
                    if (position == null) {
                        errorString = "Node " + name + " does not have a location";
                        throw new Exception();
                    }
                    String posString = ((XMLBlock)position.elementAt(0)).getText();
                    posString = posString.substring(posString.indexOf("(") + 1, posString.indexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(posString, " ,");
                    float posX = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)scale;
                    float posY = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)(-scale);
                    RobotNode node = new RobotNode(this, new Point(posX, posY));
                    name = "@" + name;
                    node.setName(name);
                    node.updateSize();
                    this.addNode(node);
                    ++i;
                }
            }
            if ((walls = world.searchChildTag("wall")) != null) {
                int i = 0;
                while (i < walls.size()) {
                    XMLBlock thiswall = (XMLBlock)walls.elementAt(i);
                    Vector startPos = thiswall.searchChildTag("start");
                    Vector endPos = thiswall.searchChildTag("end");
                    if (startPos == null) {
                        errorString = "A wall does not have a start position";
                        throw new Exception();
                    }
                    if (endPos == null) {
                        errorString = "A wall does not have an end position";
                        throw new Exception();
                    }
                    String posFrom = ((XMLBlock)startPos.elementAt(0)).getText();
                    posFrom = posFrom.substring(posFrom.indexOf("(") + 1, posFrom.indexOf(")"));
                    StringTokenizer fromTokenizer = new StringTokenizer(posFrom, " ,");
                    String posTo = ((XMLBlock)endPos.elementAt(0)).getText();
                    posTo = posTo.substring(posTo.indexOf("(") + 1, posTo.indexOf(")"));
                    StringTokenizer toTokenizer = new StringTokenizer(posTo, " ,");
                    float posXFrom = Float.valueOf(fromTokenizer.nextToken().trim()).floatValue() * (float)scale;
                    float posYFrom = Float.valueOf(fromTokenizer.nextToken().trim()).floatValue() * (float)(-scale);
                    float posXTo = Float.valueOf(toTokenizer.nextToken().trim()).floatValue() * (float)scale;
                    float posYTo = Float.valueOf(toTokenizer.nextToken().trim()).floatValue() * (float)(-scale);
                    InvisibleNode from = null;
                    InvisibleNode to = null;
                    int j = 0;
                    while (j < this.numInvisibleNodes()) {
                        InvisibleNode tmpNode = this.invisibleNodeAt(j);
                        if (tmpNode.pos.x == posXFrom && tmpNode.pos.y == posYFrom) {
                            from = tmpNode;
                        }
                        if (tmpNode.pos.x == posXTo && tmpNode.pos.y == posYTo) {
                            to = tmpNode;
                        }
                        ++j;
                    }
                    if (from == null) {
                        from = new InvisibleNode(this, new Point(posXFrom, posYFrom));
                        this.addInvisibleNode(from);
                    }
                    if (to == null) {
                        to = new InvisibleNode(this, new Point(posXTo, posYTo));
                        this.addInvisibleNode(to);
                    }
                    RobotEdge edge = new RobotEdge(this, from, to);
                    this.addEdge(edge);
                    ++i;
                }
            }
            if ((r = world.searchChildTag("robot")) == null) {
                errorString = "No robot defined";
                throw new Exception();
            }
            if (r.size() > 1) {
                errorString = "Multiple robots defined";
                throw new Exception();
            }
            XMLBlock thisrobot = (XMLBlock)r.elementAt(0);
            Vector position = thisrobot.searchChildTag("property");
            if (position == null) {
                errorString = "Robot does not have a position defined";
                throw new Exception();
            }
            String posString = ((XMLBlock)position.elementAt(0)).getText();
            posString = posString.substring(posString.indexOf("(") + 1, posString.indexOf(")"));
            StringTokenizer tokenizer = new StringTokenizer(posString, " ,");
            float posX = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)scale;
            float posY = Float.valueOf(tokenizer.nextToken().trim()).floatValue() * (float)(-scale);
            Vector dir = thisrobot.searchChildTag("direction");
            if (dir == null) {
                errorString = "Robot direction not defined";
                throw new Exception();
            }
            String dirString = ((XMLBlock)dir.elementAt(0)).getText();
            double direction = Double.valueOf(dirString.trim());
            RobotRobot robot = new RobotRobot(this, new Point(posX, posY));
            robot.setRobotDirection(direction);
            this.addRobot(robot);
            Vector plans = world.searchChildTag("plan");
            if (plans != null) {
                XMLBlock thisplan = (XMLBlock)plans.elementAt(0);
                Vector planlocations = thisplan.searchChildTag("loc");
                int j = 0;
                while (j < planlocations.size()) {
                    XMLBlock currLoc = (XMLBlock)planlocations.elementAt(j);
                    String nextGoalName = currLoc.getText().trim();
                    boolean exists = this.nodeNameExists("@" + nextGoalName);
                    if (!exists) {
                        return "Goal '" + nextGoalName + "' does not exist";
                    }
                    this.plan.addElement("@" + nextGoalName);
                    ++j;
                }
            }
        }
        catch (Exception e) {
            if (errorString.length() > 0) {
                return "Error: " + errorString;
            }
            return "Error: " + e.toString();
        }
        return "OK";
    }

    private String stripComments(String s, String defaultCode) {
        int commentIndex = s.indexOf(defaultCode);
        String returnString = "";
        if (commentIndex == -1) {
            return s;
        }
        returnString = String.valueOf(s.substring(0, commentIndex)) + s.substring(commentIndex + defaultCode.length());
        return returnString;
    }

    public String generateXMLTextRep() {
        int scale = Environment.pixelsPerUnit;
        String rep = "";
        rep = String.valueOf(rep) + "<ROBOTXML VERSION=\"0.1\">\n\n";
        rep = String.valueOf(rep) + "<!-- WORLD REPRESENTATION -->\n\n";
        rep = String.valueOf(rep) + "<WORLD>\n\n";
        if (this.numNodes() > 0) {
            rep = String.valueOf(rep) + "<!-- Locations -->\n";
        }
        int i = 0;
        while (i < this.numNodes()) {
            RobotNode tmpNode = (RobotNode)this.nodeAt(i);
            rep = String.valueOf(rep) + "<LOCATION>\n";
            rep = String.valueOf(rep) + "   <NAME>" + RobotGraph.chompAt(tmpNode.getName()) + "</NAME>\n";
            rep = String.valueOf(rep) + "   <PROPERTY>position=(" + tmpNode.pos.x / (float)scale + ", " + -tmpNode.pos.y / (float)scale + ")</PROPERTY>\n";
            rep = String.valueOf(rep) + "</LOCATION>\n\n";
            ++i;
        }
        if (this.numEdges() > 0) {
            rep = String.valueOf(rep) + "<!-- Walls -->\n";
        }
        int i2 = 0;
        while (i2 < this.numEdges()) {
            RobotEdge edge = (RobotEdge)this.edgeAt(i2);
            int fromIndex = edge.start.index;
            int toIndex = edge.end.index;
            InvisibleNode fromNode = this.invisibleNodeFromIndex(fromIndex);
            InvisibleNode toNode = this.invisibleNodeFromIndex(toIndex);
            rep = String.valueOf(rep) + "<WALL>\n";
            if (fromNode != null && toNode != null) {
                rep = String.valueOf(rep) + "   <START>position=(" + fromNode.pos.x / (float)scale + ", " + -fromNode.pos.y / (float)scale + ")</START>\n" + "   <END>position=(" + toNode.pos.x / (float)scale + ", " + -toNode.pos.y / (float)scale + ")</END>\n";
                rep = String.valueOf(rep) + "</WALL>\n\n";
            }
            ++i2;
        }
        if (this.numRobots() > 0) {
            rep = String.valueOf(rep) + "<!-- Robots -->\n";
        }
        int i3 = 0;
        while (i3 < this.numRobots()) {
            RobotRobot robot = this.robotAt(i3);
            rep = String.valueOf(rep) + "<ROBOT>\n";
            rep = String.valueOf(rep) + "   <PROPERTY>position=(" + robot.pos.x / (float)scale + ", " + -robot.pos.y / (float)scale + ")</PROPERTY>\n";
            rep = String.valueOf(rep) + "   <DIRECTION>" + robot.direction + "</DIRECTION>\n";
            rep = String.valueOf(rep) + "</ROBOT>\n\n";
            ++i3;
        }
        if (this.plan.size() > 0) {
            rep = String.valueOf(rep) + "<!-- Plan -->\n";
            rep = String.valueOf(rep) + "<PLAN>\n";
        }
        i3 = 0;
        while (i3 < this.plan.size()) {
            rep = String.valueOf(rep) + "   <LOC>" + RobotGraph.chompAt((String)this.plan.elementAt(i3)) + "</LOC>\n";
            ++i3;
        }
        if (this.plan.size() > 0) {
            rep = String.valueOf(rep) + "</PLAN>\n\n";
        }
        rep = String.valueOf(rep) + "</WORLD>\n\n";
        rep = String.valueOf(rep) + "<!-- PROLOG SECTION -->\n";
        rep = String.valueOf(rep) + "<!-- High Layer Controller -->\n\n";
        rep = String.valueOf(rep) + "<HIGHCONTROLLER>\n";
        rep = String.valueOf(rep) + "<LogicProgram>\n";
        rep = String.valueOf(rep) + this.stripComments(this.getHighControllerCode(), this.high.getCommentedDefaultCode());
        rep = String.valueOf(rep) + "\n</LogicProgram>\n";
        rep = String.valueOf(rep) + "</HIGHCONTROLLER>\n\n";
        rep = String.valueOf(rep) + "<!-- Middle Layer Controller -->\n\n";
        rep = String.valueOf(rep) + "<MIDDLECONTROLLER>\n";
        rep = String.valueOf(rep) + "<LogicProgram>\n";
        rep = String.valueOf(rep) + this.stripComments(this.getMiddleControllerCode(), this.middle.getCommentedDefaultCode());
        rep = String.valueOf(rep) + "\n</LogicProgram>\n";
        rep = String.valueOf(rep) + "</MIDDLECONTROLLER>\n\n";
        rep = String.valueOf(rep) + "<!-- Environment -->\n\n";
        rep = String.valueOf(rep) + "<ENVIRONMENT>\n";
        rep = String.valueOf(rep) + "<LogicProgram>\n";
        rep = String.valueOf(rep) + this.stripComments(this.getEnvironmentCode(), this.env.getCommentedDefaultCode());
        rep = String.valueOf(rep) + "\n</LogicProgram>\n";
        rep = String.valueOf(rep) + "</ENVIRONMENT>\n";
        rep = String.valueOf(rep) + "</ROBOTXML>";
        return rep;
    }

    public boolean nodeNameExists(String name) {
        int i = 0;
        while (i < this.numNodes()) {
            RobotNode node = (RobotNode)this.nodeAt(i);
            if (node.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector getEdgesVector() {
        return this.edges;
    }

    public Vector getNodesVector() {
        return this.nodes;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public MiddleLayerController getMiddleLayerController() {
        return this.middle;
    }

    public HighLayerController getHighLayerController() {
        return this.high;
    }

    public void addTrace(Point p) {
        this.traces.addElement(new Point(p.x, p.y));
    }

    public void clearTrace() {
        this.traces.removeAllElements();
    }

    public Vector getPlan() {
        return this.plan;
    }

    public void addNodeToPlan(String nodeName) {
        this.plan.addElement(nodeName);
    }

    public void removeNodeFromPlan(String nodeName) {
        boolean removed = true;
        while (removed) {
            removed = this.plan.removeElement(nodeName);
        }
    }

    public void changeNodeNameInPlan(String oldName, String newName) {
        int i = 0;
        while (i < this.plan.size()) {
            if (oldName.equals((String)this.plan.elementAt(i))) {
                this.plan.setElementAt(newName, i);
            }
            ++i;
        }
    }

    public void updatePlanner(Vector p) {
        this.plan = p;
        if (this.plan.size() == 0) {
            this.canvas.showMessage("Warning", "Plan is empty!");
        }
    }

    public String getMiddleControllerCode() {
        if (this.middleControllerCode.equals("")) {
            return this.getDefaultMiddleControllerCode();
        }
        if (this.middleControllerCode.indexOf(this.middle.getCommentedDefaultCode()) == -1) {
            return String.valueOf(this.middleControllerCode) + this.middle.getCommentedDefaultCode();
        }
        return this.middleControllerCode;
    }

    public void setMiddleControllerCode(String text) {
        this.middleControllerCode = text;
    }

    public String getHighControllerCode() {
        if (this.highControllerCode.equals("")) {
            return this.getDefaultHighControllerCode();
        }
        if (this.highControllerCode.indexOf(this.high.getCommentedDefaultCode()) == -1) {
            return String.valueOf(this.highControllerCode) + this.high.getCommentedDefaultCode();
        }
        return this.highControllerCode;
    }

    public void setHighControllerCode(String text) {
        this.highControllerCode = text;
    }

    public String getEnvironmentCode() {
        if (this.environmentCode.equals("")) {
            return this.getDefaultEnvironmentCode();
        }
        if (this.environmentCode.indexOf(this.env.getCommentedDefaultCode()) == -1) {
            return String.valueOf(this.environmentCode) + this.env.getCommentedDefaultCode();
        }
        return this.environmentCode;
    }

    public void setEnvironmentCode(String text) {
        this.environmentCode = text;
    }

    public String getDefaultEnvironmentCode() {
        return this.env.getDefaultCode();
    }

    public String getDefaultMiddleControllerCode() {
        return this.middle.getDefaultCode();
    }

    public String getDefaultHighControllerCode() {
        return this.high.getDefaultCode();
    }

    public int getNumSelectedNodes() {
        return this.selectedNodes.size();
    }

    private static String chompAt(String sourceStr) {
        String outString = "";
        outString = sourceStr.substring(1, sourceStr.length());
        return outString;
    }
}

