/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.robot.RobotGraph;
import CIspace.robot.RobotGraphCanvas;
import CIspace.robot.RobotNode;
import CIspace.robot.RobotWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PlannerFrame
extends JFrame
implements ActionListener,
WindowListener,
MouseListener {
    protected RobotGraph graph;
    protected RobotGraphCanvas graphCanvas;
    protected JButton cancelButton;
    protected JButton updateButton;
    protected JButton addButton;
    protected JButton removeButton;
    protected JList nodeSet;
    protected JScrollPane nodeSetScroll;
    protected DefaultListModel nodeSetModel;
    protected JList plannerList;
    protected JScrollPane plannerListScroll;
    protected DefaultListModel plannerListModel;

    public PlannerFrame(RobotGraphCanvas gc) {
        super("Planner");
        this.graphCanvas = gc;
        this.graph = (RobotGraph)this.graphCanvas.graph;
        this.addWindowListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.updateButton = new JButton("Update");
        this.updateButton.addActionListener(this);
        this.addButton = new JButton("Add ->");
        this.addButton.addActionListener(this);
        this.removeButton = new JButton("<- Remove");
        this.removeButton.addActionListener(this);
        JPanel p1 = new JPanel();
        p1.add(this.updateButton);
        p1.add(this.cancelButton);
        this.nodeSetModel = new DefaultListModel();
        this.nodeSet = new JList(this.nodeSetModel);
        this.nodeSet.setSelectionMode(0);
        this.nodeSet.addMouseListener(this);
        this.nodeSetScroll = new JScrollPane(this.nodeSet, 20, 30);
        this.plannerListModel = new DefaultListModel();
        this.plannerList = new JList(this.plannerListModel);
        this.plannerList.setSelectionMode(0);
        this.plannerList.addMouseListener(this);
        this.plannerListScroll = new JScrollPane(this.plannerList, 20, 30);
        Vector nodes = this.graph.getNodesVector();
        int i = 0;
        while (i < nodes.size()) {
            RobotNode n = (RobotNode)nodes.elementAt(i);
            this.nodeSetModel.addElement(PlannerFrame.chompAt(n.getName()));
            ++i;
        }
        Vector plan = this.graph.getPlan();
        int i2 = 0;
        while (i2 < plan.size()) {
            String str = (String)plan.elementAt(i2);
            this.plannerListModel.addElement(PlannerFrame.chompAt(str));
            ++i2;
        }
        JLabel l1 = new JLabel("Available Locations:");
        JLabel l2 = new JLabel("Current Plan: ");
        JPanel pAA = new JPanel();
        pAA.setLayout(new BorderLayout());
        pAA.add((Component)this.addButton, "North");
        pAA.add((Component)this.removeButton, "South");
        JPanel pA = new JPanel();
        pA.setLayout(new BorderLayout());
        pA.add((Component)this.nodeSetScroll, "Center");
        pA.add((Component)l1, "North");
        JPanel pB = new JPanel();
        pB.setLayout(new BorderLayout());
        pB.add((Component)this.plannerListScroll, "Center");
        pB.add((Component)l2, "North");
        JPanel p3 = new JPanel(new GridLayout(1, 3));
        p3.add(pA);
        p3.add(pAA);
        p3.add(pB);
        this.getContentPane().add("Center", p3);
        this.getContentPane().add("South", p1);
        if (!this.graphCanvas.plannerEnabled) {
            this.updateButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.nodeSet.setEnabled(false);
            this.plannerList.setEnabled(false);
        }
        this.pack();
        RobotWindow.centerWindow(this);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        int selectedIndex;
        if (e.getActionCommand().equals("Cancel")) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (e.getActionCommand().equals("Update")) {
            if (!this.graphCanvas.isRunning()) {
                Vector<String> planner = new Vector<String>();
                String[] str = new String[this.plannerListModel.getSize()];
                int j = 0;
                while (j < this.plannerListModel.getSize()) {
                    str[j] = (String)this.plannerListModel.getElementAt(j);
                    ++j;
                }
                int i = 0;
                while (i < str.length) {
                    planner.addElement("@" + str[i]);
                    ++i;
                }
                this.graph.updatePlanner(planner);
                ((Component)this).setVisible(false);
                this.dispose();
            } else {
                this.graphCanvas.showMessage("Error", "Cannot update plan when robot is running.");
            }
        } else if (e.getActionCommand().equals("Add ->")) {
            String selected = (String)this.nodeSet.getSelectedValue();
            if (selected != null) {
                this.plannerListModel.addElement(selected);
            }
        } else if (e.getActionCommand().equals("<- Remove") && (selectedIndex = this.plannerList.getSelectedIndex()) != -1) {
            this.plannerListModel.remove(selectedIndex);
        }
    }

    public void mouseClicked(MouseEvent e) {
        int selectedIndex;
        if (e.getSource() == this.nodeSet && e.getClickCount() == 2) {
            String selected = (String)this.nodeSet.getSelectedValue();
            if (selected != null) {
                this.plannerListModel.addElement(selected);
            }
        } else if (e.getSource() == this.plannerList && e.getClickCount() == 2 && (selectedIndex = this.plannerList.getSelectedIndex()) != -1) {
            this.plannerListModel.remove(selectedIndex);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (((RobotWindow)this.graphCanvas.parent).solveViewModes != null) {
            ((RobotWindow)this.graphCanvas.parent).solveViewModes[2].setSelected(true);
        }
        if (((RobotWindow)this.graphCanvas.parent).createViewModes != null) {
            ((RobotWindow)this.graphCanvas.parent).createViewModes[2].setSelected(true);
        }
        ((RobotWindow)this.graphCanvas.parent).setPromptLabel(((RobotWindow)this.graphCanvas.parent).getMessage());
    }

    public void windowClosing(WindowEvent e) {
        if (((RobotWindow)this.graphCanvas.parent).solveViewModes != null) {
            ((RobotWindow)this.graphCanvas.parent).solveViewModes[2].setSelected(true);
        }
        if (((RobotWindow)this.graphCanvas.parent).createViewModes != null) {
            ((RobotWindow)this.graphCanvas.parent).createViewModes[2].setSelected(true);
        }
        ((RobotWindow)this.graphCanvas.parent).setPromptLabel(((RobotWindow)this.graphCanvas.parent).getMessage());
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private static String chompAt(String sourceStr) {
        String outString = "";
        if (!sourceStr.equals("")) {
            outString = sourceStr.substring(1, sourceStr.length());
        }
        return outString;
    }
}

