/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Point;
import CIspace.robot.Environment;

public class MiddleLayerController {
    public static final double CLOSE_ENOUGH = 9.0 * (double)Environment.pixelsPerUnit;
    Environment env;
    Point goalPos;

    public MiddleLayerController(Environment e) {
        this.env = e;
        this.goalPos = null;
    }

    public void setGoalPos(Point c) {
        this.goalPos = c;
    }

    public boolean arrived() {
        Point robotPos = this.env.getCurrentCartesianPosition();
        return (double)((robotPos.x - this.goalPos.x) * (robotPos.x - this.goalPos.x) + (robotPos.y - this.goalPos.y) * (robotPos.y - this.goalPos.y)) < CLOSE_ENOUGH;
    }

    public double getGoalDirection() {
        Point currentPos = this.env.getCurrentCartesianPosition();
        double dir = 180.0 * Math.acos((double)(this.goalPos.x - currentPos.x) / Math.sqrt((this.goalPos.x - currentPos.x) * (this.goalPos.x - currentPos.x) + (this.goalPos.y - currentPos.y) * (this.goalPos.y - currentPos.y))) / Math.PI;
        if (currentPos.y > this.goalPos.y) {
            dir = 360.0 - dir;
        }
        return dir;
    }

    public boolean action(boolean checkGoalDirection) {
        boolean successful = true;
        if (!this.env.getWhiskerStatus()) {
            if (checkGoalDirection) {
                double currentDirection;
                double goalDirection = this.getGoalDirection();
                int relativeDir = (int)(goalDirection - (currentDirection = this.env.getCompass()) + 540.0) % 360 - 180;
                if (relativeDir > 11) {
                    this.env.steer(7);
                    successful = true;
                } else if (relativeDir < -11) {
                    this.env.steer(8);
                    successful = true;
                } else {
                    successful = this.env.moveAhead();
                }
            } else {
                successful = this.env.moveAhead();
            }
        } else {
            this.env.steer(7);
            while (this.env.getWhiskerStatus()) {
                this.env.steer(7);
            }
            successful = this.env.moveAhead();
        }
        return successful;
    }

    public String getModifiableDefaultCode() {
        String defaultCode = new String("% Middle Layer Controller\n\n");
        defaultCode = String.valueOf(defaultCode) + "% goal_direction(G,T) is true if at time T, the direction of the goal\n% from the robot's current position is G degrees.\ngoal_direction(G,T) <-\n\twas(robot_pos,(X0,Y0),T1,T) &\n\twas(goal_pos,(X1,Y1),T2,T) &\n\tdirection((X0,Y0),(X1,Y1),G).\n\n% at time 1, there is no previous goal_pos, so just assume it is straight\ngoal_direction(0,1).\n\n% goal_is(D,T) if the position of the goal is on the D-hand-side of the\n% robot's current position at time T.  D is one of {left, right, straight}.\ngoal_is(left,T) <-\n\tgoal_direction(G,T) &\n\twas(compass,C,_,T) &\n\tis_left(G,C).\ngoal_is(straight,T) <-\n\tgoal_direction(G,T) &\n\twas(compass,C,_,T) &\n\tis_straight(G,C).\ngoal_is(right,T) <-\n\tgoal_direction(G,T) &\n\twas(compass,C,_,T) &\n\tis_right(G,C).\n\n% steer(D,T) is true if the robot is to steer in the direction D at time T\n% where D is one of {left, right, straight}.\nsteer(D,T) <-\n\twhisker_sensor(off,T) &\n\tgoal_is(D,T).\nsteer(left,T) <-\n\twhisker_sensor(on,T).\n\n% arrived(T) is true if the robot arrives at the current goal at time T.\narrived(T) <-\n\twas(goal_pos,Goal_Coords,_,T) &\n\twas(robot_pos,Robot_Coords,_,T) &\n\tclose_enough(Goal_Coords,Robot_Coords).\n\n% direction((X0,Y0),(X1,Y1),Dir) is true if Dir is the angle, in degrees,\n% of the vector from (X0,Y0) to (X1,Y1) with the horizontal.\ndirection((X0,Y0),(X1,Y1),Dir) <-\n\tY0 =< Y1 &\n\tDir is 180 * acos( (X1-X0) / sqrt( square(X1-X0) + square(Y1-Y0) ) ) / 3.141592653589793 .\ndirection((X0,Y0),(X1,Y1),Dir) <-\n\tY0 > Y1 &\n\tDir is 360 - 180 * acos( (X1-X0) / sqrt( square(X1-X0) + square(Y1-Y0) ) ) / 3.141592653589793 .\n\n% is_left(G,C) is true if the angle G is on the left of the angle C (both in degrees).\nis_left(G,C) <-\n\t((G - C + 540) mod 360) - 180 > 11 .\n\n% is_right(G,C) is true if the angle G is on the right of the angle C (both in degrees).\nis_right(G,C) <-\n\t((G - C + 540) mod 360) - 180 < -11 .\n\n% is_straight(G,C) is true if the angle G is straight ahead of the angle C (both in degrees).\nis_straight(G,C) <-\n\tabs( ((G - C + 540) mod 360) - 180) =< 11 .\n\n% close_enough((X0,Y0),(X1,Y1)) is true if the Euclidean distance between the\n% two coordinates is less than 3.0\nclose_enough((X0,Y0),(X1,Y1)) <-\n\tabs( square(X1 - X0) +  square(Y1 - Y0) ) < 9.0 .\n";
        return defaultCode;
    }

    public String getCommentedDefaultCode() {
        String defaultCode = "";
        return defaultCode;
    }

    public String getDefaultCode() {
        String defaultCode = new String("% Middle Layer Controller\n\n");
        defaultCode = String.valueOf(defaultCode) + "% goal_direction(G,T) is true if at time T, the direction of the goal\n% from the robot's current position is G degrees.\ngoal_direction(G,T) <-\n\twas(robot_pos,(X0,Y0),T1,T) &\n\twas(goal_pos,(X1,Y1),T2,T) &\n\tdirection((X0,Y0),(X1,Y1),G).\n\n% at time 1, there is no previous goal_pos, so just assume it is straight\ngoal_direction(0,1).\n\n% goal_is(D,T) if the position of the goal is on the D-hand-side of the\n% robot's current position at time T.  D is one of {left, right, straight}.\ngoal_is(left,T) <-\n\tgoal_direction(G,T) &\n\twas(compass,C,_,T) &\n\tis_left(G,C).\ngoal_is(straight,T) <-\n\tgoal_direction(G,T) &\n\twas(compass,C,_,T) &\n\tis_straight(G,C).\ngoal_is(right,T) <-\n\tgoal_direction(G,T) &\n\twas(compass,C,_,T) &\n\tis_right(G,C).\n\n% steer(D,T) is true if the robot is to steer in the direction D at time T\n% where D is one of {left, right, straight}.\nsteer(D,T) <-\n\twhisker_sensor(off,T) &\n\tgoal_is(D,T).\nsteer(left,T) <-\n\twhisker_sensor(on,T).\n\n% arrived(T) is true if the robot arrives at the current goal at time T.\narrived(T) <-\n\twas(goal_pos,Goal_Coords,_,T) &\n\twas(robot_pos,Robot_Coords,_,T) &\n\tclose_enough(Goal_Coords,Robot_Coords).\n\n% direction((X0,Y0),(X1,Y1),Dir) is true if Dir is the angle, in degrees,\n% of the vector from (X0,Y0) to (X1,Y1) with the horizontal.\ndirection((X0,Y0),(X1,Y1),Dir) <-\n\tY0 =< Y1 &\n\tDir is 180 * acos( (X1-X0) / sqrt( square(X1-X0) + square(Y1-Y0) ) ) / 3.141592653589793 .\ndirection((X0,Y0),(X1,Y1),Dir) <-\n\tY0 > Y1 &\n\tDir is 360 - 180 * acos( (X1-X0) / sqrt( square(X1-X0) + square(Y1-Y0) ) ) / 3.141592653589793 .\n\n% is_left(G,C) is true if the angle G is on the left of the angle C (both in degrees).\nis_left(G,C) <-\n\t((G - C + 540) mod 360) - 180 > 11 .\n\n% is_right(G,C) is true if the angle G is on the right of the angle C (both in degrees).\nis_right(G,C) <-\n\t((G - C + 540) mod 360) - 180 < -11 .\n\n% is_straight(G,C) is true if the angle G is straight ahead of the angle C (both in degrees).\nis_straight(G,C) <-\n\tabs( ((G - C + 540) mod 360) - 180) =< 11 .\n\n% close_enough((X0,Y0),(X1,Y1)) is true if the Euclidean distance between the\n% two coordinates is less than 3.0\nclose_enough((X0,Y0),(X1,Y1)) <-\n\tabs( square(X1 - X0) +  square(Y1 - Y0) ) < 9.0 .\n";
        return defaultCode;
    }
}

