/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.robot.RobotGraph;
import CIspace.robot.RobotGraphCanvas;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class MiddleControllerDialogWindows
extends Frame
implements ActionListener,
WindowListener,
MouseListener {
    protected Button cancelButton;
    protected Button defaultButton;
    protected Button updateButton;
    protected TextArea display;
    protected RobotGraphCanvas graphCanvas;

    public MiddleControllerDialogWindows(RobotGraphCanvas gc) {
        super("Prolog code for the Middle Layer Controller");
        ((Component)this).setLocation(50, 50);
        this.graphCanvas = gc;
        Panel p = new Panel();
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.defaultButton = new Button("Default");
        this.defaultButton.addActionListener(this);
        this.updateButton = new Button("Update");
        this.updateButton.addActionListener(this);
        p.add(this.updateButton);
        p.add(this.defaultButton);
        p.add(this.cancelButton);
        this.display = new TextArea(40, 100);
        this.display.setFont(new Font("Monospaced", 0, gc.getFontSize()));
        if (this.graphCanvas.isRunning()) {
            this.updateButton.setEnabled(false);
            this.defaultButton.setEnabled(false);
            this.display.setEditable(false);
        }
        this.display.addMouseListener(this);
        this.add("Center", this.display);
        this.add("South", p);
        this.pack();
        String middleControllerCode = ((RobotGraph)this.graphCanvas.graph).getMiddleControllerCode();
        this.display.setText(middleControllerCode);
        this.display.setCaretPosition(0);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Update")) {
            if (!this.graphCanvas.isRunning()) {
                ((RobotGraph)this.graphCanvas.graph).setMiddleControllerCode(this.display.getText());
                this.dispose();
            } else {
                this.graphCanvas.showMessage("Error", "Cannot update controller when robot is running.");
            }
        } else if (e.getActionCommand().equals("Default")) {
            String defaultCode = ((RobotGraph)this.graphCanvas.graph).getDefaultMiddleControllerCode();
            this.display.setText(defaultCode);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        e.getModifiers();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

