/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Point;
import CIspace.robot.Environment;
import CIspace.robot.RobotGraph;
import CIspace.robot.RobotGraphCanvas;
import CIspace.robot.RobotNode;
import CIspace.robot.RobotWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LocationDialog
extends JFrame
implements ActionListener,
TextListener,
WindowListener {
    protected JLabel labelLocationName;
    protected JTextField textLocationName;
    protected JLabel labelLocationX;
    protected JTextField textLocationX;
    protected JLabel labelLocationY;
    protected JTextField textLocationY;
    protected JButton buttonOk;
    protected JButton buttonCancel;
    protected JLabel labelError;
    protected JPanel p;
    protected String dialogTitle;
    protected String locationName;
    protected Double locationX;
    protected Double locationY;
    protected int scale;
    protected RobotNode node;
    protected RobotGraphCanvas canvas;

    public LocationDialog(Container parent, RobotGraphCanvas c, RobotNode n) {
        super("Location Properties");
        this.node = n;
        this.locationName = this.node.getName();
        this.initialize(c, this.node.pos);
    }

    public LocationDialog(Container parent, RobotGraphCanvas c, Point point) {
        super("Location Properties");
        this.node = null;
        this.canvas = c;
        this.locationName = this.getNextName();
        this.initialize(c, point);
    }

    public String getNextName() {
        int index = this.canvas.getLocIndex();
        while (!this.nameOK("N" + index)) {
            ++index;
        }
        return "N" + index;
    }

    public final boolean nameOK(String name) {
        if (((RobotGraph)this.canvas.graph).nodeNameExists(name)) {
            return false;
        }
        if (name == "") {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void initialize(RobotGraphCanvas c, Point point) {
        this.dialogTitle = new String("Location Properties");
        this.canvas = c;
        this.canvas.pause();
        this.scale = Environment.pixelsPerUnit;
        double posX = point.x / (float)this.scale;
        double posY = -point.y / (float)this.scale;
        Double locX = new Double(posX);
        Double locY = new Double(posY);
        this.labelLocationName = new JLabel("Location name:");
        this.textLocationName = new JTextField(this.locationName, 20);
        this.labelLocationX = new JLabel("x coordinate:");
        this.textLocationX = new JTextField(locX.toString(), 20);
        this.labelLocationY = new JLabel("y coordinate:");
        this.textLocationY = new JTextField(locY.toString(), 20);
        this.buttonOk = new JButton("OK");
        this.buttonOk.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(this);
        this.labelError = new JLabel("");
        this.p = new JPanel();
        this.p.setLayout(new GridLayout(4, 2));
        this.p.add(this.labelLocationName);
        this.p.add(this.textLocationName);
        this.p.add(this.labelLocationX);
        this.p.add(this.textLocationX);
        this.p.add(this.labelLocationY);
        this.p.add(this.textLocationY);
        this.p.add(this.buttonOk);
        this.p.add(this.buttonCancel);
        this.getContentPane().add(this.p);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        RobotWindow.centerWindow(this);
        this.show();
    }

    public void display(RobotGraphCanvas c, Point p) {
        this.canvas = c;
        this.scale = Environment.pixelsPerUnit;
        double posX = p.x / (float)this.scale;
        double posY = -p.y / (float)this.scale;
        this.textLocationName.setText(this.getNextName());
        this.textLocationX.setText(new Double(posX).toString());
        this.textLocationY.setText(new Double(posY).toString());
        this.pack();
        this.show();
    }

    public void display(RobotGraphCanvas c, RobotNode n) {
        this.canvas = c;
        this.node = n;
        this.scale = Environment.pixelsPerUnit;
        double posX = this.node.pos.x / (float)this.scale;
        double posY = -this.node.pos.y / (float)this.scale;
        this.textLocationName.setText(this.node.getName().substring(1, this.node.getName().length()));
        this.textLocationX.setText(new Double(posX).toString());
        this.textLocationY.setText(new Double(posY).toString());
        this.pack();
        this.show();
    }

    public boolean setProperties() {
        try {
            if (this.textLocationName.getText().equals("")) {
                this.labelError.setText("Error: Location must have a name");
                return false;
            }
            this.locationX = Double.valueOf(this.textLocationX.getText());
            this.locationY = Double.valueOf(this.textLocationY.getText());
            String name = this.textLocationName.getText();
            name = "@" + name;
            if (this.node != null && this.canvas.isRunning() && !this.node.getName().equals(name)) {
                this.labelError.setText("Cannot modify location name when robot is running.");
                return false;
            }
            if ((this.node == null || !this.node.getName().equals(name)) && ((RobotGraph)this.canvas.graph).nodeNameExists(name)) {
                this.labelError.setText("The name is already used.  Please use another name for this location");
                return false;
            }
            double posX = this.locationX * (double)this.scale;
            double posY = this.locationY * (double)(-this.scale);
            Point point = new Point((float)posX, (float)posY);
            if (this.node == null) {
                this.node = new RobotNode((RobotGraph)this.canvas.graph, point);
                this.node.pos = point;
                this.node.setName(name);
                this.node.updateSize();
                ((RobotGraph)this.canvas.graph).addNode(this.node);
                ((RobotGraph)this.canvas.graph).addNodeToPlan(name);
            } else {
                this.node.pos = point;
                if (!this.node.getName().equals(name)) {
                    ((RobotGraph)this.canvas.graph).changeNodeNameInPlan(this.node.getName(), name);
                    this.node.setName(name);
                    this.node.updateSize();
                }
            }
            this.canvas.repaint();
            this.canvas.unpause();
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Location coordinate(s) have invalid real number format!");
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
            if (this.setProperties()) {
                this.node = null;
                ((Component)this).setVisible(false);
                this.dispose();
            }
        } else if (e.getActionCommand() == "Cancel") {
            this.node = null;
            this.canvas.setCreateNodeCancelled(true);
            this.canvas.unpause();
            ((Component)this).setVisible(false);
        } else if (e.getSource().equals(this.textLocationName)) {
            this.textLocationName.transferFocus();
        } else if (e.getSource().equals(this.textLocationX)) {
            this.textLocationX.transferFocus();
        } else if (e.getSource().equals(this.textLocationY)) {
            this.textLocationY.transferFocus();
        }
    }

    public void textValueChanged(TextEvent e) {
        this.labelError.setText("");
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

