/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.GraphConsts;
import CIspace.robot.EnvironmentDialog;
import CIspace.robot.HighControllerDialog;
import CIspace.robot.InlineCanvas;
import CIspace.robot.MiddleControllerDialog;
import CIspace.robot.PlannerFrame;
import java.awt.BorderLayout;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JApplet;

public class InlineApplet
extends JApplet {
    public InlineCanvas canvas;
    private boolean isApplet;

    public void init() {
        this.isApplet = true;
        this.setBackground(GraphConsts.bg);
        this.setForeground(GraphConsts.fg);
        this.canvas = new InlineCanvas(this, true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.canvas);
        this.loadParams();
    }

    private void loadParams() {
        String param = this.getParameter("algorithm");
        if (param != null) {
            this.itemStateChanged(param);
        }
        if ((param = this.getParameter("filename")) != null) {
            this.load(param);
        }
    }

    public void load(String filename) {
        try {
            URL url = new URL(filename);
            InputStream iStream = url.openStream();
            this.load(new BufferedReader(new InputStreamReader(iStream)), filename);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void load(BufferedReader in, String filename) {
        if (this.canvas.frameOpened) {
            return;
        }
        try {
            String all = "";
            String errMsg = "";
            String line = in.readLine();
            while (line != null) {
                all = String.valueOf(all) + line + "\n";
                line = in.readLine();
            }
            in.close();
            boolean success = filename.endsWith(".xml") ? this.canvas.updateXMLtextRep(all) : this.canvas.updateGraphFromText(all);
            if (!success) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void itemStateChanged(String arg) {
    }

    public void actionPerformed(String arg) {
        if (arg.equals("View/Edit Prolog Code for the High Layer Controller")) {
            HighControllerDialog hcd = new HighControllerDialog(this.canvas);
        } else if (arg.equals("View/Edit Prolog Code for the Middle Layer Controller")) {
            MiddleControllerDialog mcd = new MiddleControllerDialog(this.canvas);
        } else if (arg.equals("View/Edit Prolog Code for the Environment")) {
            EnvironmentDialog ed = new EnvironmentDialog(this.canvas);
        } else if (arg.equals("View/Edit Text Representation")) {
            this.canvas.textRep();
        } else if (arg.equals("View/Modify Planner")) {
            PlannerFrame plannerFrame = new PlannerFrame(this.canvas);
        } else if (arg.equals("View/Modify Robot Properties")) {
            this.canvas.setAutoProperties();
        } else if (arg.equals("Run Robot")) {
            if (this.canvas.runEnabled && this.canvas.checkRunReady()) {
                this.canvas.runAuto2(true, false);
                this.canvas.setRunningState();
            }
        } else if (arg.equals("Stop Robot")) {
            if (this.canvas.stopEnabled) {
                this.canvas.stopAuto();
                this.canvas.setStoppedState();
            }
        } else if (arg.equals("Reset Robot")) {
            if (this.canvas.resetEnabled) {
                this.canvas.stopAuto();
                this.canvas.resetAuto();
                this.canvas.clearTrace();
                this.canvas.setResetState();
            }
        } else if (arg.equals("Clear Trace") && this.canvas.clearTraceEnabled) {
            this.canvas.clearTrace();
        }
    }
}

