/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Point;
import CIspace.robot.InvisibleNode;
import CIspace.robot.RobotEdge;
import CIspace.robot.RobotGraph;
import CIspace.robot.RobotNode;
import CIspace.robot.RobotRobot;
import java.util.Vector;

public class Environment {
    public static final int WHISKER_ON = 0;
    public static final int WHISKER_OFF = 1;
    public static final int LEFT = 7;
    public static final int RIGHT = 8;
    public static final int STRAIGHT = 9;
    public static int pixelsPerUnit = 3;
    public static double whiskerUnit = 12.0;
    public static double whiskerValidDistance = whiskerUnit * (double)pixelsPerUnit;
    protected RobotGraph graph;
    protected Vector locationDB;
    protected double rotateDegrees;
    protected boolean whiskerOn;
    protected Point intersectionPoint;

    public Environment(RobotGraph g) {
        this.graph = g;
        this.locationDB = new Vector();
        this.rotateDegrees = 10.0;
        this.whiskerOn = false;
        this.intersectionPoint = null;
    }

    public static void setPixelsPerUnit(int n) {
        pixelsPerUnit = n;
        whiskerValidDistance = whiskerUnit * (double)pixelsPerUnit;
    }

    public boolean addLocation(RobotNode n) {
        this.locationDB.addElement(n);
        return true;
    }

    public void removeLocation(String name) {
        int i = 0;
        while (i < this.locationDB.size()) {
            if (((RobotNode)this.locationDB.elementAt(i)).getName().equals(name)) {
                this.locationDB.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    public Vector getLocations() {
        return this.locationDB;
    }

    public Point getCoordByLocation(String name) {
        int i = 0;
        while (i < this.locationDB.size()) {
            RobotNode temp = (RobotNode)this.locationDB.elementAt(i);
            if (temp.getName().equals(name)) {
                return temp.getCartesianPos();
            }
            ++i;
        }
        return null;
    }

    public Point getCoordByNodeIndex(int index) {
        Vector nodes = this.graph.getNodesVector();
        int i = 0;
        while (i < nodes.size()) {
            RobotNode temp = (RobotNode)nodes.elementAt(i);
            if (temp.index == index) {
                return temp.getCartesianPos();
            }
            ++i;
        }
        return null;
    }

    public RobotNode getNodeByIndex(int index) {
        return (RobotNode)this.graph.nodeAt(index);
    }

    public Point getCurrentPosition() {
        RobotRobot robot = this.graph.robotAt(0);
        return robot.pos;
    }

    public Point getCurrentCartesianPosition() {
        if (this.graph.getNodesVector().size() > 0) {
            RobotNode robotNode = (RobotNode)this.graph.nodeAt(0);
        }
        RobotRobot robot = this.graph.robotAt(0);
        return robot.getCartesianPos();
    }

    public void setCurrentCartesianPosition(Point p) {
        RobotRobot robot = this.graph.robotAt(0);
        robot.setRobotPosition(p);
    }

    public double getCompass() {
        RobotRobot robot = this.graph.robotAt(0);
        return robot.direction;
    }

    public void setCompass(double dir) {
        RobotRobot robot = this.graph.robotAt(0);
        robot.setRobotDirection(dir);
    }

    public Point getIntersectionPoint() {
        return this.intersectionPoint;
    }

    public boolean getWhiskerStatus() {
        boolean sensed = false;
        RobotRobot robot = this.graph.robotAt(0);
        Point robotCartesianPosition = robot.getCartesianPos();
        double robotDirection = robot.direction;
        double whiskerAngle = this.addAngle(robotDirection, -30.0);
        double whiskerX = (double)robotCartesianPosition.x + whiskerValidDistance * Math.cos(whiskerAngle * Math.PI / 180.0);
        double whiskerY = (double)robotCartesianPosition.y + whiskerValidDistance * Math.sin(whiskerAngle * Math.PI / 180.0);
        Point whiskerPos = new Point((float)whiskerX, (float)whiskerY);
        this.whiskerOn = sensed = this.intersectedWithWall(robotCartesianPosition, whiskerPos, 1);
        return sensed;
    }

    public boolean getWhiskerOn() {
        return this.whiskerOn;
    }

    public boolean intersectedWithWall(Point posA, Point posB, int which) {
        boolean intersected = false;
        Vector edges = this.graph.getEdgesVector();
        Point from = null;
        Point to = null;
        int count = 0;
        while (!intersected && count < edges.size()) {
            RobotEdge edge = (RobotEdge)edges.elementAt(count);
            InvisibleNode head = (InvisibleNode)edge.start;
            InvisibleNode tail = (InvisibleNode)edge.end;
            to = head.getCartesianPos();
            from = tail.getCartesianPos();
            intersected = this.intersect(posA, posB, from, to);
            ++count;
        }
        return intersected;
    }

    public void steer(int direction) {
        RobotRobot robot = this.graph.robotAt(0);
        double robotDirection = robot.direction;
        switch (direction) {
            case 7: {
                robot.setRobotDirection(this.addAngle(robotDirection, this.rotateDegrees));
                break;
            }
            case 8: {
                robot.setRobotDirection(this.addAngle(robotDirection, -this.rotateDegrees));
                break;
            }
        }
    }

    public boolean moveAhead() {
        double newRobotPosY;
        double robotDirection;
        double newRobotPosX;
        boolean successful = false;
        RobotRobot robot = this.graph.robotAt(0);
        Point robotCartesianPosition = robot.getCartesianPos();
        boolean crashed = this.intersectedWithWall(robotCartesianPosition, new Point((float)(newRobotPosX = (double)robotCartesianPosition.x + (double)pixelsPerUnit * Math.cos((robotDirection = robot.direction) * Math.PI / 180.0)), (float)(newRobotPosY = (double)robotCartesianPosition.y + (double)pixelsPerUnit * Math.sin(robotDirection * Math.PI / 180.0))), 2);
        if (crashed) {
            System.out.println("Crashed onto a wall!!");
            this.getWhiskerStatus();
        } else {
            robotCartesianPosition.x = (float)newRobotPosX;
            robotCartesianPosition.y = (float)newRobotPosY;
            successful = true;
        }
        robot.setRobotPosition(new Point(robotCartesianPosition.x, -robotCartesianPosition.y));
        robot.setRobotDirection(robotDirection);
        return successful;
    }

    public double getDirectionDifference(double a, double b) {
        double result = a - b;
        if (result < -180.0) {
            result += 360.0;
        }
        return result;
    }

    public double addAngle(double angle, double addition) {
        double result = angle + addition;
        while (result < 0.0) {
            result += 360.0;
        }
        while (result > 360.0) {
            result -= 360.0;
        }
        return result;
    }

    public boolean intersect(Point u, Point v, Point w, Point z) {
        Point a = new Point(u.x, u.y);
        Point b = new Point(v.x, v.y);
        Point c = new Point(w.x, w.y);
        Point d = new Point(z.x, z.y);
        if ((double)Math.abs(a.x - b.x) < 0.01) {
            b.x = (float)((double)b.x + 0.1);
        }
        if ((double)Math.abs(a.y - b.y) < 0.01) {
            b.y = (float)((double)b.y + 0.1);
        }
        if ((double)Math.abs(c.x - d.x) < 0.01) {
            d.x = (float)((double)d.x + 0.1);
        }
        if ((double)Math.abs(c.y - d.y) < 0.01) {
            d.y = (float)((double)d.y + 0.1);
        }
        double denom = (a.x - b.x) * (c.y - d.y) - (a.y - b.y) * (c.x - d.x);
        double determAB = a.x * b.y - a.y * b.x;
        double determCD = c.x * d.y - c.y * d.x;
        double numerX = determAB * (double)(c.x - d.x) - (double)(a.x - b.x) * determCD;
        double numerY = determAB * (double)(c.y - d.y) - (double)(a.y - b.y) * determCD;
        double intersectX = numerX / denom;
        double intersectY = numerY / denom;
        boolean inside = (double)Math.min(a.x, b.x) <= intersectX && intersectX <= (double)Math.max(a.x, b.x) && (double)Math.min(a.y, b.y) <= intersectY && intersectY <= (double)Math.max(a.y, b.y) && (double)Math.min(c.x, d.x) <= intersectX && intersectX <= (double)Math.max(c.x, d.x) && (double)Math.min(c.y, d.y) <= intersectY && intersectY <= (double)Math.max(c.y, d.y);
        this.intersectionPoint = inside ? new Point((float)intersectX, (float)intersectY) : null;
        return inside;
    }

    public String getModifiableDefaultCode() {
        String defaultCode = new String("% Environment\n\n");
        defaultCode = String.valueOf(defaultCode) + "% whisker_sensor(S,T) is true if the whisker sensor's state is S at time T\n% where S is one of {on, off}.\nwhisker_sensor(on,T) <-\n\twas(compass,D,_,T) &\n\twas(robot_pos,(X,Y),_,T) &\n\tget_whisker_direction(D,30,right,WD) &\n\tseeblock(X,Y,12,WD).\nwhisker_sensor(off,T) <-\n\twas(compass,D,_,T) &\n\twas(robot_pos,(X,Y),_,T) &\n\tget_whisker_direction(D,30,right,WD) &\n\tnotseeblock(X,Y,12,WD).\n\n% compass_deriv(A,T) is true if the robot is to turn an angle of A degrees at time T\ncompass_deriv(0,T) <-\n\tsteer(straight,T).\ncompass_deriv(-18,T) <-\n\tsteer(right,T).\ncompass_deriv(18,T) <-\n\tsteer(left,T).\n\n% assign(compass,C,T) is true if the attribute compass is assigned the value C at time T\nassign(compass,C,T) <-\n\twas(compass,C1,T1,T) &\n\tcompass_deriv(DC,T) &\n\tupdate_compass(T1,T,DC,C1,C).\n\n% assign(robot_pos,(X,Y),T) is true if the attribute robot_pos is assigned the\n% value (X,Y) at time T\nassign(robot_pos,(X,Y),T) <-\n\twas(robot_pos,(X1,Y1),T1,T) &\n\tx_deriv(DX,T1) &\n\ty_deriv(DY,T1) &\n\tupdate_robot_pos(X1,Y1,DX,DY,T1,T,X,Y).\n\n% get_whisker_direction(D,A,LR,WD) is true if D is the compass value of the\trobot\n% A is the angle of the whisker relative to the head direction of the robot,\n% LR is whether the whisker is on the left or right side of the robot,\n% and WD is the compass value (relative to the horizontal) of the whisker direction.\nget_whisker_direction(D,A,right,WD) <-\n\tWD is D - A.\nget_whisker_direction(D,A,left,WD) <-\n\tWD is D + A.\n\n% update_compass(T1,T,DC,C1,C) is true if T1 is the previous time,\n% T is the current time, C1 is the previous compass value,\n% DC is the change in compass value, and C is the new compass value.\nupdate_compass(T1,T,DC,C1,C) <-\n\tC is (C1 + DC * (T - T1) + 360) mod 360.\n\n% update_robot_pos(X1,Y1,DX,DY,T1,T,X,Y) is true if T1 is the previous time,\n% T is the current time, (X1,Y1) is the robot's position at time T1,\n% (DX,DY) is the change in robot position, and (X,Y) is the new robot position.\nupdate_robot_pos(X1,Y1,DX,DY,T1,T,X,Y) <-\n\tDT is T - T1 &\n\tX is X1 + DX * DT &\n\tY is Y1 + DY * DT.\n\n%x_deriv(DX,T)\nx_deriv(DX,T) <-\n\twas(compass,D,_,T) &\n\tDX is cos(D*3.14159265358979344/180).\n\n%y_deriv(DY,T)\ny_deriv(DY,T) <-\n\twas(compass,D,_,T) &\n\tDY is sin(D*3.14159265358979344/180).\n\n";
        return defaultCode;
    }

    public String getCommentedDefaultCode() {
        String defaultCode = "";
        return defaultCode;
    }

    public String getDefaultCode() {
        String defaultCode = new String("% Environment\n\n");
        defaultCode = String.valueOf(defaultCode) + "% whisker_sensor(S,T) is true if the whisker sensor's state is S at time T\n% where S is one of {on, off}.\nwhisker_sensor(on,T) <-\n\twas(compass,D,_,T) &\n\twas(robot_pos,(X,Y),_,T) &\n\tget_whisker_direction(D,30,right,WD) &\n\tseeblock(X,Y,12,WD).\nwhisker_sensor(off,T) <-\n\twas(compass,D,_,T) &\n\twas(robot_pos,(X,Y),_,T) &\n\tget_whisker_direction(D,30,right,WD) &\n\tnotseeblock(X,Y,12,WD).\n\n% compass_deriv(A,T) is true if the robot is to turn an angle of A degrees at time T\ncompass_deriv(0,T) <-\n\tsteer(straight,T).\ncompass_deriv(-18,T) <-\n\tsteer(right,T).\ncompass_deriv(18,T) <-\n\tsteer(left,T).\n\n% assign(compass,C,T) is true if the attribute compass is assigned the value C at time T\nassign(compass,C,T) <-\n\twas(compass,C1,T1,T) &\n\tcompass_deriv(DC,T) &\n\tupdate_compass(T1,T,DC,C1,C).\n\n% assign(robot_pos,(X,Y),T) is true if the attribute robot_pos is assigned the\n% value (X,Y) at time T\nassign(robot_pos,(X,Y),T) <-\n\twas(robot_pos,(X1,Y1),T1,T) &\n\tx_deriv(DX,T1) &\n\ty_deriv(DY,T1) &\n\tupdate_robot_pos(X1,Y1,DX,DY,T1,T,X,Y).\n\n% get_whisker_direction(D,A,LR,WD) is true if D is the compass value of the\trobot\n% A is the angle of the whisker relative to the head direction of the robot,\n% LR is whether the whisker is on the left or right side of the robot,\n% and WD is the compass value (relative to the horizontal) of the whisker direction.\nget_whisker_direction(D,A,right,WD) <-\n\tWD is D - A.\nget_whisker_direction(D,A,left,WD) <-\n\tWD is D + A.\n\n% update_compass(T1,T,DC,C1,C) is true if T1 is the previous time,\n% T is the current time, C1 is the previous compass value,\n% DC is the change in compass value, and C is the new compass value.\nupdate_compass(T1,T,DC,C1,C) <-\n\tC is (C1 + DC * (T - T1) + 360) mod 360.\n\n% update_robot_pos(X1,Y1,DX,DY,T1,T,X,Y) is true if T1 is the previous time,\n% T is the current time, (X1,Y1) is the robot's position at time T1,\n% (DX,DY) is the change in robot position, and (X,Y) is the new robot position.\nupdate_robot_pos(X1,Y1,DX,DY,T1,T,X,Y) <-\n\tDT is T - T1 &\n\tX is X1 + DX * DT &\n\tY is Y1 + DY * DT.\n\n%x_deriv(DX,T)\nx_deriv(DX,T) <-\n\twas(compass,D,_,T) &\n\tDX is cos(D*3.14159265358979344/180).\n\n%y_deriv(DY,T)\ny_deriv(DY,T) <-\n\twas(compass,D,_,T) &\n\tDY is sin(D*3.14159265358979344/180).\n\n";
        return defaultCode;
    }
}

