/*
 * Decompiled with CFR 0.152.
 */
package CIspace.robot;

import CIspace.graphToolKit.Point;
import CIspace.robot.RobotGraphCanvas;
import CIspace.robot.RobotWindow;
import CIspace.robotProlog.PrologError;
import CIspace.robotProlog.RobotProgram;
import java.util.Hashtable;

public class AutoRobot
implements Runnable {
    private double endTime;
    protected boolean stopRequested;
    protected RobotGraphCanvas canvas;
    protected int runSpeed;
    protected int stepNumber;
    protected double maxTimeStep;
    protected double dt;
    protected int whichStyle;
    protected boolean isApplet;
    protected boolean initialized;
    protected double time;
    protected RobotProgram p;

    public AutoRobot(RobotGraphCanvas c, int which, boolean a, RobotProgram p) {
        this.p = p;
        this.canvas = c;
        this.stopRequested = false;
        this.runSpeed = this.canvas.getAutoRate();
        this.maxTimeStep = this.canvas.getMaxTimeStep();
        this.dt = this.canvas.getDeltaT();
        this.stepNumber = 0;
        this.whichStyle = which;
        this.isApplet = a;
        this.time = 0.0;
        this.endTime = 0.0;
        this.initialized = false;
    }

    public void initialize() {
        boolean success = true;
        this.initialized = true;
        success = this.p.initializeSimulation_web(this.canvas, this.maxTimeStep, this.dt);
        if (!success) {
            this.stopRequested = true;
        } else {
            this.p.markWatchPredicates(((RobotWindow)this.canvas.parent).signalsDialog.getWatchPredicates());
            RobotProgram.currentAssigned.clear();
            RobotProgram.previousAssigned.clear();
            RobotProgram.timeSteps.clear();
            this.p.totalrowsdeleted = 0;
        }
    }

    public void run() {
        if (this.whichStyle == 1) {
            this.runStyle1();
        } else {
            this.runStyle2();
        }
        System.gc();
    }

    public void runStyle1() {
        boolean success = true;
        while (!this.stopRequested && success) {
            try {
                Thread.sleep(this.runSpeed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            success = this.canvas.doAction(this.stepNumber);
            ++this.stepNumber;
        }
    }

    public void runStyle2() {
        if (this.time >= this.endTime) {
            this.endTime += this.maxTimeStep;
        }
        if (this.maxTimeStep == 1.0) {
            this.endTime = this.time;
        }
        if (!this.initialized) {
            this.initialize();
            this.p.resetDebugTable();
            this.p.totalrowsdeleted = 0;
            this.p.logicalRowNum = 0;
        }
        Hashtable assigned = new Hashtable();
        if (RobotProgram.robotPositions != null && RobotProgram.robotPositions.size() > 0) {
            if (!((Point)RobotProgram.robotPositions.lastElement()).equals(this.canvas.getRobotPosition())) {
                this.p.manuallyMovedRobot(assigned);
            }
            RobotProgram.robotPositions.clear();
        }
        this.runSpeed = this.canvas.getAutoRate();
        while (!this.stopRequested) {
            try {
                Thread.sleep(this.runSpeed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.time >= 100.0) {
                this.p.updateTrace(this.time - 100.0);
            }
            if (this.time % 20.0 == 0.0) {
                RobotProgram.robotPositions.clear();
            }
            try {
                assigned = this.p.fullTimeStep(this.time, assigned);
            }
            catch (PrologError error) {
                this.canvas.showMessage("PrologError", error.getMessage());
                this.canvas.doStopped();
                return;
            }
            this.canvas.setPromptLabel("Robot Running (Current time: " + this.time + "; End time: " + this.endTime + ")");
            if (this.time >= this.endTime) {
                this.stopRequested = true;
                this.p.resetAssigns(assigned);
            }
            this.time += this.dt;
        }
        this.canvas.doStopped();
        if (!this.canvas.getCrashed()) {
            this.canvas.setPromptLabel("Robot Stopped (Current time: " + (this.time - this.dt) + "; End time: " + this.endTime + ")");
        } else {
            this.canvas.setPromptLabel("Robot crashed onto a wall!!! (Current time: " + (this.time - this.dt) + "; End time: " + this.endTime + ")");
        }
    }
}

